/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.service.sys.SysLogServiceHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.RuleServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.nocode.model.PermResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.threads.ThreadPools;

public class SysMenuServiceImpl {
    private static final Log log = LogFactory.getLog(SysMenuServiceImpl.class);
    private static final String PROP_ID = "id";
    private static final String PROP_NAME = "name";
    private static final String PROP_FORMID = "formId";
    private static final String PROP_FORMNUMBER = "formNumber";
    private static final String PROP_PARENTID = "parentId";
    private static final String PROP_TYPE = "type";
    private static final String PROP_SEQ = "seq";
    private static final String PROP_CHILDREN = "children";
    private static final String PROP_PARAM_IMAGE = "image";
    private static final String KEY_SUCCESS = "success";
    private static final String MESSAGE = "message";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            NoCodeTemplateUtil.templateCheck(param);
            MenuServiceSaveImpl appServiceSave = new MenuServiceSaveImpl();
            return appServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            MenuServiceQueryImpl appServiceQuery = new MenuServiceQueryImpl();
            return appServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            NoCodeTemplateUtil.templateCheck(param);
            MenuDeleteServiceImpl appServiceDelete = new MenuDeleteServiceImpl();
            return appServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysMenuServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class MenuDeleteServiceImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            long start = System.currentTimeMillis();
            RestApiResponse response = new RestApiResponse();
            Map httpQueryString = param.getRequest().getHttpQueryString();
            if (httpQueryString == null || !httpQueryString.containsKey(SysMenuServiceImpl.PROP_ID)) {
                long end = System.currentTimeMillis();
                return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)ResManager.loadKDString((String)"url\u4e2d\u65e0id", (String)"SysMenuServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]), (RestApiResponse)response, (long)(end - start));
            }
            String id = (String)httpQueryString.get(SysMenuServiceImpl.PROP_ID);
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)param.getAppNumber());
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
            AppMenuElement appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
            String type = appMenuElement.getMenuType();
            String formId = appMenuElement.getFormId();
            NoCodePermHelper.verifyManage((String)appId);
            this.checkProcess(formId);
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(1);
            RestBaseFilterItemData data = new RestBaseFilterItemData();
            data.setBillStatus(true);
            boolean delSuccess = MenuDeleteServiceImpl.deleteMenu(appMetadata, appMenuElement, data);
            data.setId(id);
            resultsData.add(data);
            long end = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            if (delSuccess) {
                if (StringUtils.isNotEmpty((CharSequence)formId) && data.isBillStatus()) {
                    MenuDeleteServiceImpl.deleteFormPublish(formId);
                    RuleServiceHelper.delRules((String[])new String[]{formId});
                }
                try (TXHandle tx = TX.required((String)"SysFormMetaServiceImpl_deletePage");){
                    Map saveResult = AppMetaServiceHelper.save((AppMetadata)appMetadata);
                    if (saveResult.size() > 0 && !Boolean.parseBoolean(saveResult.get(SysMenuServiceImpl.KEY_SUCCESS).toString())) {
                        RestApiServiceData restApiServiceData = RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)saveResult.get(SysMenuServiceImpl.MESSAGE).toString(), (RestApiResponse)response, (long)(end - start));
                        return restApiServiceData;
                    }
                    try {
                        if (StringUtils.isNotEmpty((CharSequence)formId) && data.isBillStatus()) {
                            String deleteErrorMessage = FormMetadataUtils.deleteForm((String)formId, (String)appId);
                            if (StringUtils.isNotBlank((CharSequence)deleteErrorMessage)) {
                                throw new RestApiException("delete form error: {}", new Object[]{deleteErrorMessage});
                            }
                            WfProcessDataService.create().deleteWfInfoByEntityNumber(formId);
                            ThreadPools.executeOnce((String)"nocode_asyncUpdateTableMeta", () -> this.deleteRefTableRelations(formId));
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw new RestApiException(e.getMessage(), (Throwable)e);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)formId) && type.equals("custom")) {
                    this.deletePage(formId);
                }
            }
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setTotalCount(1L);
            result.setResult(resultsData);
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }

        private void deleteRefTableRelations(String formId) {
            QFilter f1 = new QFilter("formid", "=", (Object)formId);
            QFilter f2 = new QFilter("refformid", "=", (Object)formId);
            QFilter f3 = f1.or(f2);
            DeleteServiceHelper.delete((String)"bos_nc_reftable", (QFilter[])new QFilter[]{f3});
        }

        private void deletePage(String formId) {
            QFilter filter = new QFilter("pageid", "=", (Object)Long.parseLong(formId));
            try {
                DynamicObjectCollection cards = QueryServiceHelper.query((String)"bos_nocode_cardcontainer", (String)"pageid", (QFilter[])new QFilter[]{filter});
                if (!cards.isEmpty()) {
                    List list = cards.stream().map(d -> d.getLong("cardid")).collect(Collectors.toList());
                    if (!list.isEmpty()) {
                        QFilter f = new QFilter("cardid", "in", list);
                        DeleteServiceHelper.delete((String)"bos_nocode_card", (QFilter[])new QFilter[]{f});
                    }
                    DeleteServiceHelper.delete((String)"bos_nocode_cardcontainer", (QFilter[])new QFilter[]{filter});
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }

        private void checkProcess(String formId) {
            if (StringUtils.isEmpty((CharSequence)formId)) {
                return;
            }
            if (!NcEntityTypeUtil.existProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId), (String)WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY)) {
                return;
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)("id," + WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY), null);
            for (DynamicObject dynamicObject : query) {
                if (!Objects.equals(dynamicObject.getString(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY), WfConsts.WfLockStatusEnum.LOCKED.getCode())) continue;
                throw new RestApiException(ResManager.loadKDString((String)"\u6d41\u7a0b\u9501\u5b9a\u4e2d\uff0c\u4e0d\u53ef\u5220\u9664", (String)"SysMenuServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
        }

        private static void deleteFormPublish(String formId) {
            PermResult result = NoCodePermissionServiceHelper.deleteAppliedPerm((Map)Maps.of((Object)formId, Collections.emptySet()));
            if (!result.getErrors().isEmpty()) {
                throw new RestApiException(String.join((CharSequence)",", result.getErrors()));
            }
            try {
                String sql = "delete from t_nocode_form_auth where fformid =?";
                Object[] params = new Object[]{formId};
                DB.update((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params);
            }
            catch (Exception e) {
                log.debug("\u5220\u9664\u8868\u5355\u6388\u6743\u8bb0\u5f55\u5931\u8d25", (Object)e);
            }
        }

        public static boolean deleteMenu(AppMetadata appMetadata, AppMenuElement appMenuElement, RestBaseFilterItemData data) {
            if (appMenuElement == null) {
                data.setBillStatus(false);
                data.getErrors().add(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u83dc\u5355", (String)"SysMenuServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]));
                return false;
            }
            List childs = appMetadata.getAppMenus().stream().filter(m -> appMenuElement.getId().equalsIgnoreCase(m.getParentId())).collect(Collectors.toList());
            while (childs != null && !childs.isEmpty()) {
                AppMenuElement currAppMenuEle = (AppMenuElement)childs.get(0);
                if (StringUtils.isNotBlank((CharSequence)currAppMenuEle.getFormId()) && Boolean.TRUE.toString().equalsIgnoreCase(currAppMenuEle.getVisible())) {
                    data.setBillStatus(false);
                    data.getErrors().add(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5206\u7ec4\u4e0b\u9762\u5b58\u5728\u8868\u5355\uff0c\u8bf7\u79fb\u51fa\u6216\u5220\u9664\u8868\u5355\u540e\u518d\u5220\u9664\u5206\u7ec4", (String)"SysMenuServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"SysMenuServiceImpl_1"));
                    return false;
                }
                boolean delSucess = MenuDeleteServiceImpl.deleteMenu(appMetadata, currAppMenuEle, data);
                if (!delSucess) {
                    return false;
                }
                childs.remove(currAppMenuEle);
            }
            if ("page".equalsIgnoreCase(appMenuElement.getMenuType()) && StringUtils.isNotBlank((CharSequence)appMenuElement.getFormId())) {
                FormMetadataUtils.deleteMenu((AppMetadata)appMetadata, (String)appMenuElement.getFormId());
            } else {
                appMetadata.getAppMenus().remove(appMenuElement);
            }
            return true;
        }
    }

    public static class MenuServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            QFilter[] filters = (QFilter[])qFilterPair.getValue();
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)param.getAppNumber());
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
            if (appMetadata == null) {
                throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u4e0d\u5b58\u5728", (String)"SysMenuServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            ArrayList<AppMenuElement> appMenus = new ArrayList<AppMenuElement>(10);
            String menuId = null;
            if (filters != null && filters.length > 0) {
                for (QFilter filter : filters) {
                    if (!SysMenuServiceImpl.PROP_ID.equalsIgnoreCase(filter.getProperty())) continue;
                    menuId = (String)filter.getValue();
                }
            }
            if (StringUtils.isNotBlank(menuId)) {
                AppMenuElement appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(menuId);
                appMenus.add(appMenuElement);
            } else {
                List visibleMenus = appMetadata.getAppMenus().stream().filter(e -> Boolean.TRUE.toString().equalsIgnoreCase(e.getVisible())).collect(Collectors.toList());
                appMenus.addAll(visibleMenus);
            }
            RestApiQueryResult result = new RestApiQueryResult();
            long startTime = System.currentTimeMillis();
            long endTime = System.currentTimeMillis();
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(10);
            this.buildRow(rows, appMenus, appId, appMetadata, null);
            result.setRows(rows);
            try {
                int totalCount = rows.size();
                result.setTotalCount(totalCount);
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= totalCount));
            }
            catch (Exception e2) {
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size()));
                log.debug("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Object)new RestApiException((Throwable)e2));
            }
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            SysLogServiceHelper.clickApp(appId);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private void buildRow(List<Map<String, Object>> rows, List<AppMenuElement> menuElements, String appId, AppMetadata appMetadata, Map<String, Object> row) {
            if (row == null) {
                List topMenus = menuElements.stream().filter(m -> appMetadata.getId().equalsIgnoreCase(m.getParentId())).collect(Collectors.toList());
                for (AppMenuElement topMenu : topMenus) {
                    block8: {
                        if ("bas_appstarted".equalsIgnoreCase(topMenu.getFormNumber())) continue;
                        String formId = topMenu.getFormId();
                        boolean istemplate = NoCodeTemplateUtil.queryTemplateAppIds().contains(appId);
                        if (StringUtils.isNotEmpty((CharSequence)formId) && !istemplate) {
                            try {
                                if (!this.checkPermForMenu(formId, topMenu)) {
                                }
                                break block8;
                            }
                            catch (KDException ex) {
                                log.warn((Throwable)ex);
                            }
                            continue;
                        }
                    }
                    HashMap<String, Object> topRow = new HashMap<String, Object>(10);
                    topRow.put(SysMenuServiceImpl.PROP_ID, topMenu.getId());
                    topRow.put(SysMenuServiceImpl.PROP_NAME, topMenu.getName().toString());
                    topRow.put(SysMenuServiceImpl.PROP_FORMID, topMenu.getFormId());
                    topRow.put(SysMenuServiceImpl.PROP_FORMNUMBER, topMenu.getFormNumber());
                    topRow.put(SysMenuServiceImpl.PROP_SEQ, topMenu.getSeq());
                    topRow.put(SysMenuServiceImpl.PROP_PARENTID, topMenu.getParentId());
                    topRow.put(SysMenuServiceImpl.PROP_TYPE, topMenu.getMenuType());
                    topRow.put(SysMenuServiceImpl.PROP_PARAM_IMAGE, this.getParameterImage(topMenu));
                    this.buildRow(rows, menuElements, appId, appMetadata, topRow);
                    rows.add(topRow);
                }
            } else {
                String rowId = (String)row.get(SysMenuServiceImpl.PROP_ID);
                List childMenus = menuElements.stream().filter(m -> rowId.equalsIgnoreCase(m.getParentId())).collect(Collectors.toList());
                for (AppMenuElement childMenu : childMenus) {
                    String formId = childMenu.getFormId();
                    boolean istemplate = NoCodeTemplateUtil.queryTemplateAppIds().contains(appId);
                    if (StringUtils.isNotEmpty((CharSequence)formId) && !istemplate && !this.checkPermForMenu(formId, childMenu)) continue;
                    HashMap<String, Object> childRow = new HashMap<String, Object>(10);
                    childRow.put(SysMenuServiceImpl.PROP_ID, childMenu.getId());
                    childRow.put(SysMenuServiceImpl.PROP_NAME, childMenu.getName().toString());
                    childRow.put(SysMenuServiceImpl.PROP_FORMID, childMenu.getFormId());
                    childRow.put(SysMenuServiceImpl.PROP_FORMNUMBER, childMenu.getFormNumber());
                    childRow.put(SysMenuServiceImpl.PROP_SEQ, childMenu.getSeq());
                    childRow.put(SysMenuServiceImpl.PROP_PARENTID, childMenu.getParentId());
                    childRow.put(SysMenuServiceImpl.PROP_TYPE, childMenu.getMenuType());
                    childRow.put(SysMenuServiceImpl.PROP_PARAM_IMAGE, this.getParameterImage(childMenu));
                    List childs = (List)row.computeIfAbsent(SysMenuServiceImpl.PROP_CHILDREN, k -> new ArrayList(10));
                    childs.add(childRow);
                    this.buildRow(rows, menuElements, appId, appMetadata, childRow);
                }
            }
        }

        private boolean checkPermForMenu(String formId, AppMenuElement menu) {
            if ("custom".equals(menu.getMenuType())) {
                return NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId);
            }
            return NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formId) || NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.input, (String)formId) || NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.delete, (String)formId) || NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.edit, (String)formId);
        }

        private Object getParameterImage(AppMenuElement menu) {
            String parameter = menu.getParameter();
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
            Object image = paramMap.get(SysMenuServiceImpl.PROP_PARAM_IMAGE);
            return Objects.isNull(image) ? "" : image;
        }
    }

    public static class MenuServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            Map saveResult;
            long startTime = System.currentTimeMillis();
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)param.getAppNumber());
            NoCodePermHelper.verifyManage((String)appId);
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
            ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
            this.classifyByKey(param, insertList, updateList);
            List<RestApiSaveItemData> insertIds = this.batchInsert(insertList, appMetadata);
            List<RestApiSaveItemData> updateIds = this.batchUpdate(updateList, appMetadata);
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(insertIds, updateIds);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean isDirdy = apiSaveResult.getResult().stream().anyMatch(RestApiSaveItemData::isBillStatus);
            if (isDirdy && (saveResult = AppMetaServiceHelper.save((AppMetadata)appMetadata)).size() > 0 && !Boolean.parseBoolean(saveResult.get(SysMenuServiceImpl.KEY_SUCCESS).toString())) {
                return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)saveResult.get(SysMenuServiceImpl.MESSAGE).toString(), (RestApiResponse)response, (long)modelTimeCost);
            }
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        protected void classifyByKey(RestApiSaveParam param, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
            for (Map dataMap : param.getDataList()) {
                String id = (String)dataMap.get(SysMenuServiceImpl.PROP_ID);
                if (id == null) {
                    insertList.add(dataMap);
                    continue;
                }
                dataMap.put(SysMenuServiceImpl.PROP_ID, id);
                updateList.add(dataMap);
            }
        }

        private List<RestApiSaveItemData> batchInsert(List<Map<String, Object>> insertList, AppMetadata appMetadata) {
            if (CollectionUtils.isEmpty(insertList)) {
                return Collections.emptyList();
            }
            return this.executeSave(insertList, true, appMetadata);
        }

        private List<RestApiSaveItemData> batchUpdate(List<Map<String, Object>> updateList, AppMetadata appMetadata) {
            if (CollectionUtils.isEmpty(updateList)) {
                return Collections.emptyList();
            }
            return this.executeSave(updateList, false, appMetadata);
        }

        protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean isInsert, AppMetadata appMetadata) {
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
            String id = null;
            int len = sourceDatas.size();
            for (int i = 0; i < len; ++i) {
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                Map<String, Object> dataMap = sourceDatas.get(i);
                try {
                    String propName = StringUtil.cleanXSSParam((String)((String)dataMap.get(SysMenuServiceImpl.PROP_NAME)));
                    propName = propName.length() > 50 ? propName.substring(0, 47) + "..." : propName;
                    LocaleString name = new LocaleString(propName);
                    Pair<String, String> idAndNumber = this.parseFormIdAndNumber(dataMap);
                    String formId = (String)idAndNumber.getKey();
                    String formNumber = (String)idAndNumber.getValue();
                    AppMenuElement appMenuElement = null;
                    if (isInsert) {
                        appMenuElement = new AppMenuElement();
                        id = FormMetaUtil.genIdUrlFriendly();
                        appMenuElement.setId(id);
                        appMenuElement.setVisible(Boolean.TRUE.toString());
                        Boolean enabled = (Boolean)dataMap.get("enabled");
                        if (Objects.nonNull(enabled)) {
                            appMenuElement.setVisible(enabled.toString());
                        }
                        appMenuElement.setNumber(id);
                        boolean custom = (Boolean)dataMap.getOrDefault("custom", false);
                        if (custom) {
                            appMenuElement.setMenuType("custom");
                        }
                    } else {
                        id = (String)dataMap.get(SysMenuServiceImpl.PROP_ID);
                        appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
                    }
                    if (!isInsert && !propName.equalsIgnoreCase(appMenuElement.getName().getLocaleValue()) && FormMetadataUtils.existByFormNumber((String)formNumber)) {
                        FormMetadataUtils.setFormName((String)formId, (LocaleString)name, (String)appMenuElement.getMenuType());
                    }
                    appMenuElement.setFormNumber(formNumber);
                    appMenuElement.setFormId(formId);
                    appMenuElement.setParameter(this.getParameter(dataMap));
                    appMenuElement.setCaption(name);
                    appMenuElement.setName(name);
                    appMenuElement.setDescription(name);
                    String parentId = this.parseParentId(dataMap, isInsert, appMetadata);
                    if (parentId == null) {
                        apiSaveData.setBillStatus(false);
                        RestApiSaveRowErrorData rowError = new RestApiSaveRowErrorData();
                        HashSet<String> msg = new HashSet<String>(1);
                        msg.add(ResManager.loadKDString((String)"parentId\u6709\u8bef:", (String)"SysMenuServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]) + parentId);
                        rowError.setRowMsg(msg);
                        apiSaveData.getErrors().add(rowError);
                        break;
                    }
                    appMenuElement.setParentId(parentId);
                    Short seq = this.parseSeq(dataMap, isInsert, appMetadata);
                    appMenuElement.setSeq(seq.shortValue());
                    appMetadata.getAppMenus().add(appMenuElement);
                    apiSaveData.setId(id);
                    apiSaveData.setBillStatus(true);
                }
                catch (Exception e) {
                    apiSaveData.addError(e);
                    apiSaveData.setBillStatus(false);
                }
                results.add(apiSaveData);
            }
            return results;
        }

        private String getParameter(Map<String, Object> dataMap) {
            String image = SysMenuServiceImpl.PROP_PARAM_IMAGE;
            if (dataMap.containsKey(SysMenuServiceImpl.PROP_PARAM_IMAGE)) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
                paramMap.put(SysMenuServiceImpl.PROP_PARAM_IMAGE, dataMap.get(SysMenuServiceImpl.PROP_PARAM_IMAGE));
                return SerializationUtils.toJsonString(paramMap);
            }
            return "";
        }

        private Pair<String, String> parseFormIdAndNumber(Map<String, Object> dataMap) {
            String formId = (String)dataMap.get(SysMenuServiceImpl.PROP_FORMID);
            String formNumber = (String)dataMap.get(SysMenuServiceImpl.PROP_FORMNUMBER);
            if (StringUtils.isNotBlank((CharSequence)formId) && StringUtils.isNotBlank((CharSequence)formNumber)) {
                return new Pair((Object)formId, (Object)formNumber);
            }
            if (StringUtils.isBlank((CharSequence)formId) && StringUtils.isBlank((CharSequence)formNumber)) {
                return new Pair((Object)"", (Object)"");
            }
            if (StringUtils.isBlank((CharSequence)formId)) {
                if (StringUtils.isNumeric((CharSequence)formNumber)) {
                    formId = formNumber;
                } else {
                    formId = FormMetaUtil.getFormIdByNumber((String)formNumber);
                    if (StringUtils.isBlank((CharSequence)formId)) {
                        formId = formNumber;
                        formNumber = FormMetaUtil.getFormNumberById((String)formId);
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                if (StringUtils.isNumeric((CharSequence)formId)) {
                    formNumber = formId;
                } else {
                    formNumber = FormMetaUtil.getFormNumberById((String)formId);
                    if (StringUtils.isBlank((CharSequence)formNumber)) {
                        formNumber = formId;
                        formId = FormMetaUtil.getFormIdByNumber((String)formNumber);
                    }
                }
            }
            return new Pair((Object)formId, (Object)formNumber);
        }

        private String parseParentId(Map<String, Object> dataMap, boolean isInsert, AppMetadata appMetadata) {
            String parentId = (String)dataMap.get(SysMenuServiceImpl.PROP_PARENTID);
            if (StringUtils.isBlank((CharSequence)parentId) && isInsert) {
                return appMetadata.getId();
            }
            if (StringUtils.isBlank((CharSequence)parentId) && !isInsert) {
                String id = (String)dataMap.get(SysMenuServiceImpl.PROP_ID);
                AppMenuElement appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
                if (appMenuElement == null) {
                    return null;
                }
                return appMenuElement.getParentId();
            }
            AppMenuElement parentAppMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(parentId);
            if (parentId.equalsIgnoreCase(appMetadata.getBizappId())) {
                return parentId;
            }
            if (parentAppMenuElement == null) {
                return null;
            }
            return parentId;
        }

        private Short parseSeq(Map<String, Object> dataMap, boolean isInsert, AppMetadata appMetadata) {
            String parentId = (String)dataMap.get(SysMenuServiceImpl.PROP_PARENTID);
            if (dataMap.containsKey(SysMenuServiceImpl.PROP_SEQ) && dataMap.get(SysMenuServiceImpl.PROP_SEQ) != null) {
                Integer seq = (Integer)dataMap.get(SysMenuServiceImpl.PROP_SEQ);
                return Short.parseShort(seq.toString());
            }
            if (isInsert) {
                if (StringUtils.isBlank((CharSequence)parentId)) {
                    Set seqs = appMetadata.getAppMenus().stream().filter(m -> appMetadata.getId().equalsIgnoreCase(m.getParentId())).map(AppMenuElement::getSeq).collect(Collectors.toSet());
                    Short maxSeq = seqs.isEmpty() ? Short.valueOf((short)0) : (Short)Collections.max(seqs);
                    int iSeq = maxSeq + 1;
                    return Short.parseShort(Integer.toString(iSeq));
                }
                Set seqs = appMetadata.getAppMenus().stream().filter(m -> parentId.equalsIgnoreCase(m.getParentId())).map(AppMenuElement::getSeq).collect(Collectors.toSet());
                Short maxSeq = seqs.isEmpty() ? Short.valueOf((short)0) : (Short)Collections.max(seqs);
                int iSeq = maxSeq + 1;
                return Short.parseShort(Integer.toString(iSeq));
            }
            String id = (String)dataMap.get(SysMenuServiceImpl.PROP_ID);
            AppMenuElement appMenuElement = (AppMenuElement)appMetadata.getMapMenus().get(id);
            if (StringUtils.isNotBlank((CharSequence)parentId) && !parentId.equalsIgnoreCase(appMenuElement.getParentId())) {
                Set seqs = appMetadata.getAppMenus().stream().filter(m -> parentId.equalsIgnoreCase(m.getParentId())).map(AppMenuElement::getSeq).collect(Collectors.toSet());
                Short maxSeq = seqs.isEmpty() ? Short.valueOf((short)0) : (Short)Collections.max(seqs);
                int iSeq = maxSeq + 1;
                return Short.parseShort(Integer.toString(iSeq));
            }
            return appMenuElement.getSeq();
        }
    }
}

