/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.cache.RestApiServiceLocalCache;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SysPlatformServiceImpl {
    private static final Log log = LogFactory.getLog(SysPlatformServiceImpl.class);
    private static final String PROP_ID = "id";
    private static final String PROP_BIZAPP_ID = "bizappid";
    private static final String PROP_NAME = "name";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_VISIBLE = "visible";
    private static final String ALGO_KEY_COUNT = "NOCODE_PLATINFO_COUNT_FORM";
    private static final String PROP_BIZCLOUD = "bizcloud";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (!(param instanceof RestApiSaveParam)) {
            if (param instanceof RestApiQueryParam) {
                PlatformServiceQueryImpl adminServiceQuery = new PlatformServiceQueryImpl();
                return adminServiceQuery.execute((RestApiQueryParam)param);
            }
            if (param instanceof RestApiDeleteParam) {
                // empty if block
            }
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysPlatformServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class PlatformServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            NoCodePermHelper.verifyPlatManage();
            ArrayList<Map> ret = new ArrayList<Map>(8);
            ArrayList<QFilter> appFilters = new ArrayList<QFilter>();
            appFilters.add(new QFilter(SysPlatformServiceImpl.PROP_BIZCLOUD, "=", (Object)RestApiServiceLocalCache.getNoCodeCloudId()));
            appFilters.add(new QFilter(SysPlatformServiceImpl.PROP_NUMBER, "!=", (Object)"nocode_fromtemplate_app"));
            appFilters.add(new QFilter(SysPlatformServiceImpl.PROP_VISIBLE, "=", (Object)true));
            int records = 0;
            boolean formNums = false;
            DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)SysPlatformServiceImpl.PROP_ID, (QFilter[])appFilters.toArray(new QFilter[0]));
            List appids = Arrays.stream(apps).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
            Map row = Maps.of((Object)"appNums", (Object)appids.size());
            row.put("formNums", FormMetaUtil.getMenuCountInNoCodeCloud());
            row.put("recordNums", records);
            ret.add(row);
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(ret);
            result.setTotalCount(1);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            log.debug("nocode AppServiceQueryImpl execute end");
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }
    }
}

