/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.cache.NoCodeCacheHelper;
import kd.bos.nocode.cache.NoCodeCacheService;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.service.sys.helper.AppServiceHelper;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.AppManageTypeEnum;
import kd.bos.permission.nocode.model.AppUseTypeEnum;
import kd.bos.permission.nocode.model.DataRule;
import kd.bos.permission.nocode.model.DataRuleTypeEnum;
import kd.bos.permission.nocode.model.EntityPerm;
import kd.bos.permission.nocode.model.PermItem;
import kd.bos.permission.nocode.model.Role;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;

public class SysRoleServiceImpl {
    private static final Log log = LogFactory.getLog(SysRoleServiceImpl.class);
    private static final String PROP_ID = "id";
    private static final String PROP_NAME = "name";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_DESC = "desc";
    private static final String PROP_SEQ = "seq";
    private static final String PROP_APPID = "appId";
    private static final int ROLE_NAME_MAX_LENGTH = 50;

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            RoleServiceSaveImpl roleServiceSave = new RoleServiceSaveImpl();
            return roleServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            RoleServiceQueryImpl roleServiceQuery = new RoleServiceQueryImpl();
            return roleServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            RoleDeleteServiceImpl roleServiceDelete = new RoleDeleteServiceImpl();
            return roleServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysRoleServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class RoleDeleteServiceImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            long start = System.currentTimeMillis();
            Map data = (Map)param.getRequest().getData();
            List list = (List)data.get("data");
            String id = (String)((Map)list.get(0)).get(SysRoleServiceImpl.PROP_ID);
            RolePerm role = NoCodePermissionServiceHelper.getRolePerm((String)id);
            if (role == null) {
                throw new RestApiException("unknown role");
            }
            String appid = role.getAppId();
            NoCodePermHelper.verifyManage((String)appid);
            if (role.isSystem()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u89d2\u8272\u4e0d\u53ef\u5220\u9664", (String)"SysRoleServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            NoCodePermissionServiceHelper.deleteRole((Role)role);
            RestApiDeleteResult ret = new RestApiDeleteResult();
            RestBaseFilterItemData item = new RestBaseFilterItemData();
            if (!role.getErrors().isEmpty()) {
                item.setBillStatus(false);
                item.setErrors(new ArrayList(role.getErrors()));
                ret.setSuccessCount(0L);
                ret.setFailCount(1L);
            } else {
                item.setId(id);
                item.setBillStatus(true);
                ret.setSuccessCount(1L);
                ret.setFailCount(0L);
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(1);
            resultsData.add(item);
            long end = System.currentTimeMillis();
            ret.setTotalCount(1L);
            ret.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }
    }

    public static class RoleServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            log.debug("nocode AppServiceQueryImpl execute begin");
            long startTime = System.currentTimeMillis();
            ArrayList ret = new ArrayList(64);
            List<Object> roles = new ArrayList();
            if (param.getRequest().getHttpQueryString().containsKey("roleId")) {
                String roleId = (String)param.getRequest().getHttpQueryString().get("roleId");
                RolePerm role = NoCodePermissionServiceHelper.getRolePerm((String)roleId);
                if (role != null) {
                    String appid = role.getAppId();
                    NoCodePermHelper.verifyManage((String)appid);
                    roles = Collections.singletonList(role);
                }
            } else {
                String appid = (String)param.getRequest().getHttpQueryString().get(SysRoleServiceImpl.PROP_ID);
                NoCodePermHelper.verifyManage((String)appid);
                roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
            }
            Set uids = roles.stream().filter(RolePerm.class::isInstance).map(r -> (RolePerm)r).map(RolePerm::getAssignUserIds).flatMap(Collection::stream).collect(Collectors.toSet());
            Set oids = roles.stream().filter(RolePerm.class::isInstance).map(r -> (RolePerm)r).map(RolePerm::getAssignOrgIds).flatMap(Collection::stream).collect(Collectors.toSet());
            HashMap<Long, Pair> userInfos = new HashMap<Long, Pair>();
            if (!uids.isEmpty()) {
                QFilter[] filters = new QFilter[]{new QFilter(SysRoleServiceImpl.PROP_ID, "in", uids)};
                String select = String.join((CharSequence)",", SysRoleServiceImpl.PROP_NUMBER, SysRoleServiceImpl.PROP_NAME);
                Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)select, (QFilter[])filters);
                for (Map.Entry entry : map.entrySet()) {
                    String string = ((DynamicObject)entry.getValue()).getString(SysRoleServiceImpl.PROP_NAME);
                    String number = ((DynamicObject)entry.getValue()).getString(SysRoleServiceImpl.PROP_NUMBER);
                    userInfos.put((Long)entry.getKey(), new Pair((Object)string, (Object)number));
                }
            }
            HashMap<Long, Pair> orgInfos = new HashMap<Long, Pair>();
            if (!oids.isEmpty()) {
                QFilter[] filters = new QFilter[]{new QFilter(SysRoleServiceImpl.PROP_ID, "in", oids)};
                String string = String.join((CharSequence)",", SysRoleServiceImpl.PROP_NUMBER, SysRoleServiceImpl.PROP_NAME);
                Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)string, (QFilter[])filters);
                for (Map.Entry entry : dynamicObjects.entrySet()) {
                    String name = ((DynamicObject)entry.getValue()).getString(SysRoleServiceImpl.PROP_NAME);
                    String number = ((DynamicObject)entry.getValue()).getString(SysRoleServiceImpl.PROP_NUMBER);
                    orgInfos.put((Long)entry.getKey(), new Pair((Object)name, (Object)number));
                }
            }
            roles.sort(Comparator.comparingInt(Role::getSortCode));
            for (Role role : roles) {
                LinkedHashMap<String, Object> role2 = new LinkedHashMap<String, Object>();
                ret.add(role2);
                role2.put(SysRoleServiceImpl.PROP_ID, role.getId());
                role2.put(SysRoleServiceImpl.PROP_NAME, NoCodePermHelper.getRoleName((String)role.getName()));
                role2.put(SysRoleServiceImpl.PROP_DESC, role.getDescription());
                role2.put(SysRoleServiceImpl.PROP_APPID, role.getAppId());
                role2.put(SysRoleServiceImpl.PROP_SEQ, role.getSortCode());
                role2.put("system", role.isSystem());
                if (role instanceof RolePerm) {
                    HashMap<String, Object> map;
                    for (Long l : ((RolePerm)role).getAssignOrgIds()) {
                        List orgs = (List)role2.computeIfAbsent("orgs", s -> new ArrayList());
                        map = new HashMap<String, Object>();
                        if (!orgInfos.containsKey(l)) continue;
                        orgs.add(map);
                        map.put(SysRoleServiceImpl.PROP_ID, l);
                        map.put(SysRoleServiceImpl.PROP_NAME, ((Pair)orgInfos.get(l)).getKey());
                        map.put(SysRoleServiceImpl.PROP_NUMBER, ((Pair)orgInfos.get(l)).getValue());
                    }
                    for (Long l : ((RolePerm)role).getAssignUserIds()) {
                        List users = (List)role2.computeIfAbsent("users", s -> new ArrayList());
                        map = new HashMap();
                        if (!userInfos.containsKey(l)) continue;
                        users.add(map);
                        map.put(SysRoleServiceImpl.PROP_ID, l);
                        map.put(SysRoleServiceImpl.PROP_NAME, ((Pair)userInfos.get(l)).getKey());
                        map.put(SysRoleServiceImpl.PROP_NUMBER, ((Pair)userInfos.get(l)).getValue());
                    }
                    Map map2 = ((RolePerm)role).getEntityNumberPermMap();
                    for (Map.Entry entry : map2.entrySet()) {
                        Set set;
                        PermItem item;
                        if (role.getAppUseType() == AppUseTypeEnum.OWN || role.getAppUseType() == AppUseTypeEnum.VIEW_ALL) {
                            Map appPerm = (Map)role2.computeIfAbsent("appPerm", s -> new HashMap());
                            List permIds = (List)appPerm.computeIfAbsent("funcPermSet", s -> new ArrayList());
                            ((EntityPerm)entry.getValue()).getPermItemMap().keySet().stream().map(FuncPermItemEnum::getById).filter(Objects::nonNull).map(FuncPermItemEnum::getNumber).forEach(permIds::add);
                            continue;
                        }
                        Map formPerm = (Map)role2.computeIfAbsent("formPerm", s -> new HashMap());
                        Map funcPerm = (Map)formPerm.computeIfAbsent(entry.getKey(), s -> new HashMap());
                        List permIds = (List)funcPerm.computeIfAbsent("funcPermSet", s -> new ArrayList());
                        Map permItemMap = ((EntityPerm)entry.getValue()).getPermItemMap();
                        permItemMap.keySet().stream().map(FuncPermItemEnum::getById).filter(Objects::nonNull).map(FuncPermItemEnum::getNumber).forEach(permIds::add);
                        DataRule dataRule = ((EntityPerm)entry.getValue()).getDataRule();
                        switch (dataRule.getType()) {
                            case ALL: {
                                funcPerm.put("record", "0");
                                break;
                            }
                            case OWN: {
                                funcPerm.put("record", "1");
                                break;
                            }
                            case VIEW_ALL: {
                                funcPerm.put("record", "3");
                                break;
                            }
                            case CUSTOM: {
                                funcPerm.put("record", "2");
                                List filterRows = (List)JSONArray.parse((String)dataRule.getNoCodeRule());
                                ListFilterConfigUtils.clearInvalidFilterRows((String)entry.getKey(), filterRows);
                                funcPerm.put("filters", filterRows);
                            }
                        }
                        Map fieldPermSet = (Map)funcPerm.computeIfAbsent("fieldPermSet", s -> new HashMap());
                        if (permItemMap.containsKey(FuncPermItemEnum.view.getId())) {
                            item = (PermItem)permItemMap.get(FuncPermItemEnum.view.getId());
                            set = (Set)fieldPermSet.computeIfAbsent("view", s -> new HashSet());
                            set.addAll(item.getNoPermProperties());
                        }
                        if (permItemMap.containsKey(FuncPermItemEnum.input.getId())) {
                            item = (PermItem)permItemMap.get(FuncPermItemEnum.input.getId());
                            set = (Set)fieldPermSet.computeIfAbsent("input", s -> new HashSet());
                            set.addAll(item.getNoPermProperties());
                        }
                        if (!permItemMap.containsKey(FuncPermItemEnum.edit.getId())) continue;
                        item = (PermItem)permItemMap.get(FuncPermItemEnum.edit.getId());
                        set = (Set)fieldPermSet.computeIfAbsent("edit", s -> new HashSet());
                        set.addAll(item.getNoPermProperties());
                    }
                }
                role2.put("manage", role.getAppManageType() == AppManageTypeEnum.ALL);
                role2.put("useType", role.getAppUseType().getValue());
            }
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(ret);
            result.setTotalCount(roles.size());
            RestApiResponse restApiResponse = new RestApiResponse();
            restApiResponse.setData((Object)result);
            log.debug("nocode AppServiceQueryImpl execute end");
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)restApiResponse, (long)startTime, (long)endTime);
        }
    }

    public static class RoleServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            boolean reorder = ((Map)param.getRequest().getData()).getOrDefault("reorder", false);
            List<RestApiSaveItemData> saveIds = this.executeSave(param.getDataList(), reorder);
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(saveIds);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean reorder) {
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
            if (reorder) {
                this.reorder(sourceDatas);
                return results;
            }
            Map<String, Object> dataMap = sourceDatas.get(0);
            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
            if (((Boolean)dataMap.getOrDefault("copy", false)).booleanValue()) {
                RoleServiceSaveImpl.copyRole(dataMap, apiSaveData);
            } else {
                RolePerm role;
                String id = (String)dataMap.get(SysRoleServiceImpl.PROP_ID);
                boolean add = false;
                String appid = (String)dataMap.get(SysRoleServiceImpl.PROP_APPID);
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    role = NoCodePermissionServiceHelper.getRolePerm((String)id);
                    apiSaveData.setType("Update");
                } else {
                    add = true;
                    role = new RolePerm();
                    role.setAppId(appid);
                    role.setSortCode(1);
                }
                NoCodePermHelper.verifyManage((String)appid);
                String name = (String)dataMap.get(SysRoleServiceImpl.PROP_NAME);
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    if (name.contains("$")) {
                        throw new RestApiException(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u4e0d\u53ef\u5305\u542b\u7279\u6b8a\u5b57\u7b26", (String)"SysRoleServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
                    }
                    name = StringUtil.cleanXSSParam((String)name);
                }
                apiSaveData.setNumber(name);
                name = NoCodePermHelper.setRoleName((String)name, (String)ID.genStringId());
                role.setName(name);
                String desc = (String)dataMap.get(SysRoleServiceImpl.PROP_DESC);
                role.setDescription(desc);
                if (add) {
                    if (!dataMap.containsKey(SysRoleServiceImpl.PROP_SEQ)) {
                        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
                        int seq = roles.stream().mapToInt(Role::getSortCode).max().orElse(0) + 1;
                        role.setSortCode(seq);
                    } else {
                        int seq = (Integer)dataMap.get(SysRoleServiceImpl.PROP_SEQ);
                        role.setSortCode(seq);
                    }
                }
                if (dataMap.containsKey("manage")) {
                    boolean manage = (Boolean)dataMap.get("manage");
                    role.setAppManageType(manage ? AppManageTypeEnum.ALL : AppManageTypeEnum.NONE);
                } else {
                    role.setAppManageType(AppManageTypeEnum.NONE);
                }
                if (dataMap.containsKey("useType")) {
                    String type = (String)dataMap.get("useType");
                    AppUseTypeEnum e = AppUseTypeEnum.of((String)type);
                    role.setAppUseType(e);
                } else {
                    role.setAppUseType(AppUseTypeEnum.CUSTOM);
                }
                role.setEntityNumberPermMap(new HashMap());
                if (role.getAppUseType().equals((Object)AppUseTypeEnum.VIEW_ALL)) {
                    EntityPerm perm = EntityPerm.createPublicEntityInstance();
                    Map map = role.getEntityNumberPermMap();
                    map.put(perm.getEntityNumber(), perm);
                    Set funcPermSet = Arrays.stream(FuncPermItemEnum.values()).map(FuncPermItemEnum::getNumber).collect(Collectors.toSet());
                    this.setFuncPerm(Maps.of((Object)"funcPermSet", funcPermSet), perm.getPermItemMap());
                    this.setDataPerm(Maps.of((Object)"record", (Object)"3"), perm);
                } else if (dataMap.containsKey("formPerm")) {
                    Map formPerm = (Map)dataMap.get("formPerm");
                    Map map = role.getEntityNumberPermMap();
                    for (Map.Entry entry : formPerm.entrySet()) {
                        String formId = (String)entry.getKey();
                        EntityPerm entityPerm = new EntityPerm(formId, formId);
                        map.put(formId, entityPerm);
                        this.setFuncPerm((Map)entry.getValue(), entityPerm.getPermItemMap());
                        this.setDataPerm((Map)entry.getValue(), entityPerm);
                        this.setFieldPerm((Map)entry.getValue(), entityPerm, formId);
                    }
                } else if (dataMap.containsKey("appPerm")) {
                    Map appPerm = (Map)dataMap.get("appPerm");
                    EntityPerm perm = EntityPerm.createPublicEntityInstance();
                    Map map = role.getEntityNumberPermMap();
                    map.put(perm.getEntityNumber(), perm);
                    this.setFuncPerm(appPerm, perm.getPermItemMap());
                    appPerm.put("record", "1");
                    this.setDataPerm(appPerm, perm);
                }
                if (dataMap.containsKey("users")) {
                    RoleServiceSaveImpl.assignUser(dataMap, role);
                }
                if (dataMap.containsKey("orgs")) {
                    RoleServiceSaveImpl.assignOrg(dataMap, role);
                }
                NoCodePermissionServiceHelper.saveRolePerm((RolePerm)role);
                apiSaveData.setId(role.getId());
                if (!role.getErrors().isEmpty()) {
                    throw new RestApiException(JSON.toJSONString((Object)role.getErrors()));
                }
                apiSaveData.setBillStatus(true);
                this.clearListSchemaAndListItemConfigCache(role.getAppId());
            }
            results.add(apiSaveData);
            return results;
        }

        private void clearListSchemaAndListItemConfigCache(String appId) {
            NoCodeCacheService cacheService = NoCodeCacheService.getInstance();
            Set formIds = FormMetaUtil.getMenuFormIdsByAppId((String)appId);
            formIds.forEach(formId -> {
                String listSchemaKey = NoCodeCacheHelper.getCacheKey((String[])new String[]{"list/schema", formId});
                cacheService.remove(listSchemaKey);
                String cacheKey = String.format("nocode:listItemConfig:%s", formId);
                cacheService.remove(cacheKey);
            });
        }

        private static void assignOrg(Map<String, Object> dataMap, RolePerm role) {
            Set scope;
            long uid = RequestContext.get().getCurrUserId();
            List orgs = (List)dataMap.get("orgs");
            Map<Long, String> orgMap = orgs.stream().collect(Collectors.toMap(m -> Long.parseLong(m.get(SysRoleServiceImpl.PROP_ID).toString()), m -> m.get(SysRoleServiceImpl.PROP_NAME).toString()));
            boolean manage = NoCodePermHelper.checkUserPlatManageInNoCode();
            HashSet<Long> oids = new HashSet<Long>(orgMap.keySet());
            if (!manage && (scope = NoCodePermissionServiceHelper.getSystemRoleOrgIds((long)uid, (boolean)true)) != null && !scope.containsAll(oids)) {
                for (Long s : scope) {
                    orgMap.remove(s);
                }
                throw new RestApiException(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u4e0d\u5728\u53ef\u6388\u6743\u8303\u56f4\u5185\uff1a", (String)"SysRoleServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]) + String.join((CharSequence)"\uff0c", orgMap.values()));
            }
            role.setAssignOrgIds(oids);
        }

        private static void assignUser(Map<String, Object> dataMap, RolePerm role) {
            long uid = RequestContext.get().getCurrUserId();
            List users = (List)dataMap.get("users");
            Map<Long, String> userMap = users.stream().collect(Collectors.toMap(m -> Long.parseLong(m.get(SysRoleServiceImpl.PROP_ID).toString()), m -> m.get(SysRoleServiceImpl.PROP_NAME).toString()));
            boolean manage = NoCodePermHelper.checkUserPlatManageInNoCode();
            HashSet<Long> uids = new HashSet<Long>(userMap.keySet());
            if (!manage) {
                Set scope = NoCodePermissionServiceHelper.getSystemRoleUserIds((long)uid, (boolean)true);
                if (Objects.nonNull(scope)) {
                    AppServiceHelper.getAppCreator(role.getAppId()).ifPresent(scope::add);
                }
                if (scope != null && !scope.containsAll(uids)) {
                    for (Long s : scope) {
                        userMap.remove(s);
                    }
                    throw new RestApiException(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4eba\u5458\u4e0d\u5728\u53ef\u6388\u6743\u8303\u56f4\u5185\uff1a", (String)"SysRoleServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]) + String.join((CharSequence)"\uff0c", userMap.values()));
                }
            }
            role.setAssignUserIds(uids);
        }

        private static void copyRole(Map<String, Object> dataMap, RestApiSaveItemData apiSaveData) {
            String id = (String)dataMap.get(SysRoleServiceImpl.PROP_ID);
            if (StringUtils.isEmpty((CharSequence)id)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u590d\u5236\u65f6\u89d2\u8272id\u4e0d\u53ef\u4e3a\u7a7a", (String)"SysRoleServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            Role old = NoCodePermissionServiceHelper.getRole((String)id);
            String name = NoCodePermHelper.getRoleName((String)old.getName());
            name = name + ResManager.loadKDString((String)"-\u590d\u5236", (String)"SysRoleServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]);
            RolePerm rolePerm = NoCodePermissionServiceHelper.copyRolePerm((String)id, (String)(name = NoCodePermHelper.setRoleName((String)name, (String)ID.genStringId())));
            if (!rolePerm.getErrors().isEmpty()) {
                throw new RestApiException(String.join((CharSequence)",", rolePerm.getErrors()));
            }
            apiSaveData.setBillStatus(true);
        }

        private void reorder(List<Map<String, Object>> sourceDatas) {
            if (sourceDatas.isEmpty()) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (Map<String, Object> dataMap : sourceDatas) {
                String id = (String)dataMap.get(SysRoleServiceImpl.PROP_ID);
                ids.add(id);
            }
            String res = NoCodePermissionServiceHelper.updateRoleSort(ids);
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                throw new RestApiException(res);
            }
        }

        private void setFuncPerm(Map<String, Object> dataMap, Map<String, PermItem> perm) {
            if (dataMap.containsKey("funcPermSet")) {
                Collection funcPermSet = (Collection)dataMap.get("funcPermSet");
                funcPermSet.stream().map(FuncPermItemEnum::getByNum).filter(Objects::nonNull).map(FuncPermItemEnum::getId).forEach(p -> perm.put((String)p, new PermItem(p)));
            }
        }

        private void setDataPerm(Map<String, Object> value, EntityPerm entityPerm) {
            String record;
            DataRule dataRule = new DataRule();
            switch (record = (String)value.getOrDefault("record", "0")) {
                case "0": {
                    dataRule.setType(DataRuleTypeEnum.ALL);
                    break;
                }
                case "1": {
                    dataRule.setType(DataRuleTypeEnum.OWN);
                    dataRule.setNoCodeRule("[{\"fieldName\":\"nocodecreatorfield\",\"compareType\":\"701\",\"value\":[]}]");
                    break;
                }
                case "2": {
                    dataRule.setType(DataRuleTypeEnum.CUSTOM);
                    if (value.containsKey("filters")) {
                        List filters = (List)value.get("filters");
                        String json = SerializationUtils.toJsonString((Object)filters);
                        if (filters.isEmpty() || StringUtils.isEmpty((CharSequence)json)) {
                            dataRule.setType(DataRuleTypeEnum.ALL);
                            break;
                        }
                        dataRule.setNoCodeRule(json);
                        break;
                    }
                    dataRule.setType(DataRuleTypeEnum.ALL);
                    break;
                }
                case "3": {
                    dataRule.setType(DataRuleTypeEnum.VIEW_ALL);
                    dataRule.setNoCodeRule("[{\"fieldName\":\"nocodecreatorfield\",\"compareType\":\"701\",\"value\":[]}]");
                }
            }
            entityPerm.setDataRule(dataRule);
        }

        private void setFieldPerm(Map<String, Object> value, EntityPerm entityPerm, String formId) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
            if (value.containsKey("fieldPermSet")) {
                Map fieldPermSet = (Map)value.get("fieldPermSet");
                List view = fieldPermSet.getOrDefault("view", new ArrayList());
                this.addRefBillKey(view, dt);
                PermItem viewPerm = (PermItem)entityPerm.getPermItemMap().get(FuncPermItemEnum.view.getId());
                if (viewPerm != null) {
                    view.forEach(e -> viewPerm.getNoPermProperties().add(e));
                }
                List input = fieldPermSet.getOrDefault("input", new ArrayList());
                this.addRefBillKey(input, dt);
                PermItem inputPerm = (PermItem)entityPerm.getPermItemMap().get(FuncPermItemEnum.input.getId());
                if (inputPerm != null) {
                    input.forEach(e -> inputPerm.getNoPermProperties().add(e));
                }
                List edit = fieldPermSet.getOrDefault("edit", new ArrayList());
                this.addRefBillKey(edit, dt);
                PermItem editPerm = (PermItem)entityPerm.getPermItemMap().get(FuncPermItemEnum.edit.getId());
                if (editPerm != null) {
                    edit.forEach(e -> editPerm.getNoPermProperties().add(e));
                }
            }
        }

        private void addRefBillKey(List<String> fields, MainEntityType dt) {
            Set refBillKey = fields.stream().map(arg_0 -> ((MainEntityType)dt).findProperty(arg_0)).filter(e -> e instanceof NoCodeRefBillTableProp).map(e -> ((NoCodeRefBillTableProp)e).getRefBillKey()).collect(Collectors.toSet());
            fields.addAll(refBillKey);
            fields.removeIf(field -> {
                IDataEntityProperty property = dt.findProperty(field);
                return property instanceof INoCodeRefBillProp && StringUtils.isNotBlank((CharSequence)((INoCodeRefBillProp)property).getRefTableKey()) && !fields.contains(((INoCodeRefBillProp)property).getRefTableKey());
            });
        }
    }
}

