/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SysRuleServiceImpl {
    private static final String PROP_NAME = "name";
    private static final Log log = LogFactory.getLog(SysRuleServiceImpl.class);

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            RuleServiceSaveImpl ruleServiceSave = new RuleServiceSaveImpl();
            return ruleServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            RuleServiceQueryImpl ruleServiceQuery = new RuleServiceQueryImpl();
            return ruleServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            RuleDeleteServiceImpl ruleServiceDelete = new RuleDeleteServiceImpl();
            return ruleServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysRuleServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class RuleDeleteServiceImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            long start = System.currentTimeMillis();
            Map data = (Map)param.getRequest().getData();
            List list = (List)data.get("data");
            RestApiDeleteResult ret = new RestApiDeleteResult();
            RestBaseFilterItemData item = new RestBaseFilterItemData();
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(1);
            resultsData.add(item);
            long end = System.currentTimeMillis();
            ret.setTotalCount(1L);
            ret.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)ret);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }
    }

    public static class RuleServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            RestApiQueryResult result = new RestApiQueryResult();
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            log.debug("nocode AppServiceQueryImpl execute end");
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }
    }

    public static class RuleServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            this.checkParam(param);
            List<RestApiSaveItemData> saveIds = this.executeSave(param.getDataList());
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(saveIds);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private void checkParam(RestApiSaveParam param) {
        }

        protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas) {
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
            ArrayList<DynamicObject> save = new ArrayList<DynamicObject>(sourceDatas.size());
            for (Map<String, Object> data : sourceDatas) {
                DynamicObject dy;
                RestApiSaveItemData item;
                block3: {
                    item = new RestApiSaveItemData();
                    results.add(item);
                    dy = null;
                    try {
                        String ruleType = (String)data.get("ruleType");
                        if (!"0".equals(ruleType)) break block3;
                        dy = this.dealWithFormRule(data);
                    }
                    catch (Exception e) {
                        item.setBillStatus(false);
                        item.addError(e);
                        continue;
                    }
                }
                save.add(dy);
                item.setBillStatus(true);
            }
            SaveServiceHelper.save((DynamicObject[])save.toArray(new DynamicObject[0]));
            return results;
        }

        private DynamicObject dealWithFormRule(Map<String, Object> data) {
            String formId = (String)data.get("formId");
            String ruleType = (String)data.get("ruleType");
            String name = (String)data.get(SysRuleServiceImpl.PROP_NAME);
            List preCondition = (List)data.get("preCondition");
            String conditionExpr = SerializationUtils.toJsonString((Object)preCondition);
            List trueAction = (List)data.get("trueAction");
            String actionExpr = SerializationUtils.toJsonString((Object)trueAction);
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_rule");
            dy.set(SysRuleServiceImpl.PROP_NAME, (Object)name);
            dy.set("formid", (Object)formId);
            dy.set("expression", (Object)conditionExpr);
            dy.set("trueaction", (Object)actionExpr);
            dy.set("ruletype", (Object)ruleType);
            dy.set("creater", (Object)RequestContext.get().getCurrUserId());
            StringBuilder expression = new StringBuilder();
            for (Map map : preCondition) {
                if (map.get("fieldValue") == null) {
                    expression.append(map.get("fieldName")).append(map.get("compareType")).append(" and ");
                    continue;
                }
                Map valueMap = (Map)map.get("fieldValue");
                expression.append(map.get("fieldName")).append(map.get("compareType")).append(valueMap.get("value")).append(" and ");
            }
            if (StringUtils.isNotBlank((CharSequence)expression.toString())) {
                expression = new StringBuilder(expression.substring(0, expression.length() - 5));
                String[] vars = FormulaEngine.extractVariables((String)expression.toString());
                String depfldkeys = String.join((CharSequence)",", Arrays.asList(vars));
                dy.set("depfldkeys", (Object)depfldkeys);
            }
            StringBuilder affectfldkeys = new StringBuilder();
            for (Map action : trueAction) {
                String fieldKey = (String)action.get("filedName");
                affectfldkeys.append(fieldKey).append(",");
            }
            if (!StringUtils.isBlank((CharSequence)affectfldkeys.toString())) {
                affectfldkeys = new StringBuilder(affectfldkeys.substring(0, affectfldkeys.length() - 1));
                dy.set("affectfldkeys", (Object)affectfldkeys.toString());
            }
            return dy;
        }
    }
}

