/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.sys.SysAppServiceImpl;
import kd.bos.nocode.restapi.service.sys.helper.AppServiceHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessTemplate;

public class SysTemplateServiceImpl {
    private static final Log log = LogFactory.getLog(SysTemplateServiceImpl.class);
    private static final String TEMPLATE_FILTER = "template_filter";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            TemplateServiceSaveImpl saveService = new TemplateServiceSaveImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            TemplateServiceQueryImpl queryService = new TemplateServiceQueryImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            TemplateServiceDeleteImpl deleteService = new TemplateServiceDeleteImpl();
            return deleteService.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"SysTemplateServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class TemplateServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            String templateFilter = (String)param.getRequest().getHttpQueryString().remove(SysTemplateServiceImpl.TEMPLATE_FILTER);
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (Objects.equals(templateFilter, "1")) {
                QFilter myCreateFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
                filters = (QFilter[])ArrayUtils.add((Object[])filters, (Object)myCreateFilter);
            }
            String selectFields = "id,name,desc,image,appid,formid,creator,type,domains,trades,icon,org,tag,frequency,createdate";
            if (param.getSelect() != null && !param.getSelect().isEmpty()) {
                selectFields = String.join((CharSequence)",", param.getSelect());
            }
            String[] splitFields = selectFields.split(",");
            HashSet selectSet = new HashSet(splitFields.length);
            Collections.addAll(selectSet, splitFields);
            String orderBy = param.getOrder_by();
            if (StringUtils.isBlank((CharSequence)orderBy)) {
                orderBy = "createdate desc";
            }
            RestApiQueryResult result = new RestApiQueryResult();
            long startTime = System.currentTimeMillis();
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_nocode_templateconfig", (String)selectFields, (QFilter[])filters, (String)orderBy);
            long endTime = System.currentTimeMillis();
            long uid = RequestContext.get().getCurrUserId();
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(dynamicObjects.length);
            for (DynamicObject dy : dynamicObjects) {
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                rows.add(row);
                for (String s : selectSet) {
                    row.put(s, dy.get(s));
                }
                List domains = dy.getDynamicObjectCollection("domains").stream().map(dynamicObject -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", dynamicObject.getDynamicObject("fbasedataid").get("id"));
                    map.put("name", dynamicObject.getDynamicObject("fbasedataid").get("name"));
                    return map;
                }).collect(Collectors.toList());
                List trades = dy.getDynamicObjectCollection("trades").stream().map(dynamicObject -> {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", dynamicObject.getDynamicObject("fbasedataid").get("id"));
                    map.put("name", dynamicObject.getDynamicObject("fbasedataid").get("name"));
                    return map;
                }).collect(Collectors.toList());
                row.put("domains", domains);
                row.put("trades", trades);
                DynamicObject creator = dy.getDynamicObject("creator");
                HashMap<String, Object> c = new HashMap<String, Object>();
                c.put("name", creator.getLocaleString("name").getLocaleValue());
                c.put("id", creator.get("id"));
                c.put("number", creator.get("number"));
                row.put("creator", c);
                row.put("edit", dy.getDynamicObject("creator").getLong("id") == uid);
            }
            this.getExtra(dynamicObjects, rows);
            result.setRows(rows);
            try {
                int totalCount;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_nocode_templateconfig", (String)"id", (QFilter[])filters, null);){
                    totalCount = dataSet.count("id", true);
                }
                result.setTotalCount(totalCount);
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= totalCount));
            }
            catch (Exception e) {
                result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size()));
                log.debug("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Object)new RestApiException((Throwable)e));
            }
            result.setPageNo(param.getPage_no());
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }

        private void getExtra(DynamicObject[] dynamicObjects, List<Map<String, Object>> rows) {
            Set tids = Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_nocode_tpl_user", (String)"templateid,userid", (QFilter[])new QFilter[]{new QFilter("templateid", "in", tids)});
            HashMap<Long, List> userMap = new HashMap<Long, List>();
            for (DynamicObject user : users) {
                List list = userMap.computeIfAbsent(user.getLong("templateid"), s -> new ArrayList());
                list.add(user.getLong("userid"));
            }
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_nocode_tpl_org", (String)"templateid,orgid", (QFilter[])new QFilter[]{new QFilter("templateid", "in", tids)});
            HashMap<Long, List> orgMap = new HashMap<Long, List>();
            for (DynamicObject org : orgs) {
                List list = orgMap.computeIfAbsent(org.getLong("templateid"), s -> new ArrayList());
                list.add(org.getLong("orgid"));
            }
            Set uids = userMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            HashMap<Long, String> userNames = new HashMap<Long, String>();
            if (!uids.isEmpty()) {
                QFilter[] f = new QFilter[]{new QFilter("id", "in", uids)};
                Map us = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"name", (QFilter[])f);
                for (Map.Entry entry : us.entrySet()) {
                    userNames.put((Long)entry.getKey(), ((DynamicObject)entry.getValue()).getString("name"));
                }
            }
            Set oids = orgMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            HashMap<Long, String> orgNames = new HashMap<Long, String>();
            if (!oids.isEmpty()) {
                QFilter[] f = new QFilter[]{new QFilter("id", "in", oids)};
                Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])f);
                for (Map.Entry entry : map.entrySet()) {
                    orgNames.put((Long)entry.getKey(), ((DynamicObject)entry.getValue()).getString("name"));
                }
            }
            for (Map<String, Object> map : rows) {
                HashMap<String, Long> map2;
                Long id = (Long)map.get("id");
                if (userMap.containsKey(id)) {
                    List us = (List)userMap.get(id);
                    ArrayList ul = new ArrayList();
                    for (Long u : us) {
                        map2 = new HashMap<String, Long>();
                        map2.put("id", u);
                        map2.put("name", (Long)userNames.get(u));
                        ul.add(map2);
                    }
                    map.put("users", ul);
                }
                if (!orgMap.containsKey(id)) continue;
                List os = (List)orgMap.get(id);
                ArrayList ol = new ArrayList();
                for (Long o : os) {
                    map2 = new HashMap();
                    map2.put("id", o);
                    map2.put("name", (Long)orgNames.get(o));
                    ol.add(map2);
                }
                map.put("orgs", ol);
            }
        }
    }

    public static class TemplateServiceDeleteImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            DynamicObject[] templates;
            boolean check = NoCodePermHelper.checkUserPlatManageInNoCode();
            if (!check) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u6a21\u677f", (String)"SysTemplateServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
            Object[] filters = (QFilter[])qFilterPair.getValue();
            if (CollectionUtil.isEmpty((Object[])filters)) {
                throw new RestApiException(ResManager.LoadKDString((String)ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"SysTemplateServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]), (String)"DeleteApiServiceImpl_0"));
            }
            long start = System.currentTimeMillis();
            List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
            if (pkIds.isEmpty()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"SysTemplateServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            if (pkIds.size() == Integer.MAX_VALUE) {
                throw new RestApiException(ResManager.LoadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6", (String)"DeleteApiServiceImpl_1"), new Object[]{Integer.MAX_VALUE});
            }
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(pkIds.size());
            QFilter filter = new QFilter("id", "in", (Object)pkIds);
            String fields = "id,type,creator,appid,formid";
            for (DynamicObject dy : templates = BusinessDataServiceHelper.load((String)"bos_nocode_templateconfig", (String)fields, (QFilter[])new QFilter[]{filter})) {
                RestBaseFilterItemData data = new RestBaseFilterItemData();
                resultsData.add(data);
                String formId = dy.getString("formid");
                String appid = dy.getString("appid");
                try {
                    String type;
                    switch (type = dy.getString("type")) {
                        case "0": {
                            String sError = FormMetadataUtils.deleteForm(null, (String)appid);
                            if (!StringUtils.isNotBlank((CharSequence)sError)) break;
                            throw new RestApiException(sError);
                        }
                        case "1": {
                            AppServiceHelper.deleteApp(appid);
                            this.delWorkFlowTemplates(appid);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    log.debug(e.getMessage());
                    data.getErrors().add(e.getMessage());
                    data.setBillStatus(false);
                    continue;
                }
                Object templateId = dy.get("id");
                DeleteServiceHelper.delete((IDataEntityType)dy.getDataEntityType(), (Object[])new Object[]{templateId});
                QFilter filter1 = new QFilter("templateid", "=", templateId);
                DeleteServiceHelper.delete((String)"bos_nocode_tpl_org", (QFilter[])new QFilter[]{filter1});
                DeleteServiceHelper.delete((String)"bos_nocode_tpl_user", (QFilter[])new QFilter[]{filter1});
                data.setBillStatus(true);
            }
            long end = System.currentTimeMillis();
            RestApiDeleteResult result = new RestApiDeleteResult();
            result.setSuccessCount(resultsData.stream().filter(RestBaseFilterItemData::isBillStatus).count());
            result.setFailCount(resultsData.stream().filter(d -> !d.isBillStatus()).count());
            result.setFilter(Arrays.toString(filters));
            result.setTotalCount((long)pkIds.size());
            result.setResult(resultsData);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }

        private void delWorkFlowTemplates(String appid) {
            List templates = NoCodeWorkflowServiceHelper.getProcessTemplatesByAppId((String)appid);
            List templateIds = templates.stream().map(ProcessTemplate::getId).collect(Collectors.toList());
            if (!templateIds.isEmpty()) {
                try {
                    NoCodeWorkflowServiceHelper.deleteProcessTemplates(templateIds);
                }
                catch (Exception e) {
                    log.warn((Throwable)e);
                }
            }
        }
    }

    public static class TemplateServiceSaveImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam restApiSaveParam) {
            boolean check = NoCodePermHelper.checkUserPlatManageInNoCode();
            if (!check) {
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\u521b\u5efa\u3001\u7f16\u8f91\u6a21\u677f", (String)"SysTemplateServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            long startTime = System.currentTimeMillis();
            ArrayList<RestApiSaveItemData> saveItemDatas = new ArrayList<RestApiSaveItemData>(10);
            for (Map dataMap : restApiSaveParam.getDataList()) {
                RestApiSaveItemData saveItemData;
                block5: {
                    saveItemData = new RestApiSaveItemData();
                    try {
                        String templateId = (String)dataMap.get("id");
                        NoCodeTemplateUtil.saveTemplate((Map)dataMap);
                        if (!StringUtils.isNotEmpty((CharSequence)templateId)) break block5;
                        this.updateAppInfo(templateId, dataMap);
                    }
                    catch (Exception e) {
                        log.debug(e.getMessage());
                        RestApiSaveRowErrorData errorData = new RestApiSaveRowErrorData();
                        errorData.setRowMsg(Collections.singleton(e.getMessage()));
                        saveItemData.setErrors(Collections.singletonList(errorData));
                        saveItemDatas.add(saveItemData);
                        continue;
                    }
                }
                saveItemData.setBillStatus(true);
                saveItemDatas.add(saveItemData);
            }
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(saveItemDatas);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private void updateAppInfo(String templateId, Map<String, Object> templateDataMap) {
            DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"bos_nocode_templateconfig");
            DynamicObject appObj = BusinessDataServiceHelper.loadSingle((Object)templateObj.getString("appId"), (String)"bos_devportal_bizapp");
            HashMap<String, Object> appDataMap = new HashMap<String, Object>(4);
            appDataMap.put("name", templateDataMap.get("name"));
            appDataMap.put("image", templateDataMap.get("icon"));
            appDataMap.put("description", templateDataMap.get("desc"));
            new SysAppServiceImpl.AppServiceSaveImpl().saveMetaOfApp(appObj, false, appDataMap);
        }
    }
}

