/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.DeleteRestApiService;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiDeleteParam;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiDeleteResult;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveRowErrorData;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.api.result.RestBaseFilterItemData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.util.OpenApiAliasHelper;
import kd.bos.nocode.utils.NcErrorUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessModel;

public class SysWfModelServiceImpl {
    private static final Log log = LogFactory.getLog(SysWfModelServiceImpl.class);
    private static final String PROP_ID = "id";
    private static final String PROP_NAME = "name";
    private static final String PROP_DESCRIPTION = "description";

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiSaveParam) {
            WfModelServiceSaveImpl appServiceSave = new WfModelServiceSaveImpl();
            return appServiceSave.execute((RestApiSaveParam)param);
        }
        if (param instanceof RestApiQueryParam) {
            WfModelServiceQueryImpl appServiceQuery = new WfModelServiceQueryImpl();
            return appServiceQuery.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiDeleteParam) {
            WfModelDeleteServiceImpl appServiceDelete = new WfModelDeleteServiceImpl();
            return appServiceDelete.execute((RestApiDeleteParam)param);
        }
        throw new RestApiException("\u8bf7\u6c42\u4e0d\u652f\u6301");
    }

    public static class WfModelDeleteServiceImpl
    implements DeleteRestApiService {
        public RestApiServiceData<RestApiDeleteResult> execute(RestApiDeleteParam param) {
            long modelId;
            long start = System.currentTimeMillis();
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)param.getAppNumber());
            NoCodePermHelper.verifyManage((String)appId);
            RestApiResponse response = new RestApiResponse();
            Map httpQueryString = param.getRequest().getHttpQueryString();
            if (httpQueryString == null || !httpQueryString.containsKey(SysWfModelServiceImpl.PROP_ID)) {
                long end = System.currentTimeMillis();
                return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)"url\u4e2d\u65e0id", (RestApiResponse)response, (long)(end - start));
            }
            String id = (String)httpQueryString.get(SysWfModelServiceImpl.PROP_ID);
            try {
                modelId = Long.parseLong(id);
            }
            catch (NumberFormatException e) {
                log.warn((Throwable)e);
                throw new RestApiException("id\u53c2\u6570\u6709\u8bef");
            }
            ArrayList<Long> modelIds = new ArrayList<Long>(0);
            modelIds.add(modelId);
            RestApiDeleteResult result = new RestApiDeleteResult();
            ArrayList<RestBaseFilterItemData> resultsData = new ArrayList<RestBaseFilterItemData>(1);
            RestBaseFilterItemData data = new RestBaseFilterItemData();
            data.setBillStatus(true);
            try {
                NoCodeWorkflowServiceHelper.discardProcesses(modelIds, (boolean)true, (boolean)true);
                WfProcessDataService.create().deleteWfInfoByModelId(modelId);
                result.setSuccessCount(1L);
                data.setId(id);
                resultsData.add(data);
            }
            catch (Exception ex) {
                log.warn((Throwable)ex);
                result.setFailCount(1L);
                data.setBillStatus(false);
                String sError = "\u5e9f\u5f03\u6d41\u7a0b\u5931\u8d25\uff1a" + ex.getMessage();
                data.getErrors().add(sError);
                throw new RestApiException("\u5e9f\u5f03\u6d41\u7a0b\u5931\u8d25", new Object[]{ex.getMessage()});
            }
            result.setTotalCount(1L);
            result.setResult(resultsData);
            response.setData((Object)result);
            long end = System.currentTimeMillis();
            return RestApiServiceData.of((boolean)resultsData.stream().allMatch(RestBaseFilterItemData::isBillStatus), (RestApiResponse)response, (long)(end - start));
        }
    }

    public static class WfModelServiceQueryImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            String id = (String)param.getRequest().getHttpQueryString().get(SysWfModelServiceImpl.PROP_ID);
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new RestApiException("\u53c2\u6570\u5f02\u5e38\uff0c\u76ee\u524d\u53ea\u652f\u6301\u901a\u8fc7id\u67e5\u8be2\u6d41\u7a0b\u5143\u6570\u636e\u4fe1\u606f");
            }
            ProcessModel process = NoCodeWorkflowServiceHelper.getProcess((Long)Long.parseLong(id));
            String processJsonStr = SerializationUtils.toJsonString((Object)process);
            Map processMap = (Map)SerializationUtils.fromJsonString((String)processJsonStr, Map.class);
            processMap.put(SysWfModelServiceImpl.PROP_NAME, process.getName().getLocaleValue());
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)process.getAppId());
            HashMap<String, String> appMap = new HashMap<String, String>(3);
            appMap.put(SysWfModelServiceImpl.PROP_ID, appInfo.getAppId());
            appMap.put(SysWfModelServiceImpl.PROP_NAME, appInfo.getName().getLocaleValue());
            appMap.put("number", appInfo.getNumber());
            processMap.put("app", appMap);
            processMap.put(SysWfModelServiceImpl.PROP_DESCRIPTION, process.getDescription().getLocaleValue());
            ArrayList<Map> rows = new ArrayList<Map>(1);
            rows.add(processMap);
            RestApiQueryResult result = new RestApiQueryResult();
            result.setRows(rows);
            result.setPageNo(-1);
            result.setPageSize(param.getPage_size());
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
        }
    }

    public static class WfModelServiceSaveImpl
    implements SaveRestApiService {
        private String getDefaultName() {
            return "\u3010\u672a\u547d\u540d\u6d41\u7a0b\u3011";
        }

        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            long startTime = System.currentTimeMillis();
            if (this.isTriggerRequest(param)) {
                return this.triggerWf(param, startTime);
            }
            ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)param.getAppNumber());
            NoCodePermHelper.verifyManage((String)appId);
            this.classifyByKey(param, insertList, updateList);
            List<RestApiSaveItemData> insertIds = this.batchInsert(insertList, param);
            List<RestApiSaveItemData> updateIds = this.batchUpdate(updateList, param);
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(insertIds, updateIds);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private RestApiServiceData<RestApiSaveResult> triggerWf(RestApiSaveParam param, long startTime) {
            List dataList = param.getDataList();
            ArrayList results = new ArrayList(dataList.size());
            dataList.forEach(e -> {
                String entityNumber;
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                String wfModelId = OpenApiAliasHelper.getWfModelIdByWfModelAlias((String)((String)e.get("wfModelId")));
                if (StringUtils.isBlank((CharSequence)wfModelId)) {
                    throw new RestApiException("\u6d41\u7a0b\u5185\u7801\u7684\u53c2\u6570\u503c\u65e0\u6548");
                }
                try {
                    ProcessModel process = NoCodeWorkflowServiceHelper.getProcess((Long)Long.parseLong(wfModelId));
                    if (process == null) {
                        throw new RestApiException("\u6d41\u7a0b\u5185\u7801\u7684\u53c2\u6570\u503c\u65e0\u6548");
                    }
                    entityNumber = process.getEntityNumber();
                }
                catch (Exception ex) {
                    throw new RestApiException("\u6d41\u7a0b\u5185\u7801\u7684\u53c2\u6570\u503c\u65e0\u6548");
                }
                if (StringUtils.isEmpty((CharSequence)entityNumber)) {
                    throw new RestApiException("\u6d41\u7a0b\u5185\u7801\u7684\u53c2\u6570\u503c\u65e0\u6548");
                }
                String businessKey = (String)e.get("businessKey");
                if (StringUtils.isBlank((CharSequence)businessKey) || !NoCodePermHelper.checkDataPermInNoCode((String)entityNumber, (Object)businessKey)) {
                    RestApiSaveRowErrorData restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                    HashSet<String> msg = new HashSet<String>(1);
                    msg.add("\u8868\u5355\u8bb0\u5f55\u5185\u7801\u7684\u53c2\u6570\u503c\u65e0\u6548\u6216\u8005\u6743\u9650\u4e0d\u8db3");
                    restApiSaveRowErrorData.setRowMsg(msg);
                    apiSaveData.getErrors().add(restApiSaveRowErrorData);
                    apiSaveData.setBillStatus(false);
                    results.add(apiSaveData);
                } else {
                    NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)Long.parseLong(wfModelId), (String)businessKey, (String)"bizOperate");
                    apiSaveData.setId(wfModelId);
                    apiSaveData.setNumber(wfModelId);
                    apiSaveData.setBillStatus(true);
                    results.add(apiSaveData);
                }
            });
            RestApiSaveResult apiSaveResult = RestApiSaveResult.of(results, null);
            long modelTimeCost = System.currentTimeMillis() - startTime;
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)apiSaveResult);
            boolean allMatch = apiSaveResult.getResult().stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)modelTimeCost);
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)modelTimeCost);
        }

        private boolean isTriggerRequest(RestApiSaveParam param) {
            return "trigger".equals(param.getRequest().getHttpQueryString().get("type"));
        }

        protected void classifyByKey(RestApiSaveParam param, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
            for (Map dataMap : param.getDataList()) {
                String id = (String)dataMap.get(SysWfModelServiceImpl.PROP_ID);
                if (StringUtils.isBlank((CharSequence)id)) {
                    insertList.add(dataMap);
                    continue;
                }
                dataMap.put(SysWfModelServiceImpl.PROP_ID, id);
                updateList.add(dataMap);
            }
        }

        private List<RestApiSaveItemData> batchInsert(List<Map<String, Object>> insertList, RestApiSaveParam param) {
            if (CollectionUtils.isEmpty(insertList)) {
                return Collections.emptyList();
            }
            return this.executeSave(insertList, true, param);
        }

        private List<RestApiSaveItemData> batchUpdate(List<Map<String, Object>> updateList, RestApiSaveParam param) {
            if (CollectionUtils.isEmpty(updateList)) {
                return Collections.emptyList();
            }
            return this.executeSave(updateList, false, param);
        }

        protected List<RestApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean isInsert, RestApiSaveParam param) {
            ArrayList<RestApiSaveItemData> results = new ArrayList<RestApiSaveItemData>(sourceDatas.size());
            String appNumber = param.getAppNumber();
            int len = sourceDatas.size();
            for (int i = 0; i < len; ++i) {
                RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                Map<String, Object> dataMap = sourceDatas.get(i);
                try {
                    Long modelId;
                    String sError;
                    ProcessModel model;
                    block12: {
                        model = null;
                        if (isInsert) {
                            model = new ProcessModel();
                            model.setName(new LocaleString(this.getDefaultName()));
                            model.setOrgId(Long.valueOf(this.getCurrentUserAdminOrg()));
                            model.setAppId(appNumber);
                            model.setCloudId("2HGKCE94QELW");
                            model.setOperation("save");
                            model.setType("NoCodeFlow");
                            String resource = NoCodeWorkflowServiceHelper.createBlankProcessResource((String)"NoCodeFlow", null);
                            String procNumber = JSON.parseObject((String)resource).getString("key");
                            model.setNumber(procNumber);
                            model.setData(resource);
                        } else {
                            String sModelId = (String)dataMap.get(SysWfModelServiceImpl.PROP_ID);
                            long modelId2 = Long.parseLong(sModelId);
                            model = NoCodeWorkflowServiceHelper.getProcess((Long)modelId2);
                        }
                        String name = (String)dataMap.get(SysWfModelServiceImpl.PROP_NAME);
                        if (StringUtils.isNotBlank((CharSequence)name)) {
                            name = (name = StringUtil.cleanXSSParam((String)name)).length() > 50 ? name.substring(0, 47) + "..." : name;
                            model.setName(new LocaleString(name));
                        } else {
                            model.setName(new LocaleString(this.getDefaultName()));
                        }
                        String description = (String)dataMap.get(SysWfModelServiceImpl.PROP_DESCRIPTION);
                        if (StringUtils.isNotBlank((CharSequence)description)) {
                            description = (description = StringUtil.cleanXSSParam((String)description)).length() > 500 ? description.substring(0, 497) + "..." : description;
                            model.setDescription(new LocaleString(description));
                        }
                        sError = null;
                        modelId = 0L;
                        try {
                            modelId = NoCodeWorkflowServiceHelper.saveProcess((ProcessModel)model);
                        }
                        catch (Exception e) {
                            log.warn((Throwable)e);
                            sError = e.getMessage();
                            if (!StringUtils.isBlank((CharSequence)sError)) break block12;
                            sError = NcErrorUtil.getStackTrace((Exception)e);
                        }
                    }
                    if (StringUtils.isNotBlank(sError)) {
                        RestApiSaveRowErrorData restApiSaveRowErrorData = new RestApiSaveRowErrorData();
                        HashSet<String> msg = new HashSet<String>(1);
                        msg.add(sError);
                        restApiSaveRowErrorData.setRowMsg(msg);
                        apiSaveData.getErrors().add(restApiSaveRowErrorData);
                    }
                    apiSaveData.setId(modelId.toString());
                    apiSaveData.setNumber(model.getNumber());
                    if (apiSaveData.getErrors().isEmpty()) {
                        apiSaveData.setBillStatus(true);
                    }
                }
                catch (Exception e) {
                    log.debug(e.getMessage(), (Object)e);
                    apiSaveData.addError(e);
                    apiSaveData.setBillStatus(false);
                }
                results.add(apiSaveData);
            }
            return results;
        }

        private long getCurrentUserAdminOrg() {
            return UserServiceHelper.getUserMainOrgId((long)RequestContext.get().getCurrUserId());
        }
    }
}

