/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TextProp;
import kd.bos.id.ID;
import kd.bos.login.utils.JWTUtils;
import kd.bos.nocode.ext.property.NoCodeMulComboProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.annotations.PropInfoParser;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.util.JsonUtil;
import kd.bos.nocode.restapi.constant.ApiDocFieldTypeEnum;
import kd.bos.nocode.restapi.constant.ApiDocTypeEnum;
import kd.bos.nocode.restapi.service.query.g.FilterVisitor;
import kd.bos.nocode.restapi.service.sys.common.pojo.ApiCodeDesc;
import kd.bos.nocode.restapi.service.sys.common.pojo.ApiInfoNewDO;
import kd.bos.nocode.restapi.service.sys.common.pojo.EntryConfig;
import kd.bos.nocode.restapi.service.sys.common.pojo.FormInfoValue;
import kd.bos.nocode.restapi.service.sys.common.pojo.Item;
import kd.bos.nocode.restapi.service.sys.common.pojo.PreviewInfo;
import kd.bos.nocode.restapi.service.sys.common.pojo.RequestParamValue;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.OpenApiAuthUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ApiDocServiceQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/api_doc(/.*)?$";
    private static final Pattern PATTERN = Pattern.compile("/api_doc(/.*)?$");
    private static final List<EntryConfig> requestParams = new ArrayList<EntryConfig>();
    private static final String TYPE = "type";
    private static final String APP_ID = "appId";
    private static final String FORM_ID = "formId";
    private static final String PHONE = "phone";
    private static final String USER_ID = "userId";
    private static final String TENANT_ID = "tenantId";
    private static final String ACCOUNT_ID = "accountId";
    private static final String URL = "url";
    private static final List<EntryConfig> formInfoParams;
    private static final List<EntryConfig> compareDesc;
    private static final List<EntryConfig> errorCodeDesc;

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        List<Object> values;
        HashMap<String, String> demoMap;
        ApiInfoNewDO apiInfoNewDO;
        DynamicObject[] loaded;
        String formId;
        String appId;
        Map<String, String> source2Alias;
        DynamicObject[] loaded2;
        long startTime = System.currentTimeMillis();
        String apiType = (String)param.getRequest().getHttpQueryString().get(TYPE);
        ArrayList rows = Lists.newArrayList();
        String domainContextUrl = UrlService.getDomainContextUrl();
        if (ApiDocTypeEnum.request_info.toString().equals(apiType)) {
            Item displayItem = new Item(ID.genStringId(), "", ApiDocFieldTypeEnum.nocodegraphicdisplayfield.toString(), new ArrayList<EntryConfig>(0), ResManager.loadKDString((String)"\u4f7f\u7528GET\u548cPOST\u65f6\uff0c\u5747\u9700\u8981\u5728\u8bf7\u6c42\u5934\u4e2d\u643a\u5e26access_token\u3001api\u4e24\u4e2a\u53c2\u6570\uff0c\u4e14api\u53c2\u6570\u503c\u9700\u8981\u8bbe\u7f6e\u4e3atrue\u3002\n", (String)"ApiDocServiceQueryImpl_9", (String)"bos-nocode-service", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u4f7f\u7528GET\u8bf7\u6c42\u65f6\uff0c\u76f8\u5173\u53c2\u6570\u5fc5\u987b\u62fc\u63a5\u5728URL\u540e\u8fdb\u884c\u8bf7\u6c42\u3002\n", (String)"ApiDocServiceQueryImpl_10", (String)"bos-nocode-service", (Object[])new Object[0]) + ResManager.loadKDString((String)"\u4f7f\u7528POST\u8bf7\u6c42\u65f6\uff0c\u8bf7\u6c42\u5934\u9700\u8981\u989d\u5916\u643a\u5e26Content-Type\u53c2\u6570\uff0c\u4e14\u53c2\u6570\u503c\u9700\u8981\u8bbe\u7f6e\u4e3aapplication/json\u3002", (String)"ApiDocServiceQueryImpl_11", (String)"bos-nocode-service", (Object[])new Object[0]));
            ApiInfoNewDO apiInfoNewDO2 = new ApiInfoNewDO(ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f", (String)"ApiDocServiceQueryImpl_12", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO2.getItems().add(displayItem);
            rows.add(apiInfoNewDO2.toMap());
        } else if (ApiDocTypeEnum.auth.toString().equals(apiType)) {
            String phone = UserServiceHelper.getCurrentUser((String)PHONE).getString(PHONE);
            HashMap<String, String> userInfo = new HashMap<String, String>();
            userInfo.put(TENANT_ID, RequestContext.get().getTenantId());
            userInfo.put(ACCOUNT_ID, RequestContext.get().getAccountId());
            userInfo.put(PHONE, phone);
            String sign = JWTUtils.generateJWTByMapParameters(userInfo, (String)this.getApiSecretKey(), (long)this.getExpiredTime());
            String accessTokenURL = domainContextUrl + "/nocode/getAccessToken.do";
            Item accessTokenUrl = new Item(ID.genStringId(), "Access Token URL", ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), accessTokenURL);
            ApiInfoNewDO apiInfoNewDO3 = new ApiInfoNewDO(ResManager.loadKDString((String)"\u8ba4\u8bc1 GET", (String)"ApiDocServiceQueryImpl_13", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO3.getItems().add(accessTokenUrl);
            ArrayList<RequestParamValue> values2 = new ArrayList<RequestParamValue>();
            values2.add(new RequestParamValue("sign", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u7b7e\u540d\uff1a", (String)"ApiDocServiceQueryImpl_15", (String)"bos-nocode-service", (Object[])new Object[0]) + sign));
            apiInfoNewDO3.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values2));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(URL, accessTokenURL + "?sign=" + sign);
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(map));
            apiInfoNewDO3.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": {\n        \"access_token\": \"1402323749146986496_TT3meQE0aD4kqRbDKD98C3ertacWGA2EL1NqK1Bv8mwQei6cd8ba7KpsddXPs5kbPa77z1WhuH3TiK6ZLhRH2x2ATeG8ufIoD7mu\",\n        \"success\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_19", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"error_desc\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_20", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"expire_time\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_21", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"error_code\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_22", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n    },\n    \"state\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_23", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_25", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO3.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n  \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_27", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_28", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO3.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO3.toMap());
        } else if (apiType.equals("formInfo")) {
            String formId2 = (String)param.getRequest().getHttpQueryString().get(FORM_ID);
            loaded2 = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId2).toArray());
            source2Alias = Arrays.stream(loaded2).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO4 = new ApiInfoNewDO();
            apiInfoNewDO4.setTitle(ResManager.loadKDString((String)"\u8868\u5355\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_29", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO4.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8868\u5355\u5185\u7801", (String)"ApiDocServiceQueryImpl_30", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), formId2));
            apiInfoNewDO4.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8868\u5355\u522b\u540d", (String)"ApiDocServiceQueryImpl_31", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), this.getAlias(formId2, source2Alias), true));
            List listItemConfig = ListConfigUtils.getListItemConfig((String)formId2);
            List values3 = listItemConfig.stream().map(e -> {
                String number = (String)e.get("number");
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId2);
                IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)number);
                String propName = "";
                if (property instanceof NoCodeProp) {
                    propName = new PropInfoParser().getPropName(((NoCodeProp)property).getClass());
                }
                return new FormInfoValue(number, this.getAlias(number, source2Alias), (String)e.get("name"), propName, ApiDocServiceQueryImpl.getFieldDesc(property));
            }).collect(Collectors.toList());
            Item formInfoItem = new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8868\u5355\u5185\u5bb9\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_32", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), formInfoParams, values3);
            formInfoItem.setBatchAlias(true);
            apiInfoNewDO4.getItems().add(formInfoItem);
            rows.add(apiInfoNewDO4.toMap());
        } else if (apiType.equals("formGetQuery")) {
            appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
            formId = (String)param.getRequest().getHttpQueryString().get(FORM_ID);
            loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
            Map<String, String> formAlias = Arrays.stream(loaded).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO5 = new ApiInfoNewDO();
            apiInfoNewDO5.setTitle(ResManager.loadKDString((String)"\u67e5\u627e\u8868\u5355\u8bb0\u5f55 GET", (String)"ApiDocServiceQueryImpl_33", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO5.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42URL", (String)"ApiDocServiceQueryImpl_34", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), domainContextUrl + String.format("/nocode/v2/%s/%s", appId, this.getAliasOrSource(formId, formAlias))));
            ArrayList<RequestParamValue> values4 = new ArrayList<RequestParamValue>();
            values4.add(new RequestParamValue("page_no", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "int", ResManager.loadKDString((String)"\u9875\u7801\uff08\u4ece1\u5f00\u59cb\uff09\uff0c\u4e0d\u4f20\u5219\u9ed8\u8ba4\u662f1", (String)"ApiDocServiceQueryImpl_36", (String)"bos-nocode-service", (Object[])new Object[0])));
            values4.add(new RequestParamValue("page_size", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "int", ResManager.loadKDString((String)"\u6bcf\u9875\u663e\u793a\u7684\u8868\u5355\u8bb0\u5f55\u6570\u91cf\uff0c\u4e0d\u4f20\u5219\u9ed8\u8ba4\u662f20", (String)"ApiDocServiceQueryImpl_37", (String)"bos-nocode-service", (Object[])new Object[0])));
            values4.add(new RequestParamValue("search", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8f93\u5165\u641c\u7d22\u7684\u5173\u952e\u8bcd\uff08\u6a21\u7cca\u641c\u7d22\uff09", (String)"ApiDocServiceQueryImpl_38", (String)"bos-nocode-service", (Object[])new Object[0])));
            values4.add(new RequestParamValue("order_by", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8bbe\u7f6e\u6392\u5e8f\u6761\u4ef6\uff0c\u4e0d\u4f20\u8be5\u53c2\u6570\u65f6\u9ed8\u8ba4\u6309\u521b\u5efa\u65f6\u95f4\u5012\u5e8f\u6392\u5e8f\u3002\u8be6\u89c1\u9644\u5f55-\u6392\u5e8f\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_39", (String)"bos-nocode-service", (Object[])new Object[0])));
            values4.add(new RequestParamValue("schemaId", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u89c6\u56fe\u5185\u7801", (String)"ApiDocServiceQueryImpl_40", (String)"bos-nocode-service", (Object[])new Object[0])));
            values4.add(new RequestParamValue("filter", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8bbe\u7f6e\u7b5b\u9009\u6761\u4ef6\u3002\u8be6\u89c1\u9644\u5f55-\u7b5b\u9009\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_41", (String)"bos-nocode-service", (Object[])new Object[0])));
            values4.add(new RequestParamValue("alias", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8bbe\u7f6e\u4f7f\u7528\u5185\u5bb9\u5185\u7801\u6216\u5185\u5bb9\u522b\u540d\u4f5c\u4e3a\u53c2\u6570\u540d\u3002false\u4e3a\u5185\u5bb9\u5185\u7801\uff0ctrue\u4e3a\u5185\u5bb9\u522b\u540d\uff0c\u53c2\u6570\u4e0d\u4f20\u65f6\u9ed8\u8ba4\u4e3afalse", (String)"ApiDocServiceQueryImpl_42", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO5.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values4));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(URL, domainContextUrl + String.format("/nocode/v2/%s/%s?page_no=1&page_size=20&alias=true", appId, this.getAliasOrSource(formId, formAlias)));
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(map));
            apiInfoNewDO5.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint((Object)SerializationUtils.fromJsonString((String)("{\n  \"data\":{\n    \"extra\":\"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_43", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"lastPage\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u6700\u540e\u4e00\u9875", (String)"ApiDocServiceQueryImpl_44", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"pageNo\":\"" + ResManager.loadKDString((String)"\u9875\u7801", (String)"ApiDocServiceQueryImpl_45", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"pageSize\":\"" + ResManager.loadKDString((String)"\u6bcf\u9875\u663e\u793a\u7684\u8868\u5355\u8bb0\u5f55\u6570\u91cf", (String)"ApiDocServiceQueryImpl_46", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"rows\":[\n       " + JsonUtil.prettyPrint(this.getFormFieldDemoData(formId, true, formAlias, false)) + "    \n],\n    \"totalCount\":\"" + ResManager.loadKDString((String)"\u67e5\u627e\u7684\u8868\u5355\u8bb0\u5f55\u603b\u6570\u91cf", (String)"ApiDocServiceQueryImpl_47", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n  },\n  \"errorCode\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_48", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"message\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_49", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"status\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_50", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"traceId\":\"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_51", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}"), Map.class)));
            apiInfoNewDO5.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u8bb0\u5f55\u6570\u636e", (String)"ApiDocServiceQueryImpl_52", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO5.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO5.toMap());
        } else if (apiType.equals("formPostQuery")) {
            appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
            formId = (String)param.getRequest().getHttpQueryString().get(FORM_ID);
            loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
            Map<String, String> formAlias = Arrays.stream(loaded).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO6 = new ApiInfoNewDO();
            apiInfoNewDO6.setTitle(ResManager.loadKDString((String)"\u67e5\u627e\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiDocServiceQueryImpl_56", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO6.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42URL", (String)"ApiDocServiceQueryImpl_34", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), domainContextUrl + String.format("/nocode/v2/%s/%s", appId, this.getAliasOrSource(formId, formAlias))));
            ArrayList<RequestParamValue> values5 = new ArrayList<RequestParamValue>();
            values5.add(new RequestParamValue("page_no", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "int", ResManager.loadKDString((String)"\u9875\u7801\uff08\u4ece1\u5f00\u59cb\uff09\uff0c\u4e0d\u4f20\u5219\u9ed8\u8ba4\u662f1", (String)"ApiDocServiceQueryImpl_36", (String)"bos-nocode-service", (Object[])new Object[0])));
            values5.add(new RequestParamValue("page_size", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "int", ResManager.loadKDString((String)"\u6bcf\u9875\u663e\u793a\u7684\u8868\u5355\u8bb0\u5f55\u6570\u91cf\uff0c\u4e0d\u4f20\u5219\u9ed8\u8ba4\u662f20", (String)"ApiDocServiceQueryImpl_37", (String)"bos-nocode-service", (Object[])new Object[0])));
            values5.add(new RequestParamValue("search", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8f93\u5165\u641c\u7d22\u7684\u5173\u952e\u8bcd\uff08\u6a21\u7cca\u641c\u7d22\uff09", (String)"ApiDocServiceQueryImpl_38", (String)"bos-nocode-service", (Object[])new Object[0])));
            values5.add(new RequestParamValue("order_by", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8bbe\u7f6e\u6392\u5e8f\u6761\u4ef6\uff0c\u4e0d\u4f20\u8be5\u53c2\u6570\u65f6\u9ed8\u8ba4\u6309\u521b\u5efa\u65f6\u95f4\u5012\u5e8f\u6392\u5e8f\u3002\u8be6\u89c1\u9644\u5f55-\u6392\u5e8f\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_39", (String)"bos-nocode-service", (Object[])new Object[0])));
            values5.add(new RequestParamValue("schemaId", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u89c6\u56fe\u5185\u7801", (String)"ApiDocServiceQueryImpl_40", (String)"bos-nocode-service", (Object[])new Object[0])));
            values5.add(new RequestParamValue("filter", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8bbe\u7f6e\u7b5b\u9009\u6761\u4ef6\uff0c\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u4f46\u5fc5\u987b\u5e26\u6709\u672c\u53c2\u6570\u3002\u8be6\u89c1\u9644\u5f55-\u7b5b\u9009\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_57", (String)"bos-nocode-service", (Object[])new Object[0])));
            values5.add(new RequestParamValue("alias", ResManager.loadKDString((String)"\u5426", (String)"ApiDocServiceQueryImpl_35", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u503c\u4e3a\u201dtrue\u201c\u65f6\u4f7f\u7528\u201d\u5185\u5bb9\u522b\u540d\u201c\u66ff\u6362\u201d\u5185\u5bb9\u5185\u7801\u201c\uff0c\u5426\u5219\u4e0d\u66ff\u6362\u201c", (String)"ApiDocServiceQueryImpl_58", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO6.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values5));
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("filter", ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\uff0c\u53ef\u4e3a\u7a7a", (String)"ApiDocServiceQueryImpl_59", (String)"bos-nocode-service", (Object[])new Object[0]));
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(itemMap));
            apiInfoNewDO6.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint((Object)SerializationUtils.fromJsonString((String)("{\n  \"data\":{\n    \"extra\":\"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_43", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"lastPage\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u6700\u540e\u4e00\u9875", (String)"ApiDocServiceQueryImpl_44", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"pageNo\":\"" + ResManager.loadKDString((String)"\u9875\u7801", (String)"ApiDocServiceQueryImpl_45", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"pageSize\":\"" + ResManager.loadKDString((String)"\u6bcf\u9875\u663e\u793a\u7684\u8868\u5355\u8bb0\u5f55\u6570\u91cf", (String)"ApiDocServiceQueryImpl_46", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"rows\":[\n       " + JsonUtil.prettyPrint(this.getFormFieldDemoData(formId, true, formAlias, false)) + "    \n],\n    \"totalCount\":\"" + ResManager.loadKDString((String)"\u67e5\u627e\u7684\u8868\u5355\u8bb0\u5f55\u603b\u6570\u91cf", (String)"ApiDocServiceQueryImpl_47", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n  },\n  \"errorCode\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_48", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"message\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_49", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"status\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_50", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n  \"traceId\":\"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_51", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}"), Map.class)));
            apiInfoNewDO6.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u8bb0\u5f55\u6570\u636e", (String)"ApiDocServiceQueryImpl_52", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO6.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO6.toMap());
        } else if (apiType.equals("formAdd")) {
            appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
            formId = (String)param.getRequest().getHttpQueryString().get(FORM_ID);
            loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
            Map<String, String> formAlias = Arrays.stream(loaded).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO7 = new ApiInfoNewDO();
            apiInfoNewDO7.setTitle(ResManager.loadKDString((String)"\u65b0\u589e\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiDocServiceQueryImpl_60", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO7.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42URL", (String)"ApiDocServiceQueryImpl_34", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), domainContextUrl + String.format("/nocode/v2/%s/%s", appId, this.getAliasOrSource(formId, formAlias))));
            ArrayList<RequestParamValue> values6 = new ArrayList<RequestParamValue>();
            values6.add(new RequestParamValue("data", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "list", ResManager.loadKDString((String)"\u63a7\u4ef6\u6570\u636e\uff0c\u6570\u636e\u5bf9\u8c61\u4e2d\u4e0d\u8981\u5305\u542bid\uff0c\u4e0d\u7136\u4f1a\u88ab\u5f53\u505a\u4fee\u6539\u6570\u636e", (String)"ApiDocServiceQueryImpl_61", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO7.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values6));
            HashMap dataMap = new HashMap();
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            data.add(this.getFormFieldDemoData(formId, false, formAlias, true));
            dataMap.put("data", data);
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(dataMap));
            apiInfoNewDO7.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": {\n    \"extra\":\"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_43", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"failCount\": \"" + ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cf", (String)"ApiDocServiceQueryImpl_62", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"result\": [\n            {\n                \"billIndex\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u7d22\u5f15", (String)"ApiDocServiceQueryImpl_63", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"billStatus\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u662f\u5426\u65b0\u589e\u6210\u529f", (String)"ApiDocServiceQueryImpl_64", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"errors\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_65", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"extra\": \"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_66", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"id\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_67", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"keys\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_68", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"number\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_69", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"type\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_70", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n            }\n        ],\n        \"successCount\": \"" + ResManager.loadKDString((String)"\u6210\u529f\u6570\u91cf", (String)"ApiDocServiceQueryImpl_71", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n    },\n   \"errorCode\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_72", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"message\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_73", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"status\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_74", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"traceId\":\"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_75", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO7.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u8bb0\u5f55\u6570\u636e", (String)"ApiDocServiceQueryImpl_52", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO7.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO7.toMap());
        } else if (apiType.equals("formUpdate")) {
            appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
            formId = (String)param.getRequest().getHttpQueryString().get(FORM_ID);
            loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
            Map<String, String> formAlias = Arrays.stream(loaded).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO8 = new ApiInfoNewDO();
            apiInfoNewDO8.setTitle(ResManager.loadKDString((String)"\u4fee\u6539\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiDocServiceQueryImpl_76", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO8.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42URL", (String)"ApiDocServiceQueryImpl_34", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), domainContextUrl + String.format("/nocode/v2/%s/%s", appId, this.getAliasOrSource(formId, formAlias))));
            ArrayList<RequestParamValue> values7 = new ArrayList<RequestParamValue>();
            values7.add(new RequestParamValue("data", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "list", ResManager.loadKDString((String)"\u63a7\u4ef6\u6570\u636e\uff0c\u6570\u636e\u5bf9\u8c61\u4e2d\u8981\u5305\u542b\u4fee\u6539\u7684\u8bb0\u5f55id\uff0c\u4e0d\u7136\u4f1a\u88ab\u5f53\u505a\u65b0\u589e\u6570\u636e", (String)"ApiDocServiceQueryImpl_77", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO8.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values7));
            HashMap dataMap = new HashMap();
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            data.add(this.getFormFieldDemoData(formId, true, formAlias, true));
            dataMap.put("data", data);
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(dataMap));
            apiInfoNewDO8.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": {\n    \"extra\":\"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_43", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"failCount\": \"" + ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cf", (String)"ApiDocServiceQueryImpl_62", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"result\": [\n            {\n                \"billIndex\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u7d22\u5f15", (String)"ApiDocServiceQueryImpl_63", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"billStatus\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u662f\u5426\u4fee\u6539\u6210\u529f", (String)"ApiDocServiceQueryImpl_78", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"errors\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_65", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"extra\": \"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_66", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"id\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_67", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"keys\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_68", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"number\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_69", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"type\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_70", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n            }\n        ],\n        \"successCount\": \"" + ResManager.loadKDString((String)"\u6210\u529f\u6570\u91cf", (String)"ApiDocServiceQueryImpl_71", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n    },\n   \"errorCode\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_72", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"message\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_73", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"status\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_74", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"traceId\":\"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_75", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO8.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u8bb0\u5f55\u6570\u636e", (String)"ApiDocServiceQueryImpl_52", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO8.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO8.toMap());
        } else if (apiType.equals("formDelete")) {
            appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
            formId = (String)param.getRequest().getHttpQueryString().get(FORM_ID);
            loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
            Map<String, String> formAlias = Arrays.stream(loaded).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO9 = new ApiInfoNewDO();
            apiInfoNewDO9.setTitle(ResManager.loadKDString((String)"\u5220\u9664\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiDocServiceQueryImpl_79", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO9.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42URL", (String)"ApiDocServiceQueryImpl_34", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), domainContextUrl + String.format("/nocode/v2/%s/%s/delete", appId, this.getAliasOrSource(formId, formAlias))));
            ArrayList<RequestParamValue> values8 = new ArrayList<RequestParamValue>();
            values8.add(new RequestParamValue("filter", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u5220\u9664\u7684filter\uff0c\u5efa\u8bae\u5982\u793a\u4f8b\u4e00\u6837\u53ea\u6309\u7167\u8868\u5355\u8bb0\u5f55\u5185\u7801\u8fdb\u884c\u5220\u9664\uff0c\u8be6\u89c1\u9644\u5f55-\u7b5b\u9009\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_80", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO9.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values8));
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("filter", ResManager.loadKDString((String)"id in (\u8868\u5355\u8bb0\u5f55\u5185\u78011,\u8868\u5355\u8bb0\u5f55\u5185\u78012)", (String)"ApiDocServiceQueryImpl_81", (String)"bos-nocode-service", (Object[])new Object[0]));
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(itemMap));
            apiInfoNewDO9.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n  \"data\": {\n    \"failCount\": \"" + ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cf", (String)"ApiDocServiceQueryImpl_82", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"filter\": \"" + ResManager.loadKDString((String)"\u7528\u5230\u7684\u8fc7\u6ee4\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_83", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"result\": [\n      {\n        \"billIndex\": \"" + ResManager.loadKDString((String)"\u5220\u9664\u7684\u7b2c\u51e0\u884c\u8868\u5355\u8bb0\u5f55", (String)"ApiDocServiceQueryImpl_84", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"billStatus\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6210\u529f", (String)"ApiDocServiceQueryImpl_85", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"errors\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u6d88\u606f\u5217\u8868", (String)"ApiDocServiceQueryImpl_86", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"id\": \"" + ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_87", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"number\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_88", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n      }\n    ],\n    \"successCount\": \"" + ResManager.loadKDString((String)"\u6210\u529f\u6570\u91cf", (String)"ApiDocServiceQueryImpl_89", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"totalCount\": \"" + ResManager.loadKDString((String)"\u5220\u9664\u7684\u8868\u5355\u8bb0\u5f55\u603b\u6570\u91cf", (String)"ApiDocServiceQueryImpl_90", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n  },\n   \"errorCode\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_72", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"message\":\"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_73", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"status\":\"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_74", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n   \"traceId\":\"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_75", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO9.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u8bb0\u5f55\u6570\u636e", (String)"ApiDocServiceQueryImpl_52", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO9.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO9.toMap());
        } else if (apiType.equals("wfInfo")) {
            String wfModelId = (String)param.getRequest().getHttpQueryString().get("wfModelId");
            loaded2 = BusinessDataServiceHelper.load((String)"bos_nc_wfinfo_alias", (String)"source,alias", (QFilter[])new QFilter("modelId", "=", (Object)wfModelId).toArray());
            source2Alias = Arrays.stream(loaded2).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ApiInfoNewDO apiInfoNewDO10 = new ApiInfoNewDO();
            apiInfoNewDO10.setTitle(ResManager.loadKDString((String)"\u6d41\u7a0b\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_91", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO10.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u6d41\u7a0b\u5185\u7801", (String)"ApiDocServiceQueryImpl_92", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), wfModelId));
            apiInfoNewDO10.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u6d41\u7a0b\u522b\u540d", (String)"ApiDocServiceQueryImpl_93", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), this.getAlias(wfModelId, source2Alias), true));
            rows.add(apiInfoNewDO10.toMap());
        } else if (apiType.equals("wfTrigger")) {
            appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
            String wfModelId = (String)param.getRequest().getHttpQueryString().get("wfModelId");
            ApiInfoNewDO apiInfoNewDO11 = new ApiInfoNewDO();
            apiInfoNewDO11.setTitle(ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b POST", (String)"ApiDocServiceQueryImpl_94", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO11.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42URL", (String)"ApiDocServiceQueryImpl_34", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), new ArrayList<EntryConfig>(), domainContextUrl + String.format("/nocode/v2/%s/wfmodel?type=trigger", appId)));
            DynamicObject[] loaded3 = BusinessDataServiceHelper.load((String)"bos_nc_wfinfo_alias", (String)"source,alias", (QFilter[])new QFilter("modelId", "=", (Object)wfModelId).toArray());
            Map<String, String> source2Alias2 = Arrays.stream(loaded3).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
            ArrayList<RequestParamValue> values9 = new ArrayList<RequestParamValue>();
            values9.add(new RequestParamValue("wfModelId", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u6d41\u7a0b\u6a21\u578b\u5185\u7801", (String)"ApiDocServiceQueryImpl_95", (String)"bos-nocode-service", (Object[])new Object[0])));
            values9.add(new RequestParamValue("businessKey", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_96", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO11.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values9));
            HashMap dataMap = new HashMap();
            ArrayList data = new ArrayList();
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("wfModelId", this.getAliasOrSource(wfModelId, source2Alias2));
            itemMap.put("businessKey", ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_96", (String)"bos-nocode-service", (Object[])new Object[0]));
            data.add(itemMap);
            dataMap.put("data", data);
            PreviewInfo requestDemo = new PreviewInfo(ResManager.loadKDString((String)"\u63d0\u4ea4\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(dataMap));
            apiInfoNewDO11.getPreviewInfos().add(requestDemo);
            PreviewInfo previewInfo2 = new PreviewInfo(ResManager.loadKDString((String)"\u6210\u529f\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": {\n        \"extra\": \"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_97", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"failCount\": \"" + ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cf", (String)"ApiDocServiceQueryImpl_62", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n        \"result\": [\n            {\n                \"billIndex\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_98", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"billStatus\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_99", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"errors\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_100", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"extra\": \"" + ResManager.loadKDString((String)"\u6269\u5c55\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_66", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"id\": \" " + ResManager.loadKDString((String)"\u6d41\u7a0b\u5185\u7801", (String)"ApiDocServiceQueryImpl_92", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"keys\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_68", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"number\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_101", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n                \"type\": \"" + ResManager.loadKDString((String)"\u5197\u4f59\u53c2\u6570\uff0c\u65e0\u9700\u5173\u6ce8", (String)"ApiDocServiceQueryImpl_70", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n            }\n        ],\n        \"successCount\": \"" + ResManager.loadKDString((String)"\u6210\u529f\u6570\u91cf", (String)"ApiDocServiceQueryImpl_71", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n    },\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u6210\u529f", (String)"ApiDocServiceQueryImpl_102", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO11.getPreviewInfos().add(previewInfo2);
            PreviewInfo previewInfo3 = new PreviewInfo(ResManager.loadKDString((String)"\u5931\u8d25\u65f6\u54cd\u5e94\u6570\u636e\u793a\u4f8b", (String)"ApiDocServiceQueryImpl_26", (String)"bos-nocode-service", (Object[])new Object[0]), "{\n    \"data\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u8bb0\u5f55\u6570\u636e", (String)"ApiDocServiceQueryImpl_52", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"errorCode\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_53", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"message\": \"" + ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ApiDocServiceQueryImpl_54", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"status\": \"" + ResManager.loadKDString((String)"\u662f\u5426\u8bf7\u6c42\u6210\u529f", (String)"ApiDocServiceQueryImpl_24", (String)"bos-nocode-service", (Object[])new Object[0]) + "\",\n    \"traceId\": \"" + ResManager.loadKDString((String)"\u8bf7\u6c42\u65e5\u5fd7\u5185\u7801", (String)"ApiDocServiceQueryImpl_55", (String)"bos-nocode-service", (Object[])new Object[0]) + "\"\n}");
            apiInfoNewDO11.getPreviewInfos().add(previewInfo3);
            rows.add(apiInfoNewDO11.toMap());
        } else if (apiType.equals("appendix_filter")) {
            apiInfoNewDO = new ApiInfoNewDO();
            apiInfoNewDO.setTitle(ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_103", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO.getItems().add(new Item(ID.genStringId(), "", "nocodegraphicdisplayfield", new ArrayList<EntryConfig>(), ResManager.loadKDString((String)"\u683c\u5f0f\uff1a\u5185\u5bb9\u5185\u7801/\u522b\u540d \u6bd4\u8f83\u7b26 \u5185\u5bb9\u503c", (String)"ApiDocServiceQueryImpl_104", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u591a\u4e2a\u7b5b\u9009\u6761\u4ef6\u65f6\u4f7f\u7528and\u6216or\u8fdb\u884c\u8fde\u63a5", (String)"ApiDocServiceQueryImpl_105", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u6bd4\u8f83\u7b26\u8be6\u89c1\u9644\u5f55-\u6bd4\u8f83\u7b26", (String)"ApiDocServiceQueryImpl_106", (String)"bos-nocode-service", (Object[])new Object[0])));
            demoMap = new HashMap<String, String>();
            demoMap.put(ResManager.loadKDString((String)"demo1\uff08\u7f16\u53f7\u7b49\u4e8ebill001\uff09", (String)"ApiDocServiceQueryImpl_107", (String)"bos-nocode-service", (Object[])new Object[0]), "billno EQ 'bill001'");
            demoMap.put(ResManager.loadKDString((String)"demo2\uff08\u6570\u5b57\u5927\u4e8e100\uff09", (String)"ApiDocServiceQueryImpl_108", (String)"bos-nocode-service", (Object[])new Object[0]), "decimal_field BT 100");
            demoMap.put(ResManager.loadKDString((String)"demo3\uff08\u9009\u9879\u5728...\u4e4b\u4e2d\uff09", (String)"ApiDocServiceQueryImpl_109", (String)"bos-nocode-service", (Object[])new Object[0]), ResManager.loadKDString((String)"combo_field IN ('\u9009\u9879\u4e00', '\u9009\u9879\u4e8c')", (String)"ApiDocServiceQueryImpl_110", (String)"bos-nocode-service", (Object[])new Object[0]));
            demoMap.put(ResManager.loadKDString((String)"demo4\uff08\u9009\u9879\u4e0d\u5728...\u4e4b\u4e2d\uff09", (String)"ApiDocServiceQueryImpl_111", (String)"bos-nocode-service", (Object[])new Object[0]), ResManager.loadKDString((String)"combo_field NI ('\u9009\u9879\u4e00', '\u9009\u9879\u4e8c')", (String)"ApiDocServiceQueryImpl_112", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO.getPreviewInfos().add(new PreviewInfo(ResManager.loadKDString((String)"\u793a\u4f8b\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_113", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(demoMap)));
            rows.add(apiInfoNewDO.toMap());
        } else if (apiType.equals("appendix_order")) {
            apiInfoNewDO = new ApiInfoNewDO();
            apiInfoNewDO.setTitle(ResManager.loadKDString((String)"\u6392\u5e8f\u6761\u4ef6", (String)"ApiDocServiceQueryImpl_114", (String)"bos-nocode-service", (Object[])new Object[0]));
            apiInfoNewDO.getItems().add(new Item(ID.genStringId(), "", "nocodegraphicdisplayfield", new ArrayList<EntryConfig>(), ResManager.loadKDString((String)"\u683c\u5f0f\uff1a\u5185\u5bb9\u5185\u7801/\u522b\u540d desc", (String)"ApiDocServiceQueryImpl_115", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u9ed8\u8ba4\u5347\u5e8f\uff0c\u5982\u679c\u5728\u6392\u5e8f\u7684\u5185\u5bb9\u540e\u6dfb\u52a0desc\uff0c\u5219\u8fd4\u56de\u5012\u5e8f\u7ed3\u679c", (String)"ApiDocServiceQueryImpl_116", (String)"bos-nocode-service", (Object[])new Object[0]) + "\n" + ResManager.loadKDString((String)"\u591a\u4e2a\u6392\u5e8f\u6761\u4ef6\u65f6\u4f7f\u7528\u201c,\u201d\u8fdb\u884c\u5206\u5272", (String)"ApiDocServiceQueryImpl_117", (String)"bos-nocode-service", (Object[])new Object[0])));
            demoMap = new HashMap();
            demoMap.put(ResManager.loadKDString((String)"demo1\uff08\u6839\u636e\u540d\u79f0\u6392\u5e8f\uff09", (String)"ApiDocServiceQueryImpl_118", (String)"bos-nocode-service", (Object[])new Object[0]), "order_by=name");
            demoMap.put(ResManager.loadKDString((String)"demo2\uff08\u6839\u636e\u540d\u79f0\u6392\u5e8f\uff0c\u518d\u6839\u636e\u6027\u522b\u5012\u5e8f\u6392\u5e8f\uff09", (String)"ApiDocServiceQueryImpl_119", (String)"bos-nocode-service", (Object[])new Object[0]), "order_by=name,gender desc");
            apiInfoNewDO.getPreviewInfos().add(new PreviewInfo(ResManager.loadKDString((String)"\u793a\u4f8b\u6570\u636e\u63d0\u793a", (String)"ApiDocServiceQueryImpl_113", (String)"bos-nocode-service", (Object[])new Object[0]), JsonUtil.prettyPrint(demoMap)));
            rows.add(apiInfoNewDO.toMap());
        } else if (apiType.equals("appendix_compare")) {
            apiInfoNewDO = new ApiInfoNewDO();
            apiInfoNewDO.setTitle(ResManager.loadKDString((String)"\u6bd4\u8f83\u7b26", (String)"ApiDocServiceQueryImpl_7", (String)"bos-nocode-service", (Object[])new Object[0]));
            values = FilterVisitor.operatorsDesc.entrySet().stream().map(e -> new ApiCodeDesc((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
            apiInfoNewDO.getItems().add(new Item(ID.genStringId(), "", ApiDocFieldTypeEnum.nocodeentryfield.toString(), compareDesc, values));
            rows.add(apiInfoNewDO.toMap());
        } else if (apiType.equals("appendix_error")) {
            apiInfoNewDO = new ApiInfoNewDO();
            apiInfoNewDO.setTitle(ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]));
            values = new ArrayList();
            values.add(new ApiCodeDesc("0", ResManager.loadKDString((String)"\u6210\u529f", (String)"ApiDocServiceQueryImpl_120", (String)"bos-nocode-service", (Object[])new Object[0])));
            values.add(new ApiCodeDesc("500", ResManager.loadKDString((String)"\u670d\u52a1\u5668\u5f02\u5e38", (String)"ApiDocServiceQueryImpl_121", (String)"bos-nocode-service", (Object[])new Object[0])));
            values.add(new ApiCodeDesc("999", ResManager.loadKDString((String)"\u8bf7\u6c42\u5f02\u5e38", (String)"ApiDocServiceQueryImpl_122", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO.getItems().add(new Item(ID.genStringId(), "", ApiDocFieldTypeEnum.nocodeentryfield.toString(), errorCodeDesc, values));
            rows.add(apiInfoNewDO.toMap());
        } else if (apiType.equals("appendix_picture")) {
            apiInfoNewDO = new ApiInfoNewDO();
            apiInfoNewDO.setTitle(ResManager.loadKDString((String)"\u56fe\u7247", (String)"ApiDocServiceQueryImpl_123", (String)"bos-nocode-service", (Object[])new Object[0]));
            values = new ArrayList();
            values.add(new RequestParamValue("name", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u56fe\u7247\u540d\u79f0", (String)"ApiDocServiceQueryImpl_124", (String)"bos-nocode-service", (Object[])new Object[0])));
            values.add(new RequestParamValue("size", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "int", ResManager.loadKDString((String)"\u56fe\u7247\u5927\u5c0f", (String)"ApiDocServiceQueryImpl_125", (String)"bos-nocode-service", (Object[])new Object[0])));
            values.add(new RequestParamValue("uid", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u552f\u4e00\u6807\u8bc6", (String)"ApiDocServiceQueryImpl_126", (String)"bos-nocode-service", (Object[])new Object[0])));
            values.add(new RequestParamValue(URL, ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5668\u7684\u56fe\u7247\u76f8\u5bf9\u5730\u5740", (String)"ApiDocServiceQueryImpl_127", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values));
            rows.add(apiInfoNewDO.toMap());
        } else if (apiType.equals("appendix_attachment")) {
            apiInfoNewDO = new ApiInfoNewDO();
            apiInfoNewDO.setTitle(ResManager.loadKDString((String)"\u9644\u4ef6", (String)"ApiDocServiceQueryImpl_128", (String)"bos-nocode-service", (Object[])new Object[0]));
            values = new ArrayList();
            values.add(new RequestParamValue("attPkIdStr", ResManager.loadKDString((String)"\u662f", (String)"ApiDocServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]), "string", ResManager.loadKDString((String)"\u9644\u4ef6\u5185\u7801", (String)"ApiDocServiceQueryImpl_129", (String)"bos-nocode-service", (Object[])new Object[0])));
            apiInfoNewDO.getItems().add(new Item(ID.genStringId(), ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"ApiDocServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodeentryfield.toString(), requestParams, values));
            rows.add(apiInfoNewDO.toMap());
        }
        RestApiQueryResult result = new RestApiQueryResult();
        result.setPageNo(param.getPage_no());
        result.setPageSize(param.getPage_size());
        result.setTotalCount(1);
        result.setLastPage(Boolean.valueOf(true));
        result.setRows((List)rows);
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
    }

    private long getExpiredTime() {
        return LocalDateTime.now().plusYears(2L).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private String getApiSecretKey() {
        return OpenApiAuthUtil.getOrCreateSC();
    }

    @NotNull
    private static String getFieldDesc(IDataEntityProperty property) {
        String val = "";
        if (property instanceof TextProp) {
            val = "string";
        } else if (property instanceof DecimalProp) {
            val = "double";
        } else if (property instanceof NoCodeMulComboProp) {
            val = ResManager.loadKDString((String)"string \u5b58\u5728\u591a\u4e2a\u65f6\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694", (String)"ApiDocServiceQueryImpl_130", (String)"bos-nocode-service", (Object[])new Object[0]);
        } else if (property instanceof ComboProp) {
            val = "string";
        } else if (property instanceof NoCodeMulRefBillProp) {
            val = "bos_user".equals(((NoCodeMulRefBillProp)property).getBillEntityNumber()) ? ResManager.loadKDString((String)"string \u4eba\u5458\u5185\u7801\uff0c\u5b58\u5728\u591a\u4e2a\u65f6\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694", (String)"ApiDocServiceQueryImpl_131", (String)"bos-nocode-service", (Object[])new Object[0]) : ("bos_adminorg".equals(((NoCodeMulRefBillProp)property).getBillEntityNumber()) ? ResManager.loadKDString((String)"string \u7ec4\u7ec7\u5185\u7801\uff0c\u5b58\u5728\u591a\u4e2a\u65f6\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694", (String)"ApiDocServiceQueryImpl_132", (String)"bos-nocode-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"string \u8868\u5355\u8bb0\u5f55\u5185\u7801\uff0c\u5b58\u5728\u591a\u4e2a\u65f6\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694", (String)"ApiDocServiceQueryImpl_133", (String)"bos-nocode-service", (Object[])new Object[0]));
        } else if (property instanceof NoCodeRefBillProp) {
            val = "bos_user".equals(((NoCodeRefBillProp)property).getBillEntityNumber()) ? ResManager.loadKDString((String)"string \u4eba\u5458\u5185\u7801", (String)"ApiDocServiceQueryImpl_134", (String)"bos-nocode-service", (Object[])new Object[0]) : ("bos_adminorg".equals(((NoCodeRefBillProp)property).getBillEntityNumber()) ? ResManager.loadKDString((String)"string \u7ec4\u7ec7\u5185\u7801", (String)"ApiDocServiceQueryImpl_135", (String)"bos-nocode-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"string \u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_136", (String)"bos-nocode-service", (Object[])new Object[0]));
        } else if (property instanceof DateTimeProp) {
            val = ResManager.loadKDString((String)"string \u9700\u8981\u6309\u7167\u201c2024-05-11 15:35:55\u201d\u7684\u683c\u5f0f\u5b8c\u6574\u586b\u5165", (String)"ApiDocServiceQueryImpl_137", (String)"bos-nocode-service", (Object[])new Object[0]);
        } else if (property instanceof PictureProp) {
            val = ResManager.loadKDString((String)"object \u56fe\u7247\u6240\u9700\u7684\u53c2\u6570\u8be6\u89c1\u9644\u5f55-\u56fe\u7247", (String)"ApiDocServiceQueryImpl_138", (String)"bos-nocode-service", (Object[])new Object[0]);
        } else if (property instanceof AttachmentProp) {
            val = ResManager.loadKDString((String)"object \u9644\u4ef6\u6240\u9700\u7684\u53c2\u6570\u8be6\u89c1\u9644\u5f55-\u9644\u4ef6", (String)"ApiDocServiceQueryImpl_139", (String)"bos-nocode-service", (Object[])new Object[0]);
        }
        return val;
    }

    private String getAlias(String source, Map<String, String> source2Alias) {
        String formAlias = source2Alias.get(source);
        if (StringUtils.isNotBlank((CharSequence)formAlias)) {
            return formAlias;
        }
        return "";
    }

    private String getAliasOrSource(String source, Map<String, String> source2Alias) {
        String formAlias = source2Alias.get(source);
        if (StringUtils.isNotBlank((CharSequence)formAlias)) {
            return formAlias;
        }
        return source;
    }

    private Map<String, Object> getFormFieldDemoData(String formId, boolean includeId, Map<String, String> formAlias, boolean addTriggerWfParam) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        List listItems = ListConfigUtils.getListItemConfig((String)formId);
        LinkedHashMap<String, Object> fieldValueMap = new LinkedHashMap<String, Object>(listItems.size());
        listItems.forEach(e -> {
            String number = (String)e.get("number");
            IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)number);
            number = this.getAliasOrSource(number, formAlias);
            if (property instanceof TextProp) {
                fieldValueMap.put(number, ResManager.loadKDString((String)"\u6587\u672c", (String)"ApiDocServiceQueryImpl_140", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (property instanceof NoCodeMulComboProp) {
                fieldValueMap.put(number, ResManager.loadKDString((String)"\u9009\u98791,\u9009\u98792", (String)"ApiDocServiceQueryImpl_141", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (property instanceof ComboProp) {
                fieldValueMap.put(number, ResManager.loadKDString((String)"\u9009\u98791", (String)"ApiDocServiceQueryImpl_142", (String)"bos-nocode-service", (Object[])new Object[0]));
            } else if (property instanceof DecimalProp) {
                fieldValueMap.put(number, "111.11");
            } else if (property instanceof RefBillProp) {
                if (((RefBillProp)property).getBillEntityId().equals("bos_user")) {
                    fieldValueMap.put(number, ResManager.loadKDString((String)"\u4eba\u5458\u5185\u7801", (String)"ApiDocServiceQueryImpl_143", (String)"bos-nocode-service", (Object[])new Object[0]));
                } else if (((RefBillProp)property).getBillEntityId().equals("bos_adminorg")) {
                    fieldValueMap.put(number, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u7801", (String)"ApiDocServiceQueryImpl_144", (String)"bos-nocode-service", (Object[])new Object[0]));
                } else {
                    fieldValueMap.put(number, ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_96", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
            } else if (property instanceof NoCodeMulRefBillProp) {
                if (((NoCodeMulRefBillProp)property).getBillEntityId().equals("bos_user")) {
                    fieldValueMap.put(number, ResManager.loadKDString((String)"\u4eba\u5458\u5185\u7801", (String)"ApiDocServiceQueryImpl_143", (String)"bos-nocode-service", (Object[])new Object[0]));
                } else if (((NoCodeMulRefBillProp)property).getBillEntityId().equals("bos_adminorg")) {
                    fieldValueMap.put(number, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u7801", (String)"ApiDocServiceQueryImpl_144", (String)"bos-nocode-service", (Object[])new Object[0]));
                } else {
                    fieldValueMap.put(number, ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u78011,\u8868\u5355\u8bb0\u5f55\u5185\u78012", (String)"ApiDocServiceQueryImpl_145", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
            } else if (property instanceof DateTimeProp) {
                fieldValueMap.put(number, "2024-05-11 15:35:55");
            } else if (property instanceof AttachmentProp) {
                ArrayList attachmentList = new ArrayList();
                HashMap<String, String> itemMap = new HashMap<String, String>();
                itemMap.put("id", ResManager.loadKDString((String)"\u9644\u4ef6\u5185\u7801", (String)"ApiDocServiceQueryImpl_129", (String)"bos-nocode-service", (Object[])new Object[0]));
                attachmentList.add(itemMap);
                fieldValueMap.put(number, attachmentList);
            } else if (property instanceof PictureProp) {
                ArrayList pictureList = new ArrayList();
                HashMap<String, String> itemMap = new HashMap<String, String>();
                itemMap.put("uid", ResManager.loadKDString((String)"\u552f\u4e00\u6807\u8bc6", (String)"ApiDocServiceQueryImpl_126", (String)"bos-nocode-service", (Object[])new Object[0]));
                itemMap.put("name", ResManager.loadKDString((String)"\u56fe\u7247\u540d\u79f0", (String)"ApiDocServiceQueryImpl_124", (String)"bos-nocode-service", (Object[])new Object[0]));
                itemMap.put("size", ResManager.loadKDString((String)"\u56fe\u7247\u5927\u5c0f", (String)"ApiDocServiceQueryImpl_125", (String)"bos-nocode-service", (Object[])new Object[0]));
                itemMap.put(URL, ResManager.loadKDString((String)"\u82cd\u7a79\u6587\u4ef6\u670d\u52a1\u5668\u7684\u56fe\u7247\u76f8\u5bf9\u5730\u5740", (String)"ApiDocServiceQueryImpl_127", (String)"bos-nocode-service", (Object[])new Object[0]));
                pictureList.add(itemMap);
                fieldValueMap.put(number, pictureList);
            }
        });
        if (includeId) {
            fieldValueMap.put("id", ResManager.loadKDString((String)"\u8868\u5355\u8bb0\u5f55\u5185\u7801", (String)"ApiDocServiceQueryImpl_96", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        if (addTriggerWfParam) {
            fieldValueMap.put("triggerWf", ResManager.loadKDString((String)"\u5e03\u5c14\u7c7b\u578b\uff0c\u662f\u5426\u89e6\u53d1\u6d41\u7a0b\u3002\u9ed8\u8ba4\u4e3atrue\uff0c\u82e5\u6ca1\u6709\u89c6\u4e3a\u89e6\u53d1\u6d41\u7a0b", (String)"ApiDocServiceQueryImpl_146", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        return fieldValueMap;
    }

    static {
        EntryConfig entryConfig1 = new EntryConfig("name", ResManager.loadKDString((String)"\u53c2\u6570\u540d", (String)"ApiDocServiceQueryImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        EntryConfig entryConfig2 = new EntryConfig("required", ResManager.loadKDString((String)"\u5fc5\u9009", (String)"ApiDocServiceQueryImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        EntryConfig entryConfig3 = new EntryConfig(TYPE, ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ApiDocServiceQueryImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        EntryConfig entryConfig4 = new EntryConfig("desc", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ApiDocServiceQueryImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        requestParams.add(entryConfig1);
        requestParams.add(entryConfig2);
        requestParams.add(entryConfig3);
        requestParams.add(entryConfig4);
        formInfoParams = new ArrayList<EntryConfig>();
        entryConfig1 = new EntryConfig("number", ResManager.loadKDString((String)"\u5185\u5bb9\u5185\u7801", (String)"ApiDocServiceQueryImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        entryConfig2 = new EntryConfig("alias", ResManager.loadKDString((String)"\u5185\u5bb9\u522b\u540d", (String)"ApiDocServiceQueryImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString(), true);
        entryConfig3 = new EntryConfig("name", ResManager.loadKDString((String)"\u5185\u5bb9\u540d\u79f0", (String)"ApiDocServiceQueryImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        entryConfig4 = new EntryConfig(TYPE, ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ApiDocServiceQueryImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        EntryConfig entryConfig5 = new EntryConfig("desc", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ApiDocServiceQueryImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        formInfoParams.add(entryConfig1);
        formInfoParams.add(entryConfig2);
        formInfoParams.add(entryConfig3);
        formInfoParams.add(entryConfig4);
        formInfoParams.add(entryConfig5);
        compareDesc = new ArrayList<EntryConfig>();
        entryConfig1 = new EntryConfig("code", ResManager.loadKDString((String)"\u6bd4\u8f83\u7b26", (String)"ApiDocServiceQueryImpl_7", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        entryConfig2 = new EntryConfig("desc", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ApiDocServiceQueryImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        compareDesc.add(entryConfig1);
        compareDesc.add(entryConfig2);
        errorCodeDesc = new ArrayList<EntryConfig>();
        entryConfig1 = new EntryConfig("code", ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiDocServiceQueryImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        entryConfig2 = new EntryConfig("desc", ResManager.loadKDString((String)"\u8bf4\u660e", (String)"ApiDocServiceQueryImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]), ApiDocFieldTypeEnum.nocodetextfield.toString());
        errorCodeDesc.add(entryConfig1);
        errorCodeDesc.add(entryConfig2);
    }
}

