/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import net.sourceforge.pinyin4j.PinyinHelper;
import org.apache.commons.lang3.StringUtils;

public class ApiDocServiceSaveImpl
implements SaveRestApiService {
    private static final String REGEX = "/api_doc(/.*)?$";
    private static final Pattern PATTERN = Pattern.compile("/api_doc(/.*)?$");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
        long startTime;
        block4: {
            String apiType;
            block3: {
                startTime = System.currentTimeMillis();
                apiType = (String)param.getRequest().getHttpQueryString().get("type");
                if (!"formInfo".equals(apiType)) break block3;
                List dataList = param.getDataList();
                for (Map<String, Object> data : dataList) {
                    Boolean batchAlias = (Boolean)data.get("batchAlias");
                    String formId = (String)param.getRequest().getHttpQueryString().get("formId");
                    if (batchAlias != null && batchAlias.booleanValue()) {
                        this.batchAlias(formId);
                        continue;
                    }
                    data = this.rebuildData(data, formId);
                    this.saveAliasMap(data, formId);
                }
                break block4;
            }
            if (!"wfInfo".equals(apiType)) break block4;
            List dataList = param.getDataList();
            for (Map data : dataList) {
                String wfModelId = (String)param.getRequest().getHttpQueryString().get("wfModelId");
                this.checkWfDuplicate(wfModelId, data);
                DeleteServiceHelper.delete((String)"bos_nc_wfinfo_alias", (QFilter[])new QFilter("modelid", "=", (Object)wfModelId).toArray());
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])data.entrySet().stream().map(e -> {
                    DynamicObject bosNcWfinfoAlias = BusinessDataServiceHelper.newDynamicObject((String)"bos_nc_wfinfo_alias");
                    bosNcWfinfoAlias.set("modelid", (Object)wfModelId);
                    bosNcWfinfoAlias.set("source", e.getKey());
                    bosNcWfinfoAlias.set("alias", e.getValue());
                    bosNcWfinfoAlias.set("type", (Object)(wfModelId.equals(e.getKey()) ? "1" : "0"));
                    return bosNcWfinfoAlias;
                }).toArray(DynamicObject[]::new)));
            }
        }
        return RestApiServiceData.ofTrue((RestApiResponse)new RestApiResponse(), (long)(System.currentTimeMillis() - startTime));
    }

    private Map<String, Object> rebuildData(Map<String, Object> data, String formId) {
        DynamicObject[] existObjArr = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"entityNumber,source,alias,type", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
        Map<String, Object> existDataMap = Arrays.stream(existObjArr).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
        existDataMap.putAll(data);
        return existDataMap;
    }

    private void saveAliasMap(Map<String, Object> data, String formId) {
        this.checkFormDuplicate(formId, data);
        DeleteServiceHelper.delete((String)"bos_nc_forminfo_alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])data.entrySet().stream().map(e -> {
            DynamicObject bosNcForminfoAlias = BusinessDataServiceHelper.newDynamicObject((String)"bos_nc_forminfo_alias");
            bosNcForminfoAlias.set("entityNumber", (Object)formId);
            bosNcForminfoAlias.set("source", e.getKey());
            bosNcForminfoAlias.set("alias", e.getValue());
            bosNcForminfoAlias.set("type", (Object)(formId.equals(e.getKey()) ? "1" : "0"));
            return bosNcForminfoAlias;
        }).toArray(DynamicObject[]::new)));
    }

    private void batchAlias(String formId) {
        DynamicObjectCollection aliasObjs = QueryServiceHelper.query((String)"bos_nc_forminfo_alias", (String)"source,alias", (QFilter[])new QFilter("entityNumber", "=", (Object)formId).toArray());
        Map<String, String> existedAliasMap = aliasObjs.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getString("alias"))).collect(Collectors.toMap(e -> e.getString("source"), e -> e.getString("alias")));
        List listItemConfig = ListConfigUtils.getListItemConfig((String)formId);
        HashMap aliasCountMap = new HashMap();
        Map<String, Object> aliasMap = listItemConfig.stream().map(e -> {
            Integer count;
            String number = (String)e.get("number");
            if (existedAliasMap.containsKey(number)) {
                return null;
            }
            String name = (String)e.get("name");
            String alias = ApiDocServiceSaveImpl.convertToFirstLetters(name, number);
            if (alias.length() > 48) {
                alias = alias.substring(0, 48);
            }
            if ((count = aliasCountMap.getOrDefault(alias, 0)) >= 100) {
                throw new RestApiException(ResManager.loadKDString((String)"\u6279\u91cf\u751f\u4ea7\u7684\u5185\u5bb9\u522b\u540d\u8d85\u8fc7\u4e86100\u4e2a\u91cd\u590d\u7684\uff0c\u8bf7\u68c0\u67e5", (String)"ApiDocServiceSaveImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            aliasCountMap.put(alias, count + 1);
            alias = count == 0 ? alias : alias + count;
            return new Tuple((Object)number, (Object)alias);
        }).filter(Objects::nonNull).collect(Collectors.toMap(e -> (String)e.item1, e -> (String)e.item2));
        aliasMap.putAll(existedAliasMap);
        this.saveAliasMap(aliasMap, formId);
    }

    private void checkWfDuplicate(String wfModelId, Map<String, Object> data) {
        DynamicObject[] loaded;
        Set alias;
        String wfAlias = (String)data.get(wfModelId);
        if (StringUtils.isNotEmpty((CharSequence)wfAlias) && (alias = Arrays.stream(loaded = BusinessDataServiceHelper.load((String)"bos_nc_wfinfo_alias", (String)"alias", (QFilter[])new QFilter("type", "=", (Object)"1").and(new QFilter("modelId", "!=", (Object)wfModelId)).toArray())).map(e -> e.getString("alias")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).contains(wfAlias)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6d41\u7a0b\u522b\u540d\u91cd\u590d\u4e86", (String)"ApiDocServiceSaveImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
    }

    private void checkFormDuplicate(String formId, Map<String, Object> data) {
        DynamicObject[] loaded;
        Set alias;
        String formAlias = (String)data.get(formId);
        if (StringUtils.isNotEmpty((CharSequence)formAlias) && (alias = Arrays.stream(loaded = BusinessDataServiceHelper.load((String)"bos_nc_forminfo_alias", (String)"alias", (QFilter[])new QFilter("type", "=", (Object)"1").and(new QFilter("entityNumber", "!=", (Object)formId)).toArray())).map(e -> e.getString("alias")).filter(StringUtils::isNotBlank).collect(Collectors.toSet())).contains(formAlias)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u8be5\u522b\u540d\u5df2\u5b58\u5728", (String)"ApiDocServiceSaveImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        List list = data.entrySet().stream().filter(e -> !((String)e.getKey()).equals(formId)).map(e -> (String)e.getValue()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        HashSet set = Sets.newHashSet(list);
        if (list.size() != set.size()) {
            throw new RestApiException(ResManager.loadKDString((String)"\u8be5\u522b\u540d\u5df2\u5b58\u5728", (String)"ApiDocServiceSaveImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
    }

    public static String convertToFirstLetters(String chineseString, String number) {
        if (StringUtils.isEmpty((CharSequence)(chineseString = chineseString.replaceAll("[^A-Za-z0-9_\\u4e00-\\u9fa5]", "")))) {
            return number;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chineseString.toCharArray()) {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c);
            if (pinyinArray != null) {
                String pinyin = pinyinArray[0];
                if (pinyin.isEmpty()) continue;
                sb.append(pinyin.toUpperCase().charAt(0));
                continue;
            }
            sb.append(c);
        }
        return sb.toString().trim();
    }
}

