/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.ID;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.constant.ApiMenuTypeEnum;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ApiMenuServiceQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/api_menu(/.*)?$";
    private static final Pattern PATTERN = Pattern.compile("/api_menu(/.*)?$");
    private static final String APP_ID = "appId";
    private static final String FORM = "form";
    private static final String WF = "wf";
    private static final String APPENDIX = "appendix";
    private static final String ILLEGAL_URL_PATH = "illegal url path";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String URL = "url";

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        List<Object> rows = Lists.newArrayList();
        String url = param.getRequest().getUrl();
        String appId = (String)param.getRequest().getHttpQueryString().get(APP_ID);
        Matcher matcher = PATTERN.matcher(url);
        if (matcher.find()) {
            String router = matcher.group(1);
            if (StringUtils.isEmpty((CharSequence)router)) {
                rows = this.getApiMainMenus(appId);
            } else {
                String path1;
                String[] paths = Splitter.on((String)"/").omitEmptyStrings().splitToList((CharSequence)router).toArray(new String[0]);
                if (paths.length == 1) {
                    path1 = paths[0];
                    if (FORM.equals(path1)) {
                        rows = this.getFormList(appId);
                    } else if (WF.equals(path1)) {
                        rows = this.getWfList(appId);
                    } else {
                        if (!APPENDIX.equals(path1)) throw new RestApiException(ILLEGAL_URL_PATH);
                        rows = this.getAppendixInfo();
                    }
                } else {
                    if (paths.length != 2) throw new RestApiException(ILLEGAL_URL_PATH);
                    path1 = paths[0];
                    String path2 = paths[1];
                    if (FORM.equals(path1)) {
                        rows = this.getFormApi(appId, path2);
                    } else {
                        if (!WF.equals(path1)) throw new RestApiException(ILLEGAL_URL_PATH);
                        rows = this.getWfApi(appId, path2);
                    }
                }
            }
        }
        RestApiQueryResult result = new RestApiQueryResult();
        result.setPageNo(param.getPage_no());
        result.setPageSize(param.getPage_size());
        result.setTotalCount(rows.size());
        result.setLastPage(Boolean.valueOf(true));
        result.setRows(rows);
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
    }

    private List<Map<String, Object>> getWfApi(String appId, String wfModelId) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, String> wfInfo = new HashMap<String, String>();
        wfInfo.put(ID, kd.bos.id.ID.genStringId());
        wfInfo.put(NAME, ResManager.loadKDString((String)"\u6d41\u7a0b\u4fe1\u606f", (String)"ApiMenuServiceQueryImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        wfInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        wfInfo.put("apiType", "wfInfo");
        wfInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=wfInfo&wfModelId=" + wfModelId);
        HashMap<String, String> wfTriggerInfo = new HashMap<String, String>();
        wfTriggerInfo.put(ID, kd.bos.id.ID.genStringId());
        wfTriggerInfo.put(NAME, ResManager.loadKDString((String)"\u89e6\u53d1\u6d41\u7a0b", (String)"ApiMenuServiceQueryImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        wfTriggerInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        wfTriggerInfo.put("apiType", "standard");
        wfTriggerInfo.put("wfModelId", wfModelId);
        wfTriggerInfo.put(URL, String.format("/nocode/v2/nocode_sys/common/api_doc?type=wfTrigger&wfModelId=%s&appId=%s", wfModelId, appId));
        rows.add(wfInfo);
        rows.add(wfTriggerInfo);
        return rows;
    }

    private List<Map<String, Object>> getFormApi(String appId, String formId) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, String> formInfo = new HashMap<String, String>();
        formInfo.put(ID, kd.bos.id.ID.genStringId());
        formInfo.put(NAME, ResManager.loadKDString((String)"\u8868\u5355\u4fe1\u606f", (String)"ApiMenuServiceQueryImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
        formInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        formInfo.put("apiType", "formInfo");
        formInfo.put("formId", formId);
        formInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=formInfo&formId=" + formId);
        HashMap<String, String> formGetQuery = new HashMap<String, String>();
        formGetQuery.put(ID, kd.bos.id.ID.genStringId());
        formGetQuery.put(NAME, ResManager.loadKDString((String)"\u67e5\u627e\u8868\u5355\u8bb0\u5f55 GET", (String)"ApiMenuServiceQueryImpl_3", (String)"bos-nocode-service", (Object[])new Object[0]));
        formGetQuery.put(TYPE, ApiMenuTypeEnum.api.toString());
        formGetQuery.put("apiType", "standard");
        formGetQuery.put("formId", formId);
        formGetQuery.put(URL, String.format("/nocode/v2/nocode_sys/common/api_doc?type=formGetQuery&appId=%s&formId=%s", appId, formId));
        HashMap<String, String> formPostQuery = new HashMap<String, String>();
        formPostQuery.put(ID, kd.bos.id.ID.genStringId());
        formPostQuery.put(NAME, ResManager.loadKDString((String)"\u67e5\u627e\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiMenuServiceQueryImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
        formPostQuery.put(TYPE, ApiMenuTypeEnum.api.toString());
        formPostQuery.put("apiType", "standard");
        formPostQuery.put("formId", formId);
        formPostQuery.put(URL, String.format("/nocode/v2/nocode_sys/common/api_doc?type=formPostQuery&appId=%s&formId=%s", appId, formId));
        HashMap<String, String> formAdd = new HashMap<String, String>();
        formAdd.put(ID, kd.bos.id.ID.genStringId());
        formAdd.put(NAME, ResManager.loadKDString((String)"\u65b0\u589e\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiMenuServiceQueryImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]));
        formAdd.put(TYPE, ApiMenuTypeEnum.api.toString());
        formAdd.put("apiType", "standard");
        formAdd.put("formId", formId);
        formAdd.put(URL, String.format("/nocode/v2/nocode_sys/common/api_doc?type=formAdd&appId=%s&formId=%s", appId, formId));
        HashMap<String, String> formUpdate = new HashMap<String, String>();
        formUpdate.put(ID, kd.bos.id.ID.genStringId());
        formUpdate.put(NAME, ResManager.loadKDString((String)"\u4fee\u6539\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiMenuServiceQueryImpl_6", (String)"bos-nocode-service", (Object[])new Object[0]));
        formUpdate.put(TYPE, ApiMenuTypeEnum.api.toString());
        formUpdate.put("apiType", "standard");
        formUpdate.put("formId", formId);
        formUpdate.put(URL, String.format("/nocode/v2/nocode_sys/common/api_doc?type=formUpdate&appId=%s&formId=%s", appId, formId));
        HashMap<String, String> formDelete = new HashMap<String, String>();
        formDelete.put(ID, kd.bos.id.ID.genStringId());
        formDelete.put(NAME, ResManager.loadKDString((String)"\u5220\u9664\u8868\u5355\u8bb0\u5f55 POST", (String)"ApiMenuServiceQueryImpl_7", (String)"bos-nocode-service", (Object[])new Object[0]));
        formDelete.put(TYPE, ApiMenuTypeEnum.api.toString());
        formDelete.put("apiType", "standard");
        formDelete.put("formId", formId);
        formDelete.put(URL, String.format("/nocode/v2/nocode_sys/common/api_doc?type=formDelete&appId=%s&formId=%s", appId, formId));
        rows.add(formInfo);
        rows.add(formGetQuery);
        rows.add(formPostQuery);
        rows.add(formAdd);
        rows.add(formUpdate);
        rows.add(formDelete);
        return rows;
    }

    private List<Map<String, Object>> getAppendixInfo() {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        HashMap<String, String> filterInfo = new HashMap<String, String>();
        filterInfo.put(ID, kd.bos.id.ID.genStringId());
        filterInfo.put(NAME, ResManager.loadKDString((String)"\u7b5b\u9009\u6761\u4ef6", (String)"ApiMenuServiceQueryImpl_8", (String)"bos-nocode-service", (Object[])new Object[0]));
        filterInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        filterInfo.put("apiType", "standard");
        filterInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=appendix_filter");
        HashMap<String, String> orderByInfo = new HashMap<String, String>();
        orderByInfo.put(ID, kd.bos.id.ID.genStringId());
        orderByInfo.put(NAME, ResManager.loadKDString((String)"\u6392\u5e8f\u6761\u4ef6", (String)"ApiMenuServiceQueryImpl_9", (String)"bos-nocode-service", (Object[])new Object[0]));
        orderByInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        orderByInfo.put("apiType", "standard");
        orderByInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=appendix_order");
        HashMap<String, String> compareInfo = new HashMap<String, String>();
        compareInfo.put(ID, kd.bos.id.ID.genStringId());
        compareInfo.put(NAME, ResManager.loadKDString((String)"\u6bd4\u8f83\u7b26", (String)"ApiMenuServiceQueryImpl_10", (String)"bos-nocode-service", (Object[])new Object[0]));
        compareInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        compareInfo.put("apiType", "standard");
        compareInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=appendix_compare");
        HashMap<String, String> errorCodeInfo = new HashMap<String, String>();
        errorCodeInfo.put(ID, kd.bos.id.ID.genStringId());
        errorCodeInfo.put(NAME, ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"ApiMenuServiceQueryImpl_11", (String)"bos-nocode-service", (Object[])new Object[0]));
        errorCodeInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        errorCodeInfo.put("apiType", "standard");
        errorCodeInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=appendix_error");
        HashMap<String, String> pictureInfo = new HashMap<String, String>();
        pictureInfo.put(ID, kd.bos.id.ID.genStringId());
        pictureInfo.put(NAME, ResManager.loadKDString((String)"\u56fe\u7247", (String)"ApiMenuServiceQueryImpl_12", (String)"bos-nocode-service", (Object[])new Object[0]));
        pictureInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        pictureInfo.put("apiType", "standard");
        pictureInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=appendix_picture");
        HashMap<String, String> attachmentInfo = new HashMap<String, String>();
        attachmentInfo.put(ID, kd.bos.id.ID.genStringId());
        attachmentInfo.put(NAME, ResManager.loadKDString((String)"\u9644\u4ef6", (String)"ApiMenuServiceQueryImpl_13", (String)"bos-nocode-service", (Object[])new Object[0]));
        attachmentInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        attachmentInfo.put("apiType", "standard");
        attachmentInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=appendix_attachment");
        rows.add(filterInfo);
        rows.add(orderByInfo);
        rows.add(compareInfo);
        rows.add(errorCodeInfo);
        rows.add(pictureInfo);
        rows.add(attachmentInfo);
        return rows;
    }

    private List<Map<String, Object>> getWfList(String appId) {
        List processModels = NoCodeWorkflowServiceHelper.getAllProcesses((String)"NoCodeFlow", (String)appId);
        return processModels.stream().map(e -> {
            HashMap<String, String> row1 = new HashMap<String, String>();
            row1.put(ID, kd.bos.id.ID.genStringId());
            row1.put(NAME, e.getName().toString());
            row1.put(TYPE, ApiMenuTypeEnum.menu.toString());
            row1.put(URL, "/nocode/v2/nocode_sys/common/api_menu/wf/" + e.getId() + "?appId=" + appId);
            return row1;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getFormList(String appId) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
        return appMetadata.getAppMenus().stream().map(e -> {
            String formId = e.getFormId();
            if (StringUtils.isBlank((CharSequence)formId)) {
                return null;
            }
            HashMap<String, String> row1 = new HashMap<String, String>(8);
            row1.put(ID, kd.bos.id.ID.genStringId());
            row1.put(NAME, e.getName().toString());
            row1.put(TYPE, ApiMenuTypeEnum.menu.toString());
            row1.put(URL, "/nocode/v2/nocode_sys/common/api_menu/form/" + formId + "?appId=" + appId);
            return row1;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getApiMainMenus(String appId) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(8);
        HashMap<String, String> requestInfo = new HashMap<String, String>(8);
        requestInfo.put(ID, kd.bos.id.ID.genStringId());
        requestInfo.put(NAME, ResManager.loadKDString((String)"\u8bf7\u6c42\u683c\u5f0f", (String)"ApiMenuServiceQueryImpl_14", (String)"bos-nocode-service", (Object[])new Object[0]));
        requestInfo.put(TYPE, ApiMenuTypeEnum.api.toString());
        requestInfo.put("apiType", "request_info");
        requestInfo.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=request_info");
        HashMap<String, String> auth = new HashMap<String, String>(8);
        auth.put(ID, kd.bos.id.ID.genStringId());
        auth.put(NAME, ResManager.loadKDString((String)"\u8ba4\u8bc1 GET", (String)"ApiMenuServiceQueryImpl_15", (String)"bos-nocode-service", (Object[])new Object[0]));
        auth.put(TYPE, ApiMenuTypeEnum.api.toString());
        auth.put("apiType", "standard");
        auth.put(URL, "/nocode/v2/nocode_sys/common/api_doc?type=auth");
        HashMap<String, String> formInfo = new HashMap<String, String>();
        formInfo.put(ID, kd.bos.id.ID.genStringId());
        formInfo.put(NAME, ResManager.loadKDString((String)"\u8868\u5355", (String)"ApiMenuServiceQueryImpl_16", (String)"bos-nocode-service", (Object[])new Object[0]));
        formInfo.put(TYPE, ApiMenuTypeEnum.menu.toString());
        formInfo.put(URL, "/nocode/v2/nocode_sys/common/api_menu/form?appId=" + appId);
        HashMap<String, String> wfInfo = new HashMap<String, String>();
        wfInfo.put(ID, kd.bos.id.ID.genStringId());
        wfInfo.put(NAME, ResManager.loadKDString((String)"\u6d41\u7a0b", (String)"ApiMenuServiceQueryImpl_17", (String)"bos-nocode-service", (Object[])new Object[0]));
        wfInfo.put(TYPE, ApiMenuTypeEnum.menu.toString());
        wfInfo.put(URL, "/nocode/v2/nocode_sys/common/api_menu/wf?appId=" + appId);
        HashMap<String, String> appendixInfo = new HashMap<String, String>();
        appendixInfo.put(ID, kd.bos.id.ID.genStringId());
        appendixInfo.put(NAME, ResManager.loadKDString((String)"\u9644\u5f55", (String)"ApiMenuServiceQueryImpl_18", (String)"bos-nocode-service", (Object[])new Object[0]));
        appendixInfo.put(TYPE, ApiMenuTypeEnum.menu.toString());
        appendixInfo.put(URL, "/nocode/v2/nocode_sys/common/api_menu/appendix");
        rows.add(requestInfo);
        rows.add(auth);
        rows.add(formInfo);
        rows.add(wfInfo);
        rows.add(appendixInfo);
        return rows;
    }
}

