/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.service.sys.helper.AppServiceHelper;
import kd.bos.nocode.utils.NoCodePermHelper;

public class AppImportServiceImpl
implements SaveRestApiService {
    private static final String REGEX = "/app_import";
    private static final Pattern PATTERN = Pattern.compile("/app_import");
    private static final Log logger = LogFactory.getLog(AppImportServiceImpl.class);

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        boolean check = NoCodePermHelper.checkUserAppCreateInNoCode();
        if (!check) {
            throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6743\u9650\u521b\u5efa\u5e94\u7528", (String)"AppImportServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        Map map = (Map)param.getDataList().get(0);
        Object file = map.get("file");
        if (file == null || StringUtil.isEmpty((String)file.toString())) {
            logger.debug("\u6587\u4ef6\u8def\u5f84\u4e0d\u53ef\u4e3a\u7a7a");
            throw new RestApiException(ResManager.loadKDString((String)"\u53ef\u80fd\u5b58\u5728\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\u7b49\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u5bfc\u5165", (String)"AppImportServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        String pre = map.getOrDefault("pre", "false");
        RestApiSaveResult result = new RestApiSaveResult();
        if ("true".equals(pre)) {
            this.preImportApp(file.toString(), result);
        } else {
            String appId = AppServiceHelper.importAppFromZip(param);
            result.setExtra(Maps.of((Object)"appId", (Object)appId));
        }
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private void preImportApp(String path, RestApiSaveResult result) {
        try {
            ZipEntry entry;
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(path);
            ZipInputStream zis = new ZipInputStream(in);
            JSONObject config = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory() || !"config.json".equals(entry.getName())) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    config = JSONObject.parseObject((String)bos.toString("UTF-8"));
                }
                catch (Throwable buffer) {
                    throwable = buffer;
                    throw buffer;
                }
                finally {
                    if (bos == null) continue;
                    if (throwable != null) {
                        try {
                            bos.close();
                        }
                        catch (Throwable buffer) {
                            throwable.addSuppressed(buffer);
                        }
                        continue;
                    }
                    bos.close();
                }
            }
            if (config == null) {
                throw new RestApiException(ResManager.loadKDString((String)"\u53ef\u80fd\u5b58\u5728\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\u7b49\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u5bfc\u5165", (String)"AppImportServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            HashMap<String, Object> row = new HashMap<String, Object>();
            String appName = config.getString("appName");
            row.put("name", appName);
            String desc = config.getString("description");
            row.put("description", desc);
            String image = config.getString("image");
            row.put("image", image);
            boolean withData = config.containsKey((Object)"datas");
            row.put("withData", withData);
            result.setExtra(row);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new RestApiException(ResManager.loadKDString((String)"\u53ef\u80fd\u5b58\u5728\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\u7b49\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u5bfc\u5165", (String)"AppImportServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
    }
}

