/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;

public class BizButtonQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/biz_button";
    private static final Pattern PATTERN = Pattern.compile("/biz_button");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        Set appids = NoCodePermissionServiceHelper.getManageAppIds((long)RequestContext.get().getCurrUserId());
        String formid = (String)param.getRequest().getHttpQueryString().get("formid");
        String appid = (String)param.getRequest().getHttpQueryString().get("appid");
        if (!appids.contains(appid)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"BizButtonQueryImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        List<Object> rows = new ArrayList();
        if (NcEntityTypeUtil.isFormExist((String)formid)) {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formid, (MetaCategory)MetaCategory.Form);
            rows = formMetadata.getItems().stream().filter(i -> i instanceof NoCodeBizButtonAp).sorted(Comparator.comparingInt(ControlAp::getIndex)).map(bizButton -> {
                NoCodeBizButtonAp noCodeBizButtonAp = (NoCodeBizButtonAp)bizButton;
                return noCodeBizButtonAp.createControl();
            }).collect(Collectors.toList());
        }
        RestApiQueryResult result = new RestApiQueryResult();
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        result.setRows(rows);
        result.setTotalCount(rows.size());
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
    }
}

