/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import kd.bos.nocode.enums.ColorEnum;
import kd.bos.nocode.restapi.api.DirectRestApiService;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.service.util.SvgUtil;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class IconServiceQueryImpl
implements DirectRestApiService {
    private static final String REGEX = "/svgs/(create_svg(_line)?)";
    private static final Pattern PATTERN = Pattern.compile("/svgs/(create_svg(_line)?)");
    private static final Pattern RGB = Pattern.compile("^#([A-Fa-f0-9]{6})$");
    public static final String STYLE = "style";
    public static final String BACKGROUND_COLOR_PATTERN = "background-color:.*;";

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public void execute(RestApiParam<?> param) {
        String url = param.getRequest().getUrl();
        Matcher matcher = PATTERN.matcher(url);
        if (matcher.find()) {
            String router;
            switch (router = matcher.group(1)) {
                case "create_svg": {
                    this.createSvg(param, false);
                    break;
                }
                case "create_svg_line": {
                    this.createSvg(param, true);
                    break;
                }
                default: {
                    throw new RestApiException("unknown request");
                }
            }
        } else {
            throw new RestApiException("unknown request");
        }
    }

    private void createSvg(RestApiParam<?> param, boolean isLine) {
        String color = StringUtil.cleanXSSContent((String)((String)param.getRequest().getHttpQueryString().get("color")));
        String label = StringUtil.cleanXSSContent((String)((String)param.getRequest().getHttpQueryString().get("svg")));
        String scale = StringUtil.cleanXSSContent((String)((String)param.getRequest().getHttpQueryString().get("scale")));
        Double sc = null;
        if (StringUtil.isNotEmpty((String)scale)) {
            sc = Double.parseDouble(scale);
        }
        ImmutableMap<String, String> map = !isLine ? SvgUtil.getSvgMap() : SvgUtil.getLineSvgMap();
        String svg = (String)map.get((Object)label);
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            int len;
            ColorEnum c = ColorEnum.DEF;
            if (!color.startsWith("#")) {
                c = ColorEnum.find(color);
            }
            if (svg == null || c == null) {
                throw new RestApiException("unknown svg or color");
            }
            if (c != ColorEnum.DEF) {
                color = c.getValue();
            }
            if (!RGB.matcher(color).matches()) {
                throw new RestApiException("invalid color");
            }
            Document document = DocumentHelper.parseText((String)svg);
            Element root = document.getRootElement();
            if (!isLine) {
                this.doAddBackGroundAttribute(color, root);
                this.doAddScaleAttribute(root, 0.6);
                this.doReplaceFillAttribute(root.elementIterator(), "white");
            } else {
                if (sc != null) {
                    this.doAddScaleAttribute(root, sc);
                } else {
                    this.doAddScaleAttribute(root, 0.6);
                }
                this.doReplaceFillAttribute(root.elementIterator(), color);
            }
            String xml = root.asXML();
            in = new ByteArrayInputStream(xml.getBytes());
            out = RestApiContext.getResponse().getOutputStream();
            RestApiContext.getResponse().setContentType("image/svg+xml");
            RestApiContext.getResponse().setHeader("Cache-Control", "public,max-age=2592000");
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                out.flush();
            }
        }
        catch (IOException | DocumentException e) {
            throw new RestApiException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doAddBackGroundAttribute(String c, Element root) {
        Attribute style = root.attribute(STYLE);
        String value = null;
        if (style != null) {
            value = style.getValue();
        }
        if (StringUtil.isEmpty(value)) {
            value = "background-color: " + c + ";";
        } else {
            Pattern pattern;
            Matcher matcher;
            assert (value != null);
            if (!value.endsWith(";")) {
                value = value + ";";
            }
            if ((matcher = (pattern = Pattern.compile(BACKGROUND_COLOR_PATTERN)).matcher(value)).find()) {
                String group = matcher.group();
                value = value.replace(group, "");
            }
            value = value + "background-color: " + c + ";";
        }
        root.setAttributeValue(STYLE, value);
    }

    private void doAddScaleAttribute(Element root, double scale) {
        Attribute style = root.attribute(STYLE);
        String value = null;
        if (style != null) {
            value = style.getValue();
        }
        if (StringUtil.isEmpty(value)) {
            value = "transform:scale(" + scale + ");";
        } else {
            assert (value != null);
            if (!value.endsWith(";")) {
                value = value + ";";
            }
            value = value + "transform:scale(" + scale + ");";
        }
        root.setAttributeValue(STYLE, value);
    }

    private void doReplaceFillAttribute(Iterator<Element> iterator, String color) {
        while (iterator.hasNext()) {
            Element e = iterator.next();
            Attribute fill = e.attribute("fill");
            if (fill != null) {
                fill.setValue(color);
            }
            this.doReplaceFillAttribute(e.elementIterator(), color);
        }
    }
}

