/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.nocode.ext.property.NoCodeGraphicDisplayProp;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;

public class ListCommonConfigQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/list_config/common/query?";
    private static final Pattern PATTERN = Pattern.compile("/list_config/common/query?");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        String appId = (String)param.getRequest().getHttpQueryString().get("appId");
        String formId = (String)param.getRequest().getHttpQueryString().get("formId");
        String share = param.getRequest().getHttpQueryString().getOrDefault("share", "false");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("listFilterConfig", new ArrayList(0));
        resultMap.put("listItemConfig", new ArrayList(0));
        resultMap.put("listTreeConfig", new ArrayList(0));
        if (!FormMetadataUtils.existByFormNumber((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formId))) {
            long endTime = System.currentTimeMillis();
            return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        ArrayList<String> fieldKeys = new ArrayList<String>();
        String displayProperty = (String)param.getRequest().getHttpQueryString().get("displayProperty");
        if (StringUtils.isNotBlank((CharSequence)displayProperty)) {
            String[] fields;
            for (String field : fields = displayProperty.split(",")) {
                fieldKeys.add(field);
            }
        }
        List<Map<String, Object>> filterColumns = ListFilterConfigUtils.getFilterColumns((IDataEntityType)dt, false, fieldKeys);
        List listItemConfig = ListConfigUtils.getListItemConfig((String)formId, (boolean)false, fieldKeys);
        List listTreeConfig = ListConfigUtils.getListTreeConfig((String)formId, (List)listItemConfig, (boolean)"true".equals(share));
        if (!"true".equals(share)) {
            Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formId);
            listItemConfig.removeIf(e -> {
                String field = (String)e.get("number");
                if (field.endsWith("_startdate")) {
                    return hides.contains(field.replace("_startdate", ""));
                }
                if (field.endsWith("_enddate")) {
                    return hides.contains(field.replace("_enddate", ""));
                }
                return hides.contains(field);
            });
            filterColumns.removeIf(e -> {
                String field = (String)e.get("fieldName");
                if (field.endsWith("_startdate")) {
                    return hides.contains(field.replace("_startdate", ""));
                }
                if (field.endsWith("_enddate")) {
                    return hides.contains(field.replace("_enddate", ""));
                }
                return hides.contains(field);
            });
        }
        if (!Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get("fromrefbill")) && Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get("fromdesigner"))) {
            listItemConfig.removeIf(e -> dt.getProperty((String)e.get("number")) instanceof EntryProp);
            listItemConfig.removeIf(e -> dt.getProperty((String)e.get("number")) instanceof NoCodeGraphicDisplayProp);
        }
        resultMap.put("listFilterConfig", filterColumns);
        resultMap.put("listItemConfig", listItemConfig);
        resultMap.put("listTreeConfig", listTreeConfig);
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue(this.getQueryResponse(resultMap), (long)startTime, (long)endTime);
    }

    private RestApiResponse<RestApiQueryResult> getQueryResponse(Map<String, Object> resultMap) {
        RestApiResponse response = new RestApiResponse();
        RestApiQueryResult result = new RestApiQueryResult();
        response.setData((Object)result);
        result.setRows((List)Lists.newArrayList((Object[])new Map[]{resultMap}));
        return response;
    }
}

