/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.cache.NoCodeCacheHelper;
import kd.bos.nocode.cache.NoCodeCacheService;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeBillNoField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreateDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeCreatorField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifierField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeModifyDateField;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.NoCodeEnvironmentEnum;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.service.qing.StatCardRepository;
import kd.bos.nocode.restapi.service.sys.ListStatConfigServiceImpl;
import kd.bos.nocode.restapi.service.sys.SysFilterConfigServiceImpl;
import kd.bos.nocode.restapi.service.sys.repository.ListPageRepository;
import kd.bos.nocode.restapi.service.sys.repository.impl.ListPageRepositoryImpl;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class ListConfigQueryImpl
implements QueryRestApiService {
    private static final Log log = LogFactory.getLog(ListConfigQueryImpl.class);
    private static final String REGEX = "/list_config/query/?";
    private static final String FROM_REF_BILL = "fromrefbill";
    private static final Pattern PATTERN = Pattern.compile("/list_config/query/?");
    private static final String BOS_NOCODE_LIST_CONFIG = "bos_nocode_list_config";
    public static final String NUMBER = "number";
    public static final String INDEX = "index";
    public static final ListSchemaService LIST_SCHEMA_SERVICE = ListSchemaService.create();
    public static final String FORM_ID = "formId";
    public static final String APPID = "appid";
    public static final String FORMID = "formid";
    public static final String ORDER_INFO = "orderInfo";
    public static final String PAGE_SIZE = "pageSize";
    public static final String SCHEMA_ID = "schemaId";
    public static final String FORM_NAME = "formName";
    public static final String FILTER_ROWS = "filterRows";
    public static final String LIST_ITEMS = "listItems";
    public static final String SCHEMA_TYPE = "schematype";
    public static final String GANTT_CONFIG = "ganttconfig";
    public static final String GANTT_TIMEMODE = "timemode";
    public static final String APP_ID = "appId";
    public static final String HIDDEN = "hidden";
    public static final String NAME = "name";
    public static final String CONFIGURED_PAGE_SIZE = "configuredPageSize";
    public static final String CONFIGURED_FILTER_ITEMS = "configuredFilterItems";
    public static final String FILTERS = "filters";
    public static final String LIST_STAT_INFO = "listStatInfo";
    public static final String ORDER_BY = "orderBy";
    public static final String STAT_CARDS = "statCards";
    private static final String DISPLAY = "display";
    private static final String LOCKED = "locked";
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"NoCode-ListConfigQueryImpl-Thread", (int)3, (int)6);
    private final ListPageRepository listPageRepository = new ListPageRepositoryImpl();

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        String schemaIdStr = (String)param.getRequest().getHttpQueryString().get(SCHEMA_ID);
        if (StringUtils.isNotEmpty((CharSequence)schemaIdStr)) {
            long schemaId = Long.parseLong(schemaIdStr);
            return this.getListConfigBySchemaId(schemaId, Boolean.TRUE);
        }
        return this.getListConfigIfNotSchemaId(param);
    }

    @NotNull
    private RestApiServiceData<RestApiQueryResult> getListConfigIfNotSchemaId(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        String appId = (String)param.getRequest().getHttpQueryString().get(APPID);
        if (StringUtil.isEmpty((String)appId)) {
            throw new RestApiException("appid can not be null");
        }
        String formid = (String)param.getRequest().getHttpQueryString().get(FORMID);
        if (StringUtil.isEmpty((String)formid)) {
            throw new RestApiException("formid can not be null");
        }
        if (formid.indexOf(",") > 0) {
            String[] split = formid.split(",");
            formid = split[split.length - 1];
        }
        List listItemConfig = ListConfigUtils.getListItemConfig((String)formid);
        List listTreeConfig = ListConfigUtils.getListTreeConfig((String)formid, (List)listItemConfig, (boolean)false);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put(LIST_STAT_INFO, new ArrayList(0));
        resultMap.put("listFilterConfig", ListFilterConfigUtils.getFilterColumns((IDataEntityType)EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formid))));
        resultMap.put(FILTERS, new ArrayList(0));
        resultMap.put("listItemConfig", listItemConfig);
        resultMap.put("listTreeConfig", listTreeConfig);
        resultMap.put(CONFIGURED_FILTER_ITEMS, new ArrayList(0));
        resultMap.put(FORM_NAME, this.getFormName(formid));
        resultMap.put(FORM_ID, formid);
        resultMap.put(APP_ID, appId);
        resultMap.put(ORDER_INFO, new ArrayList(0));
        resultMap.put(ORDER_BY, "");
        resultMap.put(CONFIGURED_PAGE_SIZE, 20);
        return this.getRestApiServiceData(formid, resultMap, startTime);
    }

    public RestApiServiceData<RestApiQueryResult> getListConfigBySchemaId(long schemaId, boolean active) {
        long startTime = System.currentTimeMillis();
        Optional<DynamicObject> schemaDetailsOp = LIST_SCHEMA_SERVICE.getSchemaDetails(schemaId);
        DynamicObject schemaDetails = schemaDetailsOp.orElseThrow(() -> new RestApiException("\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee"));
        long userId = RequestContext.get().getCurrUserId();
        String formId = schemaDetails.getString(FORM_ID);
        Map<String, Object> resultMap = this.getSchemaConfigFromCache(formId, userId, schemaId);
        if (MapUtils.isEmpty(resultMap)) {
            log.debug("\u5217\u8868\u914d\u7f6e\u672a\u547d\u4e2d\u7f13\u5b58\uff0cschemaId={}", (Object)schemaId);
            resultMap = this.getSchemaConfigFromDb(schemaId, schemaDetails, formId);
            this.saveSchemaConfigToCache(userId, formId, schemaId, resultMap);
        }
        if (active) {
            LIST_SCHEMA_SERVICE.activate(userId, formId, schemaId);
        }
        return this.getRestApiServiceData(formId, resultMap, startTime);
    }

    private RestApiServiceData<RestApiQueryResult> getRestApiServiceData(String formId, Map<String, Object> resultMap, long startTime) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(2);
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formId);
        List listItemConfig = (List)resultMap.get("listItemConfig");
        listItemConfig.removeIf(e -> {
            String field = (String)e.get(NUMBER);
            if (field.endsWith("_startdate")) {
                return hides.contains(field.replace("_startdate", ""));
            }
            if (field.endsWith("_enddate")) {
                return hides.contains(field.replace("_enddate", ""));
            }
            return hides.contains(field);
        });
        List listFilterConfig = (List)resultMap.get("listFilterConfig");
        listFilterConfig.removeIf(e -> {
            String field = (String)e.get("fieldName");
            if (field.endsWith("_startdate")) {
                return hides.contains(field.replace("_startdate", ""));
            }
            if (field.endsWith("_enddate")) {
                return hides.contains(field.replace("_enddate", ""));
            }
            return hides.contains(field);
        });
        resultMap.put("listTreeConfig", ListConfigUtils.getListTreeConfig((String)formId, (List)listItemConfig, (boolean)false));
        resultList.add(resultMap);
        RestApiQueryResult result = new RestApiQueryResult();
        result.setRows(resultList);
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        result.setTotalCount(result.getRows().size());
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)System.currentTimeMillis());
    }

    private Map<String, Object> getSchemaConfigFromDb(long schemaId, DynamicObject schemaDetails, String formId) {
        ConcurrentHashMap<String, Object> resultMap = new ConcurrentHashMap<String, Object>(16);
        String appId = FormMetaUtil.getAppIdByFormId((String)formId);
        this.setBasicInfo(schemaDetails, formId, resultMap, appId);
        String listItems = schemaDetails.getString(LIST_ITEMS);
        CompletableFuture<Void> listItemConfigFuture = this.setListItemConfig(resultMap, formId, listItems, ListSchemaService.create().isDefaultSchema(schemaDetails));
        String filterRows = schemaDetails.getString(FILTER_ROWS);
        CompletableFuture<Void> listFilterConfigFuture = this.setListFilterConfig(resultMap, formId);
        CompletionStage setConfiguredFilterRowsFuture = this.setConfiguredFilterRows(resultMap, filterRows, formId).thenAccept(filterStr -> {
            ListStatConfigServiceImpl.ListStatConfigServiceQueryImpl listStatConfigServiceQuery = new ListStatConfigServiceImpl.ListStatConfigServiceQueryImpl();
            List<Map<String, Object>> statInfo = listStatConfigServiceQuery.getStatInfo(appId, formId, (String)filterStr, "");
            resultMap.put(LIST_STAT_INFO, statInfo);
        });
        String orderInfo = schemaDetails.getString(ORDER_INFO);
        CompletableFuture<Void> setOrderInfoFuture = this.setOrderInfo(resultMap, orderInfo);
        CompletableFuture<Void> setStatCardsFuture = this.setStatCards(resultMap, schemaId);
        CompletableFuture<Void> setBizButtonsFuture = this.setBizButtons(resultMap, formId);
        resultMap.put(SCHEMA_TYPE, schemaDetails.getString(SCHEMA_TYPE));
        String ganttConfigStr = schemaDetails.getString(GANTT_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)ganttConfigStr)) {
            resultMap.put(GANTT_CONFIG, SerializationUtils.fromJsonString((String)ganttConfigStr, ArrayList.class));
        }
        resultMap.put(GANTT_TIMEMODE, schemaDetails.getString(GANTT_TIMEMODE));
        CompletableFuture.allOf(new CompletableFuture[]{listItemConfigFuture, listFilterConfigFuture, setConfiguredFilterRowsFuture, setOrderInfoFuture, setStatCardsFuture, setBizButtonsFuture}).join();
        return resultMap;
    }

    private CompletableFuture<Void> setBizButtons(Map<String, Object> resultMap, String formId) {
        return CompletableFuture.runAsync(() -> {
            List<Map<String, Object>> bizButtons = this.getBizButtons(formId);
            resultMap.put("bizButtons", bizButtons);
        }, es);
    }

    private List<Map<String, Object>> getBizButtons(String formId) {
        List bizButtonsRuntimeMeta = FormMetadataUtils.getBizButtonsRuntimeMeta((String)formId);
        ArrayList<Map<String, Object>> buttonVos = new ArrayList<Map<String, Object>>(bizButtonsRuntimeMeta.size());
        for (NoCodeBizButtonAp bizButton : bizButtonsRuntimeMeta) {
            if (!bizButton.getOperationType().equalsIgnoreCase("1")) continue;
            HashMap<String, Object> buttonVo = new HashMap<String, Object>(3);
            buttonVo.put("key", bizButton.getKey());
            buttonVo.put(NAME, bizButton.getName().toString());
            buttonVo.put("icon", bizButton.getIcon());
            buttonVo.put("secondConfirm", bizButton.isSecondConfirm());
            buttonVo.put("controlLoading", bizButton.isControlLoading());
            buttonVos.add(buttonVo);
        }
        return buttonVos;
    }

    private void setBasicInfo(DynamicObject schemaDetails, String formId, Map<String, Object> resultMap, String appId) {
        int pageSize = schemaDetails.getInt(PAGE_SIZE);
        resultMap.put(FORM_NAME, this.getFormName(formId));
        resultMap.put(FORM_ID, formId);
        resultMap.put(APP_ID, appId);
        resultMap.put(HIDDEN, schemaDetails.getString(HIDDEN));
        resultMap.put(NAME, schemaDetails.getString(NAME));
        resultMap.put(CONFIGURED_PAGE_SIZE, pageSize);
    }

    private void saveSchemaConfigToCache(long userId, String formId, long schemaId, Map<String, Object> resultMap) {
        String listSchemaKey = NoCodeCacheHelper.getCacheKey((String[])new String[]{"list/schema", formId});
        String cacheField = NoCodeCacheHelper.getCacheKey((String[])new String[]{formId, userId + "", schemaId + ""});
        String content = SerializationUtils.toJsonString(resultMap);
        NoCodeCacheService.getInstance().put(listSchemaKey, cacheField, content);
    }

    private Map<String, Object> getSchemaConfigFromCache(String formId, long userId, long schemaId) {
        String listSchemaKey = NoCodeCacheHelper.getCacheKey((String[])new String[]{"list/schema", formId});
        String cacheField = NoCodeCacheHelper.getCacheKey((String[])new String[]{formId, userId + "", schemaId + ""});
        String content = NoCodeCacheService.getInstance().get(listSchemaKey, cacheField);
        if (StringUtils.isBlank((CharSequence)content)) {
            return new HashMap<String, Object>(0);
        }
        log.debug("\u5217\u8868\u914d\u7f6e\u547d\u4e2d\u7f13\u5b58\uff0cschemaId={}", (Object)schemaId);
        Map resultMap = (Map)SerializationUtils.fromJsonString((String)content, Map.class);
        resultMap.put(FORM_NAME, this.getFormName(formId));
        List configuredFilterItems = (List)resultMap.get(CONFIGURED_FILTER_ITEMS);
        ListFilterConfigUtils.clearInvalidFilterRows(formId, configuredFilterItems);
        String filterStr = ListFilterConfigUtils.buildFilter(configuredFilterItems, formId);
        ListStatConfigServiceImpl.ListStatConfigServiceQueryImpl listStatConfigServiceQuery = new ListStatConfigServiceImpl.ListStatConfigServiceQueryImpl();
        List<Map<String, Object>> statInfo = listStatConfigServiceQuery.getStatInfo((String)resultMap.get(APP_ID), formId, filterStr, "");
        resultMap.put(LIST_STAT_INFO, statInfo);
        return resultMap;
    }

    private int getConfiguredPageSize(String appid, String formid, String env, long userid) {
        int configuredPageSize = 20;
        DynamicObject pageObj = this.listPageRepository.getPageObj(appid, formid, userid);
        if (Objects.nonNull(pageObj)) {
            configuredPageSize = pageObj.getInt(PAGE_SIZE);
            return configuredPageSize;
        }
        if (NoCodeEnvironmentEnum.RUNTIME.getCode().equalsIgnoreCase(env) && Objects.nonNull(pageObj = this.listPageRepository.getPageObj(appid, formid, 0L))) {
            configuredPageSize = pageObj.getInt(PAGE_SIZE);
            return configuredPageSize;
        }
        return configuredPageSize;
    }

    private String getFormName(String formId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formId));
        return dt.getDisplayName().getLocaleValue();
    }

    private CompletableFuture<List<Map<String, Object>>> getListStatInfo(RestApiQueryParam param) {
        return CompletableFuture.supplyAsync(() -> {
            ListStatConfigServiceImpl.ListStatConfigServiceQueryImpl listStatConfigServiceQuery = new ListStatConfigServiceImpl.ListStatConfigServiceQueryImpl();
            RestApiServiceData<RestApiQueryResult> queryResult = listStatConfigServiceQuery.execute(param);
            return ((RestApiQueryResult)queryResult.getResponse().getData()).getRows();
        }, es);
    }

    private CompletableFuture<Map<String, Object>> getListFilterConfig(RestApiQueryParam param) {
        return CompletableFuture.supplyAsync(() -> {
            RestApiServiceData<RestApiQueryResult> listFilterServiceData = new SysFilterConfigServiceImpl.SysFilterConfigServiceQueryImpl().execute(param);
            List rows = ((RestApiQueryResult)listFilterServiceData.getResponse().getData()).getRows();
            return (Map)rows.get(0);
        }, es);
    }

    private CompletableFuture<Void> setListItemConfig(Map<String, Object> resultMap, String formId, String configuredListItem, boolean isDefaultSchema) {
        return CompletableFuture.runAsync(() -> {
            List finalListItemConfig;
            List lastListItemConfig = ListConfigUtils.getListItemConfig((String)formId);
            if (StringUtils.isNotEmpty((CharSequence)configuredListItem)) {
                List tempListItemConfig = SerializationUtils.fromJsonStringToList((String)configuredListItem, Map.class);
                Map lastNumber2Obj = lastListItemConfig.stream().collect(Collectors.toMap(e -> (String)e.get(NUMBER), Function.identity()));
                tempListItemConfig.removeIf(e -> !lastNumber2Obj.containsKey((String)e.get(NUMBER)));
                List configuredNumberList = tempListItemConfig.stream().map(e -> (String)e.get(NUMBER)).collect(Collectors.toList());
                lastListItemConfig.stream().filter(e -> !configuredNumberList.contains((String)e.get(NUMBER))).forEach(e -> {
                    if (isDefaultSchema) {
                        tempListItemConfig.add(e);
                    } else {
                        e.put(DISPLAY, Boolean.FALSE);
                        tempListItemConfig.add(e);
                    }
                });
                finalListItemConfig = tempListItemConfig.stream().map(e -> {
                    String number = (String)e.get(NUMBER);
                    Map newListItem = (Map)lastNumber2Obj.get(number);
                    newListItem.put(DISPLAY, e.get(DISPLAY));
                    newListItem.put(LOCKED, e.get(LOCKED));
                    return newListItem;
                }).collect(Collectors.toList());
                LinkedList newListItemConfig = new LinkedList();
                Optional<Map> billNoFieldOp = Optional.empty();
                Optional<Map> creatorFieldOp = Optional.empty();
                Optional<Map> createDateFieldOp = Optional.empty();
                Optional<Map> modifierFieldOp = Optional.empty();
                Optional<Map> modifyDateFieldOp = Optional.empty();
                for (Map listItem : finalListItemConfig) {
                    String type = (String)listItem.get("type");
                    String number = (String)listItem.get(NUMBER);
                    if (NoCodeBillNoField.class.getSimpleName().equalsIgnoreCase(type) && !configuredNumberList.contains(number)) {
                        billNoFieldOp = Optional.of(listItem);
                        continue;
                    }
                    if (NoCodeCreatorField.class.getSimpleName().equalsIgnoreCase(type) && !configuredNumberList.contains(number)) {
                        creatorFieldOp = Optional.of(listItem);
                        continue;
                    }
                    if (NoCodeCreateDateField.class.getSimpleName().equalsIgnoreCase(type) && !configuredNumberList.contains(number)) {
                        createDateFieldOp = Optional.of(listItem);
                        continue;
                    }
                    if (NoCodeModifierField.class.getSimpleName().equalsIgnoreCase(type) && !configuredNumberList.contains(number)) {
                        modifierFieldOp = Optional.of(listItem);
                        continue;
                    }
                    if (NoCodeModifyDateField.class.getSimpleName().equalsIgnoreCase(type) && !configuredNumberList.contains(number)) {
                        modifyDateFieldOp = Optional.of(listItem);
                        continue;
                    }
                    newListItemConfig.add(listItem);
                }
                billNoFieldOp.ifPresent(e -> newListItemConfig.add(0, e));
                creatorFieldOp.ifPresent(newListItemConfig::add);
                createDateFieldOp.ifPresent(newListItemConfig::add);
                modifierFieldOp.ifPresent(newListItemConfig::add);
                modifyDateFieldOp.ifPresent(newListItemConfig::add);
                finalListItemConfig = newListItemConfig;
            } else {
                finalListItemConfig = lastListItemConfig;
            }
            resultMap.put("listItemConfig", finalListItemConfig);
            resultMap.put("listTreeConfig", ListConfigUtils.getListTreeConfig((String)formId, (List)finalListItemConfig, (boolean)false));
        }, es);
    }

    private CompletableFuture<Void> setListFilterConfig(Map<String, Object> resultMap, String formId) {
        return CompletableFuture.runAsync(() -> {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formId));
            List<Map<String, Object>> filterColumns = ListFilterConfigUtils.getFilterColumns((IDataEntityType)dataEntityType);
            resultMap.put("listFilterConfig", filterColumns);
        }, es);
    }

    private CompletableFuture<String> setConfiguredFilterRows(Map<String, Object> resultMap, String filterRows, String formId) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Map<String, Object>> configuredFilterItems = StringUtils.isNotEmpty((CharSequence)filterRows) ? SerializationUtils.fromJsonStringToList((String)filterRows, Map.class) : new ArrayList<Map<String, Object>>(0);
            ListFilterConfigUtils.clearInvalidFilterRows(formId, configuredFilterItems);
            resultMap.put(CONFIGURED_FILTER_ITEMS, configuredFilterItems);
            return ListFilterConfigUtils.buildFilter(configuredFilterItems, formId);
        }, es);
    }

    private void updateRefBillMainDisplayProp(String formId, List<Map<String, Object>> configuredFilterItems) {
        try {
            Map fields = EntityMetadataCache.getDataEntityType((String)formId).getFields();
            for (Map<String, Object> configuredFilterItem : configuredFilterItems) {
                String fieldName = (String)configuredFilterItem.get("fieldName");
                String compareType = (String)configuredFilterItem.get("compareType");
                if (!"1201".equalsIgnoreCase(compareType)) continue;
                List value = (List)configuredFilterItem.get("value");
                INoCodeRefBillProp property = (INoCodeRefBillProp)fields.get(fieldName);
                String billEntityId = property.getBillEntityId();
                List fieldValueList = value.stream().map(e -> (String)e.get("fieldValue")).filter(StringUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toList());
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)billEntityId, (String)property.getMainDisplayProperty(), (QFilter[])new QFilter("id", "in", fieldValueList).toArray());
                Map<Long, String> id2MainDisplayProperty = Arrays.stream(ids).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.get(property.getMainDisplayProperty()).toString()));
                value.forEach(e -> {
                    String fieldValue = (String)e.get("fieldValue");
                    String label = (String)id2MainDisplayProperty.get(Long.parseLong(fieldValue));
                    e.put("label", label);
                });
            }
        }
        catch (Exception e2) {
            log.debug("\u66f4\u65b0\u5173\u8054\u8868\u5355\u663e\u793a\u540d\u79f0\u5931\u8d25");
        }
    }

    private CompletableFuture<Void> setOrderInfo(Map<String, Object> resultMap, String orderInfo) {
        return CompletableFuture.runAsync(() -> {
            ArrayList orderInfoList = StringUtils.isNotEmpty((CharSequence)orderInfo) ? SerializationUtils.fromJsonStringToList((String)orderInfo, Map.class) : new ArrayList(0);
            resultMap.put(ORDER_INFO, orderInfoList);
            resultMap.put(ORDER_BY, ListConfigUtils.buildOrderInfo(orderInfoList));
        }, es);
    }

    private CompletableFuture<Void> setStatCards(Map<String, Object> resultMap, long schemaId) {
        return CompletableFuture.runAsync(() -> resultMap.put(STAT_CARDS, StatCardRepository.create().getStatCards(schemaId)), es);
    }
}

