/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ListConfigSaveImpl
implements SaveRestApiService {
    private static final String REGEX = "/list_config/?";
    private static final Pattern PATTERN = Pattern.compile("/list_config/?");
    private static final String BOS_NOCODE_LIST_CONFIG = "bos_nocode_list_config";
    private static final Log logger = LogFactory.getLog(ListConfigSaveImpl.class);
    private static final String USERID = "userid";

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
        String action;
        switch (action = this.getAction(param)) {
            case "save": {
                return this.save(param);
            }
            case "delete": {
                return this.delete(param);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData<RestApiSaveResult> delete(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        for (Map data : param.getDataList()) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            String appid = (String)data.get("appid");
            if (StringUtil.isEmpty((String)appid)) {
                throw new RestApiException("appid can not be null");
            }
            String formid = (String)data.get("formid");
            if (StringUtil.isEmpty((String)formid)) {
                throw new RestApiException("formid can not be null");
            }
            NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.view, (String)formid);
            QFilter filter1 = new QFilter("appid", "=", (Object)appid);
            filters.add(filter1);
            QFilter filter2 = new QFilter("formid", "=", (Object)formid);
            filters.add(filter2);
            String env = (String)param.getRequest().getHttpQueryString().get("env");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)env), (Object)ResManager.loadKDString((String)"env\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListConfigSaveImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            long userid = ListConfigUtils.getDBUserIdByEnv((String)env);
            filters.add(new QFilter(USERID, "=", (Object)userid));
            DeleteServiceHelper.delete((String)BOS_NOCODE_LIST_CONFIG, (QFilter[])filters.toArray(new QFilter[0]));
        }
        return RestApiServiceData.ofTrue(null, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiSaveResult> save(RestApiSaveParam param) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        long start = System.currentTimeMillis();
        for (Map data : param.getDataList()) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            String appid = (String)data.get("appid");
            if (StringUtil.isEmpty((String)appid)) {
                throw new RestApiException("appid can not be null");
            }
            String formid = (String)data.get("formid");
            if (StringUtil.isEmpty((String)formid)) {
                throw new RestApiException("formid can not be null");
            }
            NoCodePermHelper.verifyFuncPermPassTemp((FuncPermItemEnum)FuncPermItemEnum.view, (String)appid, (String)formid);
            QFilter filter1 = new QFilter("appid", "=", (Object)appid);
            filters.add(filter1);
            QFilter filter2 = new QFilter("formid", "=", (Object)formid);
            filters.add(filter2);
            String env = (String)param.getRequest().getHttpQueryString().get("env");
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)env), (Object)ResManager.loadKDString((String)"env\u4e0d\u80fd\u4e3a\u7a7a", (String)"ListConfigSaveImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            long userid = ListConfigUtils.getDBUserIdByEnv((String)env);
            filters.add(new QFilter(USERID, "=", (Object)userid));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BOS_NOCODE_LIST_CONFIG, (String)"appid,formid,userid,config", (QFilter[])filters.toArray(new QFilter[0]));
            if (dynamicObject == null) {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_NOCODE_LIST_CONFIG);
                dynamicObject.set("appid", (Object)appid);
                dynamicObject.set("formid", (Object)formid);
                dynamicObject.set(USERID, (Object)userid);
            }
            dynamicObject.set("config", (Object)"");
            list.add(dynamicObject);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.debug("save failed,data list :{}", (Object)param.getDataList());
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode(), (String)e.getMessage(), (RestApiResponse)new RestApiResponse(), (long)(System.currentTimeMillis() - start));
        }
        return RestApiServiceData.ofTrue((RestApiResponse)new RestApiResponse(), (long)start, (long)System.currentTimeMillis());
    }

    private String getAction(RestApiSaveParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split(REGEX);
        if (split.length < 2) {
            throw new RestApiException("unknown request");
        }
        return split[1];
    }
}

