/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeGraphicDisplayProp;
import kd.bos.nocode.ext.property.NoCodeRichTextProp;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiQuerySingleResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.ExportHelper;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.vo.ExportConfig;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.PermItemEnum;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.ArrayUtils;

public class ListExportServiceImpl
implements SaveRestApiService {
    private static final String REGEX = "/export/?";
    private static final Pattern PATTERN = Pattern.compile("/export/?");
    private static final String ALGO_PREFIX = "nocode.export.";
    private static final String ALGO_CHECK_PREFIX = "nocode.export.check.";
    private static final int EXPORT_MAX_COUNT = 10000000;
    private static final String FORM_RECORD = "bos_nocode_export_record";
    private static final String TASK_ID = "taskId";
    private static final String STATUS = "status";
    public static final ListSchemaService LIST_SCHEMA_SERVICE = ListSchemaService.create();

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    private String getAction(RestApiSaveParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split(REGEX);
        String action = "";
        if (split.length > 1) {
            action = split[1];
        }
        return action;
    }

    public RestApiServiceData execute(RestApiSaveParam param) {
        String action;
        switch (action = this.getAction(param)) {
            case "progress": {
                return this.queryProgress(param);
            }
            case "download": {
                return this.download(param);
            }
            case "cancel": {
                return this.cancel(param);
            }
            case "cols": {
                return this.listCols(param);
            }
            case "": {
                return this.submit(param);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData<RestApiQuerySingleResult> download(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map p = (Map)param.getDataList().get(0);
        String taskId = (String)p.get(TASK_ID);
        DynamicObject dao = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)FORM_RECORD);
        if (dao == null) {
            throw new RestApiException("unknown task");
        }
        int status = dao.getInt(STATUS);
        if (ExportHelper.TaskStatus.find(status) != ExportHelper.TaskStatus.finished) {
            String s = "";
            for (IDataEntityProperty property : dao.getDataEntityType().getProperties()) {
                if (!property.getName().equals(STATUS)) continue;
                ComboProp prop = (ComboProp)property;
                s = prop.getItemByName(dao.getString(STATUS));
                break;
            }
            throw new RestApiException("invalid task status:" + s);
        }
        String urls = dao.getString("urls");
        RestApiResponse response = new RestApiResponse();
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        HashMap row = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        JSONArray parse = JSON.parseArray((String)urls);
        for (int i = 0; i < parse.size(); ++i) {
            String path = parse.getString(i);
            list.add(UrlService.getAttachmentFullUrl((String)path));
        }
        row.put("urls", list);
        result.setRow(row);
        result.setTotalCount(1);
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private void preCheck(RestApiSaveParam param) {
        Map p = (Map)param.getDataList().get(0);
        String formid = (String)p.get("formid");
        param.setFormId(formid);
        param.getRequest().setFormId(formid);
        Pair<Boolean, QFilter[]> qFilters = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        int count = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(ALGO_CHECK_PREFIX + formid), (String)formid, (String)"id", (QFilter[])((QFilter[])qFilters.getValue()), null);){
            count = dataSet.count("id", false);
        }
        if (count > 10000000) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u91cf\u8d85\u9650,\u5f53\u524d\u5bfc\u51fa\u6570\u636e\u91cf\u4e0a\u9650:%s", (String)"ListExportServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[]{10000000}));
        }
        String[] keys = new String[]{};
        try {
            if (p.containsKey("selects")) {
                String selects = (String)p.get("selects");
                keys = selects.split(",");
            }
        }
        catch (Exception e) {
            throw new RestApiException((Throwable)e);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formid);
        Map fields = dataEntityType.getAllFields();
        if (keys.length > 0) {
            for (String key : keys) {
                IDataEntityProperty property = (IDataEntityProperty)fields.get(key);
                if (property == null) {
                    throw new RestApiException("unknown property:" + key);
                }
                if (this.canExport(property, param)) continue;
                throw new RestApiException("unsupported export property:" + key);
            }
        }
    }

    private boolean canExport(IDataEntityProperty property, RestApiSaveParam param) {
        if (this.isAttachmentExport(param)) {
            return property instanceof NoCodeAttachmentProp;
        }
        return !(property instanceof NoCodeAttachmentProp) && !(property instanceof PictureProp) && !(property instanceof NoCodeRichTextProp) && !(property instanceof NoCodeGraphicDisplayProp) && !(property instanceof EntryProp);
    }

    private RestApiServiceData listCols(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map p = (Map)param.getDataList().get(0);
        String formid = (String)p.get("formid");
        String appId = MetadataDao.getAppNumberByEntityNumber((String)formid);
        NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.export, (String)formid);
        Map fields = ListConfigUtils.getDirectFields((String)formid);
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)formid);
        for (Object field : hides) {
            fields.remove(field);
        }
        ArrayList<Map> rows = new ArrayList<Map>();
        for (Map.Entry entry : fields.entrySet()) {
            Map row = Maps.of((Object)"key", entry.getKey(), (Object)"name", (Object)((IDataEntityProperty)entry.getValue()).getDisplayName().getLocaleValue());
            boolean canExport = this.canExport((IDataEntityProperty)entry.getValue(), param);
            row.put("canExport", canExport);
            if (!canExport) {
                row.put("reason", ResManager.loadKDString((String)"\u6b64\u8868\u5355\u5185\u5bb9\u7684\u7c7b\u578b\u4e0d\u652f\u6301\u5bfc\u51fa", (String)"ListExportServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            rows.add(row);
        }
        RestApiResponse response = new RestApiResponse();
        RestApiQueryResult restApiQueryResult = new RestApiQueryResult();
        restApiQueryResult.setRows(rows);
        restApiQueryResult.setTotalCount(rows.size());
        response.setData((Object)restApiQueryResult);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiQuerySingleResult> submit(RestApiSaveParam param) {
        this.preCheck(param);
        boolean attachmentExport = this.isAttachmentExport(param);
        long start = System.currentTimeMillis();
        Map p = (Map)param.getDataList().get(0);
        String formid = (String)p.get("formid");
        String schemaId = (String)p.get("schemaId");
        if (attachmentExport) {
            boolean hasExportPerm = NoCodePermHelper.checkFuncPerm((FuncPermItemEnum)FuncPermItemEnum.export, (String)formid);
            if (!hasExportPerm) {
                RestApiResponse response = new RestApiResponse();
                RestApiQuerySingleResult result = new RestApiQuerySingleResult();
                HashMap<String, Boolean> row = new HashMap<String, Boolean>();
                row.put("noExportPerm", true);
                result.setRow(row);
                response.setData((Object)result);
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
            }
        } else {
            NoCodePermHelper.verifyFuncPerm((FuncPermItemEnum)FuncPermItemEnum.export, (String)formid);
        }
        param.setFormId(formid);
        param.getRequest().setFormId(formid);
        Pair<Boolean, QFilter[]> qFilters = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param);
        String[] keys = new String[]{};
        StringBuilder selectFields = new StringBuilder("id");
        try {
            if (p.containsKey("selects")) {
                String selects = (String)p.get("selects");
                keys = selects.split(",");
                if (attachmentExport) {
                    for (String key : keys) {
                        selectFields.append(",").append(key).append(".fbasedataid as ").append(key);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RestApiException((Throwable)e);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formid);
        ExportConfig config = new ExportConfig(dataEntityType, formid);
        if (keys.length > 0) {
            config.setColSeq(Arrays.asList(keys));
        }
        config.setAttachmentExport(this.isAttachmentExport(param));
        String orderBy = (String)p.get("order_by");
        if (StringUtils.isEmpty((CharSequence)orderBy)) {
            orderBy = "id";
        }
        ExportHelper exporter = new ExportHelper();
        String finalOrderBy = orderBy;
        Object[] filters = (QFilter[])qFilters.getValue();
        long uid = RequestContext.get().getCurrUserId();
        QFilter filter = NoCodePermissionServiceHelper.getDataRuleFilter((long)uid, (String)formid, (PermItemEnum)PermItemEnum.VIEW);
        filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])new QFilter[]{filter});
        if (StringUtils.isNotEmpty((CharSequence)schemaId)) {
            Object[] schemaFilters = ListSchemaService.create().getSchemaFilters(Long.parseLong(schemaId));
            filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])schemaFilters);
        }
        Object[] finalFilters = filters;
        String finalSelectFields = selectFields.toString();
        exporter.setDataSetBuilder(() -> ListExportServiceImpl.lambda$submit$0(formid, finalSelectFields, (QFilter[])finalFilters, finalOrderBy));
        String taskId = exporter.submit(config);
        RestApiResponse response = new RestApiResponse();
        HashMap<String, String> row = new HashMap<String, String>();
        row.put(TASK_ID, taskId);
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        result.setRow(row);
        result.setTotalCount(1);
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiQuerySingleResult> queryProgress(RestApiSaveParam param) {
        int s;
        ExportHelper.TaskStatus status;
        long start = System.currentTimeMillis();
        Map p = (Map)param.getDataList().get(0);
        String taskId = (String)p.get(TASK_ID);
        boolean exists = QueryServiceHelper.exists((String)FORM_RECORD, (Object)taskId);
        if (!exists) {
            throw new RestApiException("unknown task");
        }
        DynamicObject r = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)FORM_RECORD);
        double data = ExportHelper.getProgress(taskId);
        if (data == 0.0 && (status = ExportHelper.TaskStatus.find(s = r.getInt(STATUS))) == ExportHelper.TaskStatus.finished) {
            data = 1.0;
        }
        RestApiResponse response = new RestApiResponse();
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("progress", data > 0.0 ? Double.valueOf(data *= 100.0) : null);
        row.put(STATUS, r.getString(STATUS));
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        result.setRow(row);
        result.setTotalCount(1);
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private RestApiServiceData<RestApiQuerySingleResult> cancel(RestApiSaveParam param) {
        long start = System.currentTimeMillis();
        Map p = (Map)param.getDataList().get(0);
        String taskId = (String)p.get(TASK_ID);
        boolean canceled = ExportHelper.cancel(taskId);
        RestApiResponse response = new RestApiResponse();
        HashMap<String, Boolean> row = new HashMap<String, Boolean>();
        row.put("canceled", canceled);
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        result.setRow(row);
        result.setTotalCount(1);
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)System.currentTimeMillis());
    }

    private boolean isAttachmentExport(RestApiSaveParam param) {
        return Boolean.parseBoolean(param.getRequest().getHttpQueryString().getOrDefault("att", "false"));
    }

    private static /* synthetic */ DataSet lambda$submit$0(String formid, String finalSelectFields, QFilter[] finalFilters, String finalOrderBy) {
        return QueryServiceHelper.queryDataSet((String)(ALGO_PREFIX + formid), (String)formid, (String)finalSelectFields, (QFilter[])finalFilters, (String)finalOrderBy);
    }
}

