/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.MyApiUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.ShareInputMode;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessModel;

public class PermissionQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/perm(/.*)?$";
    private static final Pattern PATTERN = Pattern.compile("/perm(/.*)?$");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    private String getRouter(RestApiQueryParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split("/perm");
        if (split.length < 2) {
            return "";
        }
        String ret = split[1];
        if (ret.contains("/")) {
            return ret.substring(ret.indexOf(47) + 1);
        }
        return ret;
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        String router;
        switch (router = this.getRouter(param)) {
            case "": 
            case "func": {
                return this.getFuncPermItems(param);
            }
            case "manage": {
                return this.getManagePerm(param);
            }
            case "forms": {
                return this.getForms(param);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData<RestApiQueryResult> getForms(RestApiQueryParam param) {
        String appid = (String)param.getRequest().getHttpQueryString().get("appid");
        List menuInfos = FormMetaUtil.getValidMenusByAppId((String)appid);
        List rows = menuInfos.stream().filter(menu -> kd.bos.util.StringUtils.isNotEmpty((String)menu.getFormId())).map(menu -> Maps.of((Object)"formId", (Object)menu.getFormId(), (Object)"name", (Object)menu.getName().toString(), (Object)"type", (Object)menu.getMenuType())).collect(Collectors.toList());
        Map appliedAppPerm = NoCodePermissionServiceHelper.getAppliedAppPerm(Collections.singletonList(appid));
        Set formids = appliedAppPerm.getOrDefault(appid, Collections.emptySet());
        for (String formid : formids) {
            String name = this.getFormName(formid);
            rows.add(Maps.of((Object)"formId", (Object)formid, (Object)"name", (Object)name));
        }
        RestApiQueryResult result = new RestApiQueryResult();
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        result.setRows(rows);
        result.setPageNo(param.getPage_no());
        result.setPageSize(param.getPage_size());
        result.setTotalCount(rows.size());
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
    }

    private String getFormName(String formId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        return dt.getDisplayName().getLocaleValue();
    }

    private RestApiServiceData<RestApiQueryResult> getFuncPermItems(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        String formId = (String)param.getRequest().getHttpQueryString().get("formid");
        String appId = (String)param.getRequest().getHttpQueryString().get("appid");
        String pkid = (String)param.getRequest().getHttpQueryString().get("pkid");
        if (kd.bos.util.StringUtils.isEmpty((String)formId) || kd.bos.util.StringUtils.isEmpty((String)appId)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528id\u6216\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a", (String)"PermissionQueryImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean share = NoCodePermHelper.isShare((String)appId, (String)formId, (String)param.getShareId());
        if (NoCodeTemplateUtil.queryTemplateAppIds().contains(appId)) {
            for (FuncPermItemEnum item : FuncPermItemEnum.values()) {
                ret.put(item.getNumber(), true);
            }
        } else {
            NoCodePermHelper.queryFuncPermItems((String)formId, ret);
            if (share) {
                if (NoCodePermHelper.isViewShare((String)param.getShareId())) {
                    ret.put(FuncPermItemEnum.view.getNumber(), true);
                }
                if (NoCodePermHelper.isAddShare((String)param.getShareId())) {
                    if (!((Boolean)ret.getOrDefault(FuncPermItemEnum.input.getNumber(), false)).booleanValue()) {
                        ret.put("add_fixed", true);
                    }
                    ret.put(FuncPermItemEnum.input.getNumber(), true);
                    ret.put(FuncPermItemEnum.view.getNumber(), true);
                    ShareInputMode mode = NoCodePermHelper.getAddShareMode((String)param.getShareId());
                    if (mode == ShareInputMode.INPUT_EDIT) {
                        ret.put(FuncPermItemEnum.edit.getNumber(), true);
                    }
                }
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)pkid) && !share) {
            Map perms = NoCodePermHelper.checkAllDataPermInNoCode((String)formId, (Object)Long.parseLong(pkid));
            boolean view = perms.getOrDefault(FuncPermItemEnum.view.getId(), false);
            if (!view) {
                for (FuncPermItemEnum item : FuncPermItemEnum.values()) {
                    ret.put(item.getNumber(), false);
                }
            } else {
                if (!perms.getOrDefault(FuncPermItemEnum.edit.getId(), false).booleanValue()) {
                    ret.put(FuncPermItemEnum.edit.getNumber(), false);
                }
                if (!perms.getOrDefault(FuncPermItemEnum.delete.getId(), false).booleanValue()) {
                    ret.put(FuncPermItemEnum.delete.getNumber(), false);
                }
            }
        }
        this.passWf(param, ret);
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue(this.getQueryResponse(ret), (long)startTime, (long)endTime);
    }

    private void passWf(RestApiQueryParam param, HashMap<String, Object> ret) {
        NoCodeWfNodeUserInput node;
        String userTaskActivityId = (String)param.getRequest().getHttpQueryString().get("userTaskActivityId");
        String procInstId = (String)param.getRequest().getHttpQueryString().get("procInstId");
        if (kd.bos.util.StringUtils.isNotEmpty((String)userTaskActivityId) && kd.bos.util.StringUtils.isNotEmpty((String)procInstId) && (node = this.getUserTaskActivityNode(userTaskActivityId, procInstId)) != null) {
            long uid = RequestContext.get().getCurrUserId();
            String user = String.valueOf(uid);
            for (String person : node.getInputUser().getPerson()) {
                if (!person.equals(user)) continue;
                for (FuncPermItemEnum item : FuncPermItemEnum.values()) {
                    ret.put(item.getNumber(), true);
                }
            }
        }
    }

    private RestApiServiceData<RestApiQueryResult> getManagePerm(RestApiQueryParam param) {
        long startTime = System.currentTimeMillis();
        String appId = (String)param.getRequest().getHttpQueryString().get("appid");
        if (kd.bos.util.StringUtils.isEmpty((String)appId)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a", (String)"PermissionQueryImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (NoCodeTemplateUtil.queryTemplateAppIds().contains(appId)) {
            ret.put("manage", false);
            ret.put("use", true);
        } else {
            Map map = NoCodePermHelper.queryManagePerm((String)appId);
            ret.putAll(map);
        }
        ret.put("apiEnabled", MyApiUtil.isEnableMyApi());
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue(this.getQueryResponse(ret), (long)startTime, (long)endTime);
    }

    private RestApiResponse<RestApiQueryResult> getQueryResponse(Map<String, Object> resultMap) {
        RestApiResponse response = new RestApiResponse();
        RestApiQueryResult result = new RestApiQueryResult();
        response.setData((Object)result);
        result.setRows((List)Lists.newArrayList((Object[])new Map[]{resultMap}));
        return response;
    }

    private NoCodeWfNodeUserInput getUserTaskActivityNode(String userTaskActivityId, String procInstId) {
        if (StringUtils.isBlank((CharSequence)procInstId)) {
            throw new KDBizException("need procInstId param");
        }
        long lProcInstId = Long.parseLong(procInstId);
        ProcessModel procModel = new ProcessModel();
        ProcessDefinitionInfo procDefInfo = NoCodeWorkflowServiceHelper.getProcessDefinitionInfoByProcInstId((Long)lProcInstId);
        String entityId = procDefInfo.getEntityId();
        procModel.setEntityId(entityId);
        String appIdByFormId = FormMetaUtil.getAppIdByFormId((String)entityId);
        procModel.setAppId(appIdByFormId);
        procModel.setData(procDefInfo.getData());
        if (StringUtils.isBlank((CharSequence)procModel.getData())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578b\u5931\u8d25\uff1a", (String)"PermissionQueryImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]) + procDefInfo.getId());
        }
        Map loadModel = (Map)SerializationUtils.fromJsonString((String)procModel.getData(), Map.class);
        NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)loadModel, null);
        NoCodeWfNodeUserInput node = noCodeWfMetaData.getNodes().stream().filter(NoCodeWfNodeUserInput.class::isInstance).map(NoCodeWfNodeUserInput.class::cast).filter(u -> u.getId().equalsIgnoreCase(userTaskActivityId)).findFirst().orElse(null);
        return node;
    }
}

