/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.FieldTreeBuilder;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodeTreeNode;

public class RefBillQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/refbill(/.*)?$";
    private static final Pattern PATTERN = Pattern.compile("/refbill(/.*)?$");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    private String getRouter(RestApiQueryParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split("/refbill");
        if (split.length < 2) {
            return "";
        }
        String ret = split[1];
        if (ret.contains("/")) {
            return ret.substring(ret.indexOf(47) + 1);
        }
        return ret;
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        RestApiServiceData<RestApiQueryResult> result;
        String router;
        switch (router = this.getRouter(param)) {
            case "tree": {
                result = this.getRefBillTree(param);
                break;
            }
            case "display_prop": {
                result = this.getDisplayProp(param);
                break;
            }
            default: {
                throw new RestApiException("unknown request");
            }
        }
        return result;
    }

    private RestApiServiceData<RestApiQueryResult> getDisplayProp(RestApiQueryParam param) {
        Instant startTime = Instant.now();
        String formId = (String)param.getRequest().getHttpQueryString().get("formId");
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(formId);
        List showColumns = fieldTreeBuilder.withoutFieldTypes(new FieldTreeBuilder.FieldType[]{FieldTreeBuilder.FieldType.NoCodeRichTextField, FieldTreeBuilder.FieldType.NoCodeGraphicDisplayField, FieldTreeBuilder.FieldType.NoCodeAttachmentUploadField, FieldTreeBuilder.FieldType.NoCodeImageUploadField, FieldTreeBuilder.FieldType.NoCodeBillNoField, FieldTreeBuilder.FieldType.NoCodeCreateDateField, FieldTreeBuilder.FieldType.NoCodeModifierField, FieldTreeBuilder.FieldType.EntryField}).build();
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("displayProps", showColumns);
        Instant endTime = Instant.now();
        return RestApiServiceData.ofTrue(this.getQueryResponse(ret), (long)Duration.between(startTime, endTime).toMillis());
    }

    private RestApiServiceData<RestApiQueryResult> getRefBillTree(RestApiQueryParam param) {
        Instant startTime = Instant.now();
        String appId = (String)param.getRequest().getHttpQueryString().get("appId");
        NoCodeTreeNode treeData = NcEntityTypeUtil.buildRefBillTreeData((String)appId, null, (String)"true");
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("treeData", treeData);
        Instant endTime = Instant.now();
        return RestApiServiceData.ofTrue(this.getQueryResponse(ret), (long)Duration.between(startTime, endTime).toMillis());
    }

    private RestApiResponse<RestApiQueryResult> getQueryResponse(Map<String, Object> resultMap) {
        RestApiResponse response = new RestApiResponse();
        RestApiQueryResult result = new RestApiQueryResult();
        response.setData((Object)result);
        result.setRows((List)Lists.newArrayList((Object[])new Map[]{resultMap}));
        return response;
    }
}

