/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ShareServiceQueryImpl
implements QueryRestApiService {
    private static final Log log = LogFactory.getLog(ShareServiceQueryImpl.class);
    private static final String REGEX = "/share/list/(\\d+)/?";
    private static final Pattern PATTERN = Pattern.compile("/share/list/(\\d+)/?");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        String url = param.getRequest().getFullRequestUrl();
        Matcher matcher = PATTERN.matcher(url);
        if (!matcher.find()) {
            throw new RestApiException("unknown request");
        }
        String appid = matcher.group(1);
        return this.list(appid, param);
    }

    private RestApiServiceData<RestApiQueryResult> list(String appid, RestApiQueryParam param) {
        int totalCount;
        long start = System.currentTimeMillis();
        String select1 = "title,image,icon,creator,shareid,url,createdatefield";
        QFilter f1 = new QFilter("appid", "=", (Object)appid);
        int pageIndex = param.getPage_no();
        DynamicObject[] shares = new DynamicObject[]{};
        if (pageIndex == 0) {
            BusinessDataServiceHelper.load((String)"bos_nocode_share", (String)select1, (QFilter[])new QFilter[]{f1}, (String)"createdatefield desc");
        } else {
            shares = BusinessDataServiceHelper.load((String)"bos_nocode_share", (String)select1, (QFilter[])new QFilter[]{f1}, (String)"createdatefield desc", (int)(pageIndex - 1), (int)param.getPage_size());
        }
        Set ids = Arrays.stream(shares).map(s -> s.getLong("shareid")).collect(Collectors.toSet());
        QFilter f2 = new QFilter("id", "in", ids);
        String select2 = "url,expiretime,state";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_svc_share", (String)select2, (QFilter[])new QFilter[]{f2}, null);
        Map<String, DynamicObject> map = Arrays.stream(load).collect(Collectors.toMap(d -> d.getString("id"), d -> d));
        RestApiQueryResult result = new RestApiQueryResult();
        ArrayList rows = new ArrayList(8);
        result.setRows(rows);
        for (DynamicObject share : shares) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("title", share.getString("title"));
            row.put("icon", share.getString("icon"));
            row.put("bgImage", share.getString("image"));
            DynamicObject creator = share.getDynamicObject("creator");
            row.put("creator", creator.getString("name"));
            row.put("shareTime", share.get("createdatefield"));
            row.put("id", share.get("id"));
            String shareid = share.getString("shareid");
            DynamicObject s2 = map.get(shareid);
            boolean valid = false;
            if (s2 != null) {
                row.put("url", share.getString("url"));
                Date expiretime = s2.getDate("expiretime");
                row.put("expireTime", expiretime);
                String state = s2.getString("state");
                int compare = expiretime.compareTo(new Date());
                valid = "0".equals(state) && compare > 0;
            }
            row.put("valid", valid);
            rows.add(row);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_nocode_share", (String)"id", (QFilter[])new QFilter[]{f1}, null);){
            totalCount = dataSet.count("id", true);
        }
        result.setTotalCount(totalCount);
        result.setPageNo(pageIndex);
        int pageSize = param.getPage_size();
        int totalPage = (totalCount - 1) / pageSize + 1;
        result.setPageSize(pageSize);
        result.setLastPage(Boolean.valueOf(pageIndex >= totalPage));
        long end = System.currentTimeMillis();
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)end);
    }
}

