/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQuerySingleResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.share.NoCodeShare;
import kd.bos.share.service.NoCodeShareSerivce;

public class ShareServiceSaveImpl
implements SaveRestApiService {
    private static final Log logger = LogFactory.getLog(ShareServiceSaveImpl.class);
    private static final String REGEX = "/share/(save|revoke)(/(\\d+))?";
    private static final Pattern PATTERN = Pattern.compile("/share/(save|revoke)(/(\\d+))?");
    private static final long DEFAULT_INVALID_TIME = 86400000L;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData execute(RestApiSaveParam param) {
        String url = param.getRequest().getFullRequestUrl();
        Matcher matcher = PATTERN.matcher(url);
        String action = null;
        if (matcher.find()) {
            action = matcher.group(1);
        }
        assert (action != null);
        switch (action) {
            case "save": {
                return this.save(param);
            }
            case "revoke": {
                String id = matcher.group(3);
                return this.revoke(id);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData revoke(String id) {
        long start = System.currentTimeMillis();
        if (StringUtil.isEmpty((String)id)) {
            throw new RestApiException("invalid id");
        }
        DynamicObject share = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_nocode_share");
        if (share == null) {
            throw new RestApiException("invalid record");
        }
        Long shareid = share.getLong("shareid");
        DynamicObject r = BusinessDataServiceHelper.loadSingle((Object)shareid, (String)"bos_svc_share");
        r.set("expiretime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{r});
        return RestApiServiceData.ofTrue((RestApiResponse)new RestApiResponse(), (long)(System.currentTimeMillis() - start));
    }

    private RestApiServiceData<RestApiQuerySingleResult> save(RestApiSaveParam param) {
        RestApiResponse response = new RestApiResponse();
        String url = (String)((Map)param.getRequest().getData()).get("url");
        String time = (String)((Map)param.getRequest().getData()).get("validTime");
        String appId = (String)((Map)param.getRequest().getData()).get("appId");
        String formId = (String)((Map)param.getRequest().getData()).get("formId");
        String type = (String)((Map)param.getRequest().getData()).get("type");
        String mode = (String)((Map)param.getRequest().getData()).get("inputMode");
        if (StringUtil.isEmpty((String)url)) {
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)"url can not be null", (RestApiResponse)response, (long)0L);
        }
        long validTime = 0L;
        try {
            if (!StringUtil.isEmpty((String)time)) {
                validTime = Long.parseLong(new String(Base64.getDecoder().decode(time)));
            }
        }
        catch (Exception e) {
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.DATA_INVALID.getStatusCode(), (String)e.getMessage(), (RestApiResponse)response, (long)0L);
        }
        if (validTime == 0L) {
            validTime = 86400000L;
        }
        NoCodeShare config = new NoCodeShare();
        long start = System.currentTimeMillis();
        config.setShareTime(Long.valueOf(start));
        config.setExpireTime(Long.valueOf(start + validTime));
        config.setUrl(url);
        JSONObject context = new JSONObject();
        context.put("appId", (Object)appId);
        context.put("formId", (Object)formId);
        context.put("type", (Object)type);
        context.put("inputMode", (Object)mode);
        config.setContext(context.toJSONString());
        String share = new NoCodeShareSerivce().share(config);
        String title = (String)((Map)param.getRequest().getData()).get("title");
        String image = (String)((Map)param.getRequest().getData()).get("bgImage");
        String icon = (String)((Map)param.getRequest().getData()).get("icon");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_share");
        dy.set("title", (Object)title);
        dy.set("image", (Object)image);
        dy.set("icon", (Object)icon);
        dy.set("appid", (Object)appId);
        dy.set("shareid", (Object)share.substring(share.indexOf("/share/") + "/share/".length()).split("_")[0]);
        dy.set("creator", (Object)RequestContext.get().getCurrUserId());
        dy.set("url", (Object)share);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("url", share);
        Date date = new Date(start + validTime);
        row.put("validTime", FORMAT.format(date));
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        result.setRow(row);
        result.setTotalCount(1);
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(System.currentTimeMillis() - start));
    }
}

