/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.nocode.enums.ColorEnum;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQuerySingleResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.service.util.SvgUtil;
import kd.bos.nocode.restapi.vo.Icon;

public class SvgServiceQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/svgs/?";
    private static final Pattern PATTERN = Pattern.compile("/svgs/?");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData execute(RestApiQueryParam param) {
        String router;
        switch (router = this.getIconRouter(param)) {
            case "": {
                return this.listSvg(false);
            }
            case "line": {
                return this.listSvg(true);
            }
        }
        throw new RestApiException("unknown request");
    }

    private String getIconRouter(RestApiQueryParam param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split(REGEX);
        if (split.length < 2) {
            return "";
        }
        String ret = split[1];
        if (ret.contains("/")) {
            return ret.substring(ret.indexOf(47));
        }
        return ret;
    }

    private RestApiServiceData<RestApiQuerySingleResult> listSvg(boolean isLine) {
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        long start = System.currentTimeMillis();
        HashMap<String, List<Object>> row = new HashMap<String, List<Object>>();
        ArrayList<Icon> svgs = new ArrayList<Icon>();
        ImmutableMap<String, String> map = !isLine ? SvgUtil.getSvgMap() : SvgUtil.getLineSvgMap();
        for (Map.Entry entry : map.entrySet()) {
            svgs.add(new Icon((String)entry.getKey(), (String)entry.getValue()));
        }
        row.put("svgs", svgs);
        List colors = Arrays.stream(ColorEnum.values()).filter(c -> c != ColorEnum.DEF).map(c -> Maps.of((Object)"key", (Object)c.getKey(), (Object)"value", (Object)c.getValue())).collect(Collectors.toList());
        row.put("colors", colors);
        result.setRow(row);
        result.setTotalCount(1);
        long end = System.currentTimeMillis();
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)end);
    }
}

