/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiQuerySingleResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.TemplateEnabledUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.Role;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TemplateInfoServiceQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/template/(trades_domains|comment|view|enableTemplate)(/(\\d+))?";
    private static final Pattern PATTERN = Pattern.compile("/template/(trades_domains|comment|view|enableTemplate)(/(\\d+))?");
    private static final String BOS_NOCODE_TPL_COMMENT = "bos_nocode_tpl_comment";
    private static final Log log = LogFactory.getLog(TemplateInfoServiceQueryImpl.class);

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData execute(RestApiQueryParam param) {
        String url = param.getRequest().getFullRequestUrl();
        Matcher matcher = PATTERN.matcher(url);
        String action = null;
        if (matcher.find()) {
            action = matcher.group(1);
        }
        assert (action != null);
        switch (action) {
            case "trades_domains": {
                return TemplateInfoServiceQueryImpl.getExtraData();
            }
            case "comment": {
                String id = matcher.group(3);
                return this.getComment(Long.parseLong(id), param);
            }
            case "view": {
                String id = matcher.group(3);
                return this.getView(Long.parseLong(id), param);
            }
            case "enableTemplate": {
                String enableTemplate = "1".equals(matcher.group(3)) ? "true" : "false";
                return this.enableTemplate(enableTemplate);
            }
        }
        throw new RestApiException("unknown request");
    }

    private RestApiServiceData enableTemplate(String enableTemplate) {
        long start = System.currentTimeMillis();
        TemplateEnabledUtil.setEnableTemplate((String)enableTemplate);
        RestApiResponse response = new RestApiResponse();
        RestApiQueryResult result = new RestApiQueryResult();
        response.setData((Object)result);
        long end = System.currentTimeMillis();
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)end);
    }

    private RestApiServiceData getView(long id, RestApiQueryParam param) {
        long start = System.currentTimeMillis();
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_nocode_templateconfig");
        if (template == null) {
            throw new RestApiException("unknown template");
        }
        boolean canViewAdd = true;
        if (param.getRequest().getHttpQueryString().containsKey("view") && "false".equals(param.getRequest().getHttpQueryString().get("view"))) {
            canViewAdd = false;
        }
        if (canViewAdd) {
            try {
                String sql = "update t_nocode_template_config set fview = fview + 1 where fid = ?";
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{id});
            }
            catch (Exception e) {
                log.debug("\u6a21\u677f\u67e5\u6b21\u6570\u589e\u52a0\u5931\u8d25:" + e.getMessage());
            }
        }
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        QFilter filter = new QFilter("templateid", "=", (Object)id);
        double score = 0.0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"tpl_comment", (String)BOS_NOCODE_TPL_COMMENT, (String)"score,templateid", (QFilter[])new QFilter[]{filter}, (String)"createdate desc");
             DataSet finish = dataSet.groupBy(new String[]{"templateid"}).avg("score").finish();){
            if (!finish.isEmpty()) {
                Iterator iterator = finish.iterator();
                Row row = (Row)iterator.next();
                score = row.getDouble("score");
            }
        }
        HashMap<String, Object> row = new HashMap<String, Object>();
        String appid = template.getString("appid");
        row.put("forms", this.getForms(appid));
        row.put("roles", this.getRoles(appid));
        row.put("flows", this.getFlows(appid));
        row.put("avg", (double)Math.round(score * 100.0) / 100.0);
        if (canViewAdd) {
            row.put("view", template.getInt("view") + 1);
        } else {
            row.put("view", template.getInt("view"));
        }
        result.setRow(row);
        result.setTotalCount(1);
        long end = System.currentTimeMillis();
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)end);
    }

    private List<String> getFlows(String appid) {
        List templates = NoCodeWorkflowServiceHelper.getProcessTemplatesByAppId((String)appid);
        return templates.stream().map(t -> t.getName().getLocaleValue()).collect(Collectors.toList());
    }

    private List<String> getRoles(String appid) {
        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
        return roles.stream().sorted(Comparator.comparingInt(Role::getSortCode)).map(r -> NoCodePermHelper.getRoleName((String)r.getName())).collect(Collectors.toList());
    }

    private RestApiServiceData getComment(long id, RestApiQueryParam param) {
        long start = System.currentTimeMillis();
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bos_nocode_templateconfig");
        if (template == null) {
            throw new RestApiException("unknown template");
        }
        RestApiQueryResult result = new RestApiQueryResult();
        ArrayList rows = new ArrayList();
        QFilter filter = new QFilter("templateid", "=", (Object)id);
        String select = "uid,score,comment,createdate";
        int pageIndex = param.getPage_no();
        DynamicObject[] comments = pageIndex == 0 ? BusinessDataServiceHelper.load((String)BOS_NOCODE_TPL_COMMENT, (String)select, (QFilter[])new QFilter[]{filter}, (String)"createdate desc") : BusinessDataServiceHelper.load((String)BOS_NOCODE_TPL_COMMENT, (String)select, (QFilter[])new QFilter[]{filter}, (String)"createdate desc", (int)(pageIndex - 1), (int)param.getPage_size());
        for (DynamicObject comment : comments) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            rows.add(row);
            for (String key : select.split(",")) {
                row.put(key, comment.get(key));
            }
            DynamicObject user = comment.getDynamicObject("uid");
            String name = user.getString("name");
            long userId = user.getLong("id");
            Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)false);
            String imgURL = (String)userAvatarPathMap.get(userId);
            String avatar = StringUtils.isEmpty((String)imgURL) ? "/images/pc/emotion/default_person_82_82.png" : this.getFullImageUrl(imgURL);
            HashMap<String, String> uid = new HashMap<String, String>();
            uid.put("name", name);
            uid.put("avatar", avatar);
            row.put("uid", uid);
        }
        int count = ORM.create().count("tpl_comment_count", BOS_NOCODE_TPL_COMMENT, new QFilter[]{filter});
        result.setRows(rows);
        result.setTotalCount(count);
        result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= count));
        result.setPageSize(param.getPage_size());
        result.setPageNo(param.getPage_no());
        long end = System.currentTimeMillis();
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)end);
    }

    private List<Map<String, Object>> getForms(String appid) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appid);
        return appMetadata.getAppMenus().stream().filter(menu -> !"bas_appstarted".equalsIgnoreCase(menu.getFormNumber())).filter(menu -> StringUtils.isNotEmpty((String)menu.getFormId())).map(menu -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Object icon = this.getParameterImage((AppMenuElement)menu);
            map.put("icon", icon == null ? "" : icon);
            map.put("name", menu.getName().toString());
            return map;
        }).collect(Collectors.toList());
    }

    private Object getParameterImage(AppMenuElement menu) {
        String parameter = menu.getParameter();
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
        Object image = paramMap.get("image");
        return Objects.isNull(image) ? "" : image;
    }

    private String getFullImageUrl(String avatarPath) {
        if (!(avatarPath.toLowerCase(Locale.ENGLISH).startsWith("http") || "/icons/pc/other/superAdministrators_38_38.png".equals(avatarPath) || "/private/universe_ad.png".equals(avatarPath) || "/private/super_ad.png".equals(avatarPath) || "/private/audit_ad.png".equals(avatarPath) || "/private/safe_ad.png".equals(avatarPath))) {
            avatarPath = UrlService.getCheckAuthImageUrl((String)avatarPath);
        }
        return avatarPath;
    }

    @NotNull
    private static RestApiServiceData<RestApiQueryResult> getExtraData() {
        long start = System.currentTimeMillis();
        DynamicObject[] domains = BusinessDataServiceHelper.load((String)"bos_nocode_tdomains", (String)"id,name", (QFilter[])new QFilter[0]);
        ArrayList dl = new ArrayList(domains.length);
        for (DynamicObject domain : domains) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", domain.get("id"));
            map.put("name", domain.get("name"));
            dl.add(map);
        }
        DynamicObject[] trades = BusinessDataServiceHelper.load((String)"bos_nocode_ttrades", (String)"id,name", (QFilter[])new QFilter[0]);
        ArrayList tl = new ArrayList(domains.length);
        for (DynamicObject trade : trades) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("id", trade.get("id"));
            map.put("name", trade.get("name"));
            tl.add(map);
        }
        RestApiQueryResult result = new RestApiQueryResult();
        ArrayList rows = new ArrayList();
        HashMap map = new HashMap();
        map.put("domains", dl);
        rows.add(map);
        map = new HashMap();
        map.put("trades", tl);
        rows.add(map);
        result.setRows(rows);
        result.setTotalCount(2);
        long end = System.currentTimeMillis();
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)start, (long)end);
    }
}

