/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TemplateInfoServiceSaveImpl
implements SaveRestApiService {
    private static final String REGEX = "/template/comment/?";
    private static final Pattern PATTERN = Pattern.compile("/template/comment/?");
    private static final String BOS_NOCODE_TPL_COMMENT = "bos_nocode_tpl_comment";
    private static final Log logger = LogFactory.getLog(TemplateInfoServiceSaveImpl.class);

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        long start = System.currentTimeMillis();
        for (Map data : param.getDataList()) {
            String templateid = (String)data.get("templateid");
            if (StringUtil.isEmpty((String)templateid)) {
                throw new RestApiException("templateid can not be null");
            }
            String comment = (String)data.get("comment");
            String score = (String)data.get("score");
            int sc = Integer.parseInt(score);
            if (sc < 0 || sc > 5) {
                throw new RestApiException("invalid score");
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_NOCODE_TPL_COMMENT);
            dynamicObject.set("templateid", (Object)Long.parseLong(templateid));
            dynamicObject.set("comment", (Object)comment);
            dynamicObject.set("score", (Object)sc);
            dynamicObject.set("createdate", (Object)new Date());
            dynamicObject.set("uid", (Object)RequestContext.get().getCurrUserId());
            list.add(dynamicObject);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            logger.debug("save failed,data list :{}", (Object)param.getDataList());
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.HTTP_INTERNAL_ERROR.getStatusCode(), (String)e.getMessage(), (RestApiResponse)new RestApiResponse(), (long)(System.currentTimeMillis() - start));
        }
        return RestApiServiceData.ofTrue((RestApiResponse)new RestApiResponse(), (long)start, (long)System.currentTimeMillis());
    }
}

