/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQuerySingleResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class ThemeServiceSaveImpl
implements SaveRestApiService {
    private static final Log logger = LogFactory.getLog(ThemeServiceSaveImpl.class);
    private static final String REGEX = "/theme/?";
    private static final Pattern PATTERN = Pattern.compile("/theme/?");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData execute(RestApiSaveParam param) {
        RestApiResponse response = new RestApiResponse();
        long start = System.currentTimeMillis();
        NoCodePermHelper.verifyPlatManage();
        Map config = (Map)param.getRequest().getData();
        String name = (String)config.get("platformName");
        if (StringUtils.isNotEmpty((String)name) && name.length() > 12) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5e73\u53f0\u540d\u79f0\u4e0d\u5408\u6cd5", (String)"ThemeServiceSaveImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        String json = JSONObject.toJSONString((Object)config);
        long uid = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("uid", "=", (Object)uid);
        DynamicObject info = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_theme_config", (QFilter[])new QFilter[]{filter});
        if (info == null) {
            info = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_theme_config");
        }
        info.set("uid", (Object)uid);
        info.set("config", (Object)json);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        RestApiQuerySingleResult result = new RestApiQuerySingleResult();
        result.setTotalCount(1);
        response.setData((Object)result);
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(System.currentTimeMillis() - start));
    }
}

