/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.MultiLangEnumBridge;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.utils.NoCodeOrgServiceHelper;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.TemplateEnabledUtil;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;

public class UserServiceQueryImpl
implements QueryRestApiService {
    private static final String REGEX = "/user(/.*)?$";
    private static final Pattern PATTERN = Pattern.compile("/user(/.*)?$");
    private static final String BOS_USER = "bos_user";
    private static final String UID = "id";
    private static final Log log = LogFactory.getLog(UserServiceQueryImpl.class);
    private final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMdd");

    public boolean match(String path) {
        return PATTERN.matcher(path).find();
    }

    public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
        param.setFormId(BOS_USER);
        param.getRequest().setFormId(BOS_USER);
        String router = this.getRouter((RestApiParam)param);
        String selectFields = "id, number, name, gender, birthday, phone, email, ispartjob, dpt, position, isincharge, entryentity";
        QFilter[] filters = this.getFilters(param, selectFields);
        long startTime = System.currentTimeMillis();
        filters = this.recursiveDeptFilter(param, filters);
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        dynamicObjects = param.getPage_no() == 0 ? BusinessDataServiceHelper.load((String)BOS_USER, (String)selectFields, (QFilter[])filters, (String)param.getOrder_by()) : BusinessDataServiceHelper.load((String)BOS_USER, (String)selectFields, (QFilter[])filters, (String)param.getOrder_by(), (int)(param.getPage_no() - 1), (int)param.getPage_size());
        List formattedRows = PropertyHandleUtil.toMapListRootByColumn((String)BOS_USER, (String)"$", (DynamicObject[])dynamicObjects, (Set)Sets.newHashSet((Object[])new String[]{UID, "name", "number", "gender", "phone", "email"}));
        Map id2FormattedRow = formattedRows.stream().collect(Collectors.toMap(e -> e.get(UID), Function.identity()));
        ArrayList resultList = new ArrayList(dynamicObjects.length);
        List userIds = Arrays.stream(dynamicObjects).map(e -> e.getLong(UID)).collect(Collectors.toList());
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(userIds, (boolean)false);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object id = dynamicObject.get(UID);
            Map formattedRow = (Map)id2FormattedRow.get(id);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("number", formattedRow.get("number"));
            ret.put(UID, id);
            ret.put("name", formattedRow.get("name"));
            long userId = dynamicObject.getLong(UID);
            String imgURL = (String)userAvatarPathMap.get(userId);
            String avatar = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)imgURL) ? "/images/pc/emotion/default_person_82_82.png" : this.getFullImageUrl(imgURL);
            ret.put("avatar", avatar);
            ret.put("gender", formattedRow.get("gender"));
            ret.put("birthday", "");
            if (dynamicObject.getDate("birthday") != null) {
                ret.put("birthday", this.FORMAT.format(dynamicObject.getDate("birthday")));
            }
            ret.put("phone", formattedRow.get("phone"));
            ret.put("email", formattedRow.get("email"));
            TreeMap orgs = new TreeMap();
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryentity) {
                Optional<DynamicObject> dptOp = Optional.ofNullable(object.getDynamicObject("dpt"));
                dptOp.ifPresent(dpt -> {
                    HashMap<String, Object> org = new HashMap<String, Object>();
                    org.put("orgNum", dpt.get("number"));
                    org.put("orgName", dpt.getString("name"));
                    org.put("isIncharge", object.get("isincharge"));
                    orgs.put(dpt.getString("number"), org);
                });
            }
            ret.put("orgs", orgs.values());
            resultList.add(ret);
            if (!"me".equalsIgnoreCase(router)) continue;
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter filter = new QFilter("uid", "=", (Object)currUserId);
            DynamicObject theme = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_nocode_theme_config", (QFilter[])new QFilter[]{filter});
            if (theme != null) {
                String config = theme.getString("config");
                JSONObject jsonObject = JSON.parseObject((String)config);
                ret.put("themeInfo", jsonObject);
            }
            boolean admin = NoCodePermHelper.checkUserPlatManageInNoCode();
            ret.put("isAdminUser", admin);
            ret.put("createApp", admin || NoCodePermHelper.checkUserAppCreateInNoCode());
            ret.put("templateEnabled", TemplateEnabledUtil.isEnableTemplate());
        }
        RestApiQueryResult result = new RestApiQueryResult();
        result.setRows(resultList);
        if ("me".equalsIgnoreCase(router)) {
            result.getExtra().put("attachmentUrl", UrlService.getAttachmentPrefixUrl());
            result.getExtra().put("imageUrl", UrlService.getImageFullUrl((String)""));
            result.getExtra().put("maxAttachmentUploadSize", FileServiceFactory.getAttachmentFileService().getMaxUploadSize());
            result.getExtra().put("maxImageUploadSize", FileServiceFactory.getImageFileService().getMaxUploadSize());
        } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)param.getRequest().getHttpQueryString().get("deptId")))) {
            result.getExtra().put("managers", this.getManger(filters));
        } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)param.getRequest().getHttpQueryString().get("deptId")))) {
            result.getExtra().put("managers", this.getMangerByDeptId((String)param.getRequest().getHttpQueryString().get("deptId")));
        }
        try {
            int totalCount;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)BOS_USER, (String)UID, (QFilter[])filters, null);){
                totalCount = dataSet.count(UID, true);
            }
            result.setTotalCount(totalCount);
            result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size() || param.getPage_no() * param.getPage_size() >= totalCount));
        }
        catch (Exception e2) {
            result.setLastPage(Boolean.valueOf(result.getRows().size() < param.getPage_size()));
            log.debug("\u67e5\u8be2\u603b\u6570\u62a5\u9519", (Object)new RestApiException((Throwable)e2));
        }
        result.setPageNo(param.getPage_no());
        result.setPageSize(param.getPage_size());
        RestApiResponse response = new RestApiResponse();
        response.setData((Object)result);
        long endTime = System.currentTimeMillis();
        return RestApiServiceData.ofTrue((RestApiResponse)response, (long)startTime, (long)endTime);
    }

    private List<Map<String, Object>> getMangerByDeptId(String deptId) {
        if ("noOrg".equals(deptId) || "externalUserType".equals(deptId)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return this.getManagerByOrgId(Long.parseLong(deptId));
    }

    private static boolean fromAdminOrg(RestApiQueryParam param) {
        return Objects.equals(param.getRequest().getHttpQueryString().get("source"), "bos_adminorg");
    }

    private List<Map<String, Object>> getManger(QFilter[] filters) {
        String orgNumber = Arrays.stream(filters).filter(e -> e.getProperty().equalsIgnoreCase("entryentity.dpt.number") && Objects.nonNull(e.getValue())).map(e -> (String)e.getValue()).findFirst().orElse("");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)orgNumber)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        long orgId = NoCodeOrgServiceHelper.getOrgIdByOrgNumber((String)orgNumber);
        return this.getManagerByOrgId(orgId);
    }

    private List<Map<String, Object>> getManagerByOrgId(long orgId) {
        if (orgId == -1L) {
            return Lists.newArrayList();
        }
        List managersOfOrg = UserServiceHelper.getManagersOfOrg((long)orgId);
        List userInfos = UserServiceHelper.get((List)managersOfOrg, (String[])new String[]{UID, "name", "enable"}, null);
        if (CollectionUtils.isEmpty((Collection)userInfos)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return userInfos.stream().filter(e -> "1".equalsIgnoreCase((String)e.get("enable"))).map(e -> {
            Object id = e.get(UID);
            ILocaleString name = (ILocaleString)e.get("name");
            HashMap map = new HashMap(2);
            map.put(UID, id);
            map.put("name", Objects.isNull(name) ? "" : name.getLocaleValue());
            return map;
        }).collect(Collectors.toList());
    }

    private QFilter[] recursiveDeptFilter(RestApiQueryParam param, QFilter[] filters) {
        String deptId = (String)param.getRequest().getHttpQueryString().get("deptId");
        ArrayList filterList = Lists.newArrayList((Object[])filters);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)deptId)) {
            if (String.valueOf(OrgUnitServiceHelper.getRootOrgId()).equals(deptId)) {
                return filters;
            }
            if ("noOrg".equalsIgnoreCase(deptId)) {
                List userTypeIds = UserUtils.getUserTypeByCategory((String)"1");
                QFilter userTypesFilter = UserUtils.getUserTypesLikeFilter((List)userTypeIds);
                filterList.add(QFilter.isNull((String)"entryentity.dpt").and(userTypesFilter));
            } else if (deptId.startsWith("externalUserType")) {
                if ("externalUserType".equals(deptId)) {
                    List userTypeIds = UserUtils.getUserTypeByCategory((String)"2");
                    filterList.add(UserUtils.getUserTypesLikeFilter((List)userTypeIds));
                } else {
                    String userTypeId = StringUtils.substringAfterLast((String)deptId, (String)"externalUserType");
                    if (StringUtils.isNotBlank((CharSequence)userTypeId)) {
                        ArrayList<Long> userTypeIds = new ArrayList<Long>(1);
                        userTypeIds.add(Long.valueOf(userTypeId));
                        filterList.add(UserUtils.getUserTypesLikeFilter(userTypeIds));
                    } else {
                        filterList.add(UserUtils.getUserTypesLikeFilter(new ArrayList()));
                    }
                }
            } else {
                ArrayList orgIds = Lists.newArrayList((Object[])new Long[]{Long.parseLong(deptId)});
                List allSubordinateOrgs = OrgViewUtils.getSubOrgIdIncludeGrand((String)"01", (List)orgIds, (boolean)true, null);
                log.debug("\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u4e0b\u6240\u6709\u7684\u5b50\u7ec4\u7ec7\uff1a{}", (Object)allSubordinateOrgs);
                QFilter filter = new QFilter("entryentity.dpt", "in", (Object)allSubordinateOrgs);
                filterList.add(filter);
            }
        }
        return filterList.toArray(new QFilter[0]);
    }

    private <T> String getRouter(RestApiParam<T> param) {
        String url = param.getRequest().getUrl();
        String[] split = url.split("/user");
        if (split.length < 2) {
            return "";
        }
        String ret = split[1];
        if (ret.contains("/")) {
            return ret.substring(ret.indexOf(47) + 1);
        }
        return ret;
    }

    private QFilter[] getFilters(RestApiQueryParam param, String selectFields) {
        Long uid = RequestContext.get().getCurrUserId();
        String router = this.getRouter((RestApiParam)param);
        if ("me".equalsIgnoreCase(router)) {
            return new QFilter[]{new QFilter(UID, "=", (Object)uid)};
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)router)) {
            HashSet selectFieldSet = Arrays.stream(selectFields.split(",")).map(String::trim).collect(Collectors.toSet());
            HashSet searchFields = UserServiceQueryImpl.fromAdminOrg(param) ? Sets.newHashSet((Object[])new String[]{"number", "name"}) : selectFieldSet;
            Pair<Boolean, QFilter[]> qFilterPair = FilterUtil.getQFilters((RestApiParam<Map<String, Object>>)param, searchFields);
            QFilter[] filters = (QFilter[])qFilterPair.getValue();
            return (QFilter[])Arrays.stream(filters).filter(Objects::nonNull).map(e -> {
                if (!"entryentity.dpt.number".equalsIgnoreCase(e.getProperty())) {
                    return e;
                }
                String orgId = (String)e.getValue();
                if ("noOrg".equalsIgnoreCase(orgId)) {
                    List userTypeIds = UserUtils.getUserTypeByCategory((String)"1");
                    QFilter userTypesFilter = UserUtils.getUserTypesLikeFilter((List)userTypeIds);
                    return QFilter.isNull((String)"entryentity.dpt").and(userTypesFilter);
                }
                if (orgId.startsWith("externalUserType")) {
                    if ("externalUserType".equals(orgId)) {
                        return UserUtils.getUserTypesLikeFilter(new ArrayList());
                    }
                    String userTypeId = StringUtils.substringAfterLast((String)orgId, (String)"externalUserType");
                    if (StringUtils.isNotBlank((CharSequence)userTypeId)) {
                        ArrayList<Long> userTypeIds = new ArrayList<Long>(1);
                        userTypeIds.add(Long.valueOf(userTypeId));
                        return UserUtils.getUserTypesLikeFilter(userTypeIds);
                    }
                    return UserUtils.getUserTypesLikeFilter(new ArrayList());
                }
                return e;
            }).filter(Objects::nonNull).toArray(QFilter[]::new);
        }
        if (router.matches("\\d+")) {
            return new QFilter[]{new QFilter(UID, "=", (Object)Long.parseLong(router))};
        }
        throw new RestApiException("unknown request");
    }

    String getFullImageUrl(String avatarPath) {
        if (!(avatarPath.toLowerCase(Locale.ENGLISH).startsWith("http") || "/icons/pc/other/superAdministrators_38_38.png".equals(avatarPath) || "/private/universe_ad.png".equals(avatarPath) || "/private/super_ad.png".equals(avatarPath) || "/private/audit_ad.png".equals(avatarPath) || "/private/safe_ad.png".equals(avatarPath))) {
            avatarPath = UrlService.getCheckAuthImageUrl((String)avatarPath);
        }
        return avatarPath;
    }

    static enum Gender {
        Male("1", new MultiLangEnumBridge("\u7537", "UserServiceQueryImpl_0", "bos-nocode-service"), "%E7%94%B7"),
        Female("2", new MultiLangEnumBridge("\u5973", "UserServiceQueryImpl_1", "bos-nocode-service"), "%E5%A5%B3"),
        Unknown("0", new MultiLangEnumBridge("\u4fdd\u5bc6", "UserServiceQueryImpl_2", "bos-nocode-service"), "%E4%BF%9D%E5%AF%86");

        final String key;
        final MultiLangEnumBridge value;
        final String encodeName;

        private Gender(String key, MultiLangEnumBridge value, String encodeName) {
            this.key = key;
            this.value = value;
            this.encodeName = encodeName;
        }

        public static Gender find(String key) {
            for (Gender value : Gender.values()) {
                if (!value.key.equals(key)) continue;
                return value;
            }
            return Unknown;
        }
    }
}

