/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bes.mq.org.apache.commons.codec.digest.DigestUtils;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.eye.api.flamegraphs.profiler.utils.IOUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.deploy.DeployAppMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeImageProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.cache.RestApiServiceLocalCache;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.constant.CardTypeEnum;
import kd.bos.nocode.restapi.core.util.DynamicObjectUtil;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.qing.QingProxyService;
import kd.bos.nocode.restapi.service.statistics.UserBehaviorStatHelper;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.restapi.servlet.context.RestApiContext;
import kd.bos.nocode.util.NoCodeTemplateUtil;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.DevUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcAppVersionUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.AppManageTypeEnum;
import kd.bos.permission.nocode.model.AppUseTypeEnum;
import kd.bos.permission.nocode.model.DataRule;
import kd.bos.permission.nocode.model.DataRuleTypeEnum;
import kd.bos.permission.nocode.model.EntityPerm;
import kd.bos.permission.nocode.model.PermItem;
import kd.bos.permission.nocode.model.PermResult;
import kd.bos.permission.nocode.model.Role;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileUtils;
import kd.bos.workflow.api.model.ProcessModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AppServiceHelper {
    private static final Log log = LogFactory.getLog(AppServiceHelper.class);
    private static final String PROP_BIZCLOUD = "bizcloud";
    private static final String PROP_ID = "id";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_VISIBLE = "visible";
    private static final String COLLECT = "collect";
    private static final String PROP_BIZAPPID = "bizappid";
    private static final String TYPE = "_Type_";
    private static final String PROP_BIZAPP = "bizapp";
    private static final String TEMPLATE = "istemplate";
    private static final String MANAGE = "manage";
    private static final String SHORTCUT_USER = "user";
    private static final String SHORTCUT_BIZAPP = "bizapp";
    private static final String SHORTCUT_BIZPAGE = "bizpage";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String USED_COUNT = "usedCount";
    public static final String CREATE_DATE = "createdate";
    private static final String FORM_IDS = "formIds";
    private static final String IERP_UID = "13466739";
    private static final QingProxyService QING_PROXY_SERVICE = QingProxyService.create();
    private static final WfProcessDataService WF_PROCESS_DATA_SERVICE = WfProcessDataService.create();
    private static final String WF_MODELS = "wfModels";
    private static final String MODEL_ID = "modelId";
    private static final String LINE_DELIMITER = "#{delimiter}";
    private static final String ORDER_BY_CREORATEDATE_DESC = "createdate desc";
    public static final String VAR_QINGCARDID_PATTERN = "\"cardId\":\"(.+?)\",";
    public static final Pattern varQingCardIdPattern = Pattern.compile("\"cardId\":\"(.+?)\",");
    public static final String VAR_RULEID_PATTERN = "IF NOT EXISTS \\(SELECT 1 FROM t_nocode_ruleconfig WHERE FId = (.+?)\\)";
    public static final Pattern varRuleIdPattern = Pattern.compile("IF NOT EXISTS \\(SELECT 1 FROM t_nocode_ruleconfig WHERE FId = (.+?)\\)");
    public static final String VAR_ASSOID_PATTERN = "IF NOT EXISTS \\(SELECT 1 FROM t_nocode_association WHERE FId = (.+?)\\)";
    public static final Pattern varAssoIdPattern = Pattern.compile("IF NOT EXISTS \\(SELECT 1 FROM t_nocode_association WHERE FId = (.+?)\\)");
    public static final String VAR_CARDCONTAINERID_PATTERN = "IF NOT EXISTS \\(SELECT 1 FROM t_nocode_cardcontainer WHERE FId = (.+?)\\)";
    public static final Pattern varCardContainerIdPattern = Pattern.compile("IF NOT EXISTS \\(SELECT 1 FROM t_nocode_cardcontainer WHERE FId = (.+?)\\)");
    public static final String VAR_CARDID_PATTERN = "IF NOT EXISTS \\(SELECT 1 FROM t_nocode_card WHERE FId = (.+?)\\)";
    public static final Pattern varCardIdPattern = Pattern.compile("IF NOT EXISTS \\(SELECT 1 FROM t_nocode_card WHERE FId = (.+?)\\)");

    private AppServiceHelper() {
    }

    public static List<Map<String, Object>> getAppInfoList(List<QFilter> filters, String selectProperties, String orderBy, boolean isDyObjResult, int pageIndex, int pageSize) {
        return AppServiceHelper.getAppInfoList(filters, selectProperties, orderBy, isDyObjResult, pageIndex, pageSize, false);
    }

    public static List<Map<String, Object>> getAppInfoList(List<QFilter> filters, String selectProperties, String orderBy, boolean isDyObjResult, int pageIndex, int pageSize, boolean containsTemplate) {
        filters.add(new QFilter(PROP_BIZCLOUD, "=", (Object)RestApiServiceLocalCache.getNoCodeCloudId()));
        filters.add(new QFilter(PROP_NUMBER, "!=", (Object)"nocode_fromtemplate_app"));
        Optional<QFilter> specify = filters.stream().filter(qFilter -> qFilter.getProperty().equals(PROP_ID) && qFilter.getCP().equals("=")).findFirst();
        if (!specify.isPresent()) {
            if (!containsTemplate) {
                filters.add(new QFilter(PROP_ID, "not in", (Object)NoCodeTemplateUtil.queryTemplateAppIds()));
                filters.add(new QFilter(PROP_VISIBLE, "=", (Object)true));
            }
            Set ids = NoCodePermissionServiceHelper.getUsableAppIds((long)RequestContext.get().getCurrUserId());
            filters.add(new QFilter(PROP_ID, "in", (Object)ids));
        }
        if (kd.bos.util.StringUtils.isEmpty((String)selectProperties)) {
            selectProperties = "id,number,name,image,visible,version,description,deploystatus,creater,createdate,modifier,modifydate,alluserapp";
        }
        if (kd.bos.util.StringUtils.isBlank((String)orderBy)) {
            orderBy = ORDER_BY_CREORATEDATE_DESC;
        }
        String[] splitFields = selectProperties.split(",");
        HashSet selectSet = new HashSet(splitFields.length);
        Collections.addAll(selectSet, splitFields);
        QFilter[] filterArray = filters.toArray(new QFilter[0]);
        long startTime = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = pageIndex == -1 ? BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selectProperties, (QFilter[])filterArray, (String)orderBy) : BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selectProperties, (QFilter[])filterArray, (String)orderBy, (int)pageIndex, (int)pageSize);
        long endTime = System.currentTimeMillis();
        log.debug("nocode AppServiceQueryImpl execute load data:" + (endTime - startTime));
        List<Map<String, Object>> rows = isDyObjResult ? DynamicObjectUtil.serializeToMap((DynamicObject[])dynamicObjects, (DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"bos_devportal_bizapp", selectSet)) : PropertyHandleUtil.toMapListRoot((String)"bos_devportal_bizapp", (String)"$", (DynamicObject[])dynamicObjects, selectSet);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        AppServiceHelper.addExtraField(rows);
        return rows;
    }

    public static List<Map<String, Object>> getAppInfoList(List<QFilter> filters) {
        return AppServiceHelper.getAppInfoList(filters, "", "", false, -1, 0);
    }

    private static void addExtraField(List<Map<String, Object>> rows) {
        long uid = RequestContext.get().getCurrUserId();
        List<String> collectIds = AppServiceHelper.getCollectedAppIdList(uid);
        Set templates = NoCodeTemplateUtil.queryTemplateAppIds();
        Set manage = NoCodePermissionServiceHelper.getManageAppIds((long)uid);
        for (Map<String, Object> row : rows) {
            row.put(COLLECT, collectIds.contains(String.valueOf(row.get(PROP_ID))));
            row.put(TEMPLATE, templates.contains(String.valueOf(row.get(PROP_ID))));
            row.put(MANAGE, manage.contains(String.valueOf(row.get(PROP_ID))));
        }
    }

    public static List<String> getCollectedAppIdList(long userId) {
        DynamicObject[] dynamicObjects;
        ArrayList<String> bizAppIds = new ArrayList<String>(10);
        QFilter userFilter = new QFilter(SHORTCUT_USER, "=", (Object)userId);
        QFilter bizPageFilter = new QFilter(SHORTCUT_BIZPAGE, "=", (Object)" ");
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_SHORTCUT, (String)"bizapp", (QFilter[])userFilter.and(bizPageFilter).toArray())) {
            DynamicObject collectedApp = dynamicObject.getDynamicObject("bizapp");
            if (!Objects.nonNull(collectedApp)) continue;
            bizAppIds.add(collectedApp.getString(PROP_ID));
        }
        return bizAppIds;
    }

    public static List<Map<String, Object>> getUsualAppList(int limit) {
        LocalDateTime lastMonthDateTime = LocalDateTime.now().minusMonths(1L);
        Map<String, Long> id2Count = UserBehaviorStatHelper.countUsedAppId(lastMonthDateTime);
        List<Map<String, Object>> rows = limit == -1 ? AppServiceHelper.getAppInfoList(new ArrayList<QFilter>(0)) : AppServiceHelper.getAppInfoList(new ArrayList<QFilter>(0), "", "", false, 0, limit);
        AppServiceHelper.addUsedCount(rows, id2Count);
        AppServiceHelper.sort(rows);
        return rows;
    }

    private static void addUsedCount(List<Map<String, Object>> rows, Map<String, Long> id2Count) {
        for (Map<String, Object> row : rows) {
            String appId = (String)row.get(PROP_ID);
            Long count = id2Count.getOrDefault(appId, 0L);
            row.put(USED_COUNT, count);
        }
    }

    private static void sort(List<Map<String, Object>> rows) {
        Comparator byCollected = (o1, o2) -> {
            int e1Collect = (Boolean)o1.get(COLLECT) != false ? 1 : 0;
            int e2Collect = (Boolean)o2.get(COLLECT) != false ? 1 : 0;
            return e2Collect - e1Collect;
        };
        Comparator byRefCount = (o1, o2) -> {
            long e1Count = (Long)o1.get(USED_COUNT);
            long e2Count = (Long)o2.get(USED_COUNT);
            return (int)(e2Count - e1Count);
        };
        Comparator byCreateDate = (o1, o2) -> {
            String createDate1 = (String)o1.get(CREATE_DATE);
            String createDate2 = (String)o2.get(CREATE_DATE);
            return DateTimeUtils.parseDate((String)createDate2).compareTo(DateTimeUtils.parseDate((String)createDate1));
        };
        rows.sort(byCollected.thenComparing(byRefCount).thenComparing(byCreateDate));
    }

    public static String getAppNameById(String appid) {
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appid, (boolean)false);
        if (metadata == null) {
            return ResManager.loadKDString((String)"\u5e94\u7528\u540d\u4e0d\u5b58\u5728", (String)"AppServiceHelper_0", (String)"bos-nocode-service", (Object[])new Object[0]);
        }
        return metadata.getName().getLocaleValue();
    }

    public static void deleteApp(String appid) {
        boolean enableSoftDelete = NcAppVersionUtil.isEnableSoftDeleteByApp((String)appid);
        QFilter formFilter = new QFilter(PROP_BIZAPPID, "=", (Object)appid);
        QFilter[] formFilters = new QFilter[]{formFilter};
        DynamicObjectCollection forms = QueryServiceHelper.query((String)"bos_formmeta", (String)PROP_ID, (QFilter[])formFilters);
        Set<String> formIds = forms.stream().map(f -> f.getString(PROP_ID)).collect(Collectors.toSet());
        try (TXHandle handle = TX.required();){
            try {
                for (String formId : formIds) {
                    String sError = FormMetadataUtils.deleteForm((String)formId, (String)appid);
                    if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sError)) continue;
                    throw new RestApiException(sError);
                }
                if (enableSoftDelete) {
                    AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appid);
                    appMetadata.getAppElement().setVisible("0");
                    Map res = AppMetaServiceHelper.save((AppMetadata)appMetadata);
                    if (res.size() > 0 && !Boolean.parseBoolean(res.get("success").toString())) {
                        throw new RestApiException(res.get("message").toString());
                    }
                } else {
                    Map res = AppMetaServiceHelper.deleteApp((String)appid);
                    if (!res.containsKey("result") || !"success".equals(res.get("result"))) {
                        throw new RestApiException(SerializationUtils.toJsonString((Object)res));
                    }
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                handle.markRollback();
                throw e;
            }
        }
        try {
            NoCodePermHelper.delAppRoles((String)appid);
            AppServiceHelper.delPublish(appid, formIds);
            QFilter qFilter = new QFilter("bizapp", "=", (Object)appid);
            DeleteServiceHelper.delete((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])new QFilter[]{qFilter});
            AppServiceHelper.delWorkFlow(appid, formIds);
            AppServiceHelper.delCustomPageCards(formIds);
        }
        catch (Exception e) {
            log.debug("\u5e94\u7528\u4e0b\u5b58\u5728\u5220\u9664\u5931\u8d25", (Object)e);
        }
    }

    private static void delCustomPageCards(Set<String> formIds) {
        if (!formIds.isEmpty()) {
            Set forms = formIds.stream().map(Long::parseLong).collect(Collectors.toSet());
            QFilter filter = new QFilter("pageid", "in", forms);
            DynamicObjectCollection cards = QueryServiceHelper.query((String)"bos_nocode_cardcontainer", (String)"pageid,cardid", (QFilter[])new QFilter[]{filter});
            if (!cards.isEmpty()) {
                List list = cards.stream().map(d -> d.getLong("cardid")).collect(Collectors.toList());
                if (!list.isEmpty()) {
                    QFilter f = new QFilter(PROP_ID, "in", list);
                    DeleteServiceHelper.delete((String)"bos_nocode_card", (QFilter[])new QFilter[]{f});
                }
                DeleteServiceHelper.delete((String)"bos_nocode_cardcontainer", (QFilter[])new QFilter[]{filter});
            }
        }
    }

    private static void delPublish(String appid, Set<String> forms) {
        Map appliedAppPerm = NoCodePermissionServiceHelper.getAppliedAppPerm(Collections.singletonList(appid));
        Set<String> forms_other = appliedAppPerm.getOrDefault(appid, Collections.emptySet());
        HashMap map = new HashMap();
        forms.forEach(e -> map.put(e, Collections.emptySet()));
        forms_other.forEach(e -> map.put(e, Collections.singleton(appid)));
        PermResult result = NoCodePermissionServiceHelper.deleteAppliedPerm(map);
        if (!result.getErrors().isEmpty()) {
            log.debug("\u5220\u9664\u5e94\u7528\u4e0b\u8868\u5355\u7533\u8bf7\u4fe1\u606f\u5931\u8d25:%s", (Object)String.join((CharSequence)",", result.getErrors()));
        }
        AppServiceHelper.delFormPubRecordByFormId(forms);
        AppServiceHelper.delFormPubRecordByAppId(appid);
    }

    private static void delWorkFlow(String appId, Set<String> formIds) {
        List processModels = NoCodeWorkflowServiceHelper.getAllProcesses((String)"NoCodeFlow", (String)appId);
        List models = processModels.stream().map(ProcessModel::getId).collect(Collectors.toList());
        List<Long> notPublishedModelIds = processModels.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getEntityNumber())).map(ProcessModel::getId).collect(Collectors.toList());
        NoCodeWorkflowServiceHelper.discardProcesses(models, (boolean)true, (boolean)true);
        WF_PROCESS_DATA_SERVICE.deleteWfInfoByEntityNumbers(new ArrayList<String>(formIds));
        notPublishedModelIds.forEach(WF_PROCESS_DATA_SERVICE::deleteWfInfoByModelId);
    }

    private static void delFormPubRecordByAppId(String appid) {
        String sql = "delete from t_nocode_form_auth where fappid =? or fapplyappid =?";
        Object[] params = new Object[]{appid, appid};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params);
    }

    private static void delFormPubRecordByFormId(Set<String> formIds) {
        if (!formIds.isEmpty()) {
            SqlBuilder sb = new SqlBuilder();
            String sql = "delete from t_nocode_form_auth where fformid ";
            sb.appendIn(sql, formIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
        }
    }

    public static void exportAppToZip(String appid, boolean withData) throws IOException {
        boolean exists = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)appid);
        if (!exists) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5e94\u7528id\u9519\u8bef\u6216\u5e94\u7528\u5df2\u88ab\u5220\u9664", (String)"AppServiceHelper_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        AppServiceHelper.preExportCheck(appid);
        DynamicObject load = BusinessDataServiceHelper.loadSingle((Object)appid, (String)"bos_devportal_bizapp");
        JSONObject config = new JSONObject();
        config.put("version", (Object)"1.0.0");
        config.put("appId", (Object)appid);
        config.put("image", (Object)load.getString("image"));
        config.put("description", (Object)load.getString("description"));
        File temp = Files.createTempDirectory("nocode_app_export", new FileAttribute[0]).toFile();
        String path = temp.getPath();
        temp.deleteOnExit();
        String output = path + File.separator + "app";
        AppServiceHelper.exportMeta2File(appid, output, config);
        if (withData) {
            AppServiceHelper.exportFormData(config, output + File.separator + "datas");
        }
        AppServiceHelper.exportAssociation(config, output + File.separator + "sqls");
        AppServiceHelper.exportRuleData(config, output + File.separator + "sqls");
        AppServiceHelper.exportCustomPages(config, output + File.separator + "sqls");
        AppServiceHelper.exportRoles(appid, config);
        AppServiceHelper.exportWf(appid, config);
        String name = config.getString("appName");
        String export = path + File.separator + "export.zip";
        try (FileOutputStream fos = new FileOutputStream(export);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            File srcFile = new File(output);
            AppServiceHelper.addFilesToZip(srcFile, srcFile.getName(), zos);
            AppServiceHelper.addConfigToZip(config.toJSONString(), zos);
        }
        AppServiceHelper.writeOutputStream(name, export);
    }

    private static void exportWf(String appid, JSONObject config) {
        Map<String, String> models;
        try {
            List processModels = NoCodeWorkflowServiceHelper.getAllProcesses((String)"NoCodeFlow", (String)appid);
            models = processModels.stream().map(ProcessModel::getId).map(id -> {
                String content = NoCodeWorkflowServiceHelper.getExportedProcessFileContent((Long)id);
                return new Tuple((Object)id.toString(), (Object)content);
            }).collect(Collectors.toMap(e -> (String)e.item1, e -> (String)e.item2));
        }
        catch (Exception e2) {
            throw new RestApiException(RestApiErrorCode.ERROR.getStatusCode(), e2.getMessage(), (Throwable)e2);
        }
        config.put(WF_MODELS, models);
    }

    private static void exportRoles(String appid, JSONObject config) {
        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
        ArrayList<RolePerm> list = new ArrayList<RolePerm>();
        for (Role role : roles) {
            RolePerm r = NoCodePermissionServiceHelper.getRolePerm((String)role.getId());
            list.add(r);
        }
        config.put("roles", list);
    }

    private static void exportAssociation(JSONObject config, String path) throws IOException {
        JSONArray forms = config.getJSONArray(FORM_IDS);
        Set fids = forms.stream().map(Object::toString).collect(Collectors.toSet());
        LinkedHashMap<String, List<String>> sqls = new LinkedHashMap<String, List<String>>();
        QFilter f = new QFilter("first_formid", "in", fids);
        String selects = "id,first_formid,first_form_ref_fieldkey,second_formid,second_form_ref_fieldkey";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_nocode_association", (String)selects, (QFilter[])new QFilter[]{f});
        if (load.length > 0) {
            String[] select = selects.split(",");
            AppServiceHelper.genSql(false, sqls, Arrays.asList(select), load[0].getDataEntityType(), load);
            if (!sqls.isEmpty()) {
                String dbRouteKey = load[0].getDataEntityType().getDBRouteKey();
                AppServiceHelper.wirteSql2File(config, path, sqls, dbRouteKey);
            }
        }
    }

    private static void exportCustomPages(JSONObject config, String path) throws IOException {
        JSONArray forms = config.getJSONArray(FORM_IDS);
        LinkedHashMap<String, List<String>> sqls = new LinkedHashMap<String, List<String>>(32);
        HashSet<Long> ids = new HashSet<Long>(8);
        for (int i = 0; i < forms.size(); ++i) {
            String id = forms.getString(i);
            ids.add(Long.parseLong(id));
        }
        if (!ids.isEmpty()) {
            QFilter filter = new QFilter("pageid", "in", ids);
            HashSet select = Sets.newHashSet((Object[])new String[]{"cardid", "x", "y", "w", "h", "schemaId", "pageid", PROP_ID, "type"});
            String selectProperties = String.join((CharSequence)",", select);
            DynamicObject[] containers = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)selectProperties, (QFilter[])new QFilter[]{filter});
            if (containers.length > 0) {
                Set<Long> cardIds = Arrays.stream(containers).map(dy -> dy.getLong("cardid")).collect(Collectors.toSet());
                if (!cardIds.isEmpty()) {
                    AppServiceHelper.exportCards(sqls, cardIds, config);
                }
                AppServiceHelper.genSql(false, sqls, select, containers[0].getDataEntityType(), containers);
            }
            if (!sqls.isEmpty()) {
                AppServiceHelper.wirteSql2File(config, path, sqls, containers[0].getDataEntityType().getDBRouteKey());
            }
        }
    }

    private static void exportCards(Map<String, List<String>> sqls, Set<Long> cardIds, JSONObject config) {
        QFilter f = new QFilter(PROP_ID, "in", cardIds);
        String select = "id,title,type,config,deleted,app,form,image,creater,createdate,modifier,modifydate";
        DynamicObject[] cards = BusinessDataServiceHelper.load((String)"bos_nocode_card", (String)select, (QFilter[])new QFilter[]{f});
        if (cards.length > 0) {
            String[] split = select.split(",");
            AppServiceHelper.genSql(false, sqls, Arrays.asList(split), cards[0].getDataEntityType(), cards);
        }
        Set<String> qingCardIds = AppServiceHelper.getQingCardIds(cards);
        List<String> qingCardConfigs = QING_PROXY_SERVICE.exportNoCodeCards(qingCardIds);
        config.put("qingCardConfigs", qingCardConfigs);
    }

    private static Set<String> getQingCardIds(DynamicObject[] cards) {
        return Arrays.stream(cards).filter(e -> CardTypeEnum.STATISTICS.toString().equalsIgnoreCase(e.getString("type"))).map(e -> {
            String config = e.getString("config");
            Map statCardConfig = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
            return (String)statCardConfig.get("qingCardId");
        }).collect(Collectors.toSet());
    }

    private static void writeOutputStream(String name, String export) throws IOException {
        File file = new File(export);
        HttpServletResponse response = RestApiContext.getResponse();
        response.setContentType("application/octet-stream");
        response.setContentLength((int)file.length());
        name = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        response.setHeader("Content-Disposition", "attachment; filename=" + name + ".zip");
        try (FileInputStream inputStream = new FileInputStream(file);
             ServletOutputStream outputStream = response.getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
    }

    private static void preExportCheck(String appid) {
        QFilter filter = new QFilter(PROP_BIZAPPID, "=", (Object)appid);
        DynamicObject[] forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)PROP_ID, (QFilter[])new QFilter[]{filter});
        Set fs = Arrays.stream(forms).map(dy -> dy.getString(PROP_ID)).collect(Collectors.toSet());
        for (String fid : fs) {
            Map metadata = MetadataDao.loadDesignerMetadata((String)fid);
            Map em = (Map)metadata.get("entitymeta");
            List entityItems = (List)em.get("Items");
            for (Map entityItem : entityItems) {
                String refId;
                if (!entityItem.containsKey(TYPE) || !entityItem.get(TYPE).equals("NoCodeRefBillField") && !entityItem.get(TYPE).equals("NoCodeMulRefBillField") || !entityItem.containsKey("BillEntityIdEx") || fs.contains(refId = (String)entityItem.get("BillEntityIdEx")) || "bos_adminorg".equals(refId) || "bos_user".equals(refId) || !NcEntityTypeUtil.isFormExist((String)refId)) continue;
                log.debug(String.format("\u5f53\u524d\u5e94\u7528\u5b58\u5728\u5173\u8054\u5176\u4ed6\u5e94\u7528\u8868\u5355\uff0c\u65e0\u6cd5\u5bfc\u51fa:%s -> %s", fid, refId));
                throw new RestApiException(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5b58\u5728\u5173\u8054\u5176\u4ed6\u5e94\u7528\u8868\u5355\uff0c\u65e0\u6cd5\u5bfc\u51fa", (String)"AppServiceHelper_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
        }
    }

    private static void addFilesToZip(File source, String base, ZipOutputStream zos) throws IOException {
        block15: {
            block14: {
                if (!source.isDirectory()) break block14;
                File[] files = source.listFiles();
                if (files == null) break block15;
                for (File file : files) {
                    AppServiceHelper.addFilesToZip(file, base + "/" + file.getName(), zos);
                }
                break block15;
            }
            byte[] buffer = new byte[1024];
            try (FileInputStream fis = new FileInputStream(source);){
                int length;
                zos.putNextEntry(new ZipEntry(base));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
            }
        }
    }

    private static String calculateMD5(String filePath) throws IOException {
        FileInputStream fis = new FileInputStream(filePath);
        String md5 = DigestUtils.md5Hex((InputStream)fis);
        fis.close();
        return md5;
    }

    private static void addConfigToZip(String str, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry("config.json"));
        byte[] data = str.getBytes();
        zos.write(data, 0, data.length);
        zos.closeEntry();
    }

    private static void exportRuleData(JSONObject config, String path) throws IOException {
        JSONArray forms = config.getJSONArray(FORM_IDS);
        Set fids = forms.stream().map(Object::toString).collect(Collectors.toSet());
        LinkedHashMap<String, List<String>> sqls = new LinkedHashMap<String, List<String>>();
        if (!fids.isEmpty()) {
            QFilter filter = new QFilter("formid", "in", fids);
            String selectFields = "id,name,formid,expression,depfldkeys,trueaction,affectfldkeys,creater,modifier,createdate,modifydate,valuetype,ruletype";
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_nocode_rule", (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (load.length > 0) {
                String[] select = selectFields.split(",");
                AppServiceHelper.genSql(false, sqls, Arrays.asList(select), load[0].getDataEntityType(), load);
                if (!sqls.isEmpty()) {
                    String dbRouteKey = load[0].getDataEntityType().getDBRouteKey();
                    AppServiceHelper.wirteSql2File(config, path, sqls, dbRouteKey);
                }
            }
        }
    }

    private static void wirteSql2File(JSONObject config, String path, Map<String, List<String>> sqls, String dbRouteKey) throws IOException {
        String key = path.substring(path.lastIndexOf(File.separator) + 1);
        JSONArray list = (JSONArray)config.computeIfAbsent((Object)key, s -> new JSONArray());
        for (String table : sqls.keySet()) {
            list.add((Object)Maps.of((Object)"db", (Object)dbRouteKey, (Object)"sql", (Object)table));
        }
        File f = new File(path);
        f.mkdirs();
        for (Map.Entry<String, List<String>> entry : sqls.entrySet()) {
            String pathname = path + File.separator + entry.getKey() + ".sql";
            FileWriter fw = new FileWriter(pathname);
            Throwable throwable = null;
            try {
                BufferedWriter writer = new BufferedWriter(fw);
                Throwable throwable2 = null;
                try {
                    for (String content : entry.getValue()) {
                        content = content + LINE_DELIMITER;
                        writer.write(content);
                        writer.newLine();
                        writer.flush();
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable2 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (fw == null) continue;
                if (throwable != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                fw.close();
            }
        }
    }

    private static void exportFormData(JSONObject config, String path) throws IOException {
        JSONArray forms = config.getJSONArray(FORM_IDS);
        LinkedHashMap<String, List<String>> sqls = new LinkedHashMap<String, List<String>>();
        forms.forEach(s -> {
            DynamicObject[] loads;
            String fid = s.toString();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)fid);
            List<String> fields = type.getProperties().stream().map(IMetadata::getName).filter(p -> !WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY.equalsIgnoreCase((String)p)).filter(p -> !"nocodecreatorfield_id".equals(p)).filter(p -> !"nocodemodifierfield_id".equals(p)).collect(Collectors.toList());
            if (!fields.isEmpty() && (loads = BusinessDataServiceHelper.load((String)fid, (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[0])).length > 0) {
                AppServiceHelper.genSql(false, sqls, fields, (IDataEntityType)type, loads);
            }
        });
        if (!sqls.isEmpty()) {
            AppServiceHelper.wirteSql2File(config, path, sqls, "secd");
        }
    }

    private static void exportMeta2File(String app, String path, JSONObject config) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)app, (boolean)false);
        config.put("appName", (Object)appMeta.getName().getLocaleValue());
        DevUtil.expAppMetadata(app, path, "EXPORT_APP");
        QFilter filter = new QFilter(PROP_BIZAPPID, "=", (Object)app);
        DynamicObject[] forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)PROP_ID, (QFilter[])new QFilter[]{filter});
        List formIds = Arrays.stream(forms).map(DataEntityBase::getPkValue).map(String::valueOf).peek(fid -> DevUtil.expFormMetadata(fid, path, "EXPORT_PAGE")).collect(Collectors.toList());
        config.put(FORM_IDS, formIds);
    }

    private static void genSql(boolean flag, Map<String, List<String>> ret, Collection<String> selects, IDataEntityType type, DynamicObject ... dys) {
        for (DynamicObject dy : dys) {
            LinkedHashMap<String, String> sqlParams = new LinkedHashMap<String, String>();
            ArrayList<String> mulFields = new ArrayList<String>();
            ArrayList<Pair<EntityType, DynamicObjectCollection>> entryTables = new ArrayList<Pair<EntityType, DynamicObjectCollection>>();
            for (String field : selects) {
                Object v;
                Object value;
                IDataEntityProperty prop = (IDataEntityProperty)type.getProperties().get((Object)field);
                if (prop instanceof DecimalProp || prop instanceof LongProp || prop instanceof IntegerProp) {
                    value = prop.getValue((Object)dy);
                    if (value != null) {
                        sqlParams.put(prop.getAlias(), value.toString());
                        continue;
                    }
                    if (prop instanceof NoCodeDecimalProp) {
                        sqlParams.put(prop.getAlias(), "NULL");
                        continue;
                    }
                    sqlParams.put(prop.getAlias(), "0");
                    continue;
                }
                if (prop instanceof DateTimeProp) {
                    v = (Date)prop.getValue((Object)dy);
                    if (v == null) {
                        sqlParams.put(prop.getAlias(), null);
                        continue;
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    sqlParams.put(prop.getAlias(), String.format("{ts'%s'}", sdf.format((Date)v)));
                    continue;
                }
                if (prop instanceof MuliLangTextProp) {
                    mulFields.add(prop.getAlias());
                    continue;
                }
                if (prop instanceof NoCodeImageProp || prop instanceof NoCodeAttachmentProp) continue;
                if (prop instanceof NoCodeRefBillProp) {
                    if (prop instanceof NoCodeCreatorProp || prop instanceof NoCodeModifierProp) {
                        if (flag) {
                            sqlParams.put(prop.getAlias(), IERP_UID);
                            continue;
                        }
                        sqlParams.put(prop.getAlias(), "#{uid}");
                        continue;
                    }
                    NoCodeRefBillProp p = (NoCodeRefBillProp)prop;
                    String ref = p.getBillEntityId();
                    if ("bos_adminorg".equals(ref) || "bos_user".equals(ref)) continue;
                    DynamicObject value2 = (DynamicObject)prop.getValue((Object)dy);
                    sqlParams.put(prop.getAlias(), value2 == null ? "0" : value2.getPkValue().toString());
                    continue;
                }
                if (prop instanceof CreaterProp || prop instanceof ModifierProp) {
                    if (flag) {
                        sqlParams.put(prop.getAlias(), IERP_UID);
                        continue;
                    }
                    sqlParams.put(prop.getAlias(), "#{uid}");
                    continue;
                }
                if (prop instanceof EntryProp) {
                    if (!(type instanceof MainEntityType)) continue;
                    EntityType t = (EntityType)((MainEntityType)type).getAllEntities().get(prop.getName());
                    DynamicObjectCollection d = (DynamicObjectCollection)prop.getValue((Object)dy);
                    Pair pair = new Pair((Object)t, (Object)d);
                    entryTables.add((Pair<EntityType, DynamicObjectCollection>)pair);
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    value = (Boolean)prop.getValue((Object)dy);
                    if (value == null) {
                        value = Boolean.FALSE;
                    }
                    sqlParams.put(prop.getAlias(), ((Boolean)value).booleanValue() ? "'1'" : "'0'");
                    continue;
                }
                if (prop instanceof BasedataProp) {
                    value = prop.getValue((Object)dy);
                    if (value == null) continue;
                    String v2 = ((DynamicObject)value).getPkValue().toString();
                    sqlParams.put(prop.getAlias(), v2);
                    continue;
                }
                v = prop.getValue((Object)dy);
                if (v == null) continue;
                String value3 = v.toString();
                if (value3.length() == 0) {
                    value3 = " ";
                }
                value3 = value3.replaceAll("'", "''");
                sqlParams.put(prop.getAlias(), "'" + value3 + "'");
            }
            if (type instanceof EntryType) {
                sqlParams.put("fid", String.valueOf(((DynamicObject)dy.getParent()).getPkValue()));
            }
            AppServiceHelper.genMainSql(ret, sqlParams, type);
            AppServiceHelper.genMulSql(dy, ret, mulFields, type);
            AppServiceHelper.genEntrySql(ret, entryTables);
        }
    }

    private static void genEntrySql(Map<String, List<String>> ret, List<Pair<EntityType, DynamicObjectCollection>> entryTables) {
        for (Pair<EntityType, DynamicObjectCollection> pair : entryTables) {
            DynamicObject[] dys;
            List<String> fields = ((EntityType)pair.getKey()).getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
            Object[] pks = ((DynamicObjectCollection)pair.getValue()).stream().map(DataEntityBase::getPkValue).toArray();
            for (DynamicObject dy : dys = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)((DynamicObjectType)pair.getKey()))) {
                dy.setParent(((DynamicObject)((DynamicObjectCollection)pair.getValue()).get(0)).getParent());
                AppServiceHelper.genSql(false, ret, fields, (IDataEntityType)pair.getKey(), dy);
            }
        }
    }

    private static void genMulSql(DynamicObject dy, Map<String, List<String>> map, List<String> mulFields, IDataEntityType dt) {
        if (!mulFields.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("select fpkid, fid, flocaleid, ").append(String.join((CharSequence)", ", mulFields)).append(" from ").append(dt.getAlias()).append("_l").append(" where fid = ?");
            String dbRouteKey = dt.getDBRouteKey();
            List sqls = (List)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)builder.toString(), (Object[])new Object[]{dy.getPkValue()}, rs -> {
                ArrayList<String> ret = new ArrayList<String>();
                ArrayList<String> tmp = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                while (rs.next()) {
                    sb.setLength(0);
                    tmp.clear();
                    for (String field : mulFields) {
                        tmp.add("'" + rs.getString(field) + "'");
                    }
                    sb.append("IF NOT EXISTS (SELECT 1 FROM ").append(dt.getAlias()).append("_l").append(" WHERE ").append("fpkid").append(" = ").append("'").append(rs.getString("fpkid")).append("' ) ").append("INSERT INTO ").append(dt.getAlias()).append("_l(").append("fpkid, fid, flocaleid, ").append(String.join((CharSequence)", ", mulFields)).append(") ").append("VALUES(").append("'").append(rs.getString("fpkid")).append("', ").append("'").append(rs.getString("fid")).append("', ").append("'").append(rs.getString("flocaleid")).append("', ").append(String.join((CharSequence)", ", tmp)).append(");");
                    ret.add(sb.toString());
                }
                return ret;
            });
            List list = map.computeIfAbsent(dt.getAlias() + "_l", s -> new ArrayList());
            list.addAll(sqls);
        }
    }

    private static void genMainSql(Map<String, List<String>> map, Map<String, String> sqlParams, IDataEntityType dt) {
        if (!sqlParams.isEmpty()) {
            String fid;
            String fields = String.join((CharSequence)", ", sqlParams.keySet());
            String values = String.join((CharSequence)", ", sqlParams.values());
            StringBuilder builder = new StringBuilder();
            IDataEntityProperty id = (IDataEntityProperty)dt.getProperties().get((Object)PROP_ID);
            if (id != null && sqlParams.containsKey(fid = id.getAlias())) {
                builder.append("IF NOT EXISTS (SELECT 1 FROM ").append(dt.getAlias()).append(" WHERE ").append(fid).append(" = ").append(sqlParams.get(fid)).append(" ) ");
            }
            builder.append("INSERT INTO ").append(dt.getAlias()).append("(").append(fields).append(") ").append("VALUES(").append(values).append(");");
            List list = map.computeIfAbsent(dt.getAlias(), s -> new ArrayList());
            list.add(builder.toString());
        }
    }

    public static String importAppFromZip(RestApiSaveParam param) {
        String appId = null;
        try {
            Map map = (Map)param.getDataList().get(0);
            String file = (String)map.get("file");
            String withData = (String)map.get("withData");
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(file);
            File tmp = Files.createTempDirectory("nocode_app_import", new FileAttribute[0]).toFile();
            tmp.deleteOnExit();
            String path = tmp.getPath();
            String export = path + File.separator + "export.zip";
            try (FileOutputStream fos = new FileOutputStream(export);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, length);
                }
            }
            String unzip = path + File.separator + "unzip";
            IOUtils.unzip((String)export, (String)unzip);
            JSONObject config = AppServiceHelper.readConfig(unzip);
            String app = unzip + File.separator + "app";
            NewIdInfo newIdMap = AppServiceHelper.preImportCheck(config, app);
            appId = newIdMap.getNewId();
            List<String> forms = AppServiceHelper.importMeta(app + File.separator + "metadata", newIdMap);
            AppServiceHelper.importSql(app + File.separator + "sqls", config, newIdMap);
            if ("true".equals(withData)) {
                AppServiceHelper.importSql(app + File.separator + "datas", config, newIdMap);
            }
            AppServiceHelper.importRoles(config, newIdMap);
            Map<String, Long> modelIdMap = AppServiceHelper.importWf(config, newIdMap);
            AppServiceHelper.reImportFormMeta(appId, forms, modelIdMap);
            AppServiceHelper.importStatCards(config, newIdMap);
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)appId, (String)"bos_devportal_bizapp");
            if (map.containsKey("image")) {
                dyn.set("image", map.get("image"));
            }
            if (map.containsKey("name")) {
                dyn.set("name", map.get("name"));
            }
            if (map.containsKey("description")) {
                dyn.set("description", map.get("description"));
            }
            dyn.set("creater", (Object)RequestContext.get().getCurrUserId());
            dyn.set(CREATE_DATE, (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
            return appId;
        }
        catch (RestApiException e) {
            log.error((Throwable)e);
            if (kd.bos.util.StringUtils.isNotEmpty(appId)) {
                AppServiceHelper.deleteApp(appId);
            }
            throw e;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            if (kd.bos.util.StringUtils.isNotEmpty(appId)) {
                AppServiceHelper.deleteApp(appId);
            }
            throw new RestApiException(ResManager.loadKDString((String)"\u53ef\u80fd\u5b58\u5728\u6587\u4ef6\u5185\u5bb9\u7f3a\u5931\u7b49\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u5bfc\u5165", (String)"AppServiceHelper_3", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
    }

    private static void importStatCards(JSONObject config, NewIdInfo newIdMap) {
        if (!config.containsKey((Object)"qingCardConfigs")) {
            return;
        }
        JSONArray models = config.getJSONArray("qingCardConfigs");
        List qingModels = models.toJavaList(String.class);
        qingModels.replaceAll(qingModel -> {
            qingModel = newIdMap.replaceAll((String)qingModel);
            return qingModel;
        });
        QING_PROXY_SERVICE.importNoCodeCards(qingModels);
    }

    private static Map<String, Long> importWf(JSONObject config, NewIdInfo newIdMap) {
        if (!config.containsKey((Object)WF_MODELS)) {
            return new HashMap<String, Long>();
        }
        JSONObject models = config.getJSONObject(WF_MODELS);
        HashMap<String, Long> idMap = new HashMap<String, Long>(models.size());
        for (Map.Entry entry : models.entrySet()) {
            String oldModelId = (String)entry.getKey();
            String newModelId = FormMetaUtil.genIdUrlFriendly();
            String model = (String)entry.getValue();
            model = newIdMap.replaceAll(model);
            model = model.replaceAll(oldModelId, newModelId);
            Map result = newIdMap.isDiff() ? NoCodeWorkflowServiceHelper.importProcessFileContent((String)model, (boolean)true) : NoCodeWorkflowServiceHelper.importProcessFileContent((String)model);
            boolean success = result.getOrDefault("success", false);
            if (!success) {
                log.debug("\u5bfc\u5165\u6d41\u7a0b\u5931\u8d25:\n" + JSONObject.toJSONString((Object)result) + "\nmodel:\n" + model);
                throw new RestApiException(ResManager.loadKDString((String)"\u5bfc\u5165\u6d41\u7a0b\u5931\u8d25", (String)"AppServiceHelper_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            idMap.put(oldModelId, (Long)result.get(MODEL_ID));
        }
        for (Map.Entry entry : idMap.entrySet()) {
            try {
                ProcessModel process;
                Long modelId = (Long)entry.getValue();
                if (((String)entry.getKey()).equals(((Long)entry.getValue()).toString()) || kd.bos.util.StringUtils.isBlank((String)(process = NoCodeWorkflowServiceHelper.getProcess((Long)modelId)).getEntityNumber())) continue;
                String data = process.getData();
                boolean needSave = false;
                for (Map.Entry idEntry : idMap.entrySet()) {
                    String oldModelId = (String)idEntry.getKey();
                    if (!data.contains(oldModelId)) continue;
                    data = data.replace(oldModelId, ((Long)idEntry.getValue()).toString());
                    needSave = true;
                }
                if (!needSave) continue;
                process.setData(data);
                NoCodeWorkflowServiceHelper.saveProcess((ProcessModel)process);
                NoCodeWorkflowServiceHelper.publishProcess((Long)modelId, (Map)Maps.of((Object)"ignoreValidateInfo", (Object)true));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new RestApiException(ResManager.loadKDString((String)"\u5bfc\u5165\u6d41\u7a0b\u5931\u8d25", (String)"AppServiceHelper_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
        }
        return idMap;
    }

    private static void importRoles(JSONObject config, NewIdInfo newIdMap) {
        JSONArray roles = config.getJSONArray("roles");
        log.debug(roles.toJSONString());
        ArrayList<RolePerm> list = new ArrayList<RolePerm>();
        for (int i = 0; i < roles.size(); ++i) {
            JSONObject r = roles.getJSONObject(i);
            RolePerm role = new RolePerm();
            role.setAssignOrgIds(Collections.emptySet());
            role.setId(r.getString(PROP_ID));
            String appId = r.getString("appId");
            if (newIdMap.isDiff()) {
                appId = newIdMap.getNewId();
                String newRoleId = ID.genStringId();
                NewIdInfo newRoleIdInfo = new NewIdInfo();
                newRoleIdInfo.setOldId(role.getId());
                newRoleIdInfo.setNewId(newRoleId);
                newIdMap.getChildIds().add(newRoleIdInfo);
                role.setId(newRoleId);
            }
            role.setAppId(appId);
            role.setSystem(r.getBoolean("system").booleanValue());
            if (role.isSystem()) {
                role.setAssignUserIds(Collections.singleton(RequestContext.get().getCurrUserId()));
            } else {
                role.setAssignUserIds(Collections.emptySet());
            }
            role.setAppManageType(AppManageTypeEnum.valueOf((String)r.getString("appManageType")));
            role.setSortCode(r.getInteger("sortCode").intValue());
            role.setAppUseType(AppUseTypeEnum.valueOf((String)r.getString("appUseType")));
            role.setName(r.getString("name"));
            JSONObject permMap = r.getJSONObject("entityNumberPermMap");
            role.setEntityNumberPermMap(AppServiceHelper.rebuildPermMap(permMap, newIdMap));
            list.add(role);
        }
        for (RolePerm rolePerm : list) {
            String oldId = rolePerm.getId();
            NoCodePermissionServiceHelper.saveRolePerm((RolePerm)rolePerm);
            if (rolePerm.getId().equalsIgnoreCase(oldId)) continue;
            NewIdInfo roleIdInfo = new NewIdInfo();
            roleIdInfo.setOldId(oldId);
            roleIdInfo.setNewId(ID.genStringId());
            newIdMap.getChildIds().add(roleIdInfo);
        }
    }

    private static Map<String, EntityPerm> rebuildPermMap(JSONObject map, NewIdInfo newIdMap) {
        HashMap<String, EntityPerm> ret = new HashMap<String, EntityPerm>();
        for (Map.Entry entry : map.entrySet()) {
            String fid = (String)entry.getKey();
            if (fid.equalsIgnoreCase(newIdMap.getOldId())) {
                fid = newIdMap.getNewId();
            }
            JSONObject value = (JSONObject)entry.getValue();
            ret.put(fid, AppServiceHelper.rebuildPerm(value, newIdMap));
        }
        return ret;
    }

    private static EntityPerm rebuildPerm(JSONObject p, NewIdInfo newIdMap) {
        String entityId = p.getString("entityId");
        entityId = newIdMap.replaceAll(entityId);
        String entityNumber = p.getString("entityNumber");
        entityNumber = newIdMap.replaceAll(entityNumber);
        EntityPerm perm = new EntityPerm(entityId, entityNumber);
        perm.setPermItemMap(AppServiceHelper.rebuildPermItemMap(p.getJSONObject("permItemMap")));
        perm.setDataRule(AppServiceHelper.rebuildDataRule(p.getJSONObject("dataRule")));
        return perm;
    }

    private static DataRule rebuildDataRule(JSONObject dataRule) {
        DataRule ret = new DataRule();
        ret.setId(dataRule.getLong(PROP_ID).longValue());
        ret.setType(DataRuleTypeEnum.valueOf((String)dataRule.getString("type")));
        ret.setNoCodeRule(dataRule.getString("noCodeRule"));
        return ret;
    }

    private static Map<String, PermItem> rebuildPermItemMap(JSONObject permItemMap) {
        HashMap<String, PermItem> ret = new HashMap<String, PermItem>();
        for (Map.Entry entry : permItemMap.entrySet()) {
            String key = (String)entry.getKey();
            JSONObject value = (JSONObject)entry.getValue();
            ret.put(key, AppServiceHelper.rebuildPermItem(value));
        }
        return ret;
    }

    private static PermItem rebuildPermItem(JSONObject value) {
        PermItem ret = new PermItem(value.getString(PROP_ID));
        JSONArray array = value.getJSONArray("noPermProperties");
        HashSet<String> hides = new HashSet<String>();
        for (int i = 0; i < array.size(); ++i) {
            String hide = array.getString(i);
            hides.add(hide);
        }
        ret.setNoPermProperties(hides);
        return ret;
    }

    private static NewIdInfo preImportCheck(JSONObject config, String app) {
        QFilter filter;
        DynamicObject[] forms;
        NewIdInfo result = new NewIdInfo();
        String appId = config.getString("appId");
        result.setOldId(appId);
        result.setNewId(appId);
        boolean exists = QueryServiceHelper.exists((String)"bos_devportal_bizapp", (Object)appId);
        if (exists) {
            result.setNewId(FormMetaUtil.genIdUrlFriendly());
        }
        JSONArray formIds = config.getJSONArray(FORM_IDS);
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < formIds.size(); ++i) {
            String id = formIds.getString(i);
            ids.add(id);
        }
        if (!ids.isEmpty() && (forms = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)PROP_ID, (QFilter[])new QFilter[]{filter = new QFilter(PROP_ID, "in", ids)})).length > 0) {
            Set fids = Arrays.stream(forms).map(dy -> dy.getString(PROP_ID)).collect(Collectors.toSet());
            for (String fid : fids) {
                NewIdInfo formIdInfo = new NewIdInfo();
                formIdInfo.setOldId(fid);
                formIdInfo.setNewId(FormMetaUtil.genIdUrlFriendly());
                result.getChildIds().add(formIdInfo);
            }
        }
        if (result.isDiff() && config.containsKey((Object)"qingCardConfigs")) {
            JSONArray models = config.getJSONArray("qingCardConfigs");
            List qingModels = models.toJavaList(String.class);
            for (String qingModel : qingModels) {
                Matcher matcher = varQingCardIdPattern.matcher(qingModel);
                if (!matcher.find()) continue;
                String cardId = matcher.group(1);
                NewIdInfo cardIdInfo = new NewIdInfo();
                cardIdInfo.setOldId(cardId);
                cardIdInfo.setNewId(UUID.randomUUID().toString());
                result.getChildIds().add(cardIdInfo);
            }
        }
        if (result.isDiff()) {
            try {
                AppServiceHelper.parseNewFID(app, result, varRuleIdPattern, "t_nocode_ruleconfig.sql");
                AppServiceHelper.parseNewFID(app, result, varAssoIdPattern, "t_nocode_association.sql");
                AppServiceHelper.parseNewFID(app, result, varCardContainerIdPattern, "t_nocode_cardcontainer.sql");
                AppServiceHelper.parseNewFID(app, result, varCardIdPattern, "t_nocode_card.sql");
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return result;
    }

    public static JSONObject readConfig(String app) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(app + File.separator + "config.json"));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            JSONObject jSONObject = JSONObject.parseObject((String)builder.toString());
            return jSONObject;
        }
    }

    private static void parseNewFID(String app, NewIdInfo idInfo, Pattern fidPattern, String fileNameWithExt) throws IOException {
        String sqlFile = app + File.separator + "sqls" + File.separator + fileNameWithExt;
        File file = new File(FileUtils.cleanString((String)sqlFile));
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(sqlFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher;
                    if (kd.bos.util.StringUtils.isBlank((String)line) || !(matcher = fidPattern.matcher(line)).find()) continue;
                    String fid = matcher.group(1);
                    NewIdInfo newIdInfo = new NewIdInfo();
                    newIdInfo.setOldId(fid.trim());
                    newIdInfo.setNewId(FormMetaUtil.genIdUrlFriendly());
                    idInfo.getChildIds().add(newIdInfo);
                }
            }
        }
    }

    private static void importSql(String path, JSONObject config, NewIdInfo newIdMap) throws IOException {
        String key = path.substring(path.lastIndexOf(File.separator) + 1);
        if (config.containsKey((Object)key)) {
            JSONArray sqls = config.getJSONArray(key);
            for (int i = 0; i < sqls.size(); ++i) {
                JSONObject obj = sqls.getJSONObject(i);
                String db = obj.getString("db");
                String sql = obj.getString("sql");
                try {
                    AppServiceHelper.doInsertSql(db, path + File.separator + sql + ".sql", newIdMap);
                    continue;
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                }
            }
        }
    }

    private static void doInsertSql(String db, String sql, NewIdInfo newIdMap) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(sql));){
            DBRoute dbKey;
            String line;
            ArrayList<String> list = new ArrayList<String>();
            long uid = RequestContext.get().getCurrUserId();
            String u = String.valueOf(uid);
            StringBuilder sqlLineBuilder = new StringBuilder(128);
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll("#\\{uid\\}", u);
                line = newIdMap.replaceAll(line);
                sqlLineBuilder.append(line);
                if (!AppServiceHelper.isSqlLineEnd(line)) continue;
                list.add(sqlLineBuilder.toString().replace(LINE_DELIMITER, ""));
                sqlLineBuilder.setLength(0);
                if (list.size() <= 1000) continue;
                dbKey = DBRoute.of((String)db);
                DB.execute((DBRoute)dbKey, (String)String.join((CharSequence)"", list));
                list.clear();
            }
            if (!list.isEmpty()) {
                dbKey = DBRoute.of((String)db);
                DB.execute((DBRoute)dbKey, (String)String.join((CharSequence)"", list));
                list.clear();
            }
        }
    }

    private static boolean isSqlLineEnd(String line) {
        return line.endsWith(LINE_DELIMITER) || line.endsWith(");");
    }

    private static List<String> importMeta(String path, NewIdInfo newIdMap) throws IOException {
        File[] files;
        File directory = new File(path);
        ArrayList<String> apps = new ArrayList<String>();
        ArrayList<String> forms = new ArrayList<String>();
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith("app")) {
                    AppServiceHelper.readContent(file, apps, newIdMap, line -> {
                        line = line.replaceAll("(<AppVersion>).+?(</AppVersion>)", "$1" + NcAppVersionUtil.getAppVersion() + "$2");
                        line = line.replaceAll("(<Version>).+?(</Version>)", "$1" + NcAppVersionUtil.getAppVersion() + "$2");
                        return line;
                    });
                    continue;
                }
                if (file.getName().endsWith("appx")) {
                    AppServiceHelper.readContent(file, apps, newIdMap, line -> line.replaceAll("(<PkId>).+?(</PkId>)", "$1" + ID.genStringId() + "$2"));
                    continue;
                }
                if (file.isFile() && file.getName().endsWith("dym")) {
                    AppServiceHelper.readContent(file, forms, newIdMap, null);
                    continue;
                }
                if (!file.getName().endsWith("dymx")) continue;
                AppServiceHelper.readContent(file, forms, newIdMap, line -> line.replaceAll("(<PkId>).+?(</PkId>)", "$1" + ID.genStringId() + "$2"));
            }
        }
        HashSet appIds = new HashSet();
        File[] fileArray = apps.iterator();
        while (fileArray.hasNext()) {
            String app;
            String theApp = app = (String)fileArray.next();
            if (newIdMap.isDiff()) {
                theApp = AppServiceHelper.renewMenuId(theApp);
            }
            List appids = AppMetaServiceHelper.deployAppMetadata((String)theApp, (String)"2HGKCE94QELW");
            appIds.addAll(appids);
        }
        String bizAppId = (String)appIds.iterator().next();
        HashSet formIds = new HashSet();
        for (String form : forms) {
            List ids = MetadataDao.deployMetadata((String)form, null, (String)bizAppId);
            formIds.addAll(ids);
        }
        for (String appid : appIds) {
            MetadataDao.rebuildRuntimeAppMetaById((String)appid);
        }
        for (String formId : formIds) {
            MetadataDao.rebuildRuntimeMetaById((String)formId);
        }
        return forms;
    }

    private static String renewMenuId(String appContext) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployAppMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployAppMetadata deployNew = (DeployAppMetadata)serializer.deserializeFromString(appContext, null);
        MetadataSerializer appMetadataSerializer = new MetadataSerializer("AppModel");
        for (AbstractDesignMeta designMeta : deployNew.getDesignMetas()) {
            AppMetadata appMetadata = (AppMetadata)appMetadataSerializer.deserializeFromXml(designMeta.getDataXml(), null);
            NewIdInfo newMenuIdInfo = new NewIdInfo();
            for (AppMenuElement appMenu : appMetadata.getAppMenus()) {
                NewIdInfo newIdInfo = new NewIdInfo();
                newIdInfo.setOldId(appMenu.getId());
                String newId = FormMetaUtil.genIdUrlFriendly();
                appMenu.setId(newId);
                appMenu.setNumber(newId);
                newIdInfo.setNewId(newId);
                newMenuIdInfo.getChildIds().add(newIdInfo);
            }
            for (AppMenuElement appMenu : appMetadata.getAppMenus()) {
                if (!kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)appMenu.getParentId())) continue;
                appMenu.setParentId(newMenuIdInfo.replaceAll(appMenu.getParentId()));
            }
            designMeta.setDataXml(appMetadataSerializer.buildDiffXml((Object)appMetadata, null));
        }
        return serializer.serializeToString((Object)deployNew, null);
    }

    private static void reImportFormMeta(String appId, List<String> forms, Map<String, Long> modelIdMap) {
        HashSet formIds = new HashSet(forms.size());
        for (String form : forms) {
            boolean needDeploy = false;
            for (Map.Entry<String, Long> idMapEntry : modelIdMap.entrySet()) {
                if (!form.contains(idMapEntry.getKey())) continue;
                form = form.replace(idMapEntry.getKey(), idMapEntry.getValue().toString());
                needDeploy = true;
            }
            if (!needDeploy) continue;
            List ids = MetadataDao.deployMetadata((String)form, null, (String)appId);
            formIds.addAll(ids);
        }
        for (String formId : formIds) {
            MetadataDao.rebuildRuntimeMetaById((String)formId);
        }
    }

    private static void readContent(File file, List<String> list, NewIdInfo newIdMap, Function<String, String> customLine) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                line = newIdMap.replaceAll(line);
                if (customLine != null && line != null) {
                    line = customLine.apply(line);
                }
                builder.append(line);
            }
            list.add(builder.toString());
        }
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        String name = zipEntry.getName();
        if (!(name.endsWith(".sql") || name.endsWith(".json") || name.endsWith(".app") || name.endsWith(".appx") || name.endsWith(".dym") || name.endsWith(".dymx"))) {
            throw new IOException("invalid file:" + name);
        }
        File destFile = new File(destinationDir, name);
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + name);
        }
        return destFile;
    }

    public static Optional<Long> getAppCreator(String appId) {
        DynamicObject app = BusinessDataServiceHelper.loadSingle((Object)appId, (String)"bos_devportal_bizapp", (String)"creater");
        if (Objects.nonNull(app)) {
            return Optional.of(app.getDynamicObject("creater").getLong(PROP_ID));
        }
        return Optional.empty();
    }

    public static class NewIdInfo {
        private String oldId;
        private String newId;
        private List<NewIdInfo> childIds = new ArrayList<NewIdInfo>(10);

        public String getOldId() {
            return this.oldId;
        }

        public void setOldId(String oldId) {
            this.oldId = oldId;
        }

        public String getNewId() {
            return this.newId;
        }

        public void setNewId(String newId) {
            this.newId = newId;
        }

        public List<NewIdInfo> getChildIds() {
            return this.childIds;
        }

        public boolean isDiff() {
            if (this.getOldId() == null && this.getNewId() == null) {
                return false;
            }
            if (this.getOldId() == null && this.getNewId() != null) {
                return true;
            }
            return !this.getOldId().equalsIgnoreCase(this.getNewId());
        }

        public String replaceAll(String str) {
            if (kd.bos.util.StringUtils.isBlank((String)str)) {
                return str;
            }
            if (this.isDiff()) {
                str = str.replaceAll(this.getOldId(), this.getNewId());
            }
            for (NewIdInfo childId : this.getChildIds()) {
                str = childId.replaceAll(str);
            }
            return str;
        }
    }
}

