/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.helper;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;

public class MenuServiceHelper {
    private static final Log log = LogFactory.getLog(MenuServiceHelper.class);

    public static Optional<AppMenuInfo> getMenuInfo(String appId, String formId) {
        List appMenus = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
        for (AppMenuInfo appMenu : appMenus) {
            if (!Objects.equals(appMenu.getFormId(), formId)) continue;
            return Optional.of(appMenu);
        }
        return Optional.empty();
    }

    public static Optional<String> getMenuImage(String appId, String formId) {
        try {
            Instant startTime = Instant.now();
            List appMenus = AppMetadataCache.getAppMenusInfoByAppNum((String)appId);
            Instant endTime = Instant.now();
            log.debug("AppMetadataCache.getAppMenusInfoByAppNum cost: {} ms", (Object)Duration.between(startTime, endTime).toMillis());
            for (AppMenuInfo appMenu : appMenus) {
                if (!Objects.equals(appMenu.getFormId(), formId)) continue;
                String params = appMenu.getParams();
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
                Object image = paramMap.get("image");
                return Objects.isNull(image) ? Optional.of("") : Optional.of((String)image);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            log.debug(e.getMessage(), (Object)e);
            return Optional.empty();
        }
    }
}

