/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.list.config.impl;

import com.cronutils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.nocode.restapi.service.sys.list.config.ListOrderRepository;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ListOrderRepositoryImpl
implements ListOrderRepository {
    public static final String ORDER_INFO = "orderInfo";
    public static final String APP_ID = "appId";
    public static final String FORM_ID = "formId";
    public static final String USER_ID = "userId";

    @Override
    public void save(String appId, String formId, long userId, String orderByInfo) {
        DynamicObject orderByObj = this.getOrderInfoObj(appId, formId, userId);
        if (Objects.isNull(orderByObj)) {
            orderByObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_list_order");
            orderByObj.set(APP_ID, (Object)appId);
            orderByObj.set(FORM_ID, (Object)formId);
            orderByObj.set(USER_ID, (Object)userId);
        }
        orderByObj.set(ORDER_INFO, (Object)orderByInfo);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orderByObj});
    }

    @Override
    public List<Map<String, Object>> getOrderInfo(String appId, String formId, long userId) {
        DynamicObject orderInfoObj = this.getOrderInfoObj(appId, formId, userId);
        if (Objects.isNull(orderInfoObj)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        String orderInfo = orderInfoObj.getString(ORDER_INFO);
        if (StringUtils.isEmpty((CharSequence)orderInfo)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return SerializationUtils.fromJsonStringToList((String)orderInfo, Map.class);
    }

    private DynamicObject getOrderInfoObj(String appId, String formId, long userId) {
        QFilter[] filters = ListConfigUtils.getQFilters((String)appId, (String)formId, (long)userId);
        return BusinessDataServiceHelper.loadSingle((String)"bos_nocode_list_order", (String)ORDER_INFO, (QFilter[])filters);
    }
}

