/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.sys.repository.CardRepository;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardRepositoryImpl
implements CardRepository {
    public static final String SCHEMA_ID = "schemaId";
    public static final String CARD_ID = "cardId";

    @Override
    public void logicDelete(String cardId) {
        DynamicObject updateObj = BusinessDataServiceHelper.loadSingle((Object)cardId, (String)"bos_nocode_card");
        if (Objects.isNull(updateObj)) {
            throw new RestApiException(ResManager.loadKDString((String)"cardId=%s\uff0c\u6570\u636e\u4e0d\u5b58\u5728", (String)"CardRepositoryImpl_0", (String)"bos-nocode-service", (Object[])new Object[]{cardId}));
        }
        updateObj.set("deleted", (Object)Boolean.TRUE);
        SaveServiceHelper.update((DynamicObject)updateObj);
    }

    @Override
    public Set<Long> getCardIdsByUserId(Long userId) {
        QFilter filter = new QFilter("creater", "=", (Object)userId);
        DynamicObject[] cardObjs = BusinessDataServiceHelper.load((String)"bos_nocode_card", (String)"id", (QFilter[])filter.toArray());
        return Arrays.stream(cardObjs).map(e -> e.getLong("id")).collect(Collectors.toSet());
    }

    @Override
    public DynamicObject[] getCards(QFilter filter) {
        return BusinessDataServiceHelper.load((String)"bos_nocode_card", (String)"title,config", (QFilter[])filter.toArray());
    }

    @Override
    public void deleteCards(QFilter filter) {
        DeleteServiceHelper.delete((String)"bos_nocode_card", (QFilter[])filter.toArray());
    }

    @Override
    public long getCardIdByQingCardId(String cardId) {
        QFilter configFilter = QFilter.like((String)"config", (String)cardId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_card", (QFilter[])configFilter.toArray());
        return (Long)dynamicObject.getPkValue();
    }

    @Override
    public Map<String, List<Long>> getCardId2SchemaIds(List<Long> cardIds) {
        HashMap<String, List<Long>> cardId2SchemaIds = new HashMap<String, List<Long>>(cardIds.size());
        QFilter cardFilter = new QFilter(CARD_ID, "in", cardIds);
        DynamicObject[] schemaObjs = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)"cardId,schemaId", (QFilter[])cardFilter.toArray());
        Arrays.stream(schemaObjs).forEach(e -> {
            Long cardId = (Long)e.get(CARD_ID);
            Long schemaId = (Long)e.get(SCHEMA_ID);
            List schemaIds = cardId2SchemaIds.getOrDefault(cardId + "", new ArrayList(10));
            schemaIds.add(schemaId);
            cardId2SchemaIds.put(cardId + "", schemaIds);
        });
        return cardId2SchemaIds;
    }

    @Override
    public List<Long> getSchemaIds(Long cardId) {
        QFilter cardFilter = new QFilter(CARD_ID, "=", (Object)cardId);
        DynamicObject[] schemaObjs = BusinessDataServiceHelper.load((String)"bos_nocode_cardcontainer", (String)SCHEMA_ID, (QFilter[])cardFilter.toArray());
        return Arrays.stream(schemaObjs).map(e -> (Long)e.get(SCHEMA_ID)).collect(Collectors.toList());
    }

    @Override
    public void deleteBySchemaId(long schemaId) {
        QFilter schemaFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{schemaFilter};
        DeleteServiceHelper.delete((String)"bos_nocode_cardcontainer", (QFilter[])filters);
    }
}

