/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.sys.service.impl;

import com.cronutils.utils.StringUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.cache.NoCodeCacheHelper;
import kd.bos.nocode.cache.NoCodeCacheService;
import kd.bos.nocode.enums.ListSchemaHiddenEnum;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.qing.StatCardRepository;
import kd.bos.nocode.restapi.service.sys.common.ListConfigQueryImpl;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class ListSchemaServiceImpl
implements ListSchemaService {
    public static final String ORDER_INFO = "orderInfo";
    private static final Log LOG = LogFactory.getLog(ListSchemaServiceImpl.class);
    public static final int LOCK_TIMEOUT_MILLIS = 3000;
    public static final long DEFAULT_CREATOR = 0L;
    public static final String USER_ID = "userId";
    public static final String FORM_ID = "formId";
    public static final String SCHEMA_ID = "schemaId";
    public static final String ACTIVE = "active";
    public static final String INDEX = "index";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CREATER = "creater";
    public static final String HIDDEN = "hidden";
    public static final String COPY_SCHEMA_ID = "copySchemaId";
    public static final String PAGE_SIZE = "pageSize";
    public static final String LIST_ITEMS = "listItems";
    public static final String FILTER_ROWS = "filterRows";
    public static final String STAT_CARDS = "statCards";
    public static final String SCHEMA_TYPE = "schematype";
    public static final String GANTT_CONFIG = "ganttconfig";
    public static final String GANTT_TIMEMODE = "timemode";
    public static final String SCHEMA_ID_ACTIVE_INDEX = "schemaId,active,index";
    protected static ExecutorService es = ThreadPools.newCachedExecutorService((String)"NoCode-ListSchemaService-Thread", (int)3, (int)6);

    private String getDefaultSchemaName() {
        return "\u5168\u90e8";
    }

    private String getDataNotExistMessage() {
        return "\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee";
    }

    @Override
    public List<Map<String, Object>> get(long userId, String formId) {
        if (!FormMetadataUtils.existByFormId((String)formId)) {
            throw new RestApiException("\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
        }
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userIdFilter, formIdFilter};
        this.createDefaultSchemaIfNotExist(userId, formId);
        DynamicObject[] userSchemaMiddle = BusinessDataServiceHelper.load((String)"bos_nocode_userschema", (String)SCHEMA_ID_ACTIVE_INDEX, (QFilter[])filters);
        Map schemaId2UserSchema = Arrays.stream(userSchemaMiddle).collect(Collectors.toMap(e -> e.getLong(SCHEMA_ID), Function.identity()));
        Set<Long> schemaIds = schemaId2UserSchema.keySet();
        HashSet selectSet = Sets.newHashSet((Object[])new String[]{NAME, USER_ID, FORM_ID, HIDDEN, SCHEMA_TYPE, GANTT_CONFIG, GANTT_TIMEMODE});
        QFilter schemaIdsFilter = new QFilter(ID, "in", schemaIds);
        DynamicObject[] schemas = BusinessDataServiceHelper.load((String)"bos_nocode_list_schema", (String)"name,userId,formId,hidden,schemaType,ganttConfig,timemode", (QFilter[])new QFilter[]{schemaIdsFilter}, (String)"createdate");
        List rows = PropertyHandleUtil.toMapListRoot((String)"bos_nocode_list_schema", (String)"$", (DynamicObject[])schemas, (Set)selectSet);
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)"bos_nocode_list_schema");
        ComboProp schemaTypeProperty = (ComboProp)NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)SCHEMA_TYPE);
        ComboProp timeModeProperty = (ComboProp)NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)GANTT_TIMEMODE);
        for (Map row : rows) {
            Long schemaId = (Long)row.get(ID);
            row.put(ACTIVE, ((DynamicObject)schemaId2UserSchema.get(schemaId)).getBoolean(ACTIVE));
            row.put(INDEX, ((DynamicObject)schemaId2UserSchema.get(schemaId)).getInt(INDEX));
            String ganttConfig = (String)row.get(GANTT_CONFIG);
            if (!StringUtils.isEmpty((CharSequence)ganttConfig)) {
                row.put(GANTT_CONFIG, SerializationUtils.fromJsonString((String)ganttConfig, ArrayList.class));
            }
            String schemaType = (String)row.get(SCHEMA_TYPE);
            row.put(SCHEMA_TYPE, this.getComboItemValue(schemaTypeProperty, schemaType));
            String timeMode = (String)row.get(GANTT_TIMEMODE);
            row.put(GANTT_TIMEMODE, this.getComboItemValue(timeModeProperty, timeMode));
        }
        this.handleActiveStatus(rows);
        rows.sort(Comparator.comparingInt(e -> (Integer)e.get(INDEX)));
        ListConfigQueryImpl listConfigQuery = new ListConfigQueryImpl();
        rows.stream().map(e -> (Long)e.get(ID)).forEach(id -> this.cacheSchemaConfigAsync((long)id, listConfigQuery));
        return rows;
    }

    private Object getComboItemValue(ComboProp comboProperty, String itemName) {
        if (comboProperty.getComboItems().size() == 0) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)itemName)) {
            return ((ValueMapItem)comboProperty.getComboItems().get(0)).getValue();
        }
        Optional<ValueMapItem> first = comboProperty.getComboItems().stream().filter(i -> itemName.equalsIgnoreCase(i.getName().toString())).findFirst();
        return first.map(valueMapItem -> valueMapItem.getValue()).orElse(null);
    }

    private void handleActiveStatus(List<Map<String, Object>> rows) {
        boolean existActive = rows.stream().anyMatch(e -> (Boolean)e.get(ACTIVE));
        if (!existActive) {
            rows.stream().findFirst().ifPresent(e -> e.put(ACTIVE, Boolean.TRUE));
        } else {
            Long activeSchemaId = rows.stream().filter(e -> (Boolean)e.get(ACTIVE)).findFirst().map(e -> (Long)e.get(ID)).orElse(0L);
            if (activeSchemaId != 0L) {
                rows.stream().filter(e -> !((Long)e.get(ID)).equals(activeSchemaId)).forEach(e -> e.put(ACTIVE, Boolean.FALSE));
            }
        }
    }

    private void cacheSchemaConfigAsync(long schemaId, ListConfigQueryImpl listConfigQuery) {
        CompletableFuture.runAsync(() -> listConfigQuery.getListConfigBySchemaId(schemaId, false), es);
    }

    private void createDefaultSchemaIfNotExist(long userId, String formId) {
        if (!this.exist(userId, formId)) {
            DynamicObject listSchemaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_list_schema");
            listSchemaObj.set(FORM_ID, (Object)formId);
            listSchemaObj.set(NAME, (Object)this.getDefaultSchemaName());
            listSchemaObj.set(HIDDEN, (Object)ListSchemaHiddenEnum.NONE.toString());
            listSchemaObj.set(PAGE_SIZE, (Object)20);
            listSchemaObj.set(CREATER, (Object)0L);
            listSchemaObj.set(USER_ID, (Object)userId);
            listSchemaObj.set(SCHEMA_TYPE, (Object)0);
            listSchemaObj.set(GANTT_TIMEMODE, (Object)0);
            this.add0(listSchemaObj, Boolean.TRUE);
        }
    }

    @Override
    public DynamicObject add(Map<String, Object> dataItem) {
        String formId = (String)dataItem.get(FORM_ID);
        String name = (String)dataItem.get(NAME);
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject listSchemaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_list_schema");
        listSchemaObj.set(FORM_ID, (Object)formId);
        listSchemaObj.set(NAME, (Object)name);
        listSchemaObj.set(HIDDEN, (Object)ListSchemaHiddenEnum.NONE.toString());
        listSchemaObj.set(PAGE_SIZE, (Object)20);
        listSchemaObj.set(CREATER, (Object)userId);
        listSchemaObj.set(USER_ID, (Object)userId);
        if (dataItem.containsKey(SCHEMA_TYPE)) {
            listSchemaObj.set(SCHEMA_TYPE, dataItem.get(SCHEMA_TYPE));
        }
        if (dataItem.containsKey(GANTT_CONFIG) && dataItem.get(GANTT_CONFIG) != null) {
            String info = SerializationUtils.toJsonString((Object)dataItem.get(GANTT_CONFIG));
            listSchemaObj.set(GANTT_CONFIG, (Object)info);
        }
        if (dataItem.containsKey(GANTT_TIMEMODE)) {
            listSchemaObj.set(GANTT_TIMEMODE, dataItem.get(GANTT_TIMEMODE));
        }
        listSchemaObj.set(LIST_ITEMS, (Object)SerializationUtils.toJsonString((Object)ListConfigUtils.getListItemConfig((String)formId)));
        return this.add0(listSchemaObj, Boolean.FALSE);
    }

    private DynamicObject add0(DynamicObject listSchemaObj, boolean active) {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{listSchemaObj});
            long userId = listSchemaObj.getLong(USER_ID);
            String formId = listSchemaObj.getString(FORM_ID);
            DynamicObject userSchemaMiddle = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_userschema");
            userSchemaMiddle.set(USER_ID, (Object)userId);
            userSchemaMiddle.set(FORM_ID, listSchemaObj.get(FORM_ID));
            userSchemaMiddle.set(SCHEMA_ID, listSchemaObj.getPkValue());
            userSchemaMiddle.set(ACTIVE, (Object)active);
            userSchemaMiddle.set(INDEX, (Object)(this.getMaxIndex(userId, formId) + 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userSchemaMiddle});
            DynamicObject dynamicObject = listSchemaObj;
            return dynamicObject;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                LOG.debug("\u4fdd\u5b58\u5217\u8868\u89c6\u56fe\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                throw new RestApiException("\u4fdd\u5b58\u5217\u8868\u89c6\u56fe\u5931\u8d25\uff1a%s", new Object[]{e.getMessage()});
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private int getMaxIndex(long userId, String formId) {
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userIdFilter, formIdFilter};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_nocode_userschema", (String)INDEX, (QFilter[])filters, (String)"index desc", (int)1);
        if (CollectionUtils.isEmpty((Collection)query)) {
            return -1;
        }
        return ((DynamicObject)query.get(0)).getInt(INDEX);
    }

    @Override
    public Optional<DynamicObject> getSchemaDetails(long schemaId) {
        QFilter schemaIdFilter = new QFilter(ID, "=", (Object)schemaId);
        return Optional.ofNullable(BusinessDataServiceHelper.loadSingle((String)"bos_nocode_list_schema", (QFilter[])new QFilter[]{schemaIdFilter}));
    }

    @Override
    public DynamicObject update(Map<String, Object> dataItem) {
        String schemaIdStr = (String)dataItem.get(ID);
        long schemaId = Long.parseLong(schemaIdStr);
        QFilter schemaIdFilter = new QFilter(ID, "=", (Object)schemaId);
        DynamicObject schemaObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_list_schema", (QFilter[])new QFilter[]{schemaIdFilter});
        if (Objects.isNull(schemaObj)) {
            throw new RestApiException(this.getDataNotExistMessage());
        }
        String formId = schemaObj.getString(FORM_ID);
        long userId = RequestContext.get().getCurrUserId();
        if (userId != schemaObj.getLong(USER_ID)) {
            throw new RestApiException("\u6ca1\u6709\u6743\u9650\u4fee\u6539\u6b64\u89c6\u56fe");
        }
        if (dataItem.containsKey(NAME)) {
            schemaObj.set(NAME, dataItem.get(NAME));
        }
        if (dataItem.containsKey(HIDDEN)) {
            schemaObj.set(HIDDEN, dataItem.get(HIDDEN));
        }
        if (dataItem.containsKey(PAGE_SIZE)) {
            int pageSize = (Integer)dataItem.get(PAGE_SIZE);
            schemaObj.set(PAGE_SIZE, (Object)pageSize);
        }
        if (dataItem.containsKey(LIST_ITEMS)) {
            String listItems = SerializationUtils.toJsonString((Object)dataItem.get(LIST_ITEMS));
            schemaObj.set(LIST_ITEMS, (Object)listItems);
        }
        if (dataItem.containsKey(FILTER_ROWS)) {
            String filterRows = SerializationUtils.toJsonString((Object)dataItem.get(FILTER_ROWS));
            schemaObj.set(FILTER_ROWS, (Object)filterRows);
        }
        if (dataItem.containsKey(ORDER_INFO) && dataItem.get(ORDER_INFO) != null) {
            String orderInfo = SerializationUtils.toJsonString((Object)dataItem.get(ORDER_INFO));
            schemaObj.set(ORDER_INFO, (Object)orderInfo);
        }
        if (dataItem.containsKey(STAT_CARDS)) {
            StatCardRepository.create().update(schemaId, (List)dataItem.get(STAT_CARDS));
        }
        if (dataItem.containsKey(SCHEMA_TYPE)) {
            schemaObj.set(SCHEMA_TYPE, dataItem.get(SCHEMA_TYPE));
        }
        if (dataItem.containsKey(GANTT_CONFIG) && dataItem.get(GANTT_CONFIG) != null) {
            String info = SerializationUtils.toJsonString((Object)dataItem.get(GANTT_CONFIG));
            schemaObj.set(GANTT_CONFIG, (Object)info);
        }
        if (dataItem.containsKey(GANTT_TIMEMODE)) {
            schemaObj.set(GANTT_TIMEMODE, dataItem.get(GANTT_TIMEMODE));
        }
        if (dataItem.containsKey(ACTIVE)) {
            boolean active = (Boolean)dataItem.get(ACTIVE);
            if (active) {
                this.activate(userId, formId, schemaId);
            } else {
                this.inactivate(userId, formId, schemaId);
            }
        }
        SaveServiceHelper.update((DynamicObject)schemaObj);
        this.clearSchemaConfigCache(userId, formId, schemaId);
        return schemaObj;
    }

    private void clearSchemaConfigCache(long userId, String formId, long schemaId) {
        String listSchemaKey = NoCodeCacheHelper.getCacheKey((String[])new String[]{"list/schema", formId});
        String cacheField = NoCodeCacheHelper.getCacheKey((String[])new String[]{formId, userId + "", schemaId + ""});
        NoCodeCacheService.getInstance().remove(listSchemaKey, cacheField);
    }

    @Override
    public void delete(long schemaId) {
        DynamicObject deleteObj = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"bos_nocode_list_schema");
        if (Objects.isNull(deleteObj)) {
            throw new RestApiException(this.getDataNotExistMessage());
        }
        long userId = RequestContext.get().getCurrUserId();
        if (userId != deleteObj.getLong(USER_ID)) {
            throw new RestApiException("\u6ca1\u6709\u6743\u9650\u5220\u9664\u6b64\u89c6\u56fe");
        }
        String formId = deleteObj.getString(FORM_ID);
        if (this.count(userId, formId) == 1) {
            throw new RestApiException("\u81f3\u5c11\u8981\u5b58\u5728\u4e00\u4e2a\u89c6\u56fe");
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                QFilter userSchemaMiddleFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
                DeleteServiceHelper.delete((String)"bos_nocode_userschema", (QFilter[])userSchemaMiddleFilter.toArray());
                QFilter schemaFilter = new QFilter(ID, "=", (Object)schemaId);
                DeleteServiceHelper.delete((String)"bos_nocode_list_schema", (QFilter[])schemaFilter.toArray());
            }
            catch (Exception e) {
                h.markRollback();
                LOG.debug("\u5220\u9664\u5217\u8868\u89c6\u56fe\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                throw new RestApiException("\u5220\u9664\u5217\u8868\u89c6\u56fe\u5931\u8d25\uff1a%s", new Object[]{e.getMessage()});
            }
        }
    }

    @Override
    public List<Map<String, Object>> getFilterRows(long schemaId) {
        return this.getSchemaDetails(schemaId).map(schemaObj -> {
            String filterRows = schemaObj.getString(FILTER_ROWS);
            if (StringUtils.isEmpty((CharSequence)filterRows)) {
                return new ArrayList(0);
            }
            return SerializationUtils.fromJsonStringToList((String)filterRows, Map.class);
        }).orElseGet(ArrayList::new);
    }

    @Override
    public QFilter[] getSchemaFilters(long schemaId) {
        return this.getSchemaDetails(schemaId).map(schemaObj -> {
            String formId = schemaObj.getString(FORM_ID);
            String filterRowsStr = schemaObj.getString(FILTER_ROWS);
            if (StringUtils.isEmpty((CharSequence)filterRowsStr)) {
                return new QFilter[0];
            }
            List filterRows = SerializationUtils.fromJsonStringToList((String)filterRowsStr, Map.class);
            String s = ListFilterConfigUtils.buildFilter(filterRows, formId);
            Object[] filters = FilterUtil.getQFilters(formId, s);
            if (ArrayUtils.isEmpty((Object[])filters)) {
                return new QFilter[0];
            }
            return filters;
        }).orElseGet(() -> new QFilter[0]);
    }

    @Override
    public boolean isDefaultSchema(DynamicObject schemaDetails) {
        return Objects.nonNull(schemaDetails) && Objects.isNull(schemaDetails.get(CREATER));
    }

    @Override
    public DynamicObject copy(Map<String, Object> dataItem) {
        long userId = RequestContext.get().getCurrUserId();
        String copySchemaIdStr = (String)dataItem.get(COPY_SCHEMA_ID);
        Long copySchemaId = Long.parseLong(copySchemaIdStr);
        QFilter schemaIdFilter = new QFilter(ID, "=", (Object)copySchemaId);
        DynamicObject schemaObj = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_list_schema", (QFilter[])new QFilter[]{schemaIdFilter});
        if (Objects.isNull(schemaObj)) {
            throw new RestApiException(this.getDataNotExistMessage());
        }
        DynamicObject targetSchemaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_list_schema");
        String formId = schemaObj.getString(FORM_ID);
        targetSchemaObj.set(FORM_ID, (Object)formId);
        targetSchemaObj.set(NAME, dataItem.get(NAME));
        targetSchemaObj.set(HIDDEN, schemaObj.get(HIDDEN));
        targetSchemaObj.set(PAGE_SIZE, schemaObj.get(PAGE_SIZE));
        String sourceListItems = schemaObj.getString(LIST_ITEMS);
        targetSchemaObj.set(LIST_ITEMS, (Object)(StringUtils.isEmpty((CharSequence)sourceListItems) ? SerializationUtils.toJsonString((Object)ListConfigUtils.getListItemConfig((String)formId)) : sourceListItems));
        targetSchemaObj.set(FILTER_ROWS, schemaObj.get(FILTER_ROWS));
        targetSchemaObj.set(ORDER_INFO, schemaObj.get(ORDER_INFO));
        targetSchemaObj.set(STAT_CARDS, schemaObj.get(STAT_CARDS));
        targetSchemaObj.set(SCHEMA_TYPE, schemaObj.get(SCHEMA_TYPE));
        targetSchemaObj.set(GANTT_CONFIG, schemaObj.get(GANTT_CONFIG));
        targetSchemaObj.set(GANTT_TIMEMODE, schemaObj.get(GANTT_TIMEMODE));
        targetSchemaObj.set(CREATER, (Object)userId);
        targetSchemaObj.set(USER_ID, (Object)userId);
        return this.add0(targetSchemaObj, Boolean.FALSE);
    }

    @Override
    public boolean exist(long userId, String formId) {
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userIdFilter, formIdFilter};
        return ORM.create().exists("bos_nocode_userschema", filters);
    }

    @Override
    public void activate(long userId, String formId, long schemaId) {
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userIdFilter, formIdFilter};
        this.createDefaultSchemaIfNotExist(userId, formId);
        DynamicObject[] userSchemaMiddle = BusinessDataServiceHelper.load((String)"bos_nocode_userschema", (String)SCHEMA_ID_ACTIVE_INDEX, (QFilter[])filters);
        Arrays.stream(userSchemaMiddle).forEach(e -> e.set(ACTIVE, (Object)(e.getLong(SCHEMA_ID) == schemaId ? 1 : 0)));
        SaveServiceHelper.update((DynamicObject[])userSchemaMiddle);
    }

    private void inactivate(long userId, String formId, long schemaId) {
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter schemaIdFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter[] filters = new QFilter[]{userIdFilter, formIdFilter, schemaIdFilter};
        DynamicObject userSchemaMiddle = BusinessDataServiceHelper.loadSingle((String)"bos_nocode_userschema", (String)SCHEMA_ID_ACTIVE_INDEX, (QFilter[])filters);
        userSchemaMiddle.set(ACTIVE, (Object)Boolean.FALSE);
        SaveServiceHelper.update((DynamicObject)userSchemaMiddle);
    }

    @Override
    @NotNull
    public Map<String, Object> getActiveSchema(long userId, String formId) {
        List<Map<String, Object>> allSchemas = this.get(userId, formId);
        return allSchemas.stream().filter(e -> (Boolean)e.get(ACTIVE)).findFirst().orElseThrow(() -> new RestApiException("\u6ca1\u6709\u6fc0\u6d3b\u7684\u89c6\u56fe"));
    }

    @Override
    public long getActiveSchemaId(long userId, String formId) {
        return (Long)this.getActiveSchema(userId, formId).get(ID);
    }

    @Override
    public int count(long userId, String formId) {
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userIdFilter, formIdFilter};
        return ORM.create().count("ListSchemaServiceImpl.count", "bos_nocode_userschema", filters);
    }
}

