/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.nocode.restapi.constant.CardRefTypeEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CardRefHelper {
    public static final String USER_ID = "userid";
    public static final String SCHEMA_ID = "schemaid";
    public static final String APP_ID = "appid";
    public static final String FORM_ID = "formid";
    public static final String CARD_ID = "cardid";
    public static final String TYPE = "type";

    public static void saveStartPageRef(long userId, long schemaId, long cardId) {
        CardRefHelper.saveRefInternal(userId, schemaId, "0", "0", cardId, CardRefTypeEnum.START_PAGE);
    }

    public static void saveFormRef(long userId, String appId, String formId, long cardId) {
        CardRefHelper.saveRefInternal(userId, 0L, appId, formId, cardId, CardRefTypeEnum.FORM);
    }

    private static void saveRefInternal(long userId, long schemaId, String appId, String formId, long cardId, CardRefTypeEnum refTypeEnum) {
        DynamicObject refObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_nocode_cardref");
        refObj.set(USER_ID, (Object)userId);
        refObj.set(SCHEMA_ID, (Object)schemaId);
        refObj.set(APP_ID, (Object)appId);
        refObj.set(FORM_ID, (Object)formId);
        refObj.set(CARD_ID, (Object)cardId);
        refObj.set(TYPE, (Object)refTypeEnum.getFlag());
        SaveServiceHelper.save((IDataEntityType)refObj.getDataEntityType(), (Object[])new Object[]{refObj});
    }

    public static void deleteStartPageRef(long userId, long schemaId, long cardId) {
        CardRefHelper.deleteRefInternal(userId, cardId, "0", "0", schemaId, CardRefTypeEnum.START_PAGE);
    }

    public static void deleteFormRef(long userId, long cardId, String appId, String formId) {
        CardRefHelper.deleteRefInternal(userId, cardId, appId, formId, 0L, CardRefTypeEnum.FORM);
    }

    private static void deleteRefInternal(long userId, long cardId, String appId, String formId, long schemaId, CardRefTypeEnum refTypeEnum) {
        QFilter userIdFilter = new QFilter(USER_ID, "=", (Object)userId);
        QFilter schemaIdFilter = new QFilter(SCHEMA_ID, "=", (Object)schemaId);
        QFilter appIdFilter = new QFilter(APP_ID, "=", (Object)appId);
        QFilter formIdFilter = new QFilter(FORM_ID, "=", (Object)formId);
        QFilter cardIdFilter = new QFilter(CARD_ID, "=", (Object)cardId);
        QFilter typeFilter = new QFilter(TYPE, "=", (Object)refTypeEnum.getFlag());
        QFilter[] filters = new QFilter[]{userIdFilter, cardIdFilter, appIdFilter, formIdFilter, typeFilter, schemaIdFilter};
        DeleteServiceHelper.delete((String)"bos_nocode_cardref", (QFilter[])filters);
    }
}

