/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.restapi.vo.ExportConfig;

public class ExportContext {
    private static final String REGION_KEY = "nocode-ExportContext";
    private static final int CACHE_KEY_MENUS_TIMEOUT = 1800;
    private static final String CACHE_KEY_PROGRESS = "progress";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("nocode-ExportContext", new DistributeCacheHAPolicy());
    private final ExportConfig config;
    private final AtomicBoolean taskCancelFlag = new AtomicBoolean(false);

    public double getProgress(String taskId) {
        String sProgress = (String)cache.get(CACHE_KEY_PROGRESS + taskId);
        if (StringUtils.isBlank((CharSequence)sProgress)) {
            return 0.0;
        }
        return Double.parseDouble(sProgress);
    }

    public void setProgress(double progress, String taskId) {
        if (progress > 0.0) {
            cache.put(CACHE_KEY_PROGRESS + taskId, (Object)String.valueOf(progress), 1800);
        }
    }

    public ExportConfig getConfig() {
        return this.config;
    }

    public ExportContext(ExportConfig config) {
        this.config = config;
    }

    public boolean isTaskCanceled() {
        return this.taskCancelFlag.get();
    }

    public boolean cancelTask() {
        return this.taskCancelFlag.compareAndSet(false, true);
    }
}

