/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.util.DataSetBuilder;
import kd.bos.nocode.restapi.service.util.ExportContext;
import kd.bos.nocode.restapi.vo.ExportConfig;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportHelper {
    private static final ExecutorService pool = ThreadPools.newCachedExecutorService((String)"NoCodeExporter", (int)3, (int)6);
    private static final Log logger = LogFactory.getLog(ExportHelper.class);
    private static final Map<String, ExportContext> contextMap = new ConcurrentHashMap<String, ExportContext>();
    private static final String FORM_RECORD = "bos_nocode_export_record";
    private static final int MAX_BATCH_EXPORT_COUNT = 1040000;
    private static final int FLUSH_BATCH_COUNT = 1000;
    private static final int FLUSH_BATCH_COUNT_ATT = 100;
    private static final String ATT_ENTITYID = "bd_attachment";
    private DataSetBuilder dataSetBuilder;

    public void setDataSetBuilder(DataSetBuilder dataSetBuilder) {
        this.dataSetBuilder = dataSetBuilder;
    }

    public String submit(ExportConfig config) {
        if (this.dataSetBuilder == null) {
            throw new RestApiException("dataSet constructor can not be null");
        }
        String uuid = UUID.randomUUID().toString();
        ExportContext context = new ExportContext(config);
        contextMap.put(uuid, context);
        this.insertRecord(uuid);
        Runnable runnableTask = config.isAttachmentExport() ? new ExportAttachmentTask(this.dataSetBuilder, uuid, context, config) : new ExportExcelTask(this.dataSetBuilder, uuid, context, config);
        pool.execute(runnableTask);
        return uuid;
    }

    private static void save2Sheet(ExportConfig config, Map<Long, SXSSFRow> rowBuff, Map<String, Object> temp, SXSSFWorkbook wb) {
        DynamicObject[] ds;
        if (rowBuff.isEmpty()) {
            return;
        }
        Set<Long> pks = rowBuff.keySet();
        MainEntityType type = config.getType();
        for (DynamicObject dy : ds = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)type)) {
            temp.clear();
            for (String key : config.getColSeq()) {
                config.getFormatter().format(dy, key, temp);
            }
            Long id = dy.getLong("id");
            SXSSFRow r = rowBuff.get(id);
            for (int i = 0; i < config.getColSeq().size(); ++i) {
                String key = config.getColSeq().get(i);
                SXSSFCell cell = r.createCell(i);
                Object value = temp.get(key);
                if (value != null) {
                    cell.setCellValue(value.toString());
                }
                CellStyle cellStyle = wb.createCellStyle();
                DataFormat format = wb.createDataFormat();
                cellStyle.setDataFormat(format.getFormat("@"));
                cell.setCellStyle(cellStyle);
            }
        }
    }

    private void reportCancel(String uuid) {
        DynamicObject dao = BusinessDataServiceHelper.loadSingle((Object)uuid, (String)FORM_RECORD);
        dao.set("status", (Object)TaskStatus.canceled.code);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dao});
    }

    private void reportError(String uuid, String message) {
        DynamicObject dao = BusinessDataServiceHelper.loadSingle((Object)uuid, (String)FORM_RECORD);
        dao.set("status", (Object)TaskStatus.error.code);
        dao.set("extra", (Object)("traceId:" + RequestContext.get().getTraceId() + "\n" + message));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dao});
    }

    private void reportSuccess(String uuid, long start, List<String> urls) {
        DynamicObject dao = BusinessDataServiceHelper.loadSingle((Object)uuid, (String)FORM_RECORD);
        dao.set("status", (Object)TaskStatus.finished.code);
        dao.set("starttime", (Object)start);
        dao.set("endtime", (Object)System.currentTimeMillis());
        dao.set("extra", (Object)"export success");
        dao.set("urls", (Object)SerializationUtils.toJsonString(urls));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dao});
    }

    private void insertRecord(String uuid) {
        DynamicObject dao = BusinessDataServiceHelper.newDynamicObject((String)FORM_RECORD);
        dao.set("id", (Object)uuid);
        dao.set("createrfield", (Object)RequestContext.get().getCurrUserId());
        dao.set("status", (Object)TaskStatus.submit.code);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dao});
    }

    /*
     * Exception decompiling
     */
    private String uploadFile(String uuid, String fileName, SXSSFWorkbook wb) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean cancel(String taskId) {
        ExportContext context = contextMap.get(taskId);
        if (context != null) {
            return context.cancelTask();
        }
        return false;
    }

    public static double getProgress(String taskId) {
        ExportContext context = contextMap.get(taskId);
        if (context != null) {
            double progress = context.getProgress(taskId);
            return progress;
        }
        return 0.0;
    }

    private void createTableHead(MainEntityType dataEntityType, SXSSFSheet sheet, ExportConfig config) throws IOException {
        Map fields = dataEntityType.getFields();
        CellStyle style = this.getHeadColumnStyle(sheet.getWorkbook());
        SXSSFRow row = sheet.createRow(0);
        if (config == null || config.getColSeq().isEmpty()) {
            int cn = 0;
            for (IDataEntityProperty field : fields.values()) {
                SXSSFCell cell = row.createCell(cn++);
                cell.setCellValue(field.getDisplayName().getLocaleValue());
                cell.setCellStyle(style);
            }
        } else {
            List<String> colSeq = config.getColSeq();
            for (int i = 0; i < colSeq.size(); ++i) {
                SXSSFCell cell = row.createCell(i);
                cell.setCellValue(((IDataEntityProperty)fields.get(colSeq.get(i))).getDisplayName().getLocaleValue());
                cell.setCellStyle(style);
            }
        }
        sheet.flushRows();
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        Font font = wb.createFont();
        font.setBold(true);
        headColumnStyle.setFont(font);
        return headColumnStyle;
    }

    public class ExportAttachmentTask
    implements Runnable {
        private DataSetBuilder dataSetBuilder;
        private String uuid;
        private ExportContext context;
        private ExportConfig config;

        public ExportAttachmentTask(DataSetBuilder dataSetBuilder, String uuid, ExportContext context, ExportConfig config) {
            this.dataSetBuilder = dataSetBuilder;
            this.uuid = uuid;
            this.context = context;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            ArrayList<String> urls = new ArrayList<String>();
            try (DataSet dataSet = this.dataSetBuilder.build();
                 DataSet copy = dataSet.copy();){
                String col1 = copy.getRowMeta().getFields()[0].getName();
                long total = copy.count(col1, false);
                if (total == 0L) {
                    throw new RestApiException("there is no data to export");
                }
                MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)this.config.getFormId());
                long processCount = 0L;
                ArrayList<Object> attRefIds = new ArrayList<Object>(100);
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    for (String field : this.config.getColSeq()) {
                        Object attRefId = row.get(field);
                        attRefIds.add(attRefId);
                    }
                    ++processCount;
                    if (attRefIds.size() < 100) continue;
                    String sError = this.doProcAtt(attRefIds, urls);
                    if (StringUtils.isNotBlank((CharSequence)sError)) {
                        ExportHelper.this.reportError(this.uuid, sError);
                        break;
                    }
                    attRefIds.clear();
                    this.context.setProgress(0.5 * ((double)processCount / (double)total), this.uuid);
                }
                if (attRefIds.size() > 0) {
                    String sError = this.doProcAtt(attRefIds, urls);
                    if (StringUtils.isNotBlank((CharSequence)sError)) {
                        ExportHelper.this.reportError(this.uuid, sError);
                        return;
                    }
                    attRefIds.clear();
                }
                this.context.setProgress(0.5, this.uuid);
                if (!this.context.isTaskCanceled()) {
                    String formCaption = NcEntityTypeUtil.getFormCaption((String)this.config.getFormId());
                    String zipFileName = this.getZipFileName(dt, formCaption);
                    String zipUrl = this.zipAttachment(zipFileName, formCaption, urls);
                    this.context.setProgress(0.9, this.uuid);
                    ArrayList<String> attUrl = new ArrayList<String>(0);
                    attUrl.add(zipUrl);
                    ExportHelper.this.reportSuccess(this.uuid, start, attUrl);
                }
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
                ExportHelper.this.reportError(this.uuid, e.getMessage());
            }
            finally {
                contextMap.remove(this.uuid);
            }
        }

        private String doProcAtt(List<Object> attRefIds, List<String> urls) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(1);
            filters.add(new QFilter("id", "in", attRefIds));
            DynamicObjectCollection attObjColl = QueryServiceHelper.query((String)ExportHelper.ATT_ENTITYID, (String)"id,url", (QFilter[])filters.toArray(new QFilter[filters.size()]));
            for (Object attRefId : attRefIds) {
                Optional<DynamicObject> first = attObjColl.stream().filter(a -> a.get("id").equals(attRefId)).findFirst();
                if (!first.isPresent()) continue;
                urls.add(first.get().getString("url"));
            }
            return null;
        }

        private String getZipFileName(MainEntityType dt, String formCaption) {
            String displayName;
            IDataEntityProperty property;
            StringBuilder sb = new StringBuilder();
            sb.append(formCaption);
            if (this.config.getColSeq().size() == 1 && (property = dt.findProperty(this.config.getColSeq().get(0))) != null && StringUtils.isNotBlank((CharSequence)(displayName = property.getDisplayName().toString()))) {
                sb.append("-").append(displayName);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String currDateTime = dateFormat.format(new Date());
            sb.append("-").append(currDateTime);
            return sb.toString();
        }

        /*
         * Exception decompiling
         */
        private String zipAttachment(String fileName, String formCaption, List<String> urls) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String getUniqueFileName(String fileName, Set<String> fileNames) {
            if (fileNames.isEmpty() || !fileNames.contains(fileName) || StringUtils.isBlank((CharSequence)fileName)) {
                return fileName;
            }
            String name = kd.bos.orm.util.StringUtils.stripFilenameExtension((String)fileName);
            String ext = kd.bos.orm.util.StringUtils.getFilenameExtension((String)fileName);
            if (StringUtils.isNotBlank((CharSequence)ext)) {
                ext = "." + ext;
            }
            int idx = 1;
            String newFileName = String.format("%s(%s)%s", name, idx, ext);
            while (fileNames.contains(newFileName)) {
                newFileName = String.format("%s(%s)%s", name, ++idx, ext);
            }
            return newFileName;
        }

        protected String getExportFilePath(String fileName) {
            RequestContext ctx = RequestContext.getOrCreate();
            String dateStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String uuid = UUID.randomUUID().toString();
            return String.format("/%s/%s/%s/%s/%s/%s", ctx.getTenantId(), ctx.getAccountId(), dateStr, "nocodeAttExpor", uuid, fileName);
        }

        private String getTempDir() {
            return System.getProperty("java.io.tmpdir");
        }

        private void saveUrlsToDB(List<String> urls) {
            try {
                String tableName = "t_bas_report_files_path";
                Date date = new Date();
                ArrayList<SqlParameter[]> sqlParams = new ArrayList<SqlParameter[]>(urls.size());
                for (String url : urls) {
                    RequestContext rc = RequestContext.get();
                    SqlParameter[] params = new SqlParameter[6];
                    long id = IDService.get().genLongId(rc.getAccountId(), tableName);
                    params[0] = new SqlParameter(":FID", -5, (Object)id);
                    params[1] = new SqlParameter(":FTENANTID", 12, (Object)rc.getTenantId());
                    params[2] = new SqlParameter(":FACCOUNTID", 12, (Object)rc.getAccountId());
                    params[3] = new SqlParameter(":FPATH", -9, (Object)url);
                    params[4] = new SqlParameter(":FCREATORID", -5, (Object)rc.getCurrUserId());
                    params[5] = new SqlParameter(":FCREATETIME", 93, (Object)date);
                    sqlParams.add(params);
                }
                if (sqlParams.isEmpty()) {
                    return;
                }
                try (TXHandle h = TX.notSupported((String)"reportExport");){
                    String sql = String.format("INSERT INTO %s (FID,FTENANTID,FACCOUNTID,FPATH,FCREATORID,FCREATETIME) VALUES (?, ?, ?, ?, ?, ?) ", tableName);
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, sqlParams);
                }
            }
            catch (Exception e) {
                logger.debug(String.format("\u63d2\u5165\u62a5\u8868\u6587\u4ef6\u8bb0\u5f55\u8868\u62a5\u9519\uff0c\u5171%s\u6761\u8bb0\u5f55\uff0c\u6587\u4ef6\u5730\u5740\u4e3a\uff1a%s", urls.size(), Arrays.toString(urls.toArray())), (Object)e);
            }
        }
    }

    public class ExportExcelTask
    implements Runnable {
        private DataSetBuilder dataSetBuilder;
        private String uuid;
        private ExportContext context;
        private ExportConfig config;

        public ExportExcelTask(DataSetBuilder dataSetBuilder, String uuid, ExportContext context, ExportConfig config) {
            this.dataSetBuilder = dataSetBuilder;
            this.uuid = uuid;
            this.context = context;
            this.config = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            ArrayList<String> urls = new ArrayList<String>();
            try (DataSet dataSet = this.dataSetBuilder.build();
                 DataSet copy = dataSet.copy();){
                String col1 = copy.getRowMeta().getFields()[0].getName();
                long total = copy.count(col1, false);
                if (total == 0L) {
                    throw new RestApiException("there is no data to export");
                }
                LinkedHashMap<Long, SXSSFRow> rowBuff = new LinkedHashMap<Long, SXSSFRow>(1024);
                HashMap temp = new HashMap(16);
                int fileCount = 0;
                long processCount = 0L;
                block23: while (dataSet.hasNext()) {
                    SXSSFWorkbook wb = new SXSSFWorkbook(-1);
                    SXSSFSheet sheet = wb.createSheet("sheet1");
                    sheet.trackAllColumnsForAutoSizing();
                    ExportHelper.this.createTableHead(this.config.getType(), sheet, this.config);
                    int count = 0;
                    int lastRowNum = 1;
                    while (dataSet.hasNext() && count++ < 1040000) {
                        Row row = dataSet.next();
                        rowBuff.put(row.getLong(0), sheet.createRow(lastRowNum++));
                        if (rowBuff.size() <= 1000) continue;
                        if (this.context.isTaskCanceled()) {
                            ExportHelper.this.reportCancel(this.uuid);
                            break block23;
                        }
                        ExportHelper.save2Sheet(this.config, rowBuff, temp, wb);
                        sheet.flushRows();
                        this.context.setProgress((double)(processCount += 1000L) / (double)total, this.uuid);
                        rowBuff.clear();
                    }
                    ExportHelper.save2Sheet(this.config, rowBuff, temp, wb);
                    sheet.flushRows();
                    rowBuff.clear();
                    for (int i = 0; i < this.config.getColSeq().size(); ++i) {
                        sheet.autoSizeColumn(i);
                        int width = Math.max(3840, Math.min(65280, sheet.getColumnWidth(i) * 12 / 10));
                        sheet.setColumnWidth(i, width);
                    }
                    String name = this.config.getType().getDisplayName().getLocaleValue();
                    String fileName = name + (fileCount++ > 0 ? "" + fileCount : "") + ".xlsx";
                    urls.add(ExportHelper.this.uploadFile(this.uuid, fileName, wb));
                }
                if (!this.context.isTaskCanceled()) {
                    this.context.setProgress(0.999, this.uuid);
                    ExportHelper.this.reportSuccess(this.uuid, start, urls);
                }
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
                ExportHelper.this.reportError(this.uuid, e.getMessage());
            }
            finally {
                contextMap.remove(this.uuid);
            }
        }
    }

    public static enum TaskStatus {
        submit(1),
        finished(2),
        canceled(3),
        error(4);

        int code;

        private TaskStatus(int code) {
            this.code = code;
        }

        public static TaskStatus find(int value) {
            for (TaskStatus status : TaskStatus.values()) {
                if (status.code != value) continue;
                return status;
            }
            return null;
        }
    }
}

