/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Pair;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.core.util.QFilterUtil;
import kd.bos.nocode.restapi.service.query.g.FilterVisitor;
import kd.bos.nocode.restapi.service.sys.service.ListSchemaService;
import kd.bos.nocode.restapi.service.util.FuzzySearchUtils;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class FilterUtil {
    private static final ListSchemaService LIST_SCHEMA_SERVICE = ListSchemaService.create();
    private static final List<String> COMPARE_TYPE_IDS = Arrays.asList(CompareTypeEnum.EQUAL.getId(), CompareTypeEnum.NOTEQUAL.getId(), CompareTypeEnum.LIKE.getId(), CompareTypeEnum.NOTLIKE.getId(), CompareTypeEnum.LEFTLIKE.getId(), CompareTypeEnum.RIGHTLIKE.getId(), CompareTypeEnum.GREATER.getId(), CompareTypeEnum.LESS.getId(), CompareTypeEnum.GREATEROREQUAL.getId(), CompareTypeEnum.LESSOREQUAL.getId());

    private FilterUtil() {
    }

    public static QFilter[] getQFilters(String formId, String filterStr, String searchText) {
        return FilterUtil.getQFilters(formId, filterStr, searchText, false);
    }

    public static QFilter[] getQFilters(String formId, String filterStr, String searchText, boolean origin) {
        QFilter searchQFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (!origin) {
            FilterUtil.handleOrgOrUserFilter(formId, filters);
        }
        if (StringUtils.isEmpty((String)filterStr) && StringUtils.isEmpty((String)searchText)) {
            return filters.toArray(new QFilter[0]);
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber((String)formId));
        if (StringUtils.isNotEmpty((String)filterStr)) {
            FilterVisitor.mainEntityType.set(dt);
            QFilter filter = FilterVisitor.Parse(filterStr.trim());
            if (Objects.nonNull(filter)) {
                filters.add(filter);
            }
        }
        if (StringUtils.isNotEmpty((String)searchText) && Objects.nonNull(searchQFilter = FilterUtil.getSearchQFilter(searchText, formId))) {
            filters.add(searchQFilter);
        }
        return filters.toArray(new QFilter[0]);
    }

    public static QFilter[] getQFilters(String formId, String filterStr) {
        return FilterUtil.getQFilters(formId, filterStr, false);
    }

    public static QFilter[] getQFilters(String formId, String filterStr, boolean origin) {
        return FilterUtil.getQFilters(formId, filterStr, null, origin);
    }

    public static Pair<Boolean, QFilter[]> getQFilters(RestApiParam<Map<String, Object>> apiParam) {
        QFilter searchQFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        Map httpQueryString = apiParam.getRequest().getHttpQueryString();
        String filterParam = apiParam.getRequest().getFilter();
        String formId = apiParam.getRequest().getFormId();
        MainEntityType dt = null;
        if (StringUtil.isNotEmpty((String)filterParam)) {
            if (dt == null) {
                dt = EntityMetadataCache.getDataEntityType((String)formId);
            }
            FilterVisitor.mainEntityType.set(dt);
            QFilter qFitler = FilterVisitor.Parse(filterParam.trim());
            if (qFitler != null) {
                qFilters.add(qFitler);
            }
        }
        FilterUtil.handleOrgOrUserFilter(apiParam, qFilters);
        String searchText = (String)httpQueryString.get("search");
        if (StringUtils.isNotEmpty((String)searchText) && Objects.nonNull(searchQFilter = FilterUtil.getSearchQFilter(searchText, apiParam.getFormId()))) {
            qFilters.add(searchQFilter);
        }
        if (!apiParam.getSelectedIds().isEmpty()) {
            if (dt == null) {
                dt = EntityMetadataCache.getDataEntityType((String)formId);
            }
            Object[] selectedPks = new Object[apiParam.getSelectedIds().size()];
            for (int i = 0; i < apiParam.getSelectedIds().size(); ++i) {
                selectedPks[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, apiParam.getSelectedIds().get(i));
            }
            String pkName = "id";
            if (dt.getPrimaryKey() != null) {
                pkName = dt.getPrimaryKey().getName();
            }
            QFilter idsQFilter = new QFilter(pkName, "not in", (Object)selectedPks);
            if (qFilters.isEmpty()) {
                qFilters.add(idsQFilter);
            } else {
                QFilter qFilterResult = null;
                for (QFilter qFilter : qFilters) {
                    qFilterResult = kd.bos.entity.filter.FilterUtil.combineFilter((QFilter)qFilterResult, (QFilter)qFilter);
                }
                qFilterResult = kd.bos.entity.filter.FilterUtil.combineFilter(qFilterResult, (QFilter)idsQFilter, (LogicOperate)LogicOperate.AND);
                qFilters.clear();
                qFilters.add(qFilterResult);
            }
        }
        QFilter[] fitlerArray = qFilters.toArray(new QFilter[0]);
        return new Pair((Object)false, (Object)fitlerArray);
    }

    private static void handleOrgOrUserFilter(RestApiParam<Map<String, Object>> param, List<QFilter> qFilters) {
        String scope = param.getRequest().getHttpQueryString().getOrDefault("withScope", "false");
        FilterUtil.handleOrgOrUserFilter(param.getFormId(), qFilters, scope);
    }

    private static void handleOrgOrUserFilter(String formId, List<QFilter> qFilters) {
        FilterUtil.handleOrgOrUserFilter(formId, qFilters, null);
    }

    private static void handleOrgOrUserFilter(String formId, List<QFilter> qFilters, String scope) {
        boolean flag = "true".equals(scope) && !NoCodePermHelper.checkUserPlatManageInNoCode();
        long uid = RequestContext.get().getCurrUserId();
        if ("bos_adminorg".equalsIgnoreCase(NcEntityTypeUtil.getRealBillEntityNumber((String)formId))) {
            qFilters.addAll(QFilterUtil.getOrgEmbeddedFilters());
            if (flag) {
                QFilter orgFilter = NoCodePermissionServiceHelper.getSystemRoleOrgFilter((long)uid, (boolean)true);
                qFilters.add(orgFilter);
            }
        } else if ("bos_user".equalsIgnoreCase(NcEntityTypeUtil.getRealBillEntityNumber((String)formId))) {
            qFilters.addAll(QFilterUtil.getUserEmbeddedFilters());
            if (flag) {
                QFilter userFilter = NoCodePermissionServiceHelper.getSystemRoleUserFilter((long)uid, (boolean)true);
                qFilters.add(userFilter);
            }
        }
    }

    public static Pair<Boolean, QFilter[]> getQFilters(RestApiParam<Map<String, Object>> apiParam, Set<String> searchFields) {
        QFilter searchQFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        Map httpQueryString = apiParam.getRequest().getHttpQueryString();
        String filterParam = apiParam.getRequest().getFilter();
        String formId = apiParam.getRequest().getFormId();
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        MainEntityType dt = null;
        if (StringUtil.isNotEmpty((String)filterParam)) {
            if (dt == null) {
                dt = EntityMetadataCache.getDataEntityType((String)formNumber);
            }
            FilterVisitor.mainEntityType.set(dt);
            QFilter qFitler = FilterVisitor.Parse(filterParam.trim());
            if (qFitler != null) {
                qFilters.add(qFitler);
            }
        }
        FilterUtil.handleOrgOrUserFilter(apiParam, qFilters);
        String searchText = (String)httpQueryString.get("search");
        if (StringUtils.isNotEmpty((String)searchText) && Objects.nonNull(searchQFilter = FilterUtil.getSearchQFilter(searchText, apiParam.getFormId(), searchFields))) {
            qFilters.add(searchQFilter);
        }
        if (!apiParam.getSelectedIds().isEmpty()) {
            if (dt == null) {
                dt = EntityMetadataCache.getDataEntityType((String)formNumber);
            }
            Object[] selectedPks = new Object[apiParam.getSelectedIds().size()];
            for (int i = 0; i < apiParam.getSelectedIds().size(); ++i) {
                selectedPks[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, apiParam.getSelectedIds().get(i));
            }
            String pkName = "id";
            if (dt.getPrimaryKey() != null) {
                pkName = dt.getPrimaryKey().getName();
            }
            QFilter idsQFilter = new QFilter(pkName, "not in", (Object)selectedPks);
            if (qFilters.isEmpty()) {
                qFilters.add(idsQFilter);
            } else {
                QFilter qFilterResult = null;
                for (QFilter qFilter : qFilters) {
                    qFilterResult = kd.bos.entity.filter.FilterUtil.combineFilter((QFilter)qFilterResult, (QFilter)qFilter);
                }
                qFilterResult = kd.bos.entity.filter.FilterUtil.combineFilter(qFilterResult, (QFilter)idsQFilter, (LogicOperate)LogicOperate.AND);
                qFilters.clear();
                qFilters.add(qFilterResult);
            }
        }
        QFilter[] fitlerArray = qFilters.toArray(new QFilter[0]);
        return new Pair((Object)false, (Object)fitlerArray);
    }

    private static void handleListSchemaFilter(RestApiParam<Map<String, Object>> apiParam, List<QFilter> qFilters) {
        Map httpQueryString = apiParam.getRequest().getHttpQueryString();
        String schemaId = (String)httpQueryString.get("schemaId");
        if (StringUtils.isNotEmpty((String)schemaId)) {
            String formId = apiParam.getFormId();
            List<Map<String, Object>> filterRows = LIST_SCHEMA_SERVICE.getFilterRows(Long.parseLong(schemaId));
            String filterStr = ListFilterConfigUtils.buildFilter(filterRows, formId);
            Object[] defaultFilters = FilterUtil.getQFilters(formId, filterStr);
            CollectionUtils.addAll(qFilters, (Object[])defaultFilters);
        }
    }

    private static QFilter getSearchQFilter(String searchText, String formId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection properties = dt.getProperties();
        return FuzzySearchUtils.getSearchQFilter(formId, (Collection<IDataEntityProperty>)properties, searchText);
    }

    private static QFilter getSearchQFilter(String searchText, String formId, Set<String> fields) {
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = dt.getProperties();
        ArrayList<IDataEntityProperty> searchProperties = new ArrayList<IDataEntityProperty>(fields.size());
        properties.forEach(e -> {
            String name = e.getName();
            if (fields.contains(name)) {
                searchProperties.add((IDataEntityProperty)e);
            }
        });
        return FuzzySearchUtils.getSearchQFilter(entityNumber, searchProperties, searchText);
    }

    public static void checkValue(String fieldName, String type, List<FilterValue> value) {
        if (COMPARE_TYPE_IDS.contains(type) && value.size() > 1) {
            throw new RestApiException(RestApiErrorCode.DATA_INVALID, ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5 %s \u6bd4\u8f83\u65b9\u5f0f\u7684\u503c\u4e0d\u80fd\u662f\u6570\u7ec4", (String)"FilterUtil_0", (String)"bos-nocode-service", (Object[])new Object[]{fieldName}), new Object[0]);
        }
    }
}

