/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeTextProp;
import kd.bos.nocode.restapi.service.util.FuzzySearchVisitor;
import kd.bos.orm.query.QFilter;

public abstract class FuzzySearchUtils {
    private static final Log logger = LogFactory.getLog(FuzzySearchUtils.class);

    public static QFilter getSearchQFilter(String formId, Collection<IDataEntityProperty> properties, String searchText) {
        FuzzySearchVisitor propertyVisitor = new FuzzySearchVisitor();
        ImmutableMap paramMap = new ImmutableMap.Builder().put((Object)"search", (Object)searchText).build();
        List qFilters = properties.stream().filter(property -> StringUtils.isNotBlank((CharSequence)property.getAlias())).filter(FuzzySearchUtils::canSearch).flatMap(property -> ((List)propertyVisitor.visit((IDataEntityProperty)property, FilterField.buildPropORMFullName((IDataEntityProperty)property), paramMap)).stream()).collect(Collectors.toList());
        QFilter filter = qFilters.stream().reduce((f1, f2) -> f1.or(f2)).orElse(null);
        logger.debug("fuzzy search filter: {}", (Object)Objects.toString(filter));
        return filter;
    }

    private static boolean canSearch(IDataEntityProperty property) {
        return !(property instanceof NoCodeTextProp) || !((NoCodeTextProp)property).isPassword();
    }
}

