/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.restapi.common.visitor.AbstractDataEntityPropertyVisitor;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.query.g.convert.FilterValueConvertHelper;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.LikeHint;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.NotNull;

public class FuzzySearchVisitor
extends AbstractDataEntityPropertyVisitor<List<QFilter>> {
    private static final Log LOG = LogFactory.getLog(FuzzySearchVisitor.class);
    private static final String ID = "id";

    protected List<QFilter> visitSimpleProperty(ISimpleProperty property, String fullName, ImmutableMap<String, Object> extraMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        String searchText = (String)extraMap.get((Object)"search");
        if (property instanceof NoCodeMulRefBillProp) {
            return this.visitNoCodeMulRefBillProp((NoCodeMulRefBillProp)property, property, fullName, extraMap);
        }
        if (PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"LIST")) {
            LOG.debug("\u8131\u654f\u5b57\u6bb5\uff0c\u4e0d\u53c2\u4e0e\u641c\u7d22\uff1a{}", (Object)property.getName());
            return filters;
        }
        if (PrivacyCenterUtils.isEncryptField((IDataEntityProperty)property)) {
            LOG.debug("\u52a0\u5bc6\u5b57\u6bb5\uff0c\u4f7f\u7528\u7cbe\u786e\u5339\u914d\uff1a{}", (Object)property.getName());
            this.addEqualsQFilter(filters, property, fullName, searchText);
        } else if (this.useLike((IDataEntityProperty)property)) {
            this.addLikeQFilter(filters, property, fullName, searchText);
        } else if (this.useEquals((IDataEntityProperty)property)) {
            this.addEqualsQFilter(filters, property, fullName, searchText);
        }
        return filters;
    }

    @NotNull
    private static String getVisitKey(IDataEntityProperty property) {
        String entityNumber = property.getParent().getName();
        String propertyName = property.getName();
        return entityNumber + ":" + propertyName;
    }

    protected List<QFilter> visitComplexProperty(IComplexProperty property, String fullName, ImmutableMap<String, Object> extraMap) {
        List nameList = Splitter.on((String)".").splitToList((CharSequence)fullName);
        if (nameList.size() != Sets.newHashSet((Iterable)nameList).size()) {
            return Lists.newArrayList();
        }
        MainEntityType complexType = this.getComplexType(property);
        if (Objects.nonNull(complexType)) {
            Collection<IDataEntityProperty> properties = complexType.getAllFields().values();
            properties = this.getNeedSearchProperties((IDataEntityProperty)property, properties);
            return properties.stream().flatMap(p -> ((List)this.visit((IDataEntityProperty)p, fullName + "." + p.getName(), (ImmutableMap)extraMap)).stream()).collect(Collectors.toList());
        }
        return new ArrayList<QFilter>(0);
    }

    private List<QFilter> visitNoCodeMulRefBillProp(NoCodeMulRefBillProp prop, ISimpleProperty property, String fullName, ImmutableMap<String, Object> extraMap) {
        BillEntityType dt = prop.getBillEntityType();
        String searchText = (String)extraMap.get((Object)"search");
        IDataEntityType queryFormDt = prop.getParent();
        if (dt == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)searchText) || !(queryFormDt instanceof NoCodeBillEntityType)) {
            return new ArrayList<QFilter>(0);
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)queryFormDt.getName(), (String)prop.getName(), null, null, (int)1000);
        List rows = PropertyHandleUtil.toMapListRootByColumn((String)queryFormDt.getName(), (String)"$", (DynamicObject[])dynamicObjects, (Set)Sets.newHashSet((Object[])new String[]{prop.getName()}));
        List idList = rows.stream().filter(e -> {
            String value = (String)e.get(prop.getName());
            return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value) && value.contains(searchText);
        }).map(e -> (Long)e.get(ID)).collect(Collectors.toList());
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter(ID, "in", idList)});
    }

    private MainEntityType getComplexType(IComplexProperty property) {
        if (property instanceof NoCodeRefBillProp && StringUtils.isNotBlank((CharSequence)((NoCodeRefBillProp)property).getBillEntityId())) {
            String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)((NoCodeRefBillProp)property).getBillEntityId());
            return EntityMetadataCache.getDataEntityType((String)formNumber);
        }
        return (MainEntityType)property.getComplexType();
    }

    private Collection<IDataEntityProperty> getNeedSearchProperties(IDataEntityProperty parentProperty, Collection<IDataEntityProperty> properties) {
        if (parentProperty instanceof NoCodeRefBillProp) {
            NoCodeRefBillProp parentProp = (NoCodeRefBillProp)parentProperty;
            String displayPropStr = parentProp.getMainDisplayProperty();
            properties = properties.stream().filter(p -> displayPropStr.equalsIgnoreCase(p.getName())).collect(Collectors.toList());
        } else if (parentProperty instanceof NoCodeMulRefBillProp) {
            NoCodeMulRefBillProp parentProp = (NoCodeMulRefBillProp)parentProperty;
            String displayPropStr = parentProp.getMainDisplayProperty();
            properties = properties.stream().filter(p -> displayPropStr.equalsIgnoreCase(p.getName())).collect(Collectors.toList());
        }
        return properties;
    }

    protected List<QFilter> defaultValue(IDataEntityProperty property, String fullName, ImmutableMap<String, Object> extraMap) {
        return new ArrayList<QFilter>(0);
    }

    private boolean useLike(IDataEntityProperty property) {
        HashSet fieldProps = Sets.newHashSet((Object[])new Class[]{TextProp.class, TextAreaProp.class, ComboProp.class});
        return this.existProperty(property, fieldProps);
    }

    private boolean useEquals(IDataEntityProperty property) {
        HashSet fieldProps = Sets.newHashSet((Object[])new Class[]{LongProp.class, DecimalProp.class, DateTimeProp.class});
        return this.existProperty(property, fieldProps);
    }

    private boolean existProperty(IDataEntityProperty property, Set<Class<?>> fieldProps) {
        return fieldProps.stream().anyMatch(c -> c.isAssignableFrom(property.getClass()));
    }

    private void addLikeQFilter(List<QFilter> filters, ISimpleProperty property, String fullName, String searchText) {
        if (property instanceof ComboProp) {
            List comboItems = ((ComboProp)property).getComboItems();
            filters.add(new QFilter(fullName, "like", (Object)searchText, (QFilterHint)LikeHint.CONTAINS));
            for (ValueMapItem comboItem : comboItems) {
                if (comboItem == null || comboItem.getName() == null || comboItem.getName().getLocaleValue() == null || !comboItem.getName().getLocaleValue().contains(searchText)) continue;
                String value = comboItem.getValue();
                filters.add(new QFilter(fullName, "like", (Object)value, (QFilterHint)LikeHint.CONTAINS));
            }
        } else {
            filters.add(new QFilter(fullName, "like", (Object)searchText, (QFilterHint)LikeHint.CONTAINS));
        }
    }

    private void addEqualsQFilter(List<QFilter> filters, ISimpleProperty property, String fullName, String searchText) {
        try {
            Object convertResult = FilterValueConvertHelper.getConvertResult((IDataEntityProperty)property, searchText);
            if (property instanceof DateTimeProp) {
                Date date = (Date)convertResult;
                if (DateTimeUtils.isShortDate((String)searchText)) {
                    filters.addAll(DateTimeUtils.getDateRangeQFilter((String)fullName, (Date)date));
                } else if (DateTimeUtils.isYearMonth((String)searchText)) {
                    filters.addAll(DateTimeUtils.getYearMonthRangeQFiler((String)fullName, (Date)date));
                } else if (DateTimeUtils.isYear((String)searchText)) {
                    filters.addAll(DateTimeUtils.getYearRangeQFilter((String)fullName, (Date)date));
                } else {
                    filters.add(new QFilter(fullName, "=", convertResult));
                }
            } else {
                filters.add(new QFilter(fullName, "=", convertResult));
            }
        }
        catch (Exception e) {
            filters.add(new QFilter("1", "=", (Object)"-1", true));
            LOG.debug("\u503c\u8f6c\u6362\u5f02\u5e38\uff0c \u4e0d\u53c2\u4e0e\u7cbe\u786e\u5339\u914d", (Object)e);
        }
    }
}

