/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.constant.CompareTypeEnum;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.metadata.entity.filter.CompareGroupMapper;
import kd.bos.nocode.ext.metadata.entity.filter.CompareType;
import kd.bos.nocode.ext.metadata.entity.filter.FilterBuilderUtils;
import kd.bos.nocode.ext.metadata.entity.filter.NoCodeFilterMetadata;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.util.ComboItemUtils;
import kd.bos.nocode.internalapi.FilterValueService;
import kd.bos.nocode.restapi.filter.SimpleFilterRowConverterManager;
import kd.bos.nocode.restapi.filter.impl.RestApiFilterBuilder;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.util.CollectionUtils;

public class ListFilterConfigUtils {
    private static final Log log = LogFactory.getLog(ListFilterConfigUtils.class);
    public static final String FIELD_NAME = "fieldName";
    public static final String RULEID = "ruleid";
    public static final String STRUTURE_VIEWPARENT_NAME = "structure.viewparent.name";

    private ListFilterConfigUtils() {
    }

    public static List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType) {
        return ListFilterConfigUtils.getFilterColumns(dataEntityType, false);
    }

    public static List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType, boolean expandRefBill) {
        return ListFilterConfigUtils.getFilterColumns(dataEntityType, expandRefBill, new ArrayList<String>());
    }

    public static List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType, boolean expandRefBill, List<String> fieldKeys) {
        MainEntityType mainType = (MainEntityType)dataEntityType;
        List<FilterField> filterFields = ListFilterConfigUtils.getFilterFields((IDataEntityType)mainType, expandRefBill, fieldKeys);
        List<Map<String, Object>> filterColumns = filterFields.stream().map(ListFilterConfigUtils::createFilterColumn).collect(Collectors.toList());
        if (dataEntityType.getName().equalsIgnoreCase("bos_adminorg")) {
            // empty if block
        }
        return filterColumns;
    }

    public static Map<String, Object> getFilterColumn(IDataEntityType dataEntityType, String fieldName) {
        MainEntityType mainType = (MainEntityType)dataEntityType;
        List<FilterField> filterFields = ListFilterConfigUtils.getFilterFields((IDataEntityType)mainType);
        return filterFields.stream().filter(filterField -> filterField.getFullFieldName().equalsIgnoreCase(fieldName)).findFirst().map(ListFilterConfigUtils::createFilterColumn).orElse(null);
    }

    private static Map<String, Object> getOrgParentField() {
        String compareGroupId = CompareGroupMapper.getCompareGroupId((IDataEntityProperty)new TextProp());
        List<CompareType> myCompareTypes = ListFilterConfigUtils.getCompareTypes(compareGroupId);
        List compareTypeDTOList = NoCodeFilterMetadata.get().getCompareTypeDTOList(myCompareTypes);
        HashMap<String, Object> filterColumn = new HashMap<String, Object>(3);
        filterColumn.put(FIELD_NAME, "parent");
        filterColumn.put("fieldCaption", ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"ListFilterConfigUtils_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        filterColumn.put("compareTypes", compareTypeDTOList);
        return filterColumn;
    }

    public static List<FilterField> getFilterFields(IDataEntityType dataEntityType) {
        return ListFilterConfigUtils.getFilterFields(dataEntityType, false);
    }

    public static List<FilterField> getFilterFields(IDataEntityType dataEntityType, boolean expandRefBill) {
        return ListFilterConfigUtils.getFilterFields(dataEntityType, expandRefBill, new ArrayList<String>());
    }

    public static List<FilterField> getFilterFields(IDataEntityType dataEntityType, boolean expandRefBill, List<String> fieldKeys) {
        ArrayList<FilterField> filterFieldList = new ArrayList<FilterField>(50);
        MainEntityType mainType = (MainEntityType)dataEntityType;
        Map fields = ListConfigUtils.getDirectFields((String)dataEntityType.getName(), (boolean)expandRefBill, fieldKeys);
        for (IDataEntityProperty fieldProp : fields.values()) {
            IDataEntityType parentType;
            if (!(fieldProp instanceof IFieldHandle) || (parentType = fieldProp.getParent()) instanceof EntryType || PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)fieldProp, (String)Lang.get().toString(), (String)"LIST")) continue;
            List list = ((IFieldHandle)fieldProp).createFilterFields(mainType);
            list.removeIf(FilterField::isFieldPropAliasEmpty);
            filterFieldList.addAll(list);
        }
        return filterFieldList;
    }

    private static Map<String, Object> createFilterColumn(FilterField field) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put(FIELD_NAME, field.getFullFieldName());
        map.put("fieldCaption", ListFilterConfigUtils.getFieldCaption(field));
        IDataEntityProperty fieldProp = field.getFieldProp();
        String type = ((IFieldHandle)fieldProp).getFilterControlType();
        if ("text".equals(type) && StringUtils.isNotEmpty((CharSequence)field.getBaseDataFilterControlType())) {
            type = field.getBaseDataFilterControlType();
        }
        if ("enum".equals(type)) {
            map.put("items", ComboItemUtils.buildComboItemsVO((List)field.getComboItems()));
        }
        String compareGroupId = CompareGroupMapper.getCompareGroupId((IDataEntityProperty)fieldProp);
        List<CompareType> myCompareTypes = ListFilterConfigUtils.getCompareTypes(compareGroupId);
        List compareTypeDTOList = NoCodeFilterMetadata.get().getCompareTypeDTOList(myCompareTypes);
        map.put("compareTypes", compareTypeDTOList);
        return map;
    }

    private static String getFieldCaption(FilterField field) {
        if (field.getSrcFieldProp() instanceof NoCodeRefBillProp) {
            return field.getCaption().getLocaleValue().split("\\.")[0];
        }
        return field.getCaption().toString();
    }

    private static List<CompareType> getCompareTypes(String compareGroupId) {
        ArrayList<CompareType> compareTypes = new ArrayList<CompareType>(50);
        compareTypes.addAll(NoCodeFilterMetadata.get().getCompareTypes(compareGroupId));
        return compareTypes;
    }

    public static String buildFilter(List<Map<String, Object>> filterRows, String entityNumber) {
        entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)entityNumber);
        List filterItems = FilterBuilderUtils.convert(filterRows);
        return RestApiFilterBuilder.getInstance().buildFilter(filterItems, entityNumber);
    }

    public static List<Map<String, Object>> getValueList(Object value) {
        List valueList = value instanceof String ? SerializationUtils.fromJsonStringToList((String)((String)value), Object.class) : (List)value;
        return valueList;
    }

    public static FilterCondition toFilterCondition(String formId, List<Map<String, Object>> filterRows) {
        FilterCondition filterCondition = new FilterCondition();
        filterRows.stream().flatMap(row -> ListFilterConfigUtils.getSimpleFilterRowStream(formId, row)).forEach(arg_0 -> ((FilterCondition)filterCondition).addFilterRow(arg_0));
        return filterCondition;
    }

    private static Stream<? extends SimpleFilterRow> getSimpleFilterRowStream(String formId, Map<String, Object> row) {
        String fieldName = (String)row.get(FIELD_NAME);
        String compareTypeId = (String)row.get("compareType");
        List valueList = (List)row.get("value");
        CompareTypeEnum compareType = CompareTypeEnum.getById((String)compareTypeId);
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)formId);
        IDataEntityProperty fieldProp = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldName);
        List filterRowList = SimpleFilterRowConverterManager.getConverter(fieldProp, compareType).map(c -> c.convert(fieldProp, compareType, valueList)).orElseGet(() -> new ArrayList(0));
        return filterRowList.stream();
    }

    public static void clearInvalidFilterRows(String formId, List<Map<String, Object>> configuredFilterItems) {
        if (CollectionUtils.isEmpty(configuredFilterItems)) {
            return;
        }
        ListConfigUtils.clearNoExistField((String)formId, configuredFilterItems);
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)formId);
        configuredFilterItems.removeIf(item -> ListFilterConfigUtils.clearInvalidCompareType(dt, item));
    }

    private static boolean clearInvalidCompareType(MainEntityType dt, Map<String, Object> item) {
        String fieldName = (String)item.get(FIELD_NAME);
        String compareType = (String)item.get("compareType");
        IDataEntityProperty field = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldName);
        String compareGroupId = fieldName.endsWith(".fbasedataid.type") ? "0,10,3,5" : CompareGroupMapper.getCompareGroupId((IDataEntityProperty)field);
        List compareTypes = NoCodeFilterMetadata.get().getCompareTypes(compareGroupId);
        List idList = compareTypes.stream().map(CompareType::getId).collect(Collectors.toList());
        return !idList.contains(compareType);
    }

    public static void parseExpression(List<Map<String, Object>> filterInfos, String formId, DynamicObject model) {
        for (Map<String, Object> map : filterInfos) {
            Object value = map.get("value");
            String compareType = (String)map.get("compareType");
            List<Map<String, Object>> valueList = ListFilterConfigUtils.getValueList(value);
            map.put("value", valueList);
            for (Map<String, Object> obj : valueList) {
                Map<String, Object> val = obj;
                String fieldValue = (String)val.get("fieldValue");
                if (!fieldValue.contains("${model")) continue;
                fieldValue = fieldValue.replace("${model.", "");
                fieldValue = fieldValue.replace("}", "");
                if (FilterValueService.create().isAttachmentSubProp(model.getDynamicObjectType(), fieldValue)) {
                    val.put("fieldValue", FilterValueService.create().getAttachmentPropValue(model, fieldValue, compareType));
                    continue;
                }
                if (FilterValueService.create().isPictureProp(model.getDynamicObjectType(), fieldValue)) {
                    val.put("fieldValue", FilterValueService.create().getImagePropValue(model, fieldValue, compareType));
                    continue;
                }
                IDataEntityProperty prop = ((NoCodeBillEntityType)model.getDynamicObjectType()).findProperty(fieldValue);
                Object result = NcEntityTypeUtil.getOriginalValue((IDataEntityProperty)prop, (Object)model.get(fieldValue));
                IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)formId), (String)fieldValue);
                if (property instanceof NoCodeRefBillProp && result instanceof Long && (Long)result == 0L) {
                    result = null;
                }
                val.put("fieldValue", result);
            }
        }
    }

    public static Set<String> getNeedParseFields(List<Map<String, Object>> filterInfos) {
        HashSet<String> needParseFields = new HashSet<String>(32);
        for (Map<String, Object> map : filterInfos) {
            Object value = map.get("value");
            List<Map<String, Object>> valueList = ListFilterConfigUtils.getValueList(value);
            map.put("value", valueList);
            for (Map<String, Object> obj : valueList) {
                String fieldValue;
                Map<String, Object> val = obj;
                if (!(val.get("fieldValue") instanceof String) || !(fieldValue = (String)val.get("fieldValue")).contains("${model")) continue;
                fieldValue = fieldValue.replace("${model.", "");
                fieldValue = fieldValue.replace("}", "");
                needParseFields.add(fieldValue);
            }
        }
        return needParseFields;
    }
}

