/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.wf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.kscript.exception.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfTaskActionEnum;
import kd.bos.nocode.ext.constant.WfTaskTypeEnum;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeBillNoField;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.SaveRestApiService;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiSaveResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.constant.RestApiConstant;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.ComparatorUtil;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.wf.NoCodeMessageService;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.restapi.service.wf.pojo.MessageInfo;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;

public class WfProcessCenterService {
    private static final Log log = LogFactory.getLog(WfProcessCenterService.class);
    private static final String TASK = "task";
    private static final String TASK_LIST_CONFIG = "task_list_config";
    public static final String WITH_BUSINESS_DATA = "withBusinessData";
    public static final String TARGET_FORM_ID = "targetFormId";
    public static final String BUSINESS_KEY = "businessKey";
    public static final String LIST_ITEM_CONFIG = "listItemConfig";
    public static final String NUMBER = "number";
    public static final String NOCODE_BILLNO_FIELD = "nocodebillnofield";
    public static final String LIST_DATA = "listData";
    public static final String TYPE = "type";
    public static final String TASK_DATA_ERROR_MESSAGE = "errMsg";
    public static final String MESSAGE = "message";
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"WfProcessCenterService-Thread", (int)2, (int)4);
    WfProcessDataService wfProcessCenterDataService = WfProcessDataService.create();
    NoCodeMessageService wfMessageService = NoCodeMessageService.create();

    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiQueryParam) {
            WfProcessCenterQueryServiceImpl queryService = new WfProcessCenterQueryServiceImpl();
            return queryService.execute((RestApiQueryParam)param);
        }
        if (param instanceof RestApiSaveParam) {
            WfProcessCenterSaveServiceImpl saveService = new WfProcessCenterSaveServiceImpl();
            return saveService.execute((RestApiSaveParam)param);
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"WfProcessCenterService_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public class WfProcessCenterSaveServiceImpl
    implements SaveRestApiService {
        public RestApiServiceData<RestApiSaveResult> execute(RestApiSaveParam param) {
            ArrayList<RestApiSaveItemData> results;
            long startTime;
            block9: {
                String url;
                List dataList;
                block10: {
                    block8: {
                        startTime = System.currentTimeMillis();
                        dataList = param.getDataList();
                        results = new ArrayList<RestApiSaveItemData>(dataList.size());
                        url = param.getRequest().getUrl();
                        if (!url.endsWith(WfProcessCenterService.TASK)) break block8;
                        for (Map item : dataList) {
                            RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                            String action = (String)item.get("action");
                            WfTaskActionEnum actionEnum = WfTaskActionEnum.get((String)action);
                            long taskId = Long.parseLong((String)item.get("taskId"));
                            String message = (String)item.get(WfProcessCenterService.MESSAGE);
                            String nextNodeId = (String)item.get("nextNodeId");
                            switch (actionEnum) {
                                case Consent: {
                                    WfProcessCenterService.this.wfProcessCenterDataService.consent(taskId, message);
                                    break;
                                }
                                case Terminate: {
                                    WfProcessCenterService.this.wfProcessCenterDataService.terminate(taskId, message);
                                    break;
                                }
                                case Reject: {
                                    WfProcessCenterService.this.wfProcessCenterDataService.reject(taskId, message, nextNodeId);
                                    break;
                                }
                                default: {
                                    WfProcessCenterService.this.wfProcessCenterDataService.completeTask(taskId, action, message);
                                }
                            }
                            apiSaveData.setId(taskId + "");
                            apiSaveData.setNumber(taskId + "");
                            apiSaveData.setBillStatus(true);
                            results.add(apiSaveData);
                        }
                        break block9;
                    }
                    if (!url.endsWith(WfProcessCenterService.MESSAGE)) break block10;
                    for (Map item : dataList) {
                        RestApiSaveItemData apiSaveData = new RestApiSaveItemData();
                        List msgIds = (List)item.get("msgIds");
                        WfProcessCenterService.this.wfMessageService.setMessageReaded(msgIds);
                        apiSaveData.setBillStatus(true);
                        results.add(apiSaveData);
                    }
                    break block9;
                }
                if (!url.endsWith("withdraw")) break block9;
                for (Map item : dataList) {
                    String procInstId = (String)item.get("procInstId");
                    WfProcessCenterService.this.wfProcessCenterDataService.withdraw(procInstId);
                }
            }
            return this.getSaveResultData(results, startTime);
        }

        private RestApiServiceData<RestApiSaveResult> getSaveResultData(List<RestApiSaveItemData> saveItemDataList, long startTime) {
            RestApiSaveResult result = new RestApiSaveResult(saveItemDataList);
            RestApiResponse response = new RestApiResponse();
            response.setData((Object)result);
            long endTime = System.currentTimeMillis();
            boolean allMatch = saveItemDataList.stream().allMatch(RestApiSaveItemData::isBillStatus);
            if (allMatch) {
                return RestApiServiceData.ofTrue((RestApiResponse)response, (long)(endTime - startTime));
            }
            return RestApiServiceData.ofFalse((String)RestApiErrorCode.ERROR.getStatusCode(), (String)RestApiConstant.getOperationfalsemessage(), (RestApiResponse)response, (long)(endTime - startTime));
        }
    }

    public class WfProcessCenterQueryServiceImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            String url = param.getRequest().getUrl();
            long currUserId = RequestContext.get().getCurrUserId();
            if (url.endsWith(WfProcessCenterService.TASK)) {
                long total;
                boolean withBusinessData = Boolean.parseBoolean((String)param.getRequest().getHttpQueryString().get(WfProcessCenterService.WITH_BUSINESS_DATA));
                if (withBusinessData) {
                    total = 4L;
                    param.setPage_size((int)total);
                } else {
                    total = this.getTaskCount(param);
                }
                List<Map<String, Object>> taskList = this.getTaskList(param);
                if (withBusinessData) {
                    this.populateData(taskList);
                }
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(taskList, param, total), (long)startTime, (long)endTime);
            }
            if (url.endsWith(WfProcessCenterService.TASK_LIST_CONFIG)) {
                String type = (String)param.getRequest().getHttpQueryString().get(WfProcessCenterService.TYPE);
                WfTaskTypeEnum wfTaskType = StringUtils.isEmpty((String)type) ? WfTaskTypeEnum.toHandle : WfTaskTypeEnum.valueOf((String)type);
                List taskListConfig = WfProcessUtils.getTaskListConfig((WfTaskTypeEnum)wfTaskType);
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(taskListConfig, param, -1L), (long)startTime, (long)endTime);
            }
            if (url.endsWith(WfProcessCenterService.MESSAGE)) {
                List<MessageInfo> allMessage = WfProcessCenterService.this.wfMessageService.getAllMessage(currUserId, param.getPage_no(), param.getPage_size());
                long total = WfProcessCenterService.this.wfMessageService.countAllMessage(currUserId);
                long endTime = System.currentTimeMillis();
                List rows = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(allMessage), Map.class);
                return RestApiServiceData.ofTrue(this.getQueryResponse(rows, param, total), (long)startTime, (long)endTime);
            }
            if (url.endsWith("message_count")) {
                String readType = (String)param.getRequest().getHttpQueryString().get("readType");
                long total = "unread".equalsIgnoreCase(readType) ? WfProcessCenterService.this.wfMessageService.countUnreadMessage(currUserId) : WfProcessCenterService.this.wfMessageService.countAllMessage(currUserId);
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(new ArrayList<Map<String, Object>>(0), param, total), (long)startTime, (long)endTime);
            }
            throw new RestApiException(ResManager.loadKDString((String)"\u975e\u6cd5\u8bf7\u6c42", (String)"WfProcessCenterService_1", (String)"bos-nocode-service", (Object[])new Object[0]));
        }

        private void populateData(List<Map<String, Object>> taskList) {
            CompletableFuture.allOf((CompletableFuture[])taskList.stream().map(this::populateDataAsync).toArray(CompletableFuture[]::new)).join();
        }

        private CompletableFuture<Void> populateDataAsync(Map<String, Object> task) {
            return CompletableFuture.runAsync(() -> this.doPopulateData(task), executorService);
        }

        private void doPopulateData(Map<String, Object> task) {
            String entityNumber = (String)task.get(WfProcessCenterService.TARGET_FORM_ID);
            String businessKey = (String)task.get(WfProcessCenterService.BUSINESS_KEY);
            try {
                if (!FormMetadataUtils.existByFormNumber((String)entityNumber)) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u5df2\u4e0d\u5b58\u5728", (String)"WfProcessCenterService_2", (String)"bos-nocode-service", (Object[])new Object[]{entityNumber}));
                }
                if (!ORM.create().exists(entityNumber, new QFilter("id", "=", (Object)Long.parseLong(businessKey)).toArray())) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u8981\u64cd\u4f5c\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u65e0\u6743\u8bbf\u95ee", (String)"WfProcessCenterService_3", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                List listItemConfig = ListConfigUtils.getListItemConfig((String)entityNumber);
                task.put(WfProcessCenterService.LIST_ITEM_CONFIG, listItemConfig);
                DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(businessKey), (String)entityNumber);
                Set selectSet = ListConfigUtils.sureSelectSet((String)entityNumber);
                selectSet = ComparatorUtil.getSelect((Set)selectSet);
                List rows = PropertyHandleUtil.toMapListRoot((String)entityNumber, (String)"$", (DynamicObject[])new DynamicObject[]{dynObj}, (Set)selectSet);
                Map data = (Map)rows.get(0);
                if (this.existsBillNoField(listItemConfig)) {
                    this.removeBillNoField(listItemConfig);
                    task.put(WfProcessCenterService.NOCODE_BILLNO_FIELD, data.remove(WfProcessCenterService.NOCODE_BILLNO_FIELD));
                }
                task.put(WfProcessCenterService.LIST_DATA, data);
            }
            catch (Exception e) {
                task.put(WfProcessCenterService.TASK_DATA_ERROR_MESSAGE, e.getMessage());
                log.debug("\u83b7\u53d6\u5f85\u529e\u4efb\u52a1\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a{}\uff0centityNumber={}\uff0cbusinessKey={}", new Object[]{e.getMessage(), entityNumber, businessKey, e});
            }
        }

        private void removeBillNoField(List<Map<String, Object>> listItemConfig) {
            listItemConfig.removeIf(item -> NoCodeBillNoField.class.getSimpleName().equalsIgnoreCase((String)item.get(WfProcessCenterService.NUMBER)));
        }

        private boolean existsBillNoField(List<Map<String, Object>> listItemConfig) {
            return listItemConfig.stream().anyMatch(item -> NoCodeBillNoField.class.getSimpleName().equalsIgnoreCase((String)item.get(WfProcessCenterService.NUMBER)));
        }

        private long getTaskCount(RestApiQueryParam param) {
            long currUserId = RequestContext.get().getCurrUserId();
            String type = (String)param.getRequest().getHttpQueryString().get(WfProcessCenterService.TYPE);
            WfTaskTypeEnum wfTaskType = WfTaskTypeEnum.valueOf((String)type);
            return WfProcessCenterService.this.wfProcessCenterDataService.getTaskCount(currUserId, wfTaskType);
        }

        private List<Map<String, Object>> getTaskList(RestApiQueryParam param) {
            long currUserId = RequestContext.get().getCurrUserId();
            String type = (String)param.getRequest().getHttpQueryString().get(WfProcessCenterService.TYPE);
            WfTaskTypeEnum wfTaskType = WfTaskTypeEnum.valueOf((String)type);
            int pageNo = param.getPage_no();
            int pageSize = param.getPage_size();
            return WfProcessCenterService.this.wfProcessCenterDataService.getTaskList(currUserId, wfTaskType, pageNo, pageSize);
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows, RestApiQueryParam param, long total) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            int pageNo = param.getPage_no();
            result.setPageNo(pageNo);
            int pageSize = param.getPage_size();
            result.setPageSize(pageSize);
            result.setTotalCount((int)total);
            double totalPage = Math.ceil(((double)total + 0.0) / (double)pageSize);
            result.setLastPage(Boolean.valueOf((double)pageNo >= totalPage));
            result.setRows(rows);
            return response;
        }
    }
}

