/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.wf;

import com.cronutils.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.constant.WfTaskHandleResultEnum;
import kd.bos.nocode.ext.constant.WfProcessStatusEnum;
import kd.bos.nocode.ext.constant.WfTaskTypeEnum;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.api.QueryRestApiService;
import kd.bos.nocode.restapi.api.model.ApprovalRecord;
import kd.bos.nocode.restapi.api.model.ApproverInfo;
import kd.bos.nocode.restapi.api.model.RestApiResponse;
import kd.bos.nocode.restapi.api.params.RestApiParam;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.result.RestApiQueryResult;
import kd.bos.nocode.restapi.api.result.RestApiServiceData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.wf.ApprovalRecordService;
import kd.bos.nocode.restapi.service.wf.WfProcessRequestContext;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.nocode.utils.PageUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessInitiator;
import kd.bos.workflow.api.model.ProcessModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class WfProcessManageService {
    private static final Log log = LogFactory.getLog(WfProcessManageService.class);
    private static final String PROCESS_MENU = "process_menu";
    private static final String PROCESS_INSTANCE_LIST_CONFIG = "process_instance_list_config";
    private static final String PROCESS_INSTANCE = "process_instance";
    private static final ApprovalRecordService APPROVAL_RECORD_SERVICE = ApprovalRecordService.create();
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String BUSINESS_KEY = "businessKey";
    public static final String TASK_ID = "taskId";
    public static final String PROCESS_STATUS = "processStatus";
    public static final String NUMBER = "number";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String PROCESS_NUMBER = "processNumber";
    public static final String START_NAME = "startName";
    public static final String HANDLE_STATE_DESC = "handleStateDesc";
    public static final String HANDLE_STATE = "handleState";
    public static final String IS_APPROVAL_STATUS = "isApprovalStatus";
    public static final String LOCKED = "locked";
    public static final String DISPLAY = "display";
    public static final String APPROVAL_INFO = "approval_info";
    private static final String APP_ID = "appId";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, R> RestApiServiceData<R> handle(RestApiParam<T> param) {
        if (param instanceof RestApiQueryParam) {
            try {
                WfProcessRequestContext.create();
                WfProcessManageQueryServiceImpl queryService = new WfProcessManageQueryServiceImpl();
                RestApiServiceData<RestApiQueryResult> restApiServiceData = queryService.execute((RestApiQueryParam)param);
                return restApiServiceData;
            }
            finally {
                WfProcessRequestContext.remove();
            }
        }
        throw new RestApiException(ResManager.loadKDString((String)"\u8bf7\u6c42\u4e0d\u652f\u6301", (String)"WfProcessManageService_0", (String)"bos-nocode-service", (Object[])new Object[0]));
    }

    public static class WfProcessManageQueryServiceImpl
    implements QueryRestApiService {
        public RestApiServiceData<RestApiQueryResult> execute(RestApiQueryParam param) {
            long startTime = System.currentTimeMillis();
            String url = param.getRequest().getUrl();
            if (url.endsWith(WfProcessManageService.PROCESS_MENU)) {
                List menus = new ProcessMenuQueryService().getProcessMenuList(param);
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(menus, param, -1L), (long)startTime, (long)endTime);
            }
            if (url.endsWith(WfProcessManageService.PROCESS_INSTANCE_LIST_CONFIG)) {
                WfProcessManageQueryServiceImpl.verifyAppPerm(param);
                List taskListConfig = WfProcessUtils.getTaskListConfig((WfTaskTypeEnum)WfTaskTypeEnum.process_manage);
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(taskListConfig, param, -1L), (long)startTime, (long)endTime);
            }
            if (url.endsWith(WfProcessManageService.PROCESS_INSTANCE)) {
                WfProcessManageQueryServiceImpl.verifyAppPerm(param);
                ProcessInstanceQueryService processInstanceQueryService = new ProcessInstanceQueryService();
                List<Map<String, Object>> instances = processInstanceQueryService.getProcessInstanceList(param);
                long total = processInstanceQueryService.countProcessInstance(param);
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(instances, param, total), (long)startTime, (long)endTime);
            }
            if (url.endsWith(WfProcessManageService.APPROVAL_INFO)) {
                String entityNumber = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.ENTITY_NUMBER);
                String businessKey = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.BUSINESS_KEY);
                if (NoCodePermHelper.isShare(null, null, (String)param.getShareId())) {
                    long endTime = System.currentTimeMillis();
                    return RestApiServiceData.ofTrue(this.getQueryResponse(new ArrayList<Map<String, Object>>(0), param, -1L), (long)startTime, (long)endTime);
                }
                if (!FormMetadataUtils.existByFormNumber((String)entityNumber)) {
                    long endTime = System.currentTimeMillis();
                    return RestApiServiceData.ofTrue(this.getQueryResponse(new ArrayList<Map<String, Object>>(0), param, -1L), (long)startTime, (long)endTime);
                }
                if (!ORM.create().exists(entityNumber, new QFilter(WfProcessManageService.ID, "=", (Object)Long.parseLong(businessKey)).toArray())) {
                    long endTime = System.currentTimeMillis();
                    return RestApiServiceData.ofTrue(this.getQueryResponse(new ArrayList<Map<String, Object>>(0), param, -1L), (long)startTime, (long)endTime);
                }
                Map<Long, List<ApprovalRecord>> approvalRecords = ApprovalRecordService.create().getApprovalRecords(entityNumber, businessKey);
                approvalRecords = this.filterHasCurrentUser(entityNumber, approvalRecords);
                List<Map<String, Object>> approvalRecordsVo = new ArrayList<Map<String, Object>>(0);
                if (MapUtils.isNotEmpty(approvalRecords)) {
                    WfConsts.WfLockStatusEnum wfLockStatus = WfProcessUtils.getWfLockStatus((String)entityNumber, (Object)Long.parseLong(businessKey));
                    approvalRecordsVo = this.buildApprovalRecordVO(approvalRecords, wfLockStatus);
                }
                long endTime = System.currentTimeMillis();
                return RestApiServiceData.ofTrue(this.getQueryResponse(approvalRecordsVo, param, -1L), (long)startTime, (long)endTime);
            }
            return null;
        }

        private static void verifyAppPerm(RestApiQueryParam param) {
            String appId = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.APP_ID);
            String processNumber = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.PROCESS_NUMBER);
            if (StringUtils.isEmpty((CharSequence)appId) || StringUtils.isEmpty((CharSequence)processNumber)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"WfProcessManageService_1", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            NoCodePermHelper.verifyManage((String)appId);
            Set processNumbers = new ProcessMenuQueryService().getProcessNumbersByAppId(appId);
            if (!processNumbers.contains(processNumber)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"WfProcessManageService_1", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
        }

        private Map<Long, List<ApprovalRecord>> filterHasCurrentUser(String entityNumber, Map<Long, List<ApprovalRecord>> approvalRecords) {
            long userId = RequestContext.get().getCurrUserId();
            String currentUserId = userId + "";
            if (NoCodePermHelper.checkUserAppManageInNoCode((Long)userId, (String)FormMetaUtil.getAppIdByFormNumber((String)entityNumber))) {
                return approvalRecords;
            }
            HashMap<Long, List<ApprovalRecord>> resultApprovalRecords = new HashMap<Long, List<ApprovalRecord>>(approvalRecords.size());
            Set<Map.Entry<Long, List<ApprovalRecord>>> entries = approvalRecords.entrySet();
            for (Map.Entry<Long, List<ApprovalRecord>> entry : entries) {
                Long procInstId = entry.getKey();
                List<ApprovalRecord> approvalRecordList = entry.getValue();
                boolean containCurrentUser = approvalRecordList.stream().flatMap(e -> e.getApproverInfos().stream()).anyMatch(approver -> approver.getHandlerId().equalsIgnoreCase(currentUserId));
                if (!containCurrentUser) continue;
                resultApprovalRecords.put(procInstId, approvalRecordList);
            }
            return resultApprovalRecords;
        }

        private List<Map<String, Object>> buildApprovalRecordVO(Map<Long, List<ApprovalRecord>> approvalRecords, WfConsts.WfLockStatusEnum wfLockStatus) {
            if (MapUtils.isEmpty(approvalRecords)) {
                return new ArrayList<Map<String, Object>>(0);
            }
            ArrayList<Map<String, Object>> approvalRecordsVo = new ArrayList<Map<String, Object>>();
            boolean existEntityNumber = true;
            for (Map.Entry<Long, List<ApprovalRecord>> entry : approvalRecords.entrySet()) {
                Long procInstId = entry.getKey();
                List<ApprovalRecord> value = entry.getValue();
                ApprovalRecord lastRecord = value.get(0);
                String entityNumber = lastRecord.getEntityNumber();
                if (Objects.isNull(EntityMetadataCache.getDataEntityType((String)entityNumber))) {
                    existEntityNumber = false;
                    break;
                }
                ProcessInitiator processInitiator = WfProcessRequestContext.get().getProcessInitiatorByProcInstId(procInstId);
                if (Objects.isNull(processInitiator)) continue;
                HashMap<String, Object> voMap = new HashMap<String, Object>(16);
                voMap.put("approvalInfo", value);
                Long startId = processInitiator.getId();
                boolean isInitiator = startId.longValue() == RequestContext.get().getCurrUserId();
                voMap.put("canWithdraw", this.canWithdraw(isInitiator, lastRecord));
                voMap.put("procInstId", procInstId);
                Long procDefId = lastRecord.getProcDefId();
                voMap.put("procDefId", procDefId);
                voMap.put("processName", lastRecord.getProcessName());
                voMap.put(WfProcessManageService.TASK_ID, lastRecord.getTaskId());
                voMap.put(WfProcessManageService.ENTITY_NUMBER, entityNumber);
                String businessKey = lastRecord.getBusinessKey();
                voMap.put(WfProcessManageService.BUSINESS_KEY, businessKey);
                WfProcessStatusEnum processStatus = WfProcessRequestContext.get().getWfProcessStatusEnumByProcInstId(businessKey, procInstId);
                voMap.put(WfProcessManageService.PROCESS_STATUS, WfProcessUtils.getProcessStatusForApproval((WfProcessStatusEnum)processStatus, (boolean)NoCodeWorkflowServiceHelper.inProcessByProcessInstanceId((Long)procInstId), (ApprovalRecord)lastRecord));
                voMap.put("flowId", WfProcessRequestContext.get().getProcessDefinitionInfoByProcDefId(procDefId).getModelId());
                voMap.put("lockStatus", wfLockStatus.getCode());
                approvalRecordsVo.add(voMap);
            }
            if (!existEntityNumber) {
                return new ArrayList<Map<String, Object>>(0);
            }
            return approvalRecordsVo;
        }

        private boolean canWithdraw(boolean isInitiator, ApprovalRecord lastRecord) {
            Long procInstId = lastRecord.getProcInstId();
            Map canWithdrawMap = NoCodeWorkflowServiceHelper.canWithdrawByProcessInstanceId((Long)procInstId);
            List errorInfos = (List)canWithdrawMap.get("errorInfo");
            return isInitiator && CollectionUtils.isEmpty((Collection)errorInfos);
        }

        private boolean canHandle(ApprovalRecord lastRecord) {
            List handleIds = lastRecord.getApproverInfos().stream().map(ApproverInfo::getHandlerId).collect(Collectors.toList());
            long currentUserId = RequestContext.get().getCurrUserId();
            if (!"NoCodeWfNodeAudit".equals(lastRecord.getNodeType()) || !handleIds.contains(currentUserId + "")) {
                return false;
            }
            return Objects.equals(lastRecord.getHandleState(), WfTaskHandleResultEnum.willApproval.toString());
        }

        private boolean canHandle(List<ApprovalRecord> records) {
            return records.stream().anyMatch(this::canHandle);
        }

        private RestApiResponse<RestApiQueryResult> getQueryResponse(List<Map<String, Object>> rows, RestApiQueryParam param, long total) {
            RestApiResponse response = new RestApiResponse();
            RestApiQueryResult result = new RestApiQueryResult();
            response.setData((Object)result);
            int pageNo = param.getPage_no();
            result.setPageNo(pageNo);
            int pageSize = param.getPage_size();
            result.setPageSize(pageSize);
            result.setTotalCount((int)total);
            double totalPage = Math.ceil(((double)total + 0.0) / (double)pageSize);
            result.setLastPage(Boolean.valueOf((double)pageNo >= totalPage));
            result.setRows(rows);
            return response;
        }

        private static class ProcessInstanceQueryService {
            private ProcessInstanceQueryService() {
            }

            public List<Map<String, Object>> getProcessInstanceList(RestApiQueryParam param) {
                int pageSize;
                String processNumber = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.PROCESS_NUMBER);
                int pageNo = param.getPage_no();
                DynamicObjectCollection processInstanceInfos = NoCodeWorkflowServiceHelper.getNoCodeFlowProcessInstanceInfoByProcessCode((int)PageUtils.getStartIndex((int)pageNo, (int)(pageSize = param.getPage_size())), (int)pageSize, (String)processNumber);
                if (CollectionUtils.isEmpty((Collection)processInstanceInfos)) {
                    return new ArrayList<Map<String, Object>>(0);
                }
                return processInstanceInfos.stream().map(this::convert2Row).collect(Collectors.toList());
            }

            private Map<String, Object> convert2Row(DynamicObject record) {
                String procDefName = record.getString("processName");
                Date createDate = record.getDate("createDate");
                Date endTime = record.getDate("endTime");
                String endType = record.getString("endType");
                String activityId = record.getString("activityId");
                String activityName = record.getString("activityName");
                String procInstId = record.getString("procInstId");
                String entityName = record.getString("entityName");
                String handleTime = record.getString("handleTime");
                String entityNumber = record.getString(WfProcessManageService.ENTITY_NUMBER);
                String businessKey = record.getString(WfProcessManageService.BUSINESS_KEY);
                String presentAssignee = record.getString("presentAssignee");
                String errorMessage = record.getString("errorMessage");
                Map processStatus = WfProcessUtils.getProcessStatusForList((String)endType, (String)activityId, (String)activityName, (boolean)Objects.isNull(endTime), (String)errorMessage);
                processStatus.put(WfProcessManageService.IS_APPROVAL_STATUS, true);
                HashMap<String, Object> itemMap = new HashMap<String, Object>(20);
                itemMap.put("procDefName", procDefName);
                itemMap.put("createDate", createDate);
                itemMap.put("endTime", endTime);
                itemMap.put(WfProcessManageService.PROCESS_STATUS, processStatus);
                itemMap.put("activityName", activityName);
                itemMap.put("presentAssignee", presentAssignee);
                itemMap.put("procInstId", procInstId);
                itemMap.put("entityName", entityName);
                itemMap.put("handleTime", handleTime);
                itemMap.put("targetFormId", entityNumber);
                itemMap.put(WfProcessManageService.BUSINESS_KEY, businessKey);
                return itemMap;
            }

            public long countProcessInstance(RestApiQueryParam param) {
                String processNumber = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.PROCESS_NUMBER);
                return NoCodeWorkflowServiceHelper.getNoCodeFlowProcessInstanceCountByProcessCode((String)processNumber);
            }
        }

        private static class ProcessMenuQueryService {
            private ProcessMenuQueryService() {
            }

            private List<Map<String, Object>> getProcessMenuList(RestApiQueryParam param) {
                String appId = (String)param.getRequest().getHttpQueryString().get(WfProcessManageService.APP_ID);
                NoCodePermHelper.verifyManage((String)appId);
                log.info("NoCodeWorkflowServiceHelper.getAllProcesses procType={}, appId={}.", (Object)"NoCodeFlow", (Object)appId);
                List processModels = NoCodeWorkflowServiceHelper.getAllProcesses((String)"NoCodeFlow", (String)appId);
                log.info("NoCodeWorkflowServiceHelper.getAllProcesses processModels.size()={}.", (Object)processModels.size());
                return processModels.stream().map(this::cast2ProcessMenuViewMap).sorted((e1, e2) -> ((Long)e1.get(WfProcessManageService.ID)).compareTo((Long)e2.get(WfProcessManageService.ID))).collect(Collectors.toList());
            }

            private Set<String> getProcessNumbersByAppId(String appId) {
                List processModels = NoCodeWorkflowServiceHelper.getAllProcesses((String)"NoCodeFlow", (String)appId);
                return processModels.stream().map(ProcessModel::getNumber).collect(Collectors.toSet());
            }

            private Map<String, Object> cast2ProcessMenuViewMap(ProcessModel processModel) {
                HashMap<String, Object> viewMap = new HashMap<String, Object>(2);
                viewMap.put(WfProcessManageService.ID, processModel.getId());
                viewMap.put(WfProcessManageService.NAME, processModel.getName().getLocaleValue());
                viewMap.put(WfProcessManageService.NUMBER, processModel.getNumber());
                return viewMap;
            }
        }
    }
}

