/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.wf;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.constant.WfProcessStatusEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessInitiator;
import org.apache.commons.collections4.MapUtils;

public final class WfProcessRequestContext {
    private static final Log log = LogFactory.getLog(WfProcessRequestContext.class);
    private final Map<Long, ProcessDefinitionInfo> procDefId2InfoCache = new HashMap<Long, ProcessDefinitionInfo>(16);
    private final Map<Long, NoCodeWfMetaData> procDefId2MetaDataCache = new HashMap<Long, NoCodeWfMetaData>(16);
    private final Map<Long, ProcessInitiator> procInstId2ProcessInitiatorCache = new HashMap<Long, ProcessInitiator>(16);
    private final Map<Long, WfProcessStatusEnum> procInstId2BizProcessStatus = new HashMap<Long, WfProcessStatusEnum>(16);
    private static final ThreadLocal<WfProcessRequestContext> CURRENT = new ThreadLocal();

    private WfProcessRequestContext() {
    }

    public static WfProcessRequestContext create() {
        return WfProcessRequestContext.create(true);
    }

    public static WfProcessRequestContext create(boolean setCurrent) {
        WfProcessRequestContext rc = new WfProcessRequestContext();
        if (setCurrent) {
            WfProcessRequestContext.set(rc);
        }
        return rc;
    }

    public static WfProcessRequestContext get() {
        return CURRENT.get();
    }

    public static void set(WfProcessRequestContext rc) {
        CURRENT.set(rc);
    }

    public static void remove() {
        CURRENT.remove();
    }

    public ProcessDefinitionInfo getProcessDefinitionInfoByProcDefId(long procDefId) {
        ProcessDefinitionInfo processDefinitionInfo = this.procDefId2InfoCache.get(procDefId);
        if (Objects.nonNull(processDefinitionInfo)) {
            return processDefinitionInfo;
        }
        processDefinitionInfo = NoCodeWorkflowServiceHelper.getProcessDefinitionInfoById((Long)procDefId);
        if (!Objects.nonNull(processDefinitionInfo)) {
            log.debug("procDefId={}\uff0cprocessDefinitionInfo={}", (Object)procDefId, null);
            throw new RestApiException(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u7a7a\uff0cprocDefId=%s\u3002", (String)"WfProcessRequestContext_0", (String)"bos-nocode-service", (Object[])new Object[]{procDefId}));
        }
        this.procDefId2InfoCache.put(procDefId, processDefinitionInfo);
        return processDefinitionInfo;
    }

    public NoCodeWfMetaData getNoCodeWfMetaDataByProcDefId(long procDefId) {
        NoCodeWfMetaData noCodeWfMetaData = this.procDefId2MetaDataCache.get(procDefId);
        if (Objects.nonNull(noCodeWfMetaData)) {
            return noCodeWfMetaData;
        }
        ProcessDefinitionInfo processDefinitionInfo = this.getProcessDefinitionInfoByProcDefId(procDefId);
        if (Objects.isNull(processDefinitionInfo)) {
            return null;
        }
        Map loadModel = (Map)SerializationUtils.fromJsonString((String)processDefinitionInfo.getData(), Map.class);
        noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)loadModel, null);
        this.procDefId2MetaDataCache.put(procDefId, noCodeWfMetaData);
        return noCodeWfMetaData;
    }

    public ProcessInitiator getProcessInitiatorByProcInstId(long procInstId) {
        ProcessInitiator processInitiator = this.procInstId2ProcessInitiatorCache.get(procInstId);
        if (Objects.nonNull(processInitiator)) {
            return processInitiator;
        }
        Map processesInitiator = NoCodeWorkflowServiceHelper.getProcessesInitiator((List)Lists.newArrayList((Object[])new Long[]{procInstId}));
        if (MapUtils.isEmpty((Map)processesInitiator)) {
            return null;
        }
        processesInitiator.forEach(this.procInstId2ProcessInitiatorCache::put);
        return this.procInstId2ProcessInitiatorCache.get(procInstId);
    }

    public WfProcessStatusEnum getWfProcessStatusEnumByProcInstId(String businessKey, long procInstId) {
        WfProcessStatusEnum bizProcessStatus = this.procInstId2BizProcessStatus.get(procInstId);
        if (Objects.nonNull(bizProcessStatus)) {
            return bizProcessStatus;
        }
        Map noCodeFlowBizProcessStatus = NoCodeWorkflowServiceHelper.getNoCodeFlowBizProcessStatus((String[])new String[]{businessKey});
        List bizProcessStatuses = (List)noCodeFlowBizProcessStatus.get(businessKey);
        bizProcessStatuses.forEach(e -> {
            Long processInstanceId = e.getProcessInstanceId();
            this.procInstId2BizProcessStatus.put(processInstanceId, WfProcessStatusEnum.getById((String)e.getProcessStatus()));
        });
        return Optional.ofNullable(this.procInstId2BizProcessStatus.get(procInstId)).orElse(WfProcessStatusEnum.NORMAL);
    }
}

