/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.wf.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.FlowChartStatusEnum;
import kd.bos.nocode.constant.WfNodeEnum;
import kd.bos.nocode.constant.WfTaskHandleResultEnum;
import kd.bos.nocode.ext.constant.WfProcessStatusEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaData;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfMetaHelper;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeAudit;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeEnd;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeStart;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUserInput;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.api.model.ApprovalRecord;
import kd.bos.nocode.restapi.api.model.ApproverInfo;
import kd.bos.nocode.restapi.api.model.DecisionOption;
import kd.bos.nocode.restapi.api.model.DecisionOptionVO;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.restapi.service.wf.ApprovalRecordService;
import kd.bos.nocode.restapi.service.wf.WfProcessRequestContext;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.ProcessDefinitionInfo;
import kd.bos.workflow.api.model.ProcessInitiator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApprovalRecordServiceImpl
implements ApprovalRecordService {
    private static final Log log = LogFactory.getLog(ApprovalRecordServiceImpl.class);
    public static final String NAME = "name";
    public static final String HANDLE_STATE = "handleState";
    public static final String HANDLE_STATE_DESC = "handleStateDesc";
    private static final Pattern CAPTURE_SUB_CATEGORY = Pattern.compile("^([A-Za-z]+)\\d+$");
    private static final String ACTIVITY_NAME = "activityName";
    private static final String ERROR_MESSAGE = "errorMessage";

    private String getNoOutGoingMessage() {
        return "\u4e0d\u7b26\u5408\u6761\u4ef6";
    }

    @Override
    @NotNull
    public Map<Long, List<ApprovalRecord>> getApprovalRecords(String entityNumber, String businessKey) {
        DynamicObjectCollection sourceRecords = NoCodeWorkflowServiceHelper.getNoCodeFlowApprovalRecordsFromDetailLog((String)businessKey, (String)entityNumber);
        sourceRecords.removeIf(e -> e.getString("category").equalsIgnoreCase("EndTerminateEvent"));
        if (CollectionUtils.isEmpty((Collection)sourceRecords)) {
            return new HashMap<Long, List<ApprovalRecord>>(0);
        }
        List<ApprovalRecord> targetRecords = sourceRecords.stream().map(this::cast2ApprovalRecord).filter(Objects::nonNull).collect(Collectors.toList());
        targetRecords = this.removeDuplicateNotifyNodeRecords(targetRecords);
        Map<Long, List<ApprovalRecord>> procInstId2ApprovalRecordList = targetRecords.stream().collect(Collectors.groupingBy(ApprovalRecord::getProcInstId));
        Iterator<Map.Entry<Long, List<ApprovalRecord>>> iterator = procInstId2ApprovalRecordList.entrySet().iterator();
        HashMap<Long, List<ApprovalRecord>> finalProcInstId2ApprovalRecordList = new HashMap<Long, List<ApprovalRecord>>(procInstId2ApprovalRecordList.size());
        while (iterator.hasNext()) {
            Map.Entry<Long, List<ApprovalRecord>> entry = iterator.next();
            Long procInstId = entry.getKey();
            List<ApprovalRecord> approvalRecordList = entry.getValue();
            if (this.notStartNode(approvalRecordList = this.sortApprovalRecordList(approvalRecordList))) {
                this.addStartNode(approvalRecordList);
            }
            if (this.noEndNode(approvalRecordList)) {
                this.addEndNode(approvalRecordList, sourceRecords);
            }
            finalProcInstId2ApprovalRecordList.put(procInstId, approvalRecordList);
        }
        return finalProcInstId2ApprovalRecordList;
    }

    private List<ApprovalRecord> removeDuplicateNotifyNodeRecords(List<ApprovalRecord> records) {
        ArrayList<ApprovalRecord> resultList = new ArrayList<ApprovalRecord>(records.size());
        HashSet<String> existNotifyNodeUnionKeys = new HashSet<String>(16);
        for (ApprovalRecord record : records) {
            if (record.getWfNodeEnum() != WfNodeEnum.NoCodeWfNodeNotify) {
                resultList.add(record);
                continue;
            }
            String unionKey = record.getNodeId() + record.getChannel();
            if (!existNotifyNodeUnionKeys.add(unionKey)) continue;
            resultList.add(record);
        }
        return resultList;
    }

    private boolean notStartNode(List<ApprovalRecord> approvalRecordList) {
        return approvalRecordList.stream().noneMatch(e -> e.getWfNodeEnum() == WfNodeEnum.NoCodeWfNodeStart);
    }

    private boolean noEndNode(List<ApprovalRecord> approvalRecordList) {
        return approvalRecordList.stream().noneMatch(e -> e.getWfNodeEnum() == WfNodeEnum.NoCodeWfNodeEnd);
    }

    @NotNull
    private List<ApprovalRecord> sortApprovalRecordList(List<ApprovalRecord> approvalRecordList) {
        approvalRecordList = approvalRecordList.stream().sorted((e1, e2) -> {
            if (e1.getWfNodeEnum() == WfNodeEnum.NoCodeWfNodeEnd) {
                return -1;
            }
            if (e2.getWfNodeEnum() == WfNodeEnum.NoCodeWfNodeEnd) {
                return 1;
            }
            if (Objects.isNull(e1.getHandleTime()) && Objects.nonNull(e2.getHandleTime())) {
                return -1;
            }
            if (Objects.isNull(e2.getHandleTime()) && Objects.nonNull(e1.getHandleTime())) {
                return 1;
            }
            if (Objects.isNull(e1.getHandleTime()) && Objects.isNull(e2.getHandleTime())) {
                return 0;
            }
            return e2.getHandleTime().compareTo(e1.getHandleTime());
        }).collect(Collectors.toList());
        return approvalRecordList;
    }

    private void addStartNode(List<ApprovalRecord> value) {
        if (CollectionUtils.isEmpty(value)) {
            return;
        }
        ApprovalRecord lastRecord = value.get(0);
        Long procInstId = lastRecord.getProcInstId();
        Long procDefId = lastRecord.getProcDefId();
        NoCodeWfMetaData noCodeWfMetaData = WfProcessRequestContext.get().getNoCodeWfMetaDataByProcDefId(procDefId);
        if (Objects.isNull(noCodeWfMetaData)) {
            return;
        }
        NoCodeWfNodeStart startNodeInfo = NoCodeWfMetaHelper.getStartNode((NoCodeWfMetaData)noCodeWfMetaData);
        ProcessInitiator processInitiator = WfProcessRequestContext.get().getProcessInitiatorByProcInstId(procInstId);
        if (Objects.isNull(processInitiator)) {
            return;
        }
        ApprovalRecord startNode = new ApprovalRecord();
        startNode.setId(Long.valueOf(0L));
        startNode.setProcInstId(lastRecord.getProcInstId());
        startNode.setProcDefId(lastRecord.getProcDefId());
        startNode.setProcessName(lastRecord.getProcessName());
        startNode.setNodeId(startNodeInfo.getId());
        startNode.setNodeName("\u53d1\u8d77\u4eba");
        Long startUserId = processInitiator.getId();
        Map userAvatarPath = UserServiceHelper.getUserAvatarPath((List)Lists.newArrayList((Object[])new Long[]{startUserId}), (boolean)true);
        ArrayList<ApproverInfo> approverInfos = new ArrayList<ApproverInfo>(1);
        approverInfos.add(new ApproverInfo(startUserId + "", processInitiator.getName().toString(), (String)userAvatarPath.get(startUserId)));
        startNode.setApproverInfos(approverInfos);
        startNode.setHandleTime(processInitiator.getStartTime());
        startNode.setHandleState(WfTaskHandleResultEnum.launch.toString());
        startNode.setHandleStateDesc(WfTaskHandleResultEnum.launch.getDesc());
        startNode.setEntityNumber(lastRecord.getEntityNumber());
        startNode.setBusinessKey(lastRecord.getBusinessKey());
        startNode.setTaskId("");
        startNode.setMessage("");
        startNode.setNodeType(NoCodeWfNodeStart.class.getSimpleName());
        startNode.setFlowChartStatus(WfTaskHandleResultEnum.getFlowChartStatus((String)WfTaskHandleResultEnum.launch.toString()));
        value.add(startNode);
    }

    private void addEndNode(List<ApprovalRecord> value, DynamicObjectCollection sourceRecords) {
        NoCodeWfMetaData noCodeWfMetaData;
        if (CollectionUtils.isEmpty(value)) {
            return;
        }
        ApprovalRecord lastRecord = value.get(0);
        Long procInstId = lastRecord.getProcInstId();
        Long procDefId = lastRecord.getProcDefId();
        boolean inProcess = NoCodeWorkflowServiceHelper.inProcessByProcessInstanceId((Long)procInstId);
        if (inProcess) {
            return;
        }
        WfTaskHandleResultEnum endNodeHandleResult = this.getEndNodeHandleState(lastRecord.getBusinessKey(), procInstId);
        String errorMessage = lastRecord.getErrorMessage();
        if (StringUtils.isNotEmpty((CharSequence)errorMessage) && errorMessage.contains("bos.wf.runtime.noOutgoingSequenceError")) {
            endNodeHandleResult = WfTaskHandleResultEnum.done;
        }
        if (Objects.isNull(noCodeWfMetaData = WfProcessRequestContext.get().getNoCodeWfMetaDataByProcDefId(procDefId))) {
            return;
        }
        NoCodeWfNodeEnd endNodeInfo = NoCodeWfMetaHelper.getEndNode((NoCodeWfMetaData)noCodeWfMetaData);
        ApprovalRecord endNode = new ApprovalRecord();
        endNode.setId(Long.valueOf(ID.genLongId()));
        endNode.setTaskId("0");
        endNode.setNodeId(endNodeInfo.getId());
        endNode.setNodeName("\u6d41\u7a0b\u7ed3\u675f");
        endNode.setNodeType(WfNodeEnum.NoCodeWfNodeEnd.toString());
        endNode.setNodeTypeName(this.getNodeTypeName(WfNodeEnum.NoCodeWfNodeEnd));
        endNode.setEntityNumber(lastRecord.getEntityNumber());
        endNode.setBusinessKey(lastRecord.getBusinessKey());
        endNode.setMessage("");
        endNode.setProcInstId(lastRecord.getProcInstId());
        endNode.setProcDefId(procDefId);
        endNode.setProcessName(lastRecord.getProcessName());
        endNode.setBg(WfNodeEnum.NoCodeWfNodeEnd.getBg());
        endNode.setIcon(WfNodeEnum.NoCodeWfNodeEnd.getIcon());
        endNode.setHandleState(endNodeHandleResult.toString());
        endNode.setHandleStateDesc(endNodeHandleResult.getDesc());
        endNode.setEndType(this.getProcessStatusByProcInstId(lastRecord.getBusinessKey(), lastRecord.getProcInstId()).getId());
        endNode.setFlowChartStatus(this.getEndNodeFlowChartStatus(endNodeHandleResult, this.isEndNodeError(sourceRecords)));
        endNode.setErrorMessage(errorMessage);
        value.add(0, endNode);
    }

    @NotNull
    private WfProcessStatusEnum getProcessStatusByProcInstId(String businessKey, Long procInstId) {
        return WfProcessRequestContext.get().getWfProcessStatusEnumByProcInstId(businessKey, procInstId);
    }

    private boolean isEndNodeError(DynamicObjectCollection sourceRecords) {
        return sourceRecords.stream().anyMatch(e -> this.getNodeType((DynamicObject)e) == WfNodeEnum.NoCodeWfNodeEnd);
    }

    private FlowChartStatusEnum getEndNodeFlowChartStatus(WfTaskHandleResultEnum endNodeHandleResult, boolean isEndNodeError) {
        if (isEndNodeError) {
            return FlowChartStatusEnum.exception_terminate;
        }
        if (endNodeHandleResult == WfTaskHandleResultEnum.done) {
            return FlowChartStatusEnum.done;
        }
        return FlowChartStatusEnum.todo;
    }

    private WfTaskHandleResultEnum getEndNodeHandleState(String businessKey, Long procInstId) {
        WfProcessStatusEnum processInstanceStatus = this.getProcessStatusByProcInstId(businessKey, procInstId);
        if (WfProcessStatusEnum.NORMAL == processInstanceStatus) {
            return WfTaskHandleResultEnum.done;
        }
        if (WfProcessStatusEnum.AUDIT_ABORT == processInstanceStatus) {
            return WfTaskHandleResultEnum.terminate;
        }
        if (WfProcessStatusEnum.EXCEPTION_TERMINATE == processInstanceStatus) {
            return WfTaskHandleResultEnum.exception_terminate;
        }
        if (WfProcessStatusEnum.SUBMIT_WITHDRAW == processInstanceStatus) {
            return WfTaskHandleResultEnum.withdraw;
        }
        return WfTaskHandleResultEnum.terminate;
    }

    @Nullable
    private ApprovalRecord cast2ApprovalRecord(DynamicObject sourceRecord) {
        String channel = sourceRecord.getString("channel");
        String errorMessage = sourceRecord.getString(ERROR_MESSAGE);
        long messageId = sourceRecord.getLong("messageId");
        Date handleTime = this.getHandleTime(sourceRecord);
        long procDefId = sourceRecord.getLong("procDefId");
        String businessKey = sourceRecord.getString("businessKey");
        long procInstId = sourceRecord.getLong("procInstId");
        String handleState = sourceRecord.getString(HANDLE_STATE);
        String opinion = sourceRecord.getString("opinion");
        String activityId = sourceRecord.getString("activityId");
        WfNodeEnum nodeType = this.getNodeType(sourceRecord);
        Map<String, String> handleStateMap = this.getHandleStateMap(businessKey, procInstId, nodeType, errorMessage, handleState, opinion, sourceRecord);
        if (MapUtils.isEmpty(handleStateMap)) {
            return null;
        }
        ApprovalRecord record = new ApprovalRecord();
        record.setId(Long.valueOf(sourceRecord.getLong("id")));
        String taskId = sourceRecord.getLong("taskId") + "";
        record.setTaskId(taskId);
        record.setNodeId(activityId);
        record.setNodeName(this.getNodeName(nodeType, sourceRecord));
        record.setNodeType(nodeType.toString());
        record.setWfNodeEnum(nodeType);
        record.setNodeTypeName(this.getNodeTypeName(nodeType));
        record.setApproverInfos(this.getApproverInfos(sourceRecord, nodeType));
        record.setEntityNumber(sourceRecord.getString("entityNumber"));
        record.setBusinessKey(businessKey);
        record.setMessage(this.getMessage(sourceRecord, nodeType));
        record.setErrorMessage(sourceRecord.getString(ERROR_MESSAGE));
        record.setProcInstId(Long.valueOf(procInstId));
        record.setChannel(channel);
        record.setMessageId(Long.valueOf(messageId));
        record.setProcDefId(Long.valueOf(procDefId));
        record.setProcessName(sourceRecord.getString("processName"));
        record.setHandleState(handleStateMap.get(HANDLE_STATE));
        record.setHandleStateDesc(handleStateMap.get(HANDLE_STATE_DESC));
        record.setFlowChartStatus(WfTaskHandleResultEnum.getFlowChartStatus((String)handleStateMap.get(HANDLE_STATE)));
        record.setHandleTime(handleTime);
        record.setBg(nodeType.getBg());
        record.setIcon(nodeType.getIcon());
        record.setNodeEntityNumber(sourceRecord.getString("nodeEntityNumber"));
        record.setNodeBusinessKey(sourceRecord.getString("nodeBusinessKey"));
        record.setCanInputOrView(this.canInputOrView(record));
        record.setCanHandle(this.canHandle(record));
        this.getDisAllowList(record);
        record.setCanWithdraw(this.canWithdraw(record));
        if (nodeType == WfNodeEnum.NoCodeWfNodeAudit && WfTaskHandleResultEnum.willApproval.toString().equals(handleStateMap.get(HANDLE_STATE))) {
            record.setDecisionOptions(this.getDecisionOptions(procDefId, activityId));
        }
        return record;
    }

    private List<DecisionOptionVO> getDecisionOptions(long procDefId, String activityId) {
        NoCodeWfMetaData wfMetadata = WfProcessRequestContext.get().getNoCodeWfMetaDataByProcDefId(procDefId);
        if (Objects.isNull(wfMetadata)) {
            return new ArrayList<DecisionOptionVO>(0);
        }
        return wfMetadata.getNodes().stream().filter(e -> Objects.equals(e.getId(), activityId)).findFirst().map(NoCodeWfNodeAudit.class::cast).map(NoCodeWfNodeAudit::getDecisionOptions).map(this::cast2DecisionOptionVOList).orElseGet(ArrayList::new);
    }

    private List<DecisionOptionVO> cast2DecisionOptionVOList(List<DecisionOption> decisionOptions) {
        return decisionOptions.stream().map(e -> DecisionOptionVO.of((String)e.getNumber(), (String)e.getName(), (boolean)e.isAuditMessageMustInput())).collect(Collectors.toList());
    }

    private boolean canWithdraw(ApprovalRecord record) {
        ProcessInitiator processInitiator = WfProcessRequestContext.get().getProcessInitiatorByProcInstId(record.getProcInstId());
        if (Objects.isNull(processInitiator)) {
            return false;
        }
        Long startId = processInitiator.getId();
        boolean isInitiator = startId.longValue() == RequestContext.get().getCurrUserId();
        return this.canWithdraw(isInitiator, record);
    }

    private boolean canWithdraw(boolean isInitiator, ApprovalRecord record) {
        if (isInitiator) {
            Long procInstId = record.getProcInstId();
            Map canWithdrawMap = NoCodeWorkflowServiceHelper.canWithdrawByProcessInstanceId((Long)procInstId);
            List errorInfos = (List)canWithdrawMap.get("errorInfo");
            return CollectionUtils.isEmpty((Collection)errorInfos);
        }
        return false;
    }

    private boolean canHandle(ApprovalRecord record) {
        return this.canHandleInternal(record, e -> WfNodeEnum.NoCodeWfNodeAudit.toString().equals(record.getNodeType()) && Objects.equals(record.getHandleState(), WfTaskHandleResultEnum.willApproval.toString()));
    }

    private void getDisAllowList(ApprovalRecord record) {
        if (!record.isCanHandle()) {
            record.setDisAllowNodeList(Collections.emptyList());
            return;
        }
        Long procDefId = record.getProcDefId();
        ProcessDefinitionInfo processDefinitionInfo = WfProcessRequestContext.get().getProcessDefinitionInfoByProcDefId(procDefId);
        Map loadModel = (Map)SerializationUtils.fromJsonString((String)processDefinitionInfo.getData(), Map.class);
        NoCodeWfMetaData noCodeWfMetaData = NoCodeWfMetaHelper.deserializeFromMap((Map)loadModel, null);
        List nodes = noCodeWfMetaData.getNodes();
        String id = record.getNodeId();
        ArrayList<Map> ret = new ArrayList<Map>();
        while (id != null) {
            String finalId = id;
            Optional<NoCodeWfNode> node = nodes.stream().filter(s -> s.getId().equals(finalId)).findFirst();
            if (!node.isPresent()) break;
            NoCodeWfNode n = node.get();
            id = n.getParentId();
            if (n.getId().equals(record.getNodeId())) continue;
            if (n instanceof NoCodeWfNodeUserInput) {
                ret.add(Maps.of((Object)"nodeId", (Object)n.getId(), (Object)NAME, (Object)n.getName()));
                break;
            }
            if (WfProcessUtils.terminate.contains(n.getClass())) break;
            if (!(n instanceof NoCodeWfNodeAudit)) continue;
            ret.add(Maps.of((Object)"nodeId", (Object)n.getId(), (Object)NAME, (Object)n.getName()));
        }
        record.setDisAllowNodeList(ret);
        record.setCanDisallow(!ret.isEmpty());
    }

    private String getNodeName(WfNodeEnum wfNodeEnum, DynamicObject sourceRecord) {
        if (wfNodeEnum == WfNodeEnum.NoCodeWfNodeEnd) {
            return "\u6d41\u7a0b\u7ed3\u675f";
        }
        return sourceRecord.getString(ACTIVITY_NAME);
    }

    private String getNodeTypeName(WfNodeEnum wfNodeEnum) {
        return wfNodeEnum.getName();
    }

    private boolean canInputOrView(ApprovalRecord record) {
        return this.canHandleInternal(record, e -> WfNodeEnum.NoCodeWfNodeUserInput.toString().equals(record.getNodeType()) && Objects.equals(record.getHandleState(), WfTaskHandleResultEnum.willHandled.toString()));
    }

    private boolean canHandleInternal(ApprovalRecord record, Predicate<ApprovalRecord> predicate) {
        long currentUserId;
        List handleIds = record.getApproverInfos().stream().map(ApproverInfo::getHandlerId).collect(Collectors.toList());
        return handleIds.contains((currentUserId = RequestContext.get().getCurrUserId()) + "") && predicate.test(record);
    }

    private WfNodeEnum getNodeType(DynamicObject sourceRecord) {
        WfNodeEnum nodeTypeEnum;
        String category = sourceRecord.getString("category");
        String activityId = sourceRecord.getString("activityId");
        switch (category) {
            case "AuditTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeAudit;
                break;
            }
            case "UserTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeUserInput;
                break;
            }
            case "StartSignalEvent": 
            case "StartTimeEvent": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeStart;
                break;
            }
            case "EndNoneEvent": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeEnd;
                break;
            }
            case "NotifyTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeNotify;
                break;
            }
            case "JudgeTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeJudge;
                break;
            }
            case "AutoMicroServiceTask": {
                nodeTypeEnum = this.handleAutoMicroServiceTaskCategory(activityId, sourceRecord);
                break;
            }
            default: {
                nodeTypeEnum = this.getNodeTypeDeprecated(sourceRecord);
            }
        }
        return nodeTypeEnum;
    }

    private WfNodeEnum handleAutoMicroServiceTaskCategory(String activityId, DynamicObject sourceRecord) {
        WfNodeEnum nodeTypeEnum;
        String subCategory;
        switch (subCategory = this.parseSubCategory(activityId)) {
            case "CalculateAutoTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeCalculate;
                break;
            }
            case "UpdateBillAutoTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeUpdateBill;
                break;
            }
            case "QueryDataAutoTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeQueryData;
                break;
            }
            case "NewBillAutoTask": {
                nodeTypeEnum = WfNodeEnum.NoCodeWfNodeNewBill;
                break;
            }
            default: {
                nodeTypeEnum = this.getNodeTypeDeprecated(sourceRecord);
            }
        }
        return nodeTypeEnum;
    }

    @Deprecated
    private WfNodeEnum getNodeTypeDeprecated(DynamicObject sourceRecord) {
        long procDefId = sourceRecord.getLong("procDefId");
        String activityId = sourceRecord.getString("activityId");
        NoCodeWfMetaData noCodeWfMetaData = WfProcessRequestContext.get().getNoCodeWfMetaDataByProcDefId(procDefId);
        if (Objects.isNull(noCodeWfMetaData)) {
            throw new RestApiException("\u83b7\u53d6\u6d41\u7a0b\u5143\u6570\u636e\u5931\u8d25");
        }
        return WfNodeEnum.valueOf((String)noCodeWfMetaData.getNodes().stream().filter(e -> Objects.equals(activityId, e.getId())).map(e -> e.getClass().getSimpleName()).findFirst().orElse(""));
    }

    @NotNull
    private String parseSubCategory(String activityId) {
        int lastUnderlineIndex = activityId.lastIndexOf("_");
        Matcher matcher = CAPTURE_SUB_CATEGORY.matcher(activityId = activityId.substring(lastUnderlineIndex + 1));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    private List<ApproverInfo> getApproverInfos(DynamicObject sourceRecord, WfNodeEnum nodeType) {
        if (nodeType == WfNodeEnum.NoCodeWfNodeStart) {
            return this.getStarterInfo(sourceRecord);
        }
        String assigneeId = sourceRecord.getString("assigneeId");
        String assignee = sourceRecord.getString("assignee");
        String assigneeAvatar = sourceRecord.getString("assigneeAvatar");
        if (StringUtils.isBlank((CharSequence)assigneeId)) {
            return new ArrayList<ApproverInfo>(0);
        }
        String[] assigneeIdArray = assigneeId.split(",");
        String[] assigneeArray = assignee.split(",");
        String[] assigneeAvatarArray = assigneeAvatar.split(",");
        ArrayList<ApproverInfo> approverInfos = new ArrayList<ApproverInfo>(assigneeIdArray.length);
        for (int i = 0; i < assigneeIdArray.length; ++i) {
            String id = assigneeIdArray[i];
            String name = assigneeArray[i];
            String avatar = assigneeAvatarArray[i];
            ApproverInfo approverInfo = new ApproverInfo(id, name, avatar);
            approverInfos.add(approverInfo);
        }
        return approverInfos;
    }

    private List<ApproverInfo> getStarterInfo(DynamicObject sourceRecord) {
        String startId = sourceRecord.getString("startId");
        String startName = sourceRecord.getString("startName");
        String startAvatar = sourceRecord.getString("startAvatar");
        ArrayList<ApproverInfo> approverInfos = new ArrayList<ApproverInfo>(1);
        ApproverInfo approverInfo = new ApproverInfo(startId, startName, startAvatar);
        approverInfos.add(approverInfo);
        return approverInfos;
    }

    @Nullable
    private Date getHandleTime(DynamicObject sourceRecord) {
        String handleState = sourceRecord.getString(HANDLE_STATE);
        Date createDate = handleState.equalsIgnoreCase(WfTaskHandleResultEnum.willApproval.toString()) || handleState.equalsIgnoreCase(WfTaskHandleResultEnum.willHandled.toString()) ? null : sourceRecord.getDate("createDate");
        return createDate;
    }

    private String getMessage(DynamicObject sourceRecord, WfNodeEnum nodeType) {
        String opinion = sourceRecord.getString("opinion");
        if (nodeType == WfNodeEnum.NoCodeWfNodeEnd) {
            return "";
        }
        if (nodeType == WfNodeEnum.NoCodeWfNodeAudit || nodeType == WfNodeEnum.NoCodeWfNodeUserInput) {
            return opinion;
        }
        if (nodeType == WfNodeEnum.NoCodeWfNodeNotify) {
            if ("fail".equalsIgnoreCase(opinion)) {
                return WfTaskHandleResultEnum.exception_terminate.getDesc();
            }
            return "\u5b8c\u6210";
        }
        String errorMessage = sourceRecord.getString(ERROR_MESSAGE);
        if (StringUtils.isNotBlank((CharSequence)errorMessage) && errorMessage.contains("bos.wf.runtime.noOutgoingSequenceError") && nodeType == WfNodeEnum.NoCodeWfNodeGateway) {
            return this.getNoOutGoingMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage) && !errorMessage.contains("bos.wf.runtime.noOutgoingSequenceError")) {
            return WfTaskHandleResultEnum.exception_terminate.getDesc();
        }
        return "\u5b8c\u6210";
    }

    @Nullable
    private Map<String, String> getHandleStateMap(String businessKey, long procInstId, WfNodeEnum nodeType, String errMsg, String handleState, String opinion, DynamicObject sourceRecord) {
        HashMap<String, String> handleStateMap = new HashMap<String, String>(2);
        handleStateMap.put(HANDLE_STATE, handleState);
        String resultName = "";
        if (sourceRecord.containsProperty("resultName")) {
            resultName = sourceRecord.getString("resultName");
        }
        if (nodeType == WfNodeEnum.NoCodeWfNodeStart) {
            handleStateMap.put(HANDLE_STATE, WfTaskHandleResultEnum.launch.toString());
            handleStateMap.put(HANDLE_STATE_DESC, WfTaskHandleResultEnum.launch.getDesc());
            return handleStateMap;
        }
        if (nodeType == WfNodeEnum.NoCodeWfNodeEnd) {
            WfTaskHandleResultEnum endNodeHandleState = this.getEndNodeHandleState(businessKey, procInstId);
            handleStateMap.put(HANDLE_STATE, endNodeHandleState.toString());
            handleStateMap.put(HANDLE_STATE_DESC, endNodeHandleState.getDesc());
            return handleStateMap;
        }
        if (nodeType == WfNodeEnum.NoCodeWfNodeNotify) {
            if (StringUtils.isBlank((CharSequence)opinion) && StringUtils.isBlank((CharSequence)errMsg)) {
                return null;
            }
            WfTaskHandleResultEnum resultEnum = WfTaskHandleResultEnum.done;
            if ("fail".equalsIgnoreCase(opinion) || !StringUtils.isBlank((CharSequence)errMsg) && !errMsg.contains("bos.wf.runtime.noOutgoingSequenceError")) {
                resultEnum = WfTaskHandleResultEnum.exception_terminate;
            }
            handleStateMap.put(HANDLE_STATE, resultEnum.toString());
            handleStateMap.put(HANDLE_STATE_DESC, resultEnum.getDesc());
            return handleStateMap;
        }
        if (nodeType != WfNodeEnum.NoCodeWfNodeAudit && nodeType != WfNodeEnum.NoCodeWfNodeUserInput) {
            if (StringUtils.isNotEmpty((CharSequence)errMsg) && !errMsg.contains("bos.wf.runtime.noOutgoingSequenceError")) {
                handleStateMap.put(HANDLE_STATE, WfTaskHandleResultEnum.exception_terminate.toString());
            } else {
                handleStateMap.put(HANDLE_STATE, WfTaskHandleResultEnum.done.toString());
            }
        } else if (StringUtils.isNotEmpty((CharSequence)errMsg) && !errMsg.contains("bos.wf.runtime.noOutgoingSequenceError")) {
            handleStateMap.put(HANDLE_STATE, WfTaskHandleResultEnum.exception_terminate.toString());
        }
        if (WfTaskHandleResultEnum.dismissed.toString().equalsIgnoreCase(handleState)) {
            if (nodeType == WfNodeEnum.NoCodeWfNodeAudit) {
                handleStateMap.put(HANDLE_STATE, WfTaskHandleResultEnum.willApproval.toString());
            } else if (nodeType == WfNodeEnum.NoCodeWfNodeUserInput) {
                handleStateMap.put(HANDLE_STATE, WfTaskHandleResultEnum.willHandled.toString());
            }
        }
        handleStateMap.put(HANDLE_STATE_DESC, WfTaskHandleResultEnum.getHandleStateDesc((String)((String)handleStateMap.get(HANDLE_STATE))));
        if (nodeType == WfNodeEnum.NoCodeWfNodeAudit && StringUtils.isNotBlank((CharSequence)resultName)) {
            handleStateMap.put(HANDLE_STATE_DESC, resultName);
        }
        return handleStateMap;
    }
}

