/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.wf.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.MessageType;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.service.wf.NoCodeMessageService;
import kd.bos.nocode.restapi.service.wf.pojo.MessageInfo;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.api.MessageRequestInfo;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class NoCodeMessageServiceImpl
implements NoCodeMessageService {
    private static final Log logger = LogFactory.getLog(NoCodeMessageServiceImpl.class);
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"NoCodeMessageServiceImpl-Thread", (int)2, (int)4);

    private String getMsgFmt() {
        return "\u60a8\u6709\u4e00\u6761\u3010%s\u3011\u7684%s\u5f85\u5904\u7406";
    }

    @Override
    public List<MessageInfo> getAllMessage(long userId, int pageNo, int pageSize) {
        logger.debug(ResManager.loadKDString((String)"\u5206\u9875\u67e5\u8be2\u6d88\u606f, userId=%s, pageNo=%s, pageSize=%s", (String)"NoCodeMessageServiceImpl_1", (String)"BOS_NOCODE", (Object[])new Object[]{userId, pageNo, pageSize}));
        CompletableFuture<List<MessageInfo>> allMessageInfosFuture = this.getAllMessageInfosAsync(userId, pageNo, pageSize);
        List<MessageInfo> allMessage = allMessageInfosFuture.join();
        List lists = Lists.partition(allMessage, (int)pageSize);
        List<MessageInfo> tasks = new ArrayList<MessageInfo>(pageSize);
        int index = pageNo - 1;
        if (index < lists.size()) {
            tasks = (List)lists.get(index);
        }
        return tasks;
    }

    private CompletableFuture<List<MessageInfo>> getAllMessageInfosAsync(long userId, int pageNo, int pageSize) {
        return this.getMessageNodeInfoAsync(userId, pageNo, pageSize).thenCombine(this.getToHandleTaskMessageAsync(userId, pageNo, pageSize), (messageNodeInfos, toHandleTaskMessageInfos) -> {
            ArrayList<MessageInfo> allMessage = new ArrayList<MessageInfo>(messageNodeInfos.size() + toHandleTaskMessageInfos.size());
            allMessage.addAll((Collection<MessageInfo>)messageNodeInfos);
            allMessage.addAll((Collection<MessageInfo>)toHandleTaskMessageInfos);
            allMessage.sort(Comparator.comparing(MessageInfo::getCreateDate).reversed());
            return allMessage;
        });
    }

    private CompletableFuture<List<MessageInfo>> getToHandleTaskMessageAsync(long userId, int pageNo, int pageSize) {
        return CompletableFuture.supplyAsync(() -> {
            Instant start = Instant.now();
            int limit = pageNo * pageSize;
            DynamicObjectCollection tasks = NoCodeWorkflowServiceHelper.getNoCodeFlowToHandleTasksByUserId((int)0, (int)limit, (String)String.valueOf(userId));
            logger.debug("getToHandleTaskMessageAsync cost: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
            return tasks.stream().map(this::wrapTask2Message).collect(Collectors.toList());
        }, executorService);
    }

    private CompletableFuture<List<MessageInfo>> getMessageNodeInfoAsync(long userId, int pageNo, int pageSize) {
        return CompletableFuture.supplyAsync(() -> {
            Instant start = Instant.now();
            MessageRequestInfo messageRequestInfo = new MessageRequestInfo();
            messageRequestInfo.setUserId(Long.valueOf(userId));
            messageRequestInfo.setStart(0);
            int limit = pageNo * pageSize;
            messageRequestInfo.setLimit(limit);
            List nodeMessageList = MessageCenterServiceHelper.getNoCodeFlowMessageData((MessageRequestInfo)messageRequestInfo);
            logger.debug("getMessageNodeInfo cost: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
            return nodeMessageList.stream().map(this::nodeMessage2MessageInfo).collect(Collectors.toList());
        }, executorService);
    }

    private MessageInfo nodeMessage2MessageInfo(Map<String, Object> nodeMessage) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setId(String.valueOf(nodeMessage.get("id")));
        messageInfo.setContent((String)nodeMessage.get("content"));
        messageInfo.setCreateDate((Date)nodeMessage.get("createdate"));
        messageInfo.setType(MessageType.WF_MESSAGE_NODE);
        messageInfo.setSource("\u6d41\u7a0b\u4e2d\u5fc3");
        messageInfo.setReadState((String)nodeMessage.get("readstate"));
        messageInfo.setEntityNumber((String)nodeMessage.get("entitynumber"));
        messageInfo.setBusinessKey((String)nodeMessage.get("businesskey"));
        return messageInfo;
    }

    private MessageInfo wrapTask2Message(DynamicObject task) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setId(String.valueOf(task.getLong("id")));
        String subject = task.getString("subject");
        String handleState = task.getString("handleState");
        String procDefName = task.getString("procDefName");
        String taskTypeDesc = WfProcessUtils.getToHandleTaskTypeDesc((String)task.getString("category"));
        String content = String.format(this.getMsgFmt(), procDefName, taskTypeDesc);
        if (StringUtils.isNotEmpty((CharSequence)subject)) {
            content = content + "\uff0c\u4efb\u52a1\u4e3b\u9898\uff1a\u3010" + subject + "\u3011";
        }
        messageInfo.setContent(content);
        messageInfo.setCreateDate(task.getDate("createDate"));
        messageInfo.setType(MessageType.WF_TO_HANDLED_TASK);
        messageInfo.setSource("\u6d41\u7a0b\u4e2d\u5fc3");
        messageInfo.setReadState("unread");
        messageInfo.setEntityNumber(task.getString("entitynumber"));
        messageInfo.setBusinessKey(task.getString("businessKey"));
        messageInfo.setProcInstId(task.getString("procInstId"));
        messageInfo.setProcDefId(task.getString("procDefId"));
        messageInfo.setProcDefId(task.getString("procDefId"));
        messageInfo.setNodeBusinessKey(task.getString("nodeBusinessKey"));
        messageInfo.setNodeEntityNumber(task.getString("nodeEntityNumber"));
        messageInfo.setActivityId(task.getString("activityId"));
        messageInfo.setAppId(FormMetaUtil.getAppIdByFormId((String)messageInfo.getEntityNumber()));
        return messageInfo;
    }

    @Override
    public long countAllMessage(long userId) {
        Long messageCount = MessageCenterServiceHelper.getNoCodeFlowMessageCount((String)String.valueOf(userId));
        Long toHandleTaskCount = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)String.valueOf(userId), (String)"toHandle");
        return messageCount + toHandleTaskCount;
    }

    @Override
    public long countUnreadMessage(long userId) {
        Long unReadMessageCount = MessageCenterServiceHelper.getNoCodeFlowUnReadMessageCount((String)String.valueOf(userId));
        Long toHandleTaskCount = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)String.valueOf(userId), (String)"toHandle");
        return unReadMessageCount + toHandleTaskCount;
    }

    @Override
    public void setMessageReaded(List<String> msgIds) {
        for (String msgIdStr : msgIds) {
            long msgId = Long.parseLong(msgIdStr);
            ArrayList userIdList = Lists.newArrayList((Object[])new Long[]{RequestContext.get().getCurrUserId()});
            MessageCenterServiceHelper.setMsgReadState((Long)msgId, (List)userIdList);
        }
    }
}

