/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.service.wf.impl;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.WfTaskActionEnum;
import kd.bos.nocode.constant.WfTaskHandleResultEnum;
import kd.bos.nocode.ext.constant.WfTaskTypeEnum;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.bos.workflow.exception.WFTaskException;
import org.apache.curator.shaded.com.google.common.collect.Lists;

public class WfProcessDataServiceImpl
implements WfProcessDataService {
    private static final Log log = LogFactory.getLog(WfProcessDataServiceImpl.class);
    public static final String ID = "id";
    public static final String ENTITY_NUMBER = "entityNumber";
    public static final String ENTITY_NAME = "entityName";
    public static final String START_NAME = "startName";
    public static final String START_USER_ID = "startUserId";
    public static final String START_USER_IMG_URL = "startUserImgUrl";
    public static final String PROC_DEF_ID = "procDefId";
    public static final String PROC_DEF_NAME = "procDefName";
    public static final String CREATE_DATE = "createDate";
    public static final String HANDLE_TIME = "handleTime";
    public static final String HANDLE_STATE = "handleState";
    public static final String BUSINESS_KEY = "businessKey";
    public static final String HANDLE_STATE_DESC = "handleStateDesc";
    public static final String APP_ID = "appId";
    public static final String APP_NAME = "appName";
    public static final String TARGET_FORM_ID = "targetFormId";
    public static final String PROC_INST_ID = "procInstId";
    public static final String ACTIVITY_USER_ID = "activityUserId";
    public static final String ACTIVITY_USER_NAME = "activityUserName";
    public static final String ACTIVITY_USER_IMG_URL = "activityUserImgUrl";
    public static final String ACTIVITY_ID = "activityId";
    public static final String ACTIVITY_NAME = "activityName";
    public static final String CATEGORY = "category";
    public static final String END_TYPE = "endType";
    public static final String END_TIME = "endTime";
    public static final int AUDIT_MESSAGE_PREFIX_COUNT = 255;
    public static final String NODE_BUSINESS_KEY = "nodeBusinessKey";
    public static final String NODE_ENTITY_NUMBER = "nodeEntityNumber";
    public static final String TASK_SUBJECT = "subject";
    public static final String SENDER_NAME = "senderName";
    public static final String PRESENT_ASSIGNEE = "presentAssignee";
    private static final String DELETE_REASON = "deleteReason";
    private static final int PER_PROCESS_COUNT = 1000;
    private static final ExecutorService es = ThreadPools.newExecutorService((String)"WfProcessDataServiceImpl", (int)3);

    @Override
    public long getTaskCount(long userId, WfTaskTypeEnum wfTaskType) {
        long count;
        String uid = userId + "";
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u4efb\u52a1\u6570\uff0c\u53c2\u6570\uff1auid={}, wfTaskType={}", (Object)uid, (Object)wfTaskType);
        switch (wfTaskType) {
            case toHandle: {
                count = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)uid, (String)"toHandle");
                break;
            }
            case handled: {
                count = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)uid, (String)"handled");
                break;
            }
            case toApply: {
                count = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)uid, (String)"toApply");
                break;
            }
            case applyed: {
                count = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)uid, (String)"applyed");
                break;
            }
            case toApply_and_applyed: {
                count = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)uid, (String)"toApply") + NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)uid, (String)"applyed");
                break;
            }
            default: {
                count = 0L;
            }
        }
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u4efb\u52a1\u6570\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)count);
        return count;
    }

    @Override
    public List<Map<String, Object>> getTaskList(long userId, WfTaskTypeEnum wfTaskType, int pageNo, int pageSize) {
        List<Map<String, Object>> taskList;
        switch (wfTaskType) {
            case toHandle: {
                taskList = this.getToHandleTask(pageNo, pageSize);
                break;
            }
            case handled: {
                taskList = this.getHandledTasks(pageNo, pageSize);
                break;
            }
            case toApply: {
                taskList = this.getInProcessApply(pageNo, pageSize);
                break;
            }
            case applyed: {
                taskList = this.getApplyedProcess(pageNo, pageSize);
                break;
            }
            case toApply_and_applyed: {
                taskList = this.getToApplyAndApplyed(pageNo, pageSize);
                break;
            }
            default: {
                taskList = new ArrayList<Map<String, Object>>(0);
            }
        }
        return taskList;
    }

    @Override
    public void consent(Long taskId, String message) {
        this.completeTask(taskId, WfTaskActionEnum.Consent.toString(), message);
    }

    @Override
    public void reject(Long taskId, String message, String preId) {
        if (StringUtils.isEmpty((String)preId)) {
            throw new RestApiException(ResManager.loadKDString((String)"\u9a73\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u9a73\u56de\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a", (String)"WfProcessDataServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        HashMap<String, Object> vars = new HashMap<String, Object>(2);
        vars.put("nextNodeId", preId);
        this.completeTask(taskId, WfTaskActionEnum.Reject.toString(), message, vars);
    }

    @Override
    public void terminate(Long taskId, String message) {
        this.completeTask(taskId, WfTaskActionEnum.Terminate.toString(), message);
    }

    @Override
    public void withdraw(String procInstId) {
        try {
            Instant start = Instant.now();
            NoCodeWorkflowServiceHelper.withdrawByProcessInstanceId((Long)Long.parseLong(procInstId));
            Instant end = Instant.now();
            log.debug("workflow withdraw operate cost: {} s.", (Object)((double)Duration.between(start, end).toMillis() / 1000.0));
        }
        catch (KDException e) {
            if ("bos.wf.canNotWithdraw".equalsIgnoreCase(e.getErrorCode().getCode()) && e.getMessage().contains(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u6d41\u7a0b", (String)"WfProcessDataServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]))) {
                throw new RestApiException(ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f53\u524d\u6d41\u7a0b\u5df2\u7ed3\u675f", (String)"WfProcessDataServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            throw e;
        }
    }

    @Override
    public void completeTask(Long taskId, String code) {
        this.completeTask(taskId, code, "");
    }

    @Override
    public void completeTask(Long taskId, String code, String message) {
        this.completeTask(taskId, code, message, new HashMap<String, Object>(0));
    }

    @Override
    public void deleteWfInfoByEntityNumbers(List<String> entityNumbers) {
        es.submit(() -> {
            Map<String, List> entityNumber2ProcDefIds = entityNumbers.stream().collect(Collectors.toMap(e -> e, NoCodeWorkflowServiceHelper::getProcDefIdsByEntityNumber));
            entityNumber2ProcDefIds.forEach((entityNumber, procDefIds) -> procDefIds.forEach(this::deleteWfInfoByProcDefId));
        });
    }

    @Override
    public void deleteWfInfoByEntityNumber(String entityNumber) {
        this.deleteWfInfoByEntityNumbers(Lists.newArrayList((Object[])new String[]{entityNumber}));
    }

    @Override
    public void deleteWfInfoByEntityNumberAndBusinessKey(String entityNumber, String businessKey) {
        es.submit(() -> {
            Long procInstCount = NoCodeWorkflowServiceHelper.getProcessInstanceCountByEntityNumberOrBusinessKey((String)entityNumber, (String)businessKey);
            int loopCount = (int)Math.ceil((double)procInstCount.longValue() * 1.0 / 1000.0);
            for (int i = 0; i < loopCount; ++i) {
                List procInstIds = NoCodeWorkflowServiceHelper.getProcInstIdsByEntityNumberOrBusinessKey((int)0, (int)1000, (String)entityNumber, (String)businessKey);
                for (Long procInstId : procInstIds) {
                    try {
                        NoCodeWorkflowServiceHelper.deleteProcessInstanceInfoByProcInstId((Long)procInstId);
                    }
                    catch (Exception e) {
                        log.debug("deleteProcessInstanceInfoByProcInstId error: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        });
    }

    @Override
    public void deleteWfInfoByModelId(Long modelId) {
        es.submit(() -> {
            List procDefIds = NoCodeWorkflowServiceHelper.getProcDefIdsByModelId((Long)modelId);
            procDefIds.forEach(this::deleteWfInfoByProcDefId);
            NoCodeWorkflowServiceHelper.deleteProcessByModelId((Long)modelId);
        });
    }

    private void deleteWfInfoByProcDefId(Long procDefId) {
        try {
            Long procInstCount = NoCodeWorkflowServiceHelper.getProcessInstanceCountByProcDefId((Long)procDefId);
            int loopCount = (int)Math.ceil((double)procInstCount.longValue() * 1.0 / 1000.0);
            for (int i = 0; i < loopCount; ++i) {
                List procInstIds = NoCodeWorkflowServiceHelper.getProcInstIdsByProcDefId((int)0, (int)1000, (Long)procDefId);
                for (Long procInstId : procInstIds) {
                    NoCodeWorkflowServiceHelper.deleteProcessInstanceInfoByProcInstId((Long)procInstId);
                }
            }
            NoCodeWorkflowServiceHelper.deleteProcessByProcDefId((Long)procDefId);
        }
        catch (Exception e) {
            log.debug("deleteWfInfoByProcDefId error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void completeTask(Long taskId, String code, String message, Map<String, Object> variables) {
        block4: {
            if (!StringUtils.isBlank((String)message) && message.length() > 255) {
                throw new RestApiException(ResManager.loadKDString((String)"\u5ba1\u6279\u610f\u89c1\u5b57\u6570\u4e0d\u80fd\u8d85\u8fc7%s", (String)"WfProcessDataServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[]{255}));
            }
            try {
                NoCodeWorkflowServiceHelper.completeTask((Long)taskId, (Long)RequestContext.get().getCurrUserId(), (String)code, (String)message, variables);
            }
            catch (WFTaskException e) {
                if ("bos.wf.task.taskNotFound".equalsIgnoreCase(e.getErrorCode().getCode())) {
                    throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u5df2\u7ecf\u4e0d\u662f\u4efb\u52a1\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u64cd\u4f5c", (String)"WfProcessDataServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
                }
                if (!"bos.wf.task.taskCompleted".equalsIgnoreCase(e.getErrorCode().getCode())) break block4;
                throw new RestApiException(ResManager.loadKDString((String)"\u60a8\u5df2\u7ecf\u4e0d\u662f\u4efb\u52a1\u7684\u5904\u7406\u4eba\uff0c\u4e0d\u80fd\u64cd\u4f5c", (String)"WfProcessDataServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
        }
    }

    private int getStartIndex(int pageNo, int pageSize) {
        return (pageNo - 1) * pageSize;
    }

    private Map<String, Object> cast2ToHandleMap(DynamicObject dynamicObject) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>(20);
        String procDefName = dynamicObject.getString(PROC_DEF_NAME);
        String startName = dynamicObject.getString(START_NAME);
        String activityName = dynamicObject.getString(ACTIVITY_NAME);
        String nodeEntityNumber = dynamicObject.getString(NODE_ENTITY_NUMBER);
        String entityName = dynamicObject.getString(ENTITY_NAME);
        String taskSubject = dynamicObject.getString(TASK_SUBJECT);
        String handleState = dynamicObject.getString(HANDLE_STATE);
        Date createDate = dynamicObject.getDate(CREATE_DATE);
        long id = dynamicObject.getLong(ID);
        String entityNumber = dynamicObject.getString(ENTITY_NUMBER);
        AppInfo appInfo = this.getAppInfo(entityNumber);
        String startUserId = dynamicObject.getString(START_USER_ID);
        String startUserImgUrl = dynamicObject.getString(START_USER_IMG_URL);
        String procDefId = dynamicObject.getString(PROC_DEF_ID);
        Object businessKey = dynamicObject.get(BUSINESS_KEY);
        String procInstId = dynamicObject.getString(PROC_INST_ID);
        String nodeBusinessKey = dynamicObject.getString(NODE_BUSINESS_KEY);
        String activityId = dynamicObject.getString(ACTIVITY_ID);
        String senderName = dynamicObject.getString(SENDER_NAME);
        if (WfTaskHandleResultEnum.dismissed.toString().equalsIgnoreCase(handleState)) {
            String category = dynamicObject.getString(CATEGORY);
            if ("AuditTask".equalsIgnoreCase(category)) {
                handleState = WfTaskHandleResultEnum.willApproval.toString();
            } else if ("UserTask".equalsIgnoreCase(category)) {
                handleState = WfTaskHandleResultEnum.willHandled.toString();
            }
        }
        itemMap.put(START_USER_ID, startUserId);
        itemMap.put(ID, id);
        itemMap.put(START_NAME, startName);
        itemMap.put(START_USER_IMG_URL, startUserImgUrl);
        itemMap.put(HANDLE_STATE, handleState);
        itemMap.put(HANDLE_STATE_DESC, WfTaskHandleResultEnum.getHandleStateDesc((String)handleState));
        itemMap.put(APP_ID, appInfo.getId());
        itemMap.put(APP_NAME, appInfo.getName().toString());
        itemMap.put(TARGET_FORM_ID, entityNumber);
        itemMap.put(ENTITY_NAME, entityName);
        itemMap.put(BUSINESS_KEY, businessKey);
        itemMap.put(PROC_DEF_NAME, procDefName);
        itemMap.put(PROC_DEF_ID, procDefId);
        itemMap.put(CREATE_DATE, createDate);
        itemMap.put(PROC_INST_ID, procInstId);
        itemMap.put(NODE_BUSINESS_KEY, nodeBusinessKey);
        itemMap.put(NODE_ENTITY_NUMBER, nodeEntityNumber);
        itemMap.put(TASK_SUBJECT, taskSubject);
        itemMap.put(ACTIVITY_ID, activityId);
        itemMap.put(ACTIVITY_NAME, activityName);
        itemMap.put(SENDER_NAME, senderName);
        return itemMap;
    }

    private Map<String, Object> cast2HandledMap(DynamicObject dynamicObject) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>(20);
        long id = dynamicObject.getLong(ID);
        String entityNumber = dynamicObject.getString(ENTITY_NUMBER);
        String entityName = dynamicObject.getString(ENTITY_NAME);
        AppInfo appInfo = this.getAppInfo(entityNumber);
        String startUserId = dynamicObject.getString(START_USER_ID);
        String startName = dynamicObject.getString(START_NAME);
        String startUserImgUrl = dynamicObject.getString(START_USER_IMG_URL);
        String procDefId = dynamicObject.getString(PROC_DEF_ID);
        String procDefName = dynamicObject.getString(PROC_DEF_NAME);
        Date createDate = dynamicObject.getDate(CREATE_DATE);
        String handleState = dynamicObject.getString(HANDLE_STATE);
        Object businessKey = dynamicObject.get(BUSINESS_KEY);
        String procInstId = dynamicObject.getString(PROC_INST_ID);
        String nodeBusinessKey = dynamicObject.getString(NODE_BUSINESS_KEY);
        String nodeEntityNumber = dynamicObject.getString(NODE_ENTITY_NUMBER);
        String taskSubject = dynamicObject.getString(TASK_SUBJECT);
        String activityId = dynamicObject.getString(ACTIVITY_ID);
        String activityName = dynamicObject.getString(ACTIVITY_NAME);
        Date endTime = dynamicObject.getDate(END_TIME);
        String resultNumber = dynamicObject.getString("resultNumber");
        String resultName = WfProcessDataServiceImpl.getResultName(dynamicObject, resultNumber);
        String presentAssignee = this.getHandleTaskPresentUser(dynamicObject);
        itemMap.put(ID, id);
        itemMap.put(START_USER_ID, startUserId);
        itemMap.put(START_NAME, startName);
        itemMap.put(START_USER_IMG_URL, startUserImgUrl);
        itemMap.put(HANDLE_STATE, handleState);
        itemMap.put(HANDLE_STATE_DESC, resultName);
        itemMap.put(APP_ID, appInfo.getId());
        itemMap.put(APP_NAME, appInfo.getName().toString());
        itemMap.put(TARGET_FORM_ID, entityNumber);
        itemMap.put(ENTITY_NAME, entityName);
        itemMap.put(BUSINESS_KEY, businessKey);
        itemMap.put(PROC_DEF_NAME, procDefName);
        itemMap.put(PROC_DEF_ID, procDefId);
        itemMap.put(HANDLE_TIME, endTime);
        itemMap.put(PROC_INST_ID, procInstId);
        itemMap.put(NODE_BUSINESS_KEY, nodeBusinessKey);
        itemMap.put(NODE_ENTITY_NUMBER, nodeEntityNumber);
        itemMap.put(TASK_SUBJECT, taskSubject);
        itemMap.put(ACTIVITY_ID, activityId);
        itemMap.put(ACTIVITY_NAME, activityName);
        itemMap.put(PRESENT_ASSIGNEE, presentAssignee);
        return itemMap;
    }

    private static String getResultName(DynamicObject dynamicObject, String resultNumber) {
        String resultName = WfTaskActionEnum.handle.toString().equals(resultNumber) ? ResManager.loadKDString((String)"\u5df2\u5f55\u5165", (String)"WfProcessDataServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0]) : dynamicObject.getString("resultName");
        return resultName;
    }

    private String getHandleTaskPresentUser(DynamicObject dynamicObject) {
        int lastVerticalBar;
        String presentUser = dynamicObject.getString(PRESENT_ASSIGNEE);
        if (!StringUtils.isBlank((String)presentUser) && presentUser.contains("|") && (lastVerticalBar = presentUser.lastIndexOf("|")) != presentUser.length() - 1) {
            return presentUser.substring(lastVerticalBar + 1);
        }
        return presentUser;
    }

    private Map<String, Object> cast2ToApplyMap(DynamicObject dynamicObject) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>(20);
        String id = dynamicObject.getString(PROC_INST_ID);
        String entityNumber = dynamicObject.getString(ENTITY_NUMBER);
        String entityName = dynamicObject.getString(ENTITY_NAME);
        AppInfo appInfo = this.getAppInfo(entityNumber);
        String startUserId = dynamicObject.getString(START_USER_ID);
        String startName = dynamicObject.getString(START_NAME);
        String startUserImgUrl = dynamicObject.getString(START_USER_IMG_URL);
        String procDefId = dynamicObject.getString(PROC_DEF_ID);
        String procDefName = dynamicObject.getString(PROC_DEF_NAME);
        Date createDate = dynamicObject.getDate(CREATE_DATE);
        String endType = dynamicObject.getString(END_TYPE);
        Object businessKey = dynamicObject.get(BUSINESS_KEY);
        String activityUserId = dynamicObject.getString(ACTIVITY_USER_ID);
        String activityUserName = dynamicObject.getString(ACTIVITY_USER_NAME);
        String activityUserImgUrl = dynamicObject.getString(ACTIVITY_USER_IMG_URL);
        String activityId = dynamicObject.getString(ACTIVITY_ID);
        String activityName = dynamicObject.getString(ACTIVITY_NAME);
        String category = dynamicObject.getString(CATEGORY);
        Date endTime = dynamicObject.getDate(END_TIME);
        String handleTime = dynamicObject.getString(HANDLE_TIME);
        Map processStatus = WfProcessUtils.getProcessStatusForList((String)endType, (String)activityId, (String)activityName, (boolean)Objects.isNull(endTime), (String)"");
        itemMap.put(ID, id);
        itemMap.put(START_USER_ID, startUserId);
        itemMap.put(START_NAME, startName);
        itemMap.put(START_USER_IMG_URL, startUserImgUrl);
        itemMap.put(HANDLE_STATE, processStatus.get(HANDLE_STATE));
        itemMap.put(HANDLE_STATE_DESC, processStatus.get(HANDLE_STATE_DESC));
        itemMap.put(APP_ID, appInfo.getId());
        itemMap.put(APP_NAME, appInfo.getName().toString());
        itemMap.put(TARGET_FORM_ID, entityNumber);
        itemMap.put(ENTITY_NAME, entityName);
        itemMap.put(BUSINESS_KEY, businessKey);
        itemMap.put(PROC_DEF_NAME, procDefName);
        itemMap.put(PROC_DEF_ID, procDefId);
        itemMap.put(PROC_INST_ID, id);
        itemMap.put(CREATE_DATE, createDate);
        itemMap.put(ACTIVITY_USER_ID, activityUserId);
        itemMap.put(ACTIVITY_USER_NAME, activityUserName);
        itemMap.put(ACTIVITY_USER_IMG_URL, activityUserImgUrl);
        itemMap.put(ACTIVITY_ID, activityId);
        itemMap.put(ACTIVITY_NAME, activityName);
        itemMap.put(CATEGORY, category);
        itemMap.put(HANDLE_TIME, handleTime);
        return itemMap;
    }

    private Map<String, Object> cast2ApplyedMap(DynamicObject dynamicObject) {
        HashMap<String, Object> itemMap = new HashMap<String, Object>(20);
        String id = dynamicObject.getString(PROC_INST_ID);
        String entityNumber = dynamicObject.getString(ENTITY_NUMBER);
        String entityName = dynamicObject.getString(ENTITY_NAME);
        AppInfo appInfo = this.getAppInfo(entityNumber);
        String startUserId = dynamicObject.getString(START_USER_ID);
        String startName = dynamicObject.getString(START_NAME);
        String startUserImgUrl = dynamicObject.getString(START_USER_IMG_URL);
        String procDefId = dynamicObject.getString(PROC_DEF_ID);
        String procDefName = dynamicObject.getString(PROC_DEF_NAME);
        Date createDate = dynamicObject.getDate(CREATE_DATE);
        String endType = dynamicObject.getString(END_TYPE);
        Object businessKey = dynamicObject.get(BUSINESS_KEY);
        String activityUserId = dynamicObject.getString(ACTIVITY_USER_ID);
        String activityUserName = dynamicObject.getString(ACTIVITY_USER_NAME);
        String activityUserImgUrl = dynamicObject.getString(ACTIVITY_USER_IMG_URL);
        String activityId = dynamicObject.getString(ACTIVITY_ID);
        String activityName = dynamicObject.getString(ACTIVITY_NAME);
        String category = dynamicObject.getString(CATEGORY);
        Date endTime = dynamicObject.getDate(END_TIME);
        String handleTime = dynamicObject.getString(HANDLE_TIME);
        String deleteReason = dynamicObject.getString(DELETE_REASON);
        Map processStatus = WfProcessUtils.getProcessStatusForList((String)endType, (String)activityId, (String)activityName, (boolean)Objects.isNull(endTime), (String)deleteReason);
        itemMap.put(ID, id);
        itemMap.put(PROC_INST_ID, id);
        itemMap.put(START_USER_ID, startUserId);
        itemMap.put(START_NAME, startName);
        itemMap.put(START_USER_IMG_URL, startUserImgUrl);
        itemMap.put(HANDLE_STATE, processStatus.get(HANDLE_STATE));
        itemMap.put(HANDLE_STATE_DESC, processStatus.get(HANDLE_STATE_DESC));
        itemMap.put(APP_ID, appInfo.getId());
        itemMap.put(APP_NAME, appInfo.getName().toString());
        itemMap.put(TARGET_FORM_ID, entityNumber);
        itemMap.put(ENTITY_NAME, entityName);
        itemMap.put(BUSINESS_KEY, businessKey);
        itemMap.put(PROC_DEF_NAME, procDefName);
        itemMap.put(PROC_DEF_ID, procDefId);
        itemMap.put(CREATE_DATE, createDate);
        itemMap.put(ACTIVITY_USER_ID, activityUserId);
        itemMap.put(ACTIVITY_USER_NAME, activityUserName);
        itemMap.put(ACTIVITY_USER_IMG_URL, activityUserImgUrl);
        itemMap.put(ACTIVITY_ID, activityId);
        itemMap.put(ACTIVITY_NAME, activityName);
        itemMap.put(CATEGORY, category);
        itemMap.put(END_TIME, endTime);
        itemMap.put(HANDLE_TIME, handleTime);
        return itemMap;
    }

    private AppInfo getAppInfo(String entityNumber) {
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String bizAppNumber = dataEntityType.getBizAppNumber();
            AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)bizAppNumber);
            return Objects.nonNull(appInfo) ? appInfo : this.wrapAppInfo();
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return this.wrapAppInfo();
        }
    }

    private AppInfo wrapAppInfo() {
        AppInfo appInfo = new AppInfo();
        appInfo.setId("");
        appInfo.setName(new LocaleString(""));
        return appInfo;
    }

    private List<Map<String, Object>> getToApplyAndApplyed(int pageNo, int pageSize) {
        int startIndex = this.getStartIndex(pageNo, pageSize);
        long currUserId = RequestContext.get().getCurrUserId();
        int limit = startIndex + pageSize;
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u6211\u53d1\u8d77\u7684\u4efb\u52a1\uff0c\u53c2\u6570\uff1astartIndex={}, limit={}, userId={}", new Object[]{0, limit, currUserId});
        DynamicObjectCollection toApplyTaskList = NoCodeWorkflowServiceHelper.getNoCodeFlowInProcessApply((int)0, (int)limit, (String)(currUserId + ""), new HashMap(0));
        List toApplyTasks = toApplyTaskList.stream().map(this::cast2ToApplyMap).collect(Collectors.toList());
        DynamicObjectCollection applyedTaskList = NoCodeWorkflowServiceHelper.getNoCodeFlowApplyedProcess((Long)currUserId, (Integer)0, (Integer)limit, (String)"", (String)"", new HashMap(0));
        List applyedTasks = applyedTaskList.stream().map(this::cast2ApplyedMap).collect(Collectors.toList());
        ArrayList myLaunchTasks = Lists.newArrayListWithCapacity((int)(toApplyTaskList.size() + applyedTaskList.size()));
        myLaunchTasks.addAll(toApplyTasks);
        myLaunchTasks.addAll(applyedTasks);
        myLaunchTasks.sort((e1, e2) -> {
            Timestamp createDate1 = (Timestamp)e1.get(CREATE_DATE);
            Timestamp createDate2 = (Timestamp)e2.get(CREATE_DATE);
            return createDate2.compareTo(createDate1);
        });
        List lists = Lists.partition((List)myLaunchTasks, (int)pageSize);
        List<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>(0);
        int index = pageNo - 1;
        if (index < lists.size()) {
            tasks = (List)lists.get(index);
        }
        return tasks;
    }

    private List<Map<String, Object>> getToHandleTask(int pageNo, int pageSize) {
        String currUserId = RequestContext.get().getCurrUserId() + "";
        int startIndex = this.getStartIndex(pageNo, pageSize);
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u5f85\u529e\u4efb\u52a1\uff0c\u53c2\u6570\uff1astartIndex={}, pageSize={}, userId={}", new Object[]{startIndex, pageSize, currUserId});
        DynamicObjectCollection tasks = NoCodeWorkflowServiceHelper.getNoCodeFlowToHandleTasksByUserId((int)startIndex, (int)pageSize, (String)currUserId);
        return tasks.stream().map(this::cast2ToHandleMap).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getHandledTasks(int pageNo, int pageSize) {
        String currUserId = RequestContext.get().getCurrUserId() + "";
        int startIndex = this.getStartIndex(pageNo, pageSize);
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u5df2\u529e\u4efb\u52a1\uff0c\u53c2\u6570\uff1astartIndex={}, pageSize={}, userId={}", new Object[]{startIndex, pageSize, currUserId});
        DynamicObjectCollection tasks = NoCodeWorkflowServiceHelper.getNoCodeFlowHandledTasksByUserId((int)startIndex, (int)pageSize, (String)currUserId, new HashMap(0));
        return tasks.stream().map(this::cast2HandledMap).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getInProcessApply(int pageNo, int pageSize) {
        String currUserId = RequestContext.get().getCurrUserId() + "";
        int startIndex = this.getStartIndex(pageNo, pageSize);
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u5728\u529e\u7533\u8bf7\uff0c\u53c2\u6570\uff1astartIndex={}, pageSize={}, userId={}", new Object[]{startIndex, pageSize, currUserId});
        DynamicObjectCollection tasks = NoCodeWorkflowServiceHelper.getNoCodeFlowInProcessApply((int)startIndex, (int)pageSize, (String)currUserId, new HashMap(0));
        return tasks.stream().map(this::cast2ToApplyMap).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getApplyedProcess(int pageNo, int pageSize) {
        long currUserId = RequestContext.get().getCurrUserId();
        int startIndex = this.getStartIndex(pageNo, pageSize);
        log.debug("\u8c03\u7528\u5de5\u4f5c\u6d41helper\uff0c\u83b7\u53d6\u5df2\u529e\u7533\u8bf7\uff0c\u53c2\u6570\uff1astartIndex={}, pageSize={}, userId={}", new Object[]{startIndex, pageSize, currUserId});
        DynamicObjectCollection tasks = NoCodeWorkflowServiceHelper.getNoCodeFlowApplyedProcess((Long)currUserId, (Integer)startIndex, (Integer)pageSize, (String)"", (String)"", new HashMap(0));
        return tasks.stream().map(this::cast2ApplyedMap).collect(Collectors.toList());
    }
}

