/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.FileUtils;

public class DevUtil {
    public static final Log logger = LogFactory.getLog(DevUtil.class);
    public static final String EXPORT_PAGE = "EXPORT_PAGE";
    public static final String EXPORT_APP = "EXPORT_APP";
    public static final String ORITENENTISV = "kingdee";
    private static final String JSONTYPE = ".json";
    private static final String KDPKGS = "kdpkgs.xml";
    private static final String ERRORINFO = "errorInfo.txt";
    private static final String APPINFOXML = "appInfo.xml";
    private static final String RESOURCE = "resource";
    private static final String CUSTOM = "custom";
    private static final String UPLOADSOURCE = "uploadsource";
    private static final String SPACE = "   ";
    public static final String BOS_FORMMETA = "bos_formmeta";
    public static final String KINGDEE = "kingdee";

    public static JSONObject expFormMetadata(String formId, String exportPath, String sourceType) {
        JSONObject checkInMsg = new JSONObject();
        try {
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (list != null && list.size() > 0) {
                String modelType = ((DeployFile)list.get(0)).getModelType();
                String pageIsv = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)"isv").getString("isv");
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                DevUtil.saveMetaFile(dymMeta, dymFileName, exportPath);
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    if (dymLangFileName.endsWith("zh_CN.dymx")) {
                        DevUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                        continue;
                    }
                    if ((!EXPORT_PAGE.equals(sourceType) || "kingdee".equals(pageIsv)) && !StringUtils.equals((CharSequence)"PrintModel", (CharSequence)modelType)) continue;
                    DevUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                }
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        return checkInMsg;
    }

    private static void saveMetaFile(String dymMeta, String dymFileName, String exportPath) {
        String fullPath = DevUtil.getMetaXmlPath(dymFileName, exportPath);
        String[] abovePath = fullPath.split(dymFileName);
        File fileAbovePath = new File(FileUtils.cleanString((String)abovePath[0]));
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        Path customZipPath = Paths.get(DevUtil.checkFilePath(FileUtils.cleanString((String)fullPath)), new String[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(dymMeta);
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static String getMetaXmlPath(String filename, String exportPath) {
        String fullPath = String.format("%s/metadata/%s", exportPath, filename);
        return fullPath;
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static void zipFiles(List<String> zipNames, String zipPath, String defaultAppPackageName) {
        String staticResourcePath;
        File staticResourceFile;
        String customResourcePath;
        File customResourceFile;
        String appInfo;
        File appInfoFile;
        String errorLog;
        File errorLogFile;
        JSONArray files = new JSONArray();
        String packageXML = FileUtils.cleanString((String)((zipPath = DevUtil.checkFilePath(zipPath)) + File.separator + KDPKGS));
        File packageXMLFile = new File(packageXML);
        if (packageXMLFile.exists()) {
            files.add((Object)packageXML);
        }
        if ((errorLogFile = new File(errorLog = FileUtils.cleanString((String)(zipPath + File.separator + ERRORINFO)))).exists()) {
            files.add((Object)errorLog);
        }
        if ((appInfoFile = new File(appInfo = FileUtils.cleanString((String)(zipPath + File.separator + APPINFOXML)))).exists()) {
            files.add((Object)appInfo);
        }
        for (String zipName : zipNames) {
            String zipAppPath = FileUtils.cleanString((String)(zipPath + File.separator + "dm" + File.separator + zipName + ".zip"));
            File zipAppFile = new File(zipAppPath);
            if (!zipAppFile.exists()) continue;
            files.add((Object)zipAppPath);
        }
        String libPath = FileUtils.cleanString((String)(zipPath + File.separator + "jar"));
        File libFile = new File(libPath);
        if (libFile.exists()) {
            files.add((Object)libPath);
        }
        if ((customResourceFile = new File(customResourcePath = FileUtils.cleanString((String)(zipPath + File.separator + RESOURCE + File.separator + CUSTOM)))).exists()) {
            files.add((Object)customResourcePath);
        }
        if ((staticResourceFile = new File(staticResourcePath = FileUtils.cleanString((String)(zipPath + File.separator + RESOURCE + File.separator + UPLOADSOURCE)))).exists()) {
            files.add((Object)staticResourcePath);
        }
        String zipFilePath = FileUtils.cleanString((String)(zipPath + File.separator + defaultAppPackageName + ".zip"));
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevUtil.compressZipFile(files, out, zipNames);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void zipFiles(String zipName, String localPath, List<File> fileList) {
        JSONArray files = new JSONArray();
        String MetadataPath = FileUtils.cleanString((String)((localPath = DevUtil.checkFilePath(localPath)) + File.separator + "metadata"));
        File MetadataFile = new File(MetadataPath);
        if (MetadataFile.exists()) {
            files.add((Object)MetadataPath);
        }
        if (fileList != null && fileList.size() > 0) {
            for (File file : fileList) {
                try {
                    files.add((Object)file.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
        String zipFilePath = FileUtils.cleanString((String)(localPath + File.separator + zipName + ".zip"));
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevUtil.zipFile(files, out, "");
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static void zipFile(JSONArray files, ZipOutputStream out, String pathSign) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.warn((Throwable)e);
                    }
                }
                DevUtil.zipFile(tempFiles, out, pathSign);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
            Path zipFilePath = Paths.get(path, new String[0]);
            String fileName = file.getName();
            int t = -1;
            if (path == null) continue;
            if (path.contains("datamodel")) {
                t = path.indexOf("datamodel");
            }
            if (path.contains("jar") && path.endsWith(".zip") && !fileName.contains("jar")) {
                t = path.indexOf("jar");
            }
            if (StringUtils.isNotBlank((CharSequence)pathSign)) {
                if (path.contains(pathSign) && !path.contains(JSONTYPE)) {
                    t = path.indexOf("webapp");
                } else if (path.contains(JSONTYPE)) {
                    t = path.indexOf(pathSign);
                }
            } else if ((path.contains(CUSTOM) || path.contains(UPLOADSOURCE)) && path.endsWith(".zip") && !fileName.contains(CUSTOM) && !fileName.contains(UPLOADSOURCE)) {
                t = path.indexOf(RESOURCE);
            }
            if (t == -1) continue;
            if ((path = path.endsWith(JSONTYPE) ? path.substring(t + pathSign.length() + 1, path.length()) : path.substring(t, path.length())).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                logger.warn((Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private static void compressZipFile(JSONArray files, ZipOutputStream out, List<String> zipNames) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.warn((Throwable)e);
                    }
                }
                DevUtil.zipFile(tempFiles, out, "");
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.warn((Throwable)e);
            }
            if (path == null) continue;
            Path zipPath = Paths.get(path, new String[0]);
            int t = -1;
            if (path.contains(KDPKGS)) {
                t = path.indexOf(KDPKGS);
            }
            if (path.contains(ERRORINFO)) {
                t = path.indexOf(ERRORINFO);
            }
            if (path.contains(APPINFOXML)) {
                t = path.indexOf(APPINFOXML);
            }
            if (path.endsWith(".zip")) {
                for (String zipName : zipNames) {
                    if (!path.endsWith(zipName + ".zip")) continue;
                    t = path.indexOf(zipName + ".zip");
                }
            }
            if (t == -1) continue;
            path = path.endsWith(".zip") ? path.substring(t - 3, path.length()) : path.substring(t, path.length());
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                logger.warn((Throwable)exception);
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    public static boolean createJsonFile(String jsonString, String filePath, String fileName) {
        boolean flag = true;
        String fullPath = FileUtils.cleanString((String)(filePath + File.separator + fileName + JSONTYPE));
        File file = new File(fullPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        jsonString = DevUtil.formatJson(jsonString);
        Path customZipPath = Paths.get(FileUtils.cleanString((String)DevUtil.checkFilePath(fullPath)), new String[0]);
        try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
             OutputStreamWriter write = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            write.write(jsonString);
            write.flush();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            flag = false;
        }
        return flag;
    }

    public static String formatJson(String json) {
        StringBuilder result = new StringBuilder();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(DevUtil.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(DevUtil.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(DevUtil.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append('\n');
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append(SPACE);
        }
        return result.toString();
    }

    public static void expAppMetadata(String bizAppId, String exportPath, String sourceType) {
        List list = AppMetaServiceHelper.getAppDeployFile((String)bizAppId);
        if (list.size() > 0) {
            String appIsv = AppMetaServiceHelper.getIsvByAppId((String)bizAppId);
            String dymMeta = ((DeployFile)list.get(0)).getFileContent();
            String dymFileName = ((DeployFile)list.get(0)).getFileName();
            DevUtil.saveMetaFile(dymMeta, dymFileName, exportPath);
            for (int i = 1; i < list.size(); ++i) {
                String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                if (dymLangFileName.endsWith("zh_CN.appx")) {
                    DevUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                    continue;
                }
                if (!EXPORT_APP.equals(sourceType) || "kingdee".equals(appIsv)) continue;
                DevUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
            }
        }
    }
}

