/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.metadata.domainmodel.PropertyGroup;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.wf.NoCodeWfDesignerService;
import kd.bos.nocode.wf.StartSignalEventElementTypeFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.workflow.api.model.NodeProperty;
import kd.bos.workflow.api.model.ProcessNode;
import org.apache.commons.collections4.CollectionUtils;

public class NoCodeWfDesignerServiceImpl
implements NoCodeWfDesignerService {
    private static final int INITIAL_CAPACITY10 = 10;
    private static final String ICON = "Icon";
    private static final String BG = "Bg";
    private static final Log log = LogFactory.getLog(NoCodeWfDesignerServiceImpl.class);
    private static final Map<String, Integer> category2Seq = new HashMap<String, Integer>(4);

    public String getWfDomainModel() {
        List nodes = NoCodeWorkflowServiceHelper.getProcessNodes((String)"NoCodeFlow");
        Map enableMessageChannel = MessageCenterServiceHelper.getEnableChannel();
        log.debug("\u83b7\u53d6\u82cd\u7a79\u5df2\u542f\u7528\u7684\u6d88\u606f\u6e20\u9053={}", (Object)SerializationUtils.toJsonString((Object)enableMessageChannel));
        DomainModelType wfModel = this.wrapModel(nodes, enableMessageChannel);
        List dts = DomainModelType.getDomainModelTypeEntityTypes();
        DcJsonSerializer jser = new DcJsonSerializer((Iterable)dts);
        String locale = Lang.get().getLocale().toString();
        jser.getBinder().setLCId(locale);
        Map map = jser.serializeToMap((Object)wfModel, null);
        this.fixupIconBg(map);
        return SerializationUtils.toJsonString((Object)map);
    }

    private DomainModelType wrapModel(List<ProcessNode> nodes, Map<String, Object> enableMessageChannel) {
        DomainModelType mt = new DomainModelType();
        mt.setId("NoCodeWfModel");
        mt.setName(new LocaleString(ResManager.loadKDString((String)"\u65e0\u4ee3\u7801\u6d41\u7a0b\u6a21\u578b", (String)"NoCodeWfDesignerServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0])));
        for (ProcessNode node : nodes) {
            Category category;
            Optional<Category> first = mt.getCategories().stream().filter(c -> c.getId().equalsIgnoreCase(node.getGroupNumber())).findFirst();
            if (first.isPresent()) {
                category = first.get();
            } else {
                category = new Category();
                category.setId(node.getGroupNumber());
                category.setName(new LocaleString(node.getGroupName()));
                category.setSeq(category2Seq.getOrDefault(node.getGroupNumber(), 10).intValue());
                mt.getCategories().add(category);
            }
            ElementType elementType = new ElementType();
            elementType.setId(node.getNumber());
            elementType.setName(new LocaleString(node.getName()));
            for (NodeProperty property : node.getProperties()) {
                Property prop = this.wrapProperty(node, property, enableMessageChannel);
                elementType.getProperties().add(prop);
            }
            category.getElementTypes().add(elementType);
        }
        mt.getCategories().sort(Comparator.comparingInt(Category::getSeq));
        mt.getCategories().add(this.addHideCategory());
        mt.getPropertyGroups().addAll(this.createPropertyGroups());
        return mt;
    }

    private Collection<? extends PropertyGroup> createPropertyGroups() {
        ArrayList<PropertyGroup> propertyGroups = new ArrayList<PropertyGroup>(8);
        propertyGroups.add(this.createRequestSettingGroup());
        propertyGroups.add(this.createResponseSettingGroup());
        propertyGroups.add(this.createTimeoutSettingGroup());
        propertyGroups.add(this.createTokenSetGroup());
        propertyGroups.add(this.createApiTestGroup());
        propertyGroups.add(this.createAuthGroup());
        propertyGroups.add(this.createCustomJson());
        return propertyGroups;
    }

    private PropertyGroup createCustomJson() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("85");
        propertyGroup.setKey("NCPG_editJson");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u7f16\u8f91JSON", (String)"NoCodeWfDesignerServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(60);
        return propertyGroup;
    }

    private PropertyGroup createAuthGroup() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("84");
        propertyGroup.setKey("NCPG_authSetting");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u8ba4\u8bc1\u8bbe\u7f6e", (String)"NoCodeWfDesignerServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(50);
        return propertyGroup;
    }

    private PropertyGroup createApiTestGroup() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("83");
        propertyGroup.setKey("NCPG_ApiTest");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u6d4b\u8bd5API", (String)"NoCodeWfDesignerServiceImpl_3", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(40);
        return propertyGroup;
    }

    private PropertyGroup createTokenSetGroup() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("86");
        propertyGroup.setKey("NCPG_TOKEN_SET");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"Access Token \u8bbe\u7f6e", (String)"NoCodeWfDesignerServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(35);
        return propertyGroup;
    }

    private PropertyGroup createTimeoutSettingGroup() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("82");
        propertyGroup.setKey("NCPG_responseResultSetting");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u54cd\u5e94\u8bbe\u7f6e", (String)"NoCodeWfDesignerServiceImpl_5", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(30);
        return propertyGroup;
    }

    private PropertyGroup createResponseSettingGroup() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("81");
        propertyGroup.setKey("NCPG_responseSetting");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u8fd4\u56de\u8bbe\u7f6e", (String)"NoCodeWfDesignerServiceImpl_6", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(20);
        return propertyGroup;
    }

    private PropertyGroup createRequestSettingGroup() {
        PropertyGroup propertyGroup = new PropertyGroup();
        propertyGroup.setId("80");
        propertyGroup.setKey("NCPG_requestSetting");
        propertyGroup.setName(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u6c42\u8bbe\u7f6e", (String)"NoCodeWfDesignerServiceImpl_7", (String)"bos-nocode-service", (Object[])new Object[0])));
        propertyGroup.setSeq(10);
        return propertyGroup;
    }

    private Property wrapProperty(ProcessNode node, NodeProperty property, Map<String, Object> enableMessageChannel) {
        Property prop = new Property();
        prop.setPropertyName(property.getNumber());
        prop.setName(new LocaleString(property.getName()));
        prop.setGroupId(property.getGroupNumber());
        if (property.getConfig() != null) {
            for (String k : property.getConfig().keySet()) {
                Map map;
                if (k.equalsIgnoreCase("Editor") && property.getConfig().get(k) instanceof Map) {
                    map = (Map)property.getConfig().get(k);
                    prop.setEditor(map);
                    if (!"NoCodeNotifyTask".equalsIgnoreCase(node.getNumber()) || !"notifytype".equalsIgnoreCase(prop.getPropertyName())) continue;
                    this.removeDisableMessageChannel(enableMessageChannel, map);
                    continue;
                }
                if (k.equalsIgnoreCase("Hide") && property.getConfig().get(k) instanceof Map) {
                    map = (Map)property.getConfig().get(k);
                    prop.setHide(map);
                    continue;
                }
                if (k.equalsIgnoreCase("Action") && property.getConfig().get(k) instanceof Map) {
                    map = (Map)property.getConfig().get(k);
                    prop.setAction(map);
                    continue;
                }
                if (!k.equalsIgnoreCase("Tips") || !(property.getConfig().get(k) instanceof String)) continue;
                String tips = (String)property.getConfig().get(k);
                prop.setDescription(new LocaleString(tips));
            }
        }
        return prop;
    }

    private void removeDisableMessageChannel(Map<String, Object> enableMessageChannel, Map<String, Object> map) {
        JSONArray items = (JSONArray)map.get("items");
        if (CollectionUtils.isEmpty((Collection)items)) {
            return;
        }
        Set<String> enableChannelSet = enableMessageChannel.keySet();
        items.removeIf(e -> {
            JSONObject item = (JSONObject)e;
            String channel = item.getString("id");
            return !MessageChannels.MC.getNumber().equalsIgnoreCase(channel) && !enableChannelSet.contains(channel);
        });
    }

    private Category addHideCategory() {
        Category hideCate = new Category();
        hideCate.setId("CategoryNoCodeHide");
        hideCate.setName(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u53ef\u89c1\u5143\u7d20", (String)"NoCodeWfDesignerServiceImpl_8", (String)"bos-nocode-service", (Object[])new Object[0])));
        hideCate.setVisible(false);
        hideCate.setSeq(99);
        ElementType startSignalEventElementType = this.createStartSignalEventElementType();
        hideCate.getElementTypes().add(startSignalEventElementType);
        return hideCate;
    }

    private ElementType createStartSignalEventElementType() {
        return new StartSignalEventElementTypeFactory().build();
    }

    private void fixupIconBg(Map<String, Object> map) {
        List categories = (List)map.get("Categories");
        for (Map category : categories) {
            List elementTypes = (List)category.get("ElementTypes");
            for (Map elementType : elementTypes) {
                String elId = (String)elementType.get("Id");
                if (WfConsts.MAPPING_STENCIL_ICON.containsKey(elId)) {
                    elementType.put(ICON, WfConsts.MAPPING_STENCIL_ICON.get(elId));
                }
                if (!WfConsts.MAPPING_STENCIL_BG.containsKey(elId)) continue;
                elementType.put(BG, WfConsts.MAPPING_STENCIL_BG.get(elId));
            }
        }
    }

    static {
        category2Seq.put("billCategory", 1);
        category2Seq.put("taskCategory", 2);
        category2Seq.put("switchCategory", 3);
        category2Seq.put("sysCategory", 4);
    }
}

