/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import de.odysseus.nocode.ExpressionFactoryImpl;
import de.odysseus.nocode.util.SimpleContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.el.ELContext;
import javax.el.ValueExpression;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.nocode.constant.Gender;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.entity.WorkflowHttpResponse;
import kd.bos.nocode.express.NoCodeExpCtx;
import kd.bos.nocode.ext.metadata.entity.filter.FilterBuilderUtils;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterItem;
import kd.bos.nocode.ext.metadata.entity.filter.pojo.FilterValue;
import kd.bos.nocode.ext.metadata.wf.info.CustomJsonRow;
import kd.bos.nocode.ext.metadata.wf.info.MultiRefBillInfo;
import kd.bos.nocode.ext.metadata.wf.info.RequestBody;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.util.WfProcessUtils;
import kd.bos.nocode.metadata.IDecimalFormatSupport;
import kd.bos.nocode.property.INoCodeComboProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.exception.TerminateFlowException;
import kd.bos.nocode.restapi.common.util.Base36;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import kd.bos.nocode.restapi.service.query.NoCodeFilterServiceImpl;
import kd.bos.nocode.restapi.service.util.FilterUtil;
import kd.bos.nocode.restapi.service.util.ListFilterConfigUtils;
import kd.bos.nocode.restapi.service.wf.WfProcessDataService;
import kd.bos.nocode.util.DataRangeCompareUtil;
import kd.bos.nocode.util.ListConfigUtils;
import kd.bos.nocode.utils.DateTimeUtils;
import kd.bos.nocode.utils.DecimalUtil;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.JsonVarHelper;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.OpenApiUtil;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.nocode.utils.WorkflowHttpClientUtils;
import kd.bos.nocode.wf.NoCodeWfService;
import kd.bos.nocode.wf.WfExpressionBillCtx;
import kd.bos.nocode.wf.WfFormMetaService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NoCodeWfServiceImpl
implements NoCodeWfService {
    private static final String PARAM_KEY_PARAMS = "params";
    private static final String PARAM_KEY_NUMBER = "number";
    private static final String PARAM_KEY_TYPE = "type";
    private static final String PARAM_KEY_VALUE = "value";
    private static final Log logger = LogFactory.getLog(NoCodeWfServiceImpl.class);
    private static final String MESSAGE = "message";
    private static final String ERRORCODE = "errorCode";
    private static final String DATA = "data";
    private static final String ROWS = "rows";
    private static final String JSON_SUFFIX = "_json";
    private static final String MY_API_REGION_KEY = "nocode-wf-myapi";
    private static final String CACHE_KEY_AUTH_RESPONSE = "auth_response";
    private static final DistributeSessionlessCache myApiCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("nocode-wf-myapi", new DistributeCacheHAPolicy());

    public Map<String, Object> queryByRela(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        logger.debug(String.format("nocode: %s inParams:%s", "queryByRela", SerializationUtils.toJsonString(inParams)));
        HashMap<String, Object> result = new HashMap<String, Object>(outParams.size());
        for (int i = 0; i < inParams.size(); ++i) {
            Map<String, Object> inParamMap = inParams.get(i);
            String entityNumber = (String)inParamMap.get("entityNumber");
            String businessKey = (String)inParamMap.get("businessKey");
            String refbillField = String.valueOf(inParamMap.get("refbillField"));
            String relaFormId = (String)inParamMap.get("relaFormId");
            if (!NcEntityTypeUtil.isFormExist((String)relaFormId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeWfServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            WfConsts.QueryNumberEnum queryNumber = WfConsts.QueryNumberEnum.getByCode((String)((String)inParamMap.get("queryNumber")));
            Object queryResult = this.innerQueryByRela(entityNumber, businessKey, refbillField, relaFormId, queryNumber);
            if (queryResult != null) {
                Map qResult = (Map)queryResult;
                for (Map<String, Object> oParam : outParams) {
                    String oParamNumber = (String)oParam.get(PARAM_KEY_NUMBER);
                    if (!qResult.containsKey(oParamNumber)) continue;
                    result.put(oParamNumber, qResult.get(oParamNumber));
                }
                result.put("QueryResult", WfConsts.QueryResultEnum.HasData.getCode());
                continue;
            }
            result.put("QueryResult", WfConsts.QueryResultEnum.NonData.getCode());
        }
        return result;
    }

    private Object innerQueryByRela(String entityNumber, String businessKey, String refbillField, String relaFormId, WfConsts.QueryNumberEnum queryNumber) {
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)relaFormId);
        String selectProperties = NcEntityTypeUtil.getSelectPropertiesIncludePkId((String)formNumber);
        boolean isMulti = WfConsts.QueryNumberEnum.multi.getCode().equalsIgnoreCase(queryNumber.getCode());
        Object refBillPk = this.getRefBillFieldValue(entityNumber, businessKey, refbillField);
        if (refBillPk == null) {
            return null;
        }
        if (refBillPk instanceof String && "null".equalsIgnoreCase((String)refBillPk)) {
            return null;
        }
        if (!isMulti) {
            if (refBillPk instanceof String && ((String)refBillPk).indexOf(",") != -1) {
                String[] splits = kd.bos.dataentity.utils.StringUtils.split((String)((String)refBillPk), (String)",");
                refBillPk = splits[0];
            } else if (refBillPk instanceof DynamicObject) {
                refBillPk = ((DynamicObject)refBillPk).getPkValue();
            }
            DynamicObject rec = BusinessDataServiceHelper.loadSingle((Object)refBillPk, (String)formNumber);
            if (rec != null) {
                BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)relaFormId);
                Object pk = rec.get((IDataEntityProperty)dt.getPrimaryKey());
                String[] splitFields = selectProperties.split(",");
                HashSet selectSet = new HashSet(splitFields.length);
                Collections.addAll(selectSet, splitFields);
                return PropertyHandleUtil.toMap((Object)pk, (String)relaFormId, (String)"$", (DynamicObject)rec, selectSet, (boolean)true);
            }
            return null;
        }
        HashMap<String, Object> qResult = new HashMap<String, Object>(2);
        if (refBillPk instanceof String) {
            qResult.put("QueryDataSet", refBillPk);
            qResult.put("QueryDataSet_id", refBillPk);
        } else if (refBillPk instanceof DynamicObject) {
            qResult.put("QueryDataSet", ((DynamicObject)refBillPk).getPkValue());
            qResult.put("QueryDataSet_id", ((DynamicObject)refBillPk).getPkValue());
        } else {
            qResult.put("QueryDataSet", refBillPk.toString());
            qResult.put("QueryDataSet_id", refBillPk.toString());
        }
        return qResult;
    }

    private Object getRefBillFieldValue(String entityNumber, String businessKey, String refbillField) {
        Matcher m = WfConsts.varModelPattern.matcher(refbillField);
        if (m.find()) {
            String formNumber;
            String modelVar = m.group();
            String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)\\}", "$1");
            Object pkid = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)NcEntityTypeUtil.getMainEntityType((String)entityNumber), (Object)businessKey);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)(formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)entityNumber)));
            if (dynamicObject.containsProperty(fieldId)) {
                return dynamicObject.get(fieldId);
            }
            return null;
        }
        return refbillField;
    }

    public Map<String, Object> queryByFilter(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(outParams.size());
        for (int i = 0; i < inParams.size(); ++i) {
            Map<String, Object> inParamMap = inParams.get(i);
            String entityNumber = (String)inParamMap.get("entityNumber");
            String businessKey = (String)inParamMap.get("businessKey");
            String formId = (String)inParamMap.get("formId");
            if (!NcEntityTypeUtil.isFormExist((String)formId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeWfServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            List filter = (List)inParamMap.get("filter");
            List orderby = (List)inParamMap.get("orderby");
            Integer topNumber = (Integer)inParamMap.get("topNumber");
            WfConsts.QueryNumberEnum queryNumber = WfConsts.QueryNumberEnum.getByCode((String)((String)inParamMap.get("queryNumber")));
            String fetchType = (String)inParamMap.get("fetchType");
            Object queryResult = this.innerQueryByFilter(entityNumber, businessKey, formId, filter, orderby, topNumber, fetchType, queryNumber);
            if (queryResult != null) {
                Map qResult = (Map)queryResult;
                for (Map<String, Object> oParam : outParams) {
                    String oParamNumber = (String)oParam.get(PARAM_KEY_NUMBER);
                    if (!qResult.containsKey(oParamNumber)) continue;
                    result.put(oParamNumber, qResult.get(oParamNumber));
                }
                result.put("QueryResult", WfConsts.QueryResultEnum.HasData.getCode());
                continue;
            }
            result.put("QueryResult", WfConsts.QueryResultEnum.NonData.getCode());
        }
        return result;
    }

    private Object innerQueryByFilter(String entityNumber, String businessKey, String formId, List<Map<String, Object>> filter, List<Map<String, Object>> orderby, Integer topNumber, String fetchType, WfConsts.QueryNumberEnum queryNumber) {
        DynamicObject[] datas;
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        String selectProperties = NcEntityTypeUtil.getSelectPropertiesIncludePkId((String)formNumber);
        List<Map<String, Object>> newFilter = this.cloneListMap(filter);
        QFilter[] filters = this.parseFilter(formId, formNumber, newFilter, entityNumber, businessKey);
        String orderBy = this.parseOrderBy(orderby);
        Integer top = topNumber;
        boolean isMulti = WfConsts.QueryNumberEnum.multi.getCode().equalsIgnoreCase(queryNumber.getCode());
        if (!isMulti) {
            top = 1;
        }
        if ((datas = BusinessDataServiceHelper.load((String)formNumber, (String)selectProperties, (QFilter[])filters, (String)orderBy, (int)top)) != null && datas.length > 0) {
            if (!isMulti) {
                DynamicObject rec = datas[0];
                BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
                Object pk = rec.get((IDataEntityProperty)dt.getPrimaryKey());
                String[] splitFields = selectProperties.split(",");
                HashSet selectSet = new HashSet(splitFields.length);
                Collections.addAll(selectSet, splitFields);
                return PropertyHandleUtil.toMap((Object)pk, (String)formId, (String)"$", (DynamicObject)rec, selectSet, (boolean)true);
            }
            HashMap<String, String> qResult = new HashMap<String, String>(2);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject data : datas) {
                Object pkValue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((pkValue = data.getPkValue()) == null) continue;
                sb.append(pkValue);
            }
            qResult.put("QueryDataSet", sb.toString());
            qResult.put("QueryDataSet_id", sb.toString());
            return qResult;
        }
        if (isMulti) {
            HashMap<String, String> qResult = new HashMap<String, String>(2);
            qResult.put("QueryDataSet", "");
            qResult.put("QueryDataSet_id", "");
            return qResult;
        }
        return null;
    }

    public Map<String, Object> queryByApi(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(outParams.size());
        for (int i = 0; i < inParams.size(); ++i) {
            WfConsts.QueryNumberEnum queryNumber;
            Integer topNumber;
            List orderby;
            List filter;
            String formId;
            String apiId;
            String businessKey;
            Map<String, Object> inParamMap = inParams.get(i);
            String entityNumber = (String)inParamMap.get("entityNumber");
            Map<String, Object> queryResult = this.innerQueryByApi(entityNumber, businessKey = (String)inParamMap.get("businessKey"), apiId = (String)inParamMap.get("apiId"), formId = (String)inParamMap.get("formId"), filter = (List)inParamMap.get("apiFilter"), orderby = (List)inParamMap.get("orderby"), topNumber = (Integer)inParamMap.get("topNumber"), queryNumber = WfConsts.QueryNumberEnum.getByCode((String)((String)inParamMap.get("queryNumber"))));
            if (queryResult != null) {
                Map<String, Object> qResult = queryResult;
                for (Map<String, Object> oParam : outParams) {
                    String oParamNumber = (String)oParam.get(PARAM_KEY_NUMBER);
                    if (!qResult.containsKey(oParamNumber)) continue;
                    result.put(oParamNumber, qResult.get(oParamNumber));
                }
                result.put("QueryResult", WfConsts.QueryResultEnum.HasData.getCode());
                continue;
            }
            result.put("QueryResult", WfConsts.QueryResultEnum.NonData.getCode());
        }
        return result;
    }

    private Map<String, Object> innerQueryByApi(String entityNumber, String businessKey, String apiId, String formId, List<Map<String, Object>> filter, List<Map<String, Object>> orderby, Integer topNumber, WfConsts.QueryNumberEnum queryNumber) {
        Map dataByOpenApi;
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)formId);
        List<Map<String, Object>> newFilter = this.cloneListMap(filter);
        this.preParseFilter(formNumber, newFilter, entityNumber, businessKey);
        List filterItems = FilterBuilderUtils.convert(newFilter);
        HashMap<Object, String> paramMap = new HashMap<Object, String>();
        for (FilterItem filterItem : filterItems) {
            if (!(filterItem.getValue() instanceof List)) continue;
            FilterValue fv = (FilterValue)filterItem.getValue().get(0);
            paramMap.put(fv.getFieldValue(), filterItem.getFieldName());
        }
        Integer top = topNumber;
        boolean isMulti = WfConsts.QueryNumberEnum.multi.getCode().equalsIgnoreCase(queryNumber.getCode());
        if (!isMulti) {
            top = 1;
        }
        if ((dataByOpenApi = OpenApiUtil.getDataByOpenApi((String)apiId, (String)formId, paramMap, (Integer)top, (boolean)isMulti)) != null && !dataByOpenApi.isEmpty()) {
            ISimpleProperty pkProp;
            if (!"0".equalsIgnoreCase((String)dataByOpenApi.get(ERRORCODE)) && dataByOpenApi.get(MESSAGE) != null) {
                logger.info(dataByOpenApi.get(MESSAGE).toString());
                throw new KDBizException(dataByOpenApi.get(MESSAGE).toString());
            }
            Map data = (Map)dataByOpenApi.get(DATA);
            if (data == null || data.isEmpty()) {
                return null;
            }
            JSONArray rows = (JSONArray)data.get(ROWS);
            if (rows == null || rows.isEmpty()) {
                return null;
            }
            if (!isMulti) {
                JSONObject row = (JSONObject)rows.get(0);
                return row;
            }
            String pkKey = "id";
            BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)formId);
            if (dt != null && (pkProp = dt.getPrimaryKey()) != null) {
                pkKey = pkProp.getName();
            }
            HashMap<String, Object> qResult = new HashMap<String, Object>(2);
            StringBuilder sb = new StringBuilder();
            for (Object rowObj : rows) {
                JSONObject row = (JSONObject)rowObj;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (!row.containsKey((Object)pkKey)) {
                    logger.debug("nocode: X-OpenApi-QueryId " + pkKey);
                    continue;
                }
                Object pkValue = row.get((Object)pkKey);
                if (pkValue == null) continue;
                sb.append(pkValue);
            }
            qResult.put("QueryDataSet", sb.toString());
            qResult.put("QueryDataSet_id", sb.toString());
            return qResult;
        }
        return null;
    }

    private void preParseFilter(String formNumber, List<Map<String, Object>> filter, String entityNumber, String businessKey) {
        if (filter == null || filter.isEmpty()) {
            return;
        }
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)entityNumber);
        DynamicObject billObj = null;
        for (Map<String, Object> filterMap : filter) {
            this.parseComboValue(filterMap, formNumber);
            this.parseFilterItem(filterMap, billObj, entityNumber, businessKey, dt);
        }
    }

    private QFilter[] parseFilter(String formId, String formNumber, List<Map<String, Object>> filter, String entityNumber, String businessKey) {
        if (filter == null || filter.isEmpty()) {
            return new QFilter[0];
        }
        this.preParseFilter(formNumber, filter, entityNumber, businessKey);
        String filters = ListFilterConfigUtils.buildFilter(filter, formId);
        QFilter[] qFilters = FilterUtil.getQFilters(formId, filters);
        return qFilters;
    }

    private void parseComboValue(Map<String, Object> filterMap, String entityNumber) {
        String fieldName = (String)filterMap.get("fieldName");
        IDataEntityProperty property = NcEntityTypeUtil.findProperty((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber), (String)fieldName);
        if (Objects.nonNull(property) && property instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)property;
            List comboItems = comboProp.getComboItems();
            List<Map<String, Object>> valueList = ListFilterConfigUtils.getValueList(filterMap.get(PARAM_KEY_VALUE));
            for (Map<String, Object> value : valueList) {
                String _type = (String)value.get("_type");
                String fieldValue = (String)value.get("fieldValue");
                if (WfConsts.varModelPattern.matcher(fieldValue).matches() || !Objects.equals(_type, "var")) continue;
                String realFieldValue = comboItems.stream().filter(e -> Objects.equals(e.getName().toString(), fieldValue)).findFirst().map(ValueMapItem::getValue).orElse(fieldValue);
                value.put("fieldValue", realFieldValue);
            }
            filterMap.put(PARAM_KEY_VALUE, SerializationUtils.toJsonString(valueList));
        }
    }

    private void parseFilterItem(Map<String, Object> filterMap, DynamicObject billObj, String entityNumber, String businessKey, MainEntityType dt) {
        Object value = filterMap.get(PARAM_KEY_VALUE);
        if (value instanceof String) {
            value = WfProcessUtils.replaceWfSpecialCombo((String)((String)value), (boolean)true);
            boolean isDateRange = DataRangeCompareUtil.isDateRangeCompare(filterMap);
            if (isDateRange) {
                filterMap.put(PARAM_KEY_VALUE, this.parseFilterValue2DateRange((String)value, entityNumber, businessKey, billObj, dt));
            } else {
                filterMap.put(PARAM_KEY_VALUE, this.parseFilterValue((String)value, entityNumber, businessKey, billObj, dt));
            }
        }
    }

    private String parseOrderBy(List<Map<String, Object>> orderby) {
        if (orderby == null || orderby.isEmpty()) {
            return "id desc";
        }
        StringBuilder sb = new StringBuilder();
        for (Map<String, Object> orderByMap : orderby) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            String number = (String)orderByMap.get(PARAM_KEY_NUMBER);
            boolean isAsc = true;
            isAsc = orderByMap.containsKey("isAsc") ? (Boolean)orderByMap.get("isAsc") : (orderByMap.containsKey("asc") ? (Boolean)orderByMap.get("asc") : true);
            if (isAsc) {
                sb.append(number).append(" asc");
                continue;
            }
            sb.append(number).append(" desc");
        }
        return sb.toString();
    }

    private Tuple<Object, Object> updateModel(Object expression, String formId, Object businessKey, String assignment) {
        boolean notNeedExpParse;
        Object targetPkId;
        String targetField;
        BillEntityType dt;
        String targetFormId;
        Object calcValue = null;
        Object calcDisplayValue = null;
        String[] split = assignment.split("\\.");
        if (split.length == 3) {
            targetFormId = split[0];
            dt = NcEntityTypeUtil.getMainEntityType((String)targetFormId);
            targetField = split[1];
            targetPkId = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, (Object)split[2]);
        } else {
            dt = NcEntityTypeUtil.getMainEntityType((String)formId);
            targetFormId = formId;
            targetField = assignment;
            targetPkId = businessKey;
        }
        if (expression == null) {
            return null;
        }
        if (!NcEntityTypeUtil.isFormExist((String)targetFormId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeWfServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        IDataEntityProperty assignmentProperty = dt.findProperty(targetField);
        if (assignmentProperty == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d4b\u503c\u76ee\u6807\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u5220\u9664\uff1a", (String)"NoCodeWfServiceImpl_1", (String)"bos-nocode-service", (Object[])new Object[0]) + assignment);
        }
        String runtimeExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression.toString());
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)runtimeExpression)) {
            return null;
        }
        boolean bl = notNeedExpParse = !this.isNeedCallExpressParse(expression.toString(), assignmentProperty);
        if (!notNeedExpParse) {
            WfExpressionBillCtx ctx = new WfExpressionBillCtx(formId, businessKey, runtimeExpression, null, this.isAssignToText(assignmentProperty) ? WfConsts.ExpressionCtxType.NOTIFY : WfConsts.ExpressionCtxType.DEFAULT);
            ctx.getCustomParam().put("_assignmentProperty", assignmentProperty);
            NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
            calcValue = service.tryGetExpressionValue((NoCodeExpCtx)ctx);
        } else {
            calcValue = runtimeExpression;
        }
        calcValue = this.convertTo(assignmentProperty, calcValue);
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)targetFormId);
        DynamicObject rec = BusinessDataServiceHelper.loadSingle((Object)targetPkId, (String)formNumber);
        if (rec != null) {
            if (assignmentProperty instanceof INoCodeRefBillProp && !(calcValue instanceof DynamicObject)) {
                List<Object> refBillObjs;
                INoCodeRefBillProp refbillProp = (INoCodeRefBillProp)assignmentProperty;
                if (NoCodeWfServiceImpl.isMultiCalcResult(calcValue)) {
                    refBillObjs = Splitter.on((String)",").splitToStream((CharSequence)((String)calcValue)).map(e -> this.getRefBillObj(assignmentProperty, e)).filter(Objects::nonNull).collect(Collectors.toList());
                } else {
                    DynamicObject refBillObj = this.getRefBillObj(assignmentProperty, calcValue);
                    List<Object> list = refBillObjs = Objects.isNull(refBillObj) ? new ArrayList(0) : Lists.newArrayList((Object[])new DynamicObject[]{refBillObj});
                }
                if (CollectionUtils.isNotEmpty((Collection)refBillObjs)) {
                    if (refbillProp.isMultiSelect()) {
                        assignmentProperty.setValue((Object)rec, calcValue);
                    } else {
                        assignmentProperty.setValue((Object)rec, refBillObjs.get(0));
                    }
                    Object refObjDisplayValue = this.getRefObjDisplayValue(refBillObjs);
                    if (refObjDisplayValue != null) {
                        calcDisplayValue = refObjDisplayValue;
                    }
                } else {
                    assignmentProperty.setValue((Object)rec, calcValue);
                    calcDisplayValue = calcValue;
                }
            } else {
                assignmentProperty.setValue((Object)rec, calcValue);
                calcDisplayValue = calcValue;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rec});
        }
        return new Tuple(calcDisplayValue, calcValue);
    }

    private static boolean isMultiCalcResult(Object calcResult) {
        return calcResult instanceof String && StringUtils.isNotEmpty((CharSequence)((String)calcResult)) && ((String)calcResult).contains(",");
    }

    private DynamicObject getRefBillObj(IDataEntityProperty assignmentProperty, Object calcResult) {
        if (calcResult == null || NoCodeWfServiceImpl.isEmptyString(calcResult)) {
            return null;
        }
        String refBillEntityId = ((INoCodeRefBillProp)assignmentProperty).getBillEntityId();
        MainEntityType refDt = NcEntityTypeUtil.getDataEntityType((String)refBillEntityId);
        String refBillNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)refBillEntityId);
        Object refPk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)refDt, (Object)calcResult);
        if (refPk == null || refPk instanceof Long && (Long)refPk == 0L) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)refPk, (String)refBillNumber);
    }

    private static boolean isEmptyString(Object calcResult) {
        return calcResult instanceof String && StringUtils.isEmpty((CharSequence)((String)calcResult));
    }

    private Object getRefObjDisplayValue(List<DynamicObject> refBillObjs) {
        if (CollectionUtils.isEmpty(refBillObjs)) {
            return null;
        }
        String billDisplayPropertyName = NcEntityTypeUtil.getBillDisplayPropertyName((IDataEntityType)refBillObjs.get(0).getDataEntityType());
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)billDisplayPropertyName)) {
            return refBillObjs.stream().map(e -> {
                Object dispPropValue = e.get(billDisplayPropertyName);
                if (dispPropValue != null) {
                    if (dispPropValue instanceof ILocaleString) {
                        return ((ILocaleString)dispPropValue).getLocaleValue();
                    }
                    return dispPropValue.toString();
                }
                return "";
            }).collect(Collectors.joining(","));
        }
        return null;
    }

    private Object updateProc(Object expression, String formId, Object businessKey, boolean isTextTarget) {
        if (!(expression instanceof String) || !this.isNeedCallExpressParse((String)expression, null)) {
            return expression;
        }
        String runtimeExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression.toString());
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)runtimeExpression)) {
            return null;
        }
        WfExpressionBillCtx ctx = new WfExpressionBillCtx(formId, businessKey, runtimeExpression, null, isTextTarget ? WfConsts.ExpressionCtxType.NOTIFY : WfConsts.ExpressionCtxType.DEFAULT);
        NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        return service.tryGetExpressionValue((NoCodeExpCtx)ctx);
    }

    private List<Map<String, Object>> cloneListMap(List<Map<String, Object>> data) {
        if (data == null) {
            return Collections.emptyList();
        }
        if (data.isEmpty()) {
            return new ArrayList<Map<String, Object>>(0);
        }
        String str = SerializationUtils.toJsonString(data);
        return (List)SerializationUtils.fromJsonString((String)str, List.class);
    }

    public Map<String, Object> calc(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        HashMap<String, Object> calcResults = new HashMap<String, Object>(outParams.size());
        for (int i = 0; i < inParams.size(); ++i) {
            String outParamId;
            Map<String, Object> calcMap = inParams.get(i);
            Object expression = calcMap.get("expression");
            String formId = (String)calcMap.get("formId");
            String businessKey = (String)calcMap.get("businessKey");
            String remainKey = this.getRemainKey(calcMap, "expression", "formId", "businessKey");
            boolean isUpdate = kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)remainKey);
            int finalI = i;
            Map outParam = isUpdate ? outParams.stream().filter(p -> remainKey.equalsIgnoreCase((String)p.get(PARAM_KEY_NUMBER))).findFirst().orElseGet(() -> (Map)outParams.get(finalI)) : outParams.get(finalI);
            String outParamNumber = (String)outParam.get(PARAM_KEY_NUMBER);
            Map outParam_Id = outParams.stream().filter(p -> ((String)p.get(PARAM_KEY_NUMBER)).equalsIgnoreCase(outParamNumber + "_id") || ((String)p.get(PARAM_KEY_NUMBER)).equalsIgnoreCase(outParamNumber + ".id")).findFirst().orElseGet(() -> null);
            String string = outParamId = outParam_Id != null ? (String)outParam_Id.get(PARAM_KEY_NUMBER) : null;
            if (isUpdate) {
                String assignment = (String)calcMap.get(remainKey);
                Tuple<Object, Object> calcResuleTuple = this.updateModel(expression, formId, businessKey, assignment);
                if (calcResuleTuple == null) continue;
                calcResults.put(outParamNumber, calcResuleTuple.item1);
                if (outParamId == null) continue;
                calcResults.put(outParamId, calcResuleTuple.item2);
                continue;
            }
            boolean isTextTarget = WfConsts.CustomVarTypeEnum.TEXT.getCode().equalsIgnoreCase((String)outParam.get(PARAM_KEY_TYPE));
            Object calcResult = this.updateProc(expression, formId, businessKey, isTextTarget);
            if (isTextTarget) {
                calcResult = ObjectConverter.convert((Object)this.removeQuotation(calcResult), String.class);
            } else if (WfConsts.CustomVarTypeEnum.NUMBER.getCode().equalsIgnoreCase((String)outParam.get(PARAM_KEY_TYPE))) {
                calcResult = this.convertToNumber(calcResult, 38, 2);
            }
            calcResults.put(outParamNumber, calcResult);
            if (outParamId == null) continue;
            calcResults.put(outParamId, calcResult);
        }
        return calcResults;
    }

    public Map<String, Object> updateBill(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        String businessFormId = null;
        String businessKey = null;
        String refFormId = null;
        String triggerProcess = null;
        Object pkId = null;
        ArrayList<Tuple<String, Object>> updateSetting = new ArrayList<Tuple<String, Object>>(inParams.size());
        for (int i = 0; i < inParams.size(); ++i) {
            Map<String, Object> imParamMap = inParams.get(i);
            businessFormId = (String)imParamMap.get("businessFormId");
            businessKey = (String)imParamMap.get("businessKey");
            refFormId = (String)imParamMap.get("refFormId");
            triggerProcess = (String)imParamMap.get("triggerProcess");
            pkId = imParamMap.get("pkId");
            if (pkId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u8868\u5355\u76ee\u6807\u8bb0\u5f55\u4e0d\u5b58\u5728", (String)"NoCodeWfServiceImpl_2", (String)"bos-nocode-service", (Object[])new Object[0]));
            }
            Object expression = imParamMap.get("expression");
            String assignmentKey = this.getRemainKey(imParamMap, "businessFormId", "businessKey", "refFormId", "pkId", "triggerProcess", "expression");
            String assignment = (String)imParamMap.get(assignmentKey);
            updateSetting.add((Tuple<String, Object>)new Tuple((Object)assignment, expression));
        }
        if (!NcEntityTypeUtil.isFormExist(refFormId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeWfServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        BillEntityType refDt = NcEntityTypeUtil.getMainEntityType(refFormId);
        if (pkId instanceof String && ((String)pkId).indexOf(",") != -1) {
            String[] pkids = ((String)pkId).split(",");
            StringBuilder sb = new StringBuilder();
            HashMap<String, Object> updateResults = new HashMap<String, Object>(2);
            for (String pid : pkids) {
                List<Tuple<String, Object>> newUpdateSetting = this.getNewUpdateSetting(pid, (String)pkId, updateSetting);
                Map<String, Object> oneResult = this.innerUpdateBill(businessFormId, businessKey, refFormId, pid, triggerProcess, newUpdateSetting, refDt);
                Object pk = oneResult.get(refDt.getPrimaryKey().getName());
                if (pk == null) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(pk);
            }
            updateResults.put("QueryDataSet", sb.toString());
            updateResults.put("QueryDataSet_id", sb.toString());
            return updateResults;
        }
        return this.innerUpdateBill(businessFormId, businessKey, refFormId, pkId, triggerProcess, updateSetting, refDt);
    }

    private List<Tuple<String, Object>> getNewUpdateSetting(String pid, String multipkId, List<Tuple<String, Object>> updateSetting) {
        return updateSetting.stream().map(e -> {
            String assignmentKey = (String)e.item1;
            Object value = e.item2;
            if (!(value instanceof String)) {
                return new Tuple((Object)assignmentKey, value);
            }
            Pattern compileDisp = WfConsts.VAR_DISP_PATTERN_OF_FIELD;
            String valueStr = (String)value;
            Matcher matcherDisp = compileDisp.matcher(valueStr);
            if (matcherDisp.matches()) {
                valueStr = valueStr.replace(multipkId, pid);
                return new Tuple((Object)assignmentKey, (Object)valueStr);
            }
            return new Tuple((Object)assignmentKey, value);
        }).collect(Collectors.toList());
    }

    public Map<String, Object> innerUpdateBill(String businessFormId, Object businessKey, String refFormId, Object pkId, String triggerProcess, List<Tuple<String, Object>> updateSetting, BillEntityType refDt) {
        HashMap<String, Object> updateResults = new HashMap<String, Object>(updateSetting.size());
        String refFormNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)refFormId);
        DynamicObject refObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)refFormNumber);
        if (refObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d4b\u503c\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u5220\u9664(formid:%1$s pkid: %2$s)", (String)"NoCodeWfServiceImpl_4", (String)"bos-nocode-service", (Object[])new Object[]{refFormId, pkId}));
        }
        boolean isDirty = false;
        HashSet<String> selectSet = new HashSet<String>(updateSetting.size());
        for (Tuple<String, Object> updateItemMap : updateSetting) {
            Object calcResult;
            String assignment = (String)updateItemMap.item1;
            Object expression = updateItemMap.item2;
            boolean isEmptyExp = expression == null || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)NcEntityTypeUtil.getRuntimeExpression((String)expression.toString()));
            IDataEntityProperty assignmentProperty = refDt.findProperty(assignment);
            if (assignmentProperty == null) {
                if (isEmptyExp) continue;
                logger.debug("\u8d4b\u503c\u76ee\u6807\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u5220\u9664\uff1a" + assignment);
                continue;
            }
            if (expression == null || !(expression instanceof String)) {
                calcResult = expression;
                logger.debug("expression == null || !(expression instanceof String): " + (expression == null ? "null" : expression.toString()));
            } else if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)NcEntityTypeUtil.getRuntimeExpression((String)expression.toString()))) {
                calcResult = null;
                logger.debug("runtimeExpression is blank");
            } else {
                boolean notNeedExpParse;
                String runtimeExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression.toString());
                boolean bl = notNeedExpParse = !this.isNeedCallExpressParse(expression.toString(), assignmentProperty);
                if (!notNeedExpParse) {
                    WfExpressionBillCtx ctx = new WfExpressionBillCtx(businessFormId, businessKey, runtimeExpression, null, this.isAssignToText(assignmentProperty) ? WfConsts.ExpressionCtxType.NOTIFY : WfConsts.ExpressionCtxType.DEFAULT);
                    ctx.getCustomParam().put("_assignmentProperty", assignmentProperty);
                    NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
                    calcResult = service.tryGetExpressionValue((NoCodeExpCtx)ctx);
                } else {
                    calcResult = runtimeExpression;
                }
                calcResult = this.convertTo(assignmentProperty, calcResult);
            }
            logger.info("CalcResult type: " + (calcResult == null ? "null" : calcResult.getClass().getName()) + " calcResult:" + (calcResult == null ? "null" : calcResult.toString()));
            assignmentProperty.setValue((Object)refObj, calcResult);
            updateResults.put(assignment, calcResult);
            isDirty = true;
            selectSet.add(assignment);
        }
        if (isDirty) {
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{refObj});
            DynamicObject saveObj = (DynamicObject)saveObjs[0];
            ISimpleProperty primaryKey = refDt.getPrimaryKey();
            Object pk = primaryKey.getValue((Object)saveObj);
            updateResults.put(primaryKey.getName(), pk);
            this.replaceUseFormatString(pk, refFormId, refFormNumber, selectSet, updateResults);
            this.triggerProcess(refFormNumber, pk, "bizOperate", triggerProcess);
        } else {
            logger.debug("not dirty");
        }
        return updateResults;
    }

    private Object convertTo(IDataEntityProperty prop, Object value) {
        if (value == null) {
            return null;
        }
        if (prop instanceof DateTimeProp) {
            if (value instanceof Date) {
                return DateTimeUtils.parseDate((String)DateTimeUtils.formatDateTime((Date)((Date)value)));
            }
            value = this.removeQuotation(value);
            try {
                Date date = DateTimeUtils.parseDate((String)value.toString());
                return date;
            }
            catch (Exception ex) {
                logger.debug("parseDateStr: " + value.toString());
                logger.warn((Throwable)ex);
                return null;
            }
        }
        if (prop instanceof DecimalProp) {
            return this.convertToNumber(value, ((DecimalProp)prop).getPrecision(), ((DecimalProp)prop).getScale());
        }
        if (prop instanceof ComboProp) {
            if ("null".equalsIgnoreCase(value.toString())) {
                return null;
            }
            value = this.removeQuotation(value);
            String sValue = value.toString();
            ComboProp comboProp = (ComboProp)prop;
            for (ValueMapItem comboItem : comboProp.getComboItems()) {
                if (sValue.equalsIgnoreCase(comboItem.getValue())) {
                    return comboItem.getValue();
                }
                if (!sValue.equalsIgnoreCase(comboItem.getName().toString())) continue;
                return comboItem.getValue();
            }
            return Splitter.on((CharMatcher)CharMatcher.is((char)',').or(CharMatcher.is((char)'\n'))).splitToStream((CharSequence)sValue).map(e -> {
                for (ValueMapItem comboItem : comboProp.getComboItems()) {
                    if (e.equalsIgnoreCase(comboItem.getValue())) {
                        return comboItem.getValue();
                    }
                    if (!e.equalsIgnoreCase(comboItem.getName().toString())) continue;
                    return comboItem.getValue();
                }
                return e;
            }).collect(Collectors.joining(","));
        }
        if (prop instanceof TextProp) {
            if ("null".equalsIgnoreCase(value.toString())) {
                return null;
            }
            if (value instanceof Double) {
                value = BigDecimal.valueOf((Double)value);
            }
            if (value instanceof BigDecimal) {
                value = ((BigDecimal)value).stripTrailingZeros();
                return DecimalUtil.format((BigDecimal)((BigDecimal)value), (int)((BigDecimal)value).scale(), (boolean)true, (boolean)false, (boolean)true);
            }
            return ObjectConverter.convert((Object)this.removeQuotation(value), String.class);
        }
        if (prop instanceof INoCodeRefBillProp) {
            value = this.removeQuotation(value);
            if (!((INoCodeRefBillProp)prop).isMultiSelect() && value instanceof String && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)((String)value))) {
                value = null;
            }
        }
        return value;
    }

    private Object convertToNumber(Object value, int precision, int scale) {
        if (value == null) {
            return null;
        }
        if ("null".equalsIgnoreCase(value.toString())) {
            return null;
        }
        if (value instanceof String && kd.bos.dataentity.utils.StringUtils.isBlank((Object)value)) {
            return null;
        }
        try {
            BigDecimal decimal = (BigDecimal)ObjectConverter.convert((Object)this.removeThousandsSeparator(this.removeQuotation(value)), BigDecimal.class);
            if (decimal != null) {
                if ((decimal = decimal.setScale(scale, RoundingMode.HALF_UP)).precision() - decimal.scale() > precision - scale) {
                    return null;
                }
                return decimal;
            }
        }
        catch (NumberFormatException ne) {
            logger.info(value.toString());
            return null;
        }
        return null;
    }

    private Object removeQuotation(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).startsWith("\"") && ((String)value).endsWith("\"")) {
            return ((String)value).substring(1, ((String)value).length() - 1);
        }
        if (value instanceof String && ((String)value).startsWith("'") && ((String)value).endsWith("'")) {
            return ((String)value).substring(1, ((String)value).length() - 1);
        }
        return value;
    }

    private Object removeThousandsSeparator(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ((String)value).indexOf(",") != -1) {
            return ((String)value).replaceAll(",", "");
        }
        return value;
    }

    private void replaceUseFormatString(Object pk, String refFormId, String refFormNumber, Set<String> selectSet, Map<String, Object> updateResults) {
        if (pk == null || selectSet.isEmpty() || updateResults.isEmpty()) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)refFormNumber, (String)String.join((CharSequence)",", selectSet));
        Map objectMap = PropertyHandleUtil.toMap((Object)pk, (String)refFormId, (String)"$", (DynamicObject)dynamicObject, selectSet, (boolean)true);
        if (objectMap != null && !objectMap.isEmpty()) {
            for (Map.Entry resObjEntry : objectMap.entrySet()) {
                updateResults.put((String)resObjEntry.getKey(), resObjEntry.getValue());
            }
        }
    }

    public Map<String, Object> newBill(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        String businessFormId = null;
        String businessKey = null;
        String refFormId = null;
        String triggerProcess = null;
        WfConsts.NewModeEnum newMode = WfConsts.NewModeEnum.one;
        String loopby = null;
        if (inParams == null || inParams.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        ArrayList<Map<String, Object>> settings = new ArrayList<Map<String, Object>>(inParams.size());
        for (int i = 0; i < inParams.size(); ++i) {
            Map<String, Object> imParamMap = inParams.get(i);
            businessFormId = (String)imParamMap.get("businessFormId");
            businessKey = (String)imParamMap.get("businessKey");
            refFormId = (String)imParamMap.get("refFormId");
            triggerProcess = (String)imParamMap.get("triggerProcess");
            if (imParamMap.containsKey("newMode")) {
                newMode = WfConsts.NewModeEnum.getByCode((String)((String)imParamMap.get("newMode")));
            }
            if (imParamMap.containsKey("loopby")) {
                loopby = (String)imParamMap.get("loopby");
            }
            Object expression = imParamMap.get("expression");
            String assignmentKey = this.getRemainKey(imParamMap, "businessFormId", "businessKey", "refFormId", "triggerProcess", "expression", "newMode", "loopby");
            String assignment = (String)imParamMap.get(assignmentKey);
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put(PARAM_KEY_NUMBER, assignment);
            map.put(PARAM_KEY_VALUE, expression);
            settings.add(map);
        }
        if (!NcEntityTypeUtil.isFormExist(refFormId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"NoCodeWfServiceImpl_0", (String)"bos-nocode-service", (Object[])new Object[0]));
        }
        if (newMode == WfConsts.NewModeEnum.one) {
            return this.innerNewBill(businessFormId, businessKey, refFormId, triggerProcess, settings);
        }
        return this.innerNewBillByLoop(businessFormId, businessKey, refFormId, triggerProcess, settings, loopby);
    }

    public List<Map<String, Object>> queryStartNodeFormData(Map<String, Object> inParams) {
        String entityNumber = (String)inParams.get("entityNumber");
        List filter = (List)inParams.get("filter");
        List orderBy = (List)inParams.get("orderby");
        Integer topNumber = (Integer)inParams.get("topNumber");
        Long userId = Long.parseLong((String)inParams.get("userId"));
        NoCodeFilterServiceImpl noCodeFilterService = new NoCodeFilterServiceImpl();
        QFilter[] filters = noCodeFilterService.getQFilters(entityNumber, filter);
        String orderByStr = ListConfigUtils.buildOrderInfo((List)orderBy);
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])filters, (String)orderByStr, (int)topNumber);
        return pkIds.stream().map(pkId -> {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
            resultMap.put("entityNumber", entityNumber);
            resultMap.put("businessKey", pkId);
            resultMap.put("initiator", userId);
            return resultMap;
        }).collect(Collectors.toList());
    }

    public Map<String, Object> invokeApi(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(32);
        result.put("StatusCode", "");
        result.put("RequestStatus", WfConsts.RequestStatus.FAIL.getName());
        for (Map<String, Object> inParamMap : inParams) {
            WorkflowHttpResponse response;
            Map<String, String> name2ResponseType;
            List responseParams;
            String queryNumber;
            String appId;
            block12: {
                String entityNumber = (String)inParamMap.get("entityNumber");
                String businessKey = (String)inParamMap.get("businessKey");
                appId = (String)inParamMap.get("appId");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)appId)) {
                    appId = FormMetaUtil.getAppIdByFormNumber((String)entityNumber);
                }
                String apiMode = (String)inParamMap.get("apiMode");
                String authMode = (String)inParamMap.get("authMode");
                String method = (String)inParamMap.get("method");
                String url = this.parseVar((String)inParamMap.get("url"), entityNumber, businessKey);
                boolean isOAuth2 = false;
                if ("auth".equals(apiMode) && "oauth2".equals(authMode)) {
                    isOAuth2 = true;
                    url = this.parseVar((String)inParamMap.get("accessTokenUrl"), entityNumber, businessKey);
                }
                String requestHeaderStr = (String)inParamMap.get("requestHeader");
                String requestHeaderJsonVar = (String)inParamMap.get("requestHeaderJsonVar");
                Map requestHeaderJsonVarMap = JsonVarHelper.parseJsonVar((String)requestHeaderJsonVar);
                for (Map.Entry entry : requestHeaderJsonVarMap.entrySet()) {
                    requestHeaderStr = requestHeaderStr.replace((CharSequence)entry.getKey(), StringEscapeUtils.escapeJson((String)((String)entry.getValue())));
                }
                List requestHeader = SerializationUtils.fromJsonStringToList((String)requestHeaderStr, Map.class);
                Map<String, String> headers = this.getHeaders(requestHeader, entityNumber, businessKey);
                String requestBody = (String)inParamMap.get("requestBody");
                queryNumber = (String)inParamMap.get("queryNumber");
                int timeout = Integer.parseInt((String)inParamMap.get("timeout"));
                int tokenTimeout = 7200;
                if (inParamMap.get("tokenTimeout") != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)((String)inParamMap.get("tokenTimeout")))) {
                    tokenTimeout = Integer.parseInt((String)inParamMap.get("tokenTimeout"));
                }
                boolean sslAuth = Boolean.parseBoolean((String)inParamMap.get("sslAuth"));
                boolean terminateFlow = Boolean.parseBoolean((String)inParamMap.get("terminateFlow"));
                if ("auth".equals(apiMode) && "basicAuth".equals(authMode)) {
                    result.clear();
                    String username = this.parseVar((String)inParamMap.get("username"), entityNumber, businessKey);
                    String password = this.parseVar((String)inParamMap.get("password"), entityNumber, businessKey);
                    String usernameAndPassword = String.format("%s:%s", username, password);
                    result.put("BASIC_AUTH_TOKEN", "Basic " + new String(Base64.getEncoder().encode(usernameAndPassword.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
                    return result;
                }
                responseParams = SerializationUtils.fromJsonStringToList((String)((String)inParamMap.get("responseParams")), Map.class);
                name2ResponseType = responseParams.stream().collect(Collectors.toMap(e -> (String)e.get("name"), e -> (String)e.get("responseType")));
                outParams.forEach(e -> {
                    String oParamNumber = (String)e.get(PARAM_KEY_NUMBER);
                    e.put(PARAM_KEY_NUMBER, this.parseVar(oParamNumber, entityNumber, businessKey));
                });
                response = null;
                try {
                    String requestBodyJsonVar = (String)inParamMap.get("requestBodyJsonVar");
                    Map requestBodyJsonVarMap = JsonVarHelper.parseJsonVar((String)requestBodyJsonVar);
                    for (Map.Entry entry : requestBodyJsonVarMap.entrySet()) {
                        requestBody = requestBody.replace((CharSequence)entry.getKey(), StringEscapeUtils.escapeJson((String)((String)entry.getValue())));
                    }
                    response = this.sendRequest(method, url, headers, requestBody, timeout * 1000, entityNumber, businessKey, sslAuth, isOAuth2, tokenTimeout);
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    logger.error("url: {}", (Object)url);
                    if (!terminateFlow) break block12;
                    throw new TerminateFlowException((Throwable)e2);
                }
            }
            if (response == null || !response.isSuccess()) {
                return result;
            }
            result.put("StatusCode", response.getStatusCode());
            result.put("RequestStatus", WfConsts.RequestStatus.SUCCESS.getName());
            String responseBody = response.getResponseBody();
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)responseBody)) {
                return result;
            }
            Map originHeaders = response.getOriginHeaders();
            responseBody = responseBody.trim();
            outParams.removeIf(e -> Arrays.asList("StatusCode", "RequestStatus").contains((String)e.get(PARAM_KEY_NUMBER)));
            if (WfConsts.ApiQueryNumberEnum.single.toString().equals(queryNumber)) {
                NoCodeWfServiceImpl.wrapSingleResultMap(outParams, result, originHeaders, responseBody, name2ResponseType);
                continue;
            }
            NoCodeWfServiceImpl.wrapMultiResultMap(result, inParamMap, originHeaders, responseBody, responseParams, name2ResponseType, appId);
        }
        return result;
    }

    public Map<String, Object> parseCustomJson(List<Map<String, Object>> inParams, List<Map<String, Object>> outParams) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        for (Map<String, Object> inParamMap : inParams) {
            String sourceDataStr = (String)inParamMap.get("sourceData");
            String sourceDataJsonVar = (String)inParamMap.get("sourceDataJsonVar");
            Map sourceDataJsonVarMap = JsonVarHelper.parseJsonVar((String)sourceDataJsonVar);
            for (Map.Entry entry : sourceDataJsonVarMap.entrySet()) {
                sourceDataStr = sourceDataStr.replace((CharSequence)entry.getKey(), StringEscapeUtils.escapeJson((String)((String)entry.getValue())));
            }
            List sourceData = SerializationUtils.fromJsonStringToList((String)sourceDataStr, CustomJsonRow.class);
            String entityNumber = (String)inParamMap.get("entityNumber");
            String businessKey = (String)inParamMap.get("businessKey");
            this.replaceVariables(sourceData, entityNumber, businessKey);
            this.expandLoopItem(sourceData);
            this.tagTheLastOne(sourceData);
            String json = this.buildCustomJson(sourceData);
            result.put("CustomJson", json);
        }
        return result;
    }

    private void tagTheLastOne(List<CustomJsonRow> sourceData) {
        for (CustomJsonRow row : sourceData) {
            if (!CollectionUtils.isNotEmpty((Collection)row.getChildren())) continue;
            ((CustomJsonRow)row.getChildren().get(row.getChildren().size() - 1)).setLastOne(true);
            this.tagTheLastOne(row.getChildren());
        }
    }

    private void expandLoopItem(List<CustomJsonRow> sourceData) {
        for (CustomJsonRow item : sourceData) {
            CustomJsonRow.ParamValue paramValue = item.getValue();
            if (CustomJsonRow.ValueTypeEnum.var.toString().equals(paramValue.getType()) && NcEntityTypeUtil.isRefBill((String)paramValue.getConfig().getFieldType()) && paramValue.getConfig().isMulti() && CollectionUtils.isNotEmpty((Collection)item.getChildren())) {
                List children = item.getChildren();
                String jsonString = SerializationUtils.toJsonString((Object)children);
                children.clear();
                String idStr = paramValue.getValue();
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)idStr) || "null".equals(idStr)) {
                    item.setValueLeftQuote("");
                    item.setValueRightQuote("");
                    item.setValueSeparator("");
                    continue;
                }
                String[] idArray = idStr.split(",");
                ArrayList<List> groups = new ArrayList<List>(idArray.length);
                for (int i = 0; i < idArray.length; ++i) {
                    List l = SerializationUtils.fromJsonStringToList((String)jsonString, CustomJsonRow.class);
                    children.addAll(l);
                    groups.add(l);
                }
                String parentVariableKey = paramValue.getConfig().getValueVarKey();
                for (int i = 0; i < groups.size(); ++i) {
                    this.replaceMultiVariable((List)groups.get(i), i, parentVariableKey);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)item.getChildren())) continue;
            this.expandLoopItem(item.getChildren());
        }
    }

    private void replaceMultiVariable(List<CustomJsonRow> customJsonRows, int i, String parentVariableKey) {
        for (CustomJsonRow customJsonRow : customJsonRows) {
            CustomJsonRow.ParamValue paramValue = customJsonRow.getValue();
            if (CustomJsonRow.ValueTypeEnum.var.toString().equals(paramValue.getType()) && paramValue.getConfig().isMulti() && NcEntityTypeUtil.isRefBill((String)paramValue.getConfig().getFieldType()) && paramValue.getConfig().getValueVarKey() != null && paramValue.getConfig().getValueVarKey().equals(parentVariableKey)) continue;
            if (CustomJsonRow.ValueTypeEnum.var.toString().equals(paramValue.getType()) && paramValue.getConfig().getParentKey() != null && paramValue.getConfig().getParentKey().equals(parentVariableKey)) {
                String dispValueStr = paramValue.getValue();
                List dispValues = SerializationUtils.fromJsonStringToList((String)dispValueStr, String.class);
                paramValue.setValue((String)dispValues.get(i));
            }
            if (!CollectionUtils.isNotEmpty((Collection)customJsonRow.getChildren())) continue;
            this.replaceMultiVariable(customJsonRow.getChildren(), i, parentVariableKey);
        }
    }

    private void replaceVariables(List<CustomJsonRow> sourceData, String entityNumber, String businessKey) {
        sourceData.forEach(e -> {
            e.getValue().setValue(this.parseWfVariable(e.getValue().getValue(), entityNumber, businessKey));
            if (CollectionUtils.isNotEmpty((Collection)e.getChildren())) {
                this.replaceVariables(e.getChildren(), entityNumber, businessKey);
            }
        });
    }

    private String buildCustomJson(List<CustomJsonRow> sourceData) {
        return sourceData.stream().map(customJsonRow -> customJsonRow.buildJsonString(null)).collect(Collectors.joining());
    }

    public void deleteWfInfoByEntityNumberAndBusinessKey(String entityNumber, String businessKey) {
        WfProcessDataService.create().deleteWfInfoByEntityNumberAndBusinessKey(entityNumber, businessKey);
    }

    private String parseWfVariable(String var, String entityNumber, String businessKey) {
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)entityNumber);
        if (Objects.isNull(dt) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)var)) {
            return var;
        }
        WfExpressionBillCtx ctx = new WfExpressionBillCtx(entityNumber, businessKey, var, null, WfConsts.ExpressionCtxType.NOTIFY);
        NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        ctx.getCustomParam().put("parseCustomJsonVariable", true);
        String parsedValue = service.getNotifyExpression((NoCodeExpCtx)ctx);
        return parsedValue != null ? parsedValue.toString() : "";
    }

    private String parseVar(String var, String entityNumber, String businessKey) {
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType((String)entityNumber);
        if (Objects.isNull(dt) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)var)) {
            return var;
        }
        WfExpressionBillCtx ctx = new WfExpressionBillCtx(entityNumber, businessKey, var, null, WfConsts.ExpressionCtxType.NOTIFY);
        NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        Object parsedValue = var.contains("getCosmicToken") ? service.getExpressionValue((NoCodeExpCtx)ctx) : service.getNotifyExpression((NoCodeExpCtx)ctx);
        return parsedValue != null ? parsedValue.toString() : "";
    }

    private String parseFilterValue(String varExpression, String entityNumber, String businessKey, DynamicObject billObj, MainEntityType dt) {
        if (Objects.isNull(dt) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)varExpression)) {
            return varExpression;
        }
        varExpression = WfProcessUtils.removeVarSuffix((String)varExpression);
        Matcher m = WfConsts.varModelPattern.matcher(varExpression);
        while (m.find()) {
            String modelVar = m.group();
            String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)(\\.id)?\\}", "$1");
            IDataEntityProperty fieldProp = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldId);
            if (fieldProp instanceof NoCodeRefBillProp) {
                fieldId = fieldId + ".id";
            }
            if (billObj == null) {
                entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)entityNumber);
                Object pkid = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)NcEntityTypeUtil.getMainEntityType((String)entityNumber), (Object)businessKey);
                billObj = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)entityNumber);
            }
            Object fieldValue = billObj.get(fieldId);
            fieldValue = NcEntityTypeUtil.getOriginalValue((IDataEntityProperty)fieldProp, (Object)fieldValue);
            if (fieldProp instanceof IDecimalFormatSupport) {
                fieldValue = ((IDecimalFormatSupport)fieldProp).getFormattedValue(fieldValue);
            }
            String sValue = fieldValue != null ? fieldValue.toString().trim() : "";
            varExpression = varExpression.replace(modelVar, sValue);
        }
        Matcher matcherDisp = WfConsts.VAR_DISP_PATTERN.matcher(varExpression);
        while (matcherDisp.find()) {
            String dispVar = matcherDisp.group();
            WfExpressionBillCtx ctx = new WfExpressionBillCtx(entityNumber, businessKey, dispVar, null, WfConsts.ExpressionCtxType.DEFAULT);
            ctx.getCustomParam().put("isFormatDate", true);
            NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
            Object dispValue = service.tryGetExpressionValue((NoCodeExpCtx)ctx);
            String sValue = dispValue != null ? dispValue.toString().trim() : "";
            varExpression = varExpression.replace(dispVar, sValue);
        }
        return varExpression;
    }

    private String parseFilterValue2DateRange(String varExpression, String entityNumber, String businessKey, DynamicObject billObj, MainEntityType dt) {
        if (Objects.isNull(dt) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)varExpression)) {
            return varExpression;
        }
        List valueMaps = SerializationUtils.fromJsonStringToList((String)(varExpression = WfProcessUtils.removeVarSuffix((String)varExpression)), Map.class);
        if (valueMaps == null || valueMaps.isEmpty() || valueMaps.size() != 2) {
            return varExpression;
        }
        String fieldValue1 = (String)((Map)valueMaps.get(0)).get("fieldValue");
        String fieldValue1Parsed = this.parseVar2DateRange(fieldValue1, entityNumber, businessKey, billObj, dt);
        DataRangeCompareUtil.getFieldValueWithDefault((boolean)true, (Object)fieldValue1Parsed);
        ((Map)valueMaps.get(0)).put("fieldValue", DataRangeCompareUtil.getFieldValueWithDefault((boolean)true, (Object)fieldValue1Parsed));
        String fieldValue2 = (String)((Map)valueMaps.get(1)).get("fieldValue");
        String fieldValue2Parsed = this.parseVar2DateRange(fieldValue2, entityNumber, businessKey, billObj, dt);
        ((Map)valueMaps.get(1)).put("fieldValue", DataRangeCompareUtil.getFieldValueWithDefault((boolean)false, (Object)fieldValue2Parsed));
        return SerializationUtils.toJsonString((Object)valueMaps);
    }

    private String parseVar2DateRange(String varExpression, String entityNumber, String businessKey, DynamicObject billObj, MainEntityType dt) {
        Matcher m = WfConsts.varModelPattern.matcher(varExpression);
        while (m.find()) {
            String modelVar = m.group();
            String fieldId = modelVar.replaceAll("\\$\\{model\\.(.+?)(\\.id)?\\}", "$1");
            IDataEntityProperty fieldProp = NcEntityTypeUtil.findProperty((DynamicObjectType)dt, (String)fieldId);
            if (fieldProp instanceof NoCodeRefBillProp) {
                fieldId = fieldId + ".id";
            }
            if (billObj == null) {
                entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)entityNumber);
                Object pkid = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)NcEntityTypeUtil.getMainEntityType((String)entityNumber), (Object)businessKey);
                billObj = BusinessDataServiceHelper.loadSingle((Object)pkid, (String)entityNumber);
            }
            Object fieldValue = billObj.get(fieldId);
            fieldValue = NcEntityTypeUtil.getOriginalValue((IDataEntityProperty)fieldProp, (Object)fieldValue);
            if (fieldProp instanceof IDecimalFormatSupport) {
                fieldValue = ((IDecimalFormatSupport)fieldProp).getFormattedValue(fieldValue);
            }
            String sValue = fieldValue != null ? fieldValue.toString().trim() : "";
            varExpression = varExpression.replace(modelVar, sValue);
        }
        Matcher matcherDisp = WfConsts.VAR_DISP_PATTERN.matcher(varExpression);
        while (matcherDisp.find()) {
            String dispVar = matcherDisp.group();
            WfExpressionBillCtx ctx = new WfExpressionBillCtx(entityNumber, businessKey, dispVar, null, WfConsts.ExpressionCtxType.DEFAULT);
            ctx.getCustomParam().put("isFormatDate", true);
            NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
            Object dispValue = service.tryGetExpressionValue((NoCodeExpCtx)ctx);
            String sValue = dispValue != null ? dispValue.toString().trim() : "";
            varExpression = varExpression.replace(dispVar, sValue);
        }
        return varExpression;
    }

    private static void wrapMultiResultMap(Map<String, Object> result, Map<String, Object> inParamMap, Map<String, String> originHeaders, String responseBody, List<Map<String, String>> responseParams, Map<String, String> name2ResponseType, String appId) {
        int topNumber = Integer.parseInt(String.valueOf(inParamMap.get("topNumber")));
        String multiArgName = (String)inParamMap.get("multiArgName");
        long procInstId = (Long)inParamMap.get("procInstId");
        List<Map<String, Object>> resultData = new ArrayList<Map<String, Object>>(16);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)multiArgName)) {
            if (!responseBody.startsWith("[")) {
                resultData = new ArrayList(2);
            } else {
                List responseBodyData = SerializationUtils.fromJsonStringToList((String)responseBody, Map.class);
                resultData = responseBodyData.stream().limit(Math.min(topNumber, responseBodyData.size())).collect(Collectors.toList());
            }
        } else {
            Object value;
            ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
            SimpleContext context = new SimpleContext();
            context.getVariableMapper().setVariable(DATA, factory.createValueExpression(SerializationUtils.fromJsonString((String)responseBody, Map.class), Object.class));
            try {
                ValueExpression expression = factory.createValueExpression((ELContext)context, String.format("${data.%s}", multiArgName), Object.class);
                value = expression.getValue((ELContext)context);
            }
            catch (Throwable e) {
                logger.info("wrapMultiResultMap Error: {}", (Object)e.getMessage(), (Object)e);
                value = new ArrayList(2);
            }
            if (value instanceof List) {
                List rows = (List)value;
                resultData = rows.stream().limit(Math.min(topNumber, rows.size())).collect(Collectors.toList());
            }
        }
        ArrayList<Map<String, Object>> rows = resultData;
        String entityNumber = new WfFormMetaService().createForm(appId, responseParams);
        result.put("billEntityId", entityNumber);
        String pkIds = NoCodeWfServiceImpl.insertRowData(entityNumber, responseParams, rows, name2ResponseType, originHeaders);
        result.put("QueryDataSet", pkIds);
        result.put("QueryDataSet_id", pkIds);
        DynamicObject dynamicObject = ORM.create().newDynamicObject("bos_nocode_tmpform");
        dynamicObject.set("procInstId", (Object)procInstId);
        dynamicObject.set("entityNumber", (Object)entityNumber);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static String insertRowData(String formId, List<Map<String, String>> responseParams, List<Map<String, Object>> rows, Map<String, String> name2ResponseType, Map<String, String> originHeaders) {
        Set fieldNameSet = responseParams.stream().map(e -> (String)e.get("name")).collect(Collectors.toSet());
        Map<String, String> name2Type = responseParams.stream().collect(Collectors.toMap(e -> (String)e.get("name"), e -> (String)e.get("fieldType")));
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(rows.size());
        for (Map<String, Object> row : rows) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)formId);
            for (String fieldName : fieldNameSet) {
                String responseType = name2ResponseType.get(fieldName);
                String type = name2Type.get(fieldName);
                Object targetvalue = NoCodeWfServiceImpl.getTargetValue(originHeaders, row, fieldName, type, responseType);
                dynamicObject.set(fieldName, targetvalue);
            }
            dynamicObjects.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
        return dynamicObjects.stream().map(e -> e.getPkValue().toString()).collect(Collectors.joining(","));
    }

    private static void wrapSingleResultMap(List<Map<String, Object>> outParams, Map<String, Object> result, Map<String, String> originHeaders, String responseBody, Map<String, String> name2ResponseType) {
        if (responseBody.startsWith("{")) {
            Map data = (Map)SerializationUtils.fromJsonString((String)responseBody, Map.class);
            for (Map<String, Object> outParam : outParams) {
                String oParamNumber = (String)outParam.get(PARAM_KEY_NUMBER);
                String decodeParamNumber = NoCodeWfServiceImpl.decodeParamNumber(oParamNumber);
                String type = (String)outParam.get(PARAM_KEY_TYPE);
                String responseType = name2ResponseType.get(oParamNumber);
                Object targetValue = decodeParamNumber.endsWith(JSON_SUFFIX) ? NoCodeWfServiceImpl.getTargetJsonValue(decodeParamNumber, responseBody) : NoCodeWfServiceImpl.getTargetValue(originHeaders, data, oParamNumber, type, responseType);
                result.put(oParamNumber, targetValue);
            }
        }
    }

    private static String decodeParamNumber(String oParamNumber) {
        String r = oParamNumber;
        if (r.startsWith("base36__")) {
            r = r.substring("base36__".length());
            r = Base36.createInstance().decode(r);
        }
        return r;
    }

    @Nullable
    private static Object getTargetValue(Map<String, String> originHeaders, Map<String, Object> data, String oParamNumber, String type, String responseType) {
        oParamNumber = NoCodeWfServiceImpl.decodeParamNumber(oParamNumber);
        String value = "responseHeader".equalsIgnoreCase(responseType) ? originHeaders.get(oParamNumber) : NoCodeWfServiceImpl.getDataValue(data, oParamNumber);
        Object targetValue = value;
        if (PARAM_KEY_NUMBER.equalsIgnoreCase(type)) {
            targetValue = NoCodeWfServiceImpl.convertTextToNumber(value);
        } else if ("date".equalsIgnoreCase(type)) {
            try {
                targetValue = DateTimeUtils.loopParse((String)value);
            }
            catch (ParseException ex) {
                logger.debug("parse date error: {}", (Object)ex.getMessage(), (Object)ex);
                targetValue = null;
            }
        }
        return targetValue;
    }

    @Nullable
    private static Object getTargetJsonValue(String decodeParamNumber, String responseBody) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)responseBody) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)decodeParamNumber)) {
            return null;
        }
        decodeParamNumber = decodeParamNumber.replace(JSON_SUFFIX, "");
        JSONObject obj = (JSONObject)JSONObject.parse((String)responseBody);
        return obj.getString(decodeParamNumber);
    }

    public static BigDecimal convertTextToNumber(String text) {
        try {
            return new BigDecimal(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    private WorkflowHttpResponse sendRequest(String method, String url, Map<String, String> headers, String requestBodyStr, int timeoutMillis, String entityNumber, String businessKey, boolean sslAuth, boolean isOAuth2, int tokenTimeout) throws Exception {
        String sResponse;
        boolean cacheEnable = isOAuth2 && tokenTimeout > 0;
        String cacheKey = String.format("%s_%s", CACHE_KEY_AUTH_RESPONSE, url);
        if (cacheEnable && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(sResponse = (String)myApiCache.get(cacheKey)))) {
            return (WorkflowHttpResponse)SerializationUtils.fromJsonString((String)sResponse, WorkflowHttpResponse.class);
        }
        WorkflowHttpResponse workflowHttpResponse = this.innerSendRequest(method, url, headers, requestBodyStr, timeoutMillis, entityNumber, businessKey, sslAuth);
        if (cacheEnable && workflowHttpResponse.isSuccess()) {
            myApiCache.put(cacheKey, (Object)SerializationUtils.toJsonString((Object)workflowHttpResponse), tokenTimeout);
        }
        return workflowHttpResponse;
    }

    private WorkflowHttpResponse innerSendRequest(String method, String url, Map<String, String> headers, String requestBodyStr, int timeoutMillis, String entityNumber, String businessKey, boolean sslAuth) throws Exception {
        WorkflowHttpResponse workflowHttpResponse = new WorkflowHttpResponse();
        if ("get".equalsIgnoreCase(method)) {
            workflowHttpResponse = WorkflowHttpClientUtils.get((String)url, headers, (int)timeoutMillis, (int)timeoutMillis, (boolean)sslAuth);
        } else if ("post".equalsIgnoreCase(method)) {
            RequestBody requestBody = (RequestBody)SerializationUtils.fromJsonString((String)requestBodyStr, RequestBody.class);
            String enctype = requestBody.getEnctype();
            if ("json".equalsIgnoreCase(enctype)) {
                String json = this.parseVar(requestBody.getJson(), entityNumber, businessKey);
                workflowHttpResponse = WorkflowHttpClientUtils.postJson((String)url, headers, (String)json, (int)timeoutMillis, (int)timeoutMillis, (boolean)sslAuth);
            } else if ("formData".equals(enctype)) {
                List formDataList = requestBody.getFormData();
                List formDataEntityList = formDataList.stream().map(e -> new WorkflowHttpClientUtils.FormDataEntity(e.getName(), this.parseVar(e.getValue(), entityNumber, businessKey))).collect(Collectors.toList());
                workflowHttpResponse = WorkflowHttpClientUtils.postFormData((String)url, headers, formDataEntityList, (int)timeoutMillis, (int)timeoutMillis, (boolean)sslAuth);
            }
        }
        return workflowHttpResponse;
    }

    private static String getDataValue(Map<String, Object> data, String oParamNumber) {
        Object value;
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        context.getVariableMapper().setVariable(DATA, factory.createValueExpression(data, Object.class));
        try {
            ValueExpression expression = factory.createValueExpression((ELContext)context, String.format("${data.%s}", oParamNumber), Object.class);
            value = expression.getValue((ELContext)context);
        }
        catch (Throwable e) {
            logger.debug("getDataValue Error: {}", (Object)e.getMessage(), (Object)e);
            return "";
        }
        return Objects.isNull(value) ? "" : value.toString();
    }

    private Map<String, String> getHeaders(List<Map<String, String>> requestHeader, String entityNumber, String businessKey) {
        return requestHeader.stream().filter(e -> kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)((String)e.get("name"))) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)((CharSequence)e.get(PARAM_KEY_VALUE)))).collect(Collectors.toMap(e -> (String)e.get("name"), e -> this.parseVar((String)e.get(PARAM_KEY_VALUE), entityNumber, businessKey)));
    }

    public Map<String, Object> innerNewBill(String businessFormId, Object businessKey, String refFormId, String triggerProcess, List<Map<String, Object>> setting) {
        HashMap<String, Object> newResults = new HashMap<String, Object>(setting.size());
        String refFormNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)refFormId);
        DynamicObject refObj = BusinessDataServiceHelper.newDynamicObject((String)refFormNumber);
        BillEntityType refDt = NcEntityTypeUtil.getMainEntityType((String)refFormId);
        HashSet<String> selectSet = new HashSet<String>(setting.size());
        for (Map<String, Object> updateItemMap : setting) {
            Object calcResult;
            String assignment = (String)updateItemMap.get(PARAM_KEY_NUMBER);
            Object expression = updateItemMap.get(PARAM_KEY_VALUE);
            boolean isEmptyExp = expression == null || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)NcEntityTypeUtil.getRuntimeExpression((String)expression.toString()));
            IDataEntityProperty assignmentProperty = refDt.findProperty(assignment);
            if (assignmentProperty == null) {
                if (isEmptyExp) continue;
                logger.debug("\u8d4b\u503c\u76ee\u6807\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u5220\u9664\uff1a" + assignment);
                continue;
            }
            if (isEmptyExp) {
                newResults.put(assignment, null);
                continue;
            }
            if (!(expression instanceof String)) {
                calcResult = expression;
            } else {
                boolean notNeedExpParse;
                String runtimeExpression = NcEntityTypeUtil.getRuntimeExpression((String)expression.toString());
                boolean bl = notNeedExpParse = !this.isNeedCallExpressParse(expression.toString(), assignmentProperty);
                if (!notNeedExpParse) {
                    WfExpressionBillCtx ctx = new WfExpressionBillCtx(businessFormId, businessKey, runtimeExpression, null, this.isAssignToText(assignmentProperty) ? WfConsts.ExpressionCtxType.NOTIFY : WfConsts.ExpressionCtxType.DEFAULT);
                    ctx.getCustomParam().put("_assignmentProperty", assignmentProperty);
                    NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
                    calcResult = service.tryGetExpressionValue((NoCodeExpCtx)ctx);
                } else {
                    calcResult = runtimeExpression;
                }
                calcResult = this.convertTo(assignmentProperty, calcResult);
            }
            assignmentProperty.setValue((Object)refObj, calcResult);
            newResults.put(assignment, calcResult);
            selectSet.add(assignment);
        }
        this.setBillNo(refDt, refFormNumber, refObj);
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{refObj});
        DynamicObject saveObj = (DynamicObject)saveObjs[0];
        ISimpleProperty primaryKey = refDt.getPrimaryKey();
        Object pk = primaryKey.getValue((Object)saveObj);
        newResults.put(primaryKey.getName(), pk);
        this.replaceUseFormatString(pk, refFormId, refFormNumber, selectSet, newResults);
        this.triggerProcess(refFormNumber, pk, "bizOperate", triggerProcess);
        return newResults;
    }

    public Map<String, Object> innerNewBillByLoop(String businessFormId, Object businessKey, String refFormId, String triggerProcess, List<Map<String, Object>> settings, String loopby) {
        HashMap<String, Object> newResults = new HashMap<String, Object>(2);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)loopby)) {
            logger.debug("nocode: innerNewBillByLoop loopby isBlank ");
            return this.returnEmptyResultByLoop();
        }
        BillEntityType refDt = NcEntityTypeUtil.getMainEntityType((String)refFormId);
        ISimpleProperty primaryKey = refDt.getPrimaryKey();
        String[] split = loopby.split(",");
        StringBuilder sb = new StringBuilder();
        for (String sPk : split) {
            List<Map<String, Object>> newSettings = this.cloneSettings(settings);
            for (Map<String, Object> map : newSettings) {
                String assignment = (String)map.get(PARAM_KEY_NUMBER);
                DynamicProperty assignmentProperty = refDt.getProperty(assignment);
                Object expression = map.get(PARAM_KEY_VALUE);
                if (!(expression instanceof String) || !MultiRefBillInfo.isInfo((String)((String)expression))) continue;
                MultiRefBillInfo info = MultiRefBillInfo.decodeMultiRefBillInfo((String)((String)expression));
                if (info == null || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)info.getFormId()) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)info.getPropertyName()) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)info.getValue())) {
                    return this.returnEmptyResultByLoop();
                }
                String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber((String)info.getFormId());
                MainEntityType dt = NcEntityTypeUtil.getDataEntityType((String)info.getFormId());
                if (dt == null) {
                    logger.debug("nocode: innerNewBillByLoop-dt is null");
                    return this.returnEmptyResultByLoop();
                }
                Object pk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, (Object)sPk);
                String pkKey = "id";
                if (dt.getPrimaryKey() != null) {
                    pkKey = dt.getPrimaryKey().getName();
                }
                if (pk == null) continue;
                DynamicProperty srcProperty = dt.getProperty(info.getPropertyName());
                HashSet<String> selectSet = new HashSet<String>(1);
                selectSet.add(info.getPropertyName());
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)info.getPropertyName(), (QFilter[])new QFilter[]{new QFilter(pkKey, "=", pk)});
                if (dynamicObject == null) continue;
                Object value = dynamicObject.get(info.getPropertyName());
                if (value != null && srcProperty.getClass() != assignmentProperty.getClass()) {
                    Map objectMap;
                    if (this.isAssignToText((IDataEntityProperty)assignmentProperty) && (objectMap = PropertyHandleUtil.toMap((Object)pk, (String)refFormId, (String)"$", (DynamicObject)dynamicObject, selectSet, (boolean)true)) != null && !objectMap.isEmpty()) {
                        value = objectMap.get(info.getPropertyName());
                    }
                    if (entityNumber.equalsIgnoreCase("bos_user") && selectSet.contains("gender")) {
                        value = Gender.find((String)((String)value)).getEncodeName();
                    }
                    if (srcProperty instanceof ComboProp && !(assignmentProperty instanceof INoCodeComboProp)) {
                        value = URLCodecUtils.decode((String)((String)value));
                    }
                    if (value instanceof DynamicObject && assignmentProperty instanceof INoCodeRefBillProp) {
                        value = ((DynamicObject)value).getPkValue();
                    }
                }
                map.put(PARAM_KEY_VALUE, value);
            }
            Map<String, Object> oneResult = this.innerNewBill(businessFormId, businessKey, refFormId, triggerProcess, newSettings);
            Object pk = oneResult.get(primaryKey.getName());
            if (pk == null) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pk);
        }
        newResults.put("QueryDataSet", sb.toString());
        newResults.put("QueryDataSet_id", sb.toString());
        return newResults;
    }

    private List<Map<String, Object>> cloneSettings(List<Map<String, Object>> settings) {
        if (settings == null) {
            return null;
        }
        String jsonString = SerializationUtils.toJsonString(settings);
        return (List)SerializationUtils.fromJsonString((String)jsonString, List.class);
    }

    private Map<String, Object> returnEmptyResultByLoop() {
        HashMap<String, Object> newResults = new HashMap<String, Object>(2);
        newResults.put("QueryDataSet", "");
        newResults.put("QueryDataSet_id", "");
        return newResults;
    }

    private void setBillNo(BillEntityType dt, String formNumber, DynamicObject obj) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)dt.getBillNo()) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)formNumber) || obj == null) {
            return;
        }
        IDataEntityProperty billNoCodeProp = dt.findProperty(dt.getBillNo());
        if (billNoCodeProp == null) {
            return;
        }
        Object value = billNoCodeProp.getValue((Object)obj);
        if (value != null && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)value.toString())) {
            return;
        }
        String number = CodeRuleServiceHelper.getNumber((String)formNumber, (DynamicObject)obj, null);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)number)) {
            billNoCodeProp.setValue((Object)obj, (Object)number);
        }
    }

    private String getRemainKey(Map<String, Object> imParamMap, String ... keys) {
        HashSet<String> remainKeys = new HashSet<String>();
        remainKeys.addAll(imParamMap.keySet());
        remainKeys.removeAll(Arrays.asList(keys));
        if (remainKeys.size() > 0) {
            return (String)remainKeys.iterator().next();
        }
        return null;
    }

    private boolean isNeedCallExpressParse(String expression, IDataEntityProperty assignmentProperty) {
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)expression)) {
            return false;
        }
        if (expression.indexOf("@@") != -1 || WfConsts.varPattern.matcher(expression).matches()) {
            return true;
        }
        Pattern compileDisp = WfConsts.VAR_DISP_PATTERN_OF_FIELD;
        Matcher matcherDisp = compileDisp.matcher(expression);
        if (matcherDisp.matches()) {
            return true;
        }
        if (assignmentProperty instanceof DecimalProp && (expression.indexOf("+") != -1 || expression.indexOf("-") != -1 || expression.indexOf("*") != -1 || expression.indexOf("/") != -1)) {
            return true;
        }
        return this.isAssignToText(assignmentProperty) && (expression.indexOf(WfConsts.QueryResultEnum.HasData.getCode()) != -1 || expression.indexOf(WfConsts.QueryResultEnum.NonData.getCode()) != -1 || expression.indexOf(WfConsts.AuditResultEnum.Consent.getCode()) != -1 || expression.indexOf(WfConsts.AuditResultEnum.Terminate.getCode()) != -1);
    }

    private void triggerProcess(String entityNumber, Object billPk, String triggerMode, String triggerProcess) {
        String[] procs;
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)entityNumber) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)triggerProcess) || billPk == null) {
            return;
        }
        for (String proc : procs = triggerProcess.split(",")) {
            Long modelId = Long.parseLong(proc);
            ThreadPools.executeOnce((String)"nocode_triggerProcess2", () -> {
                try {
                    NoCodeWorkflowServiceHelper.tryTriggerProcess((Long)modelId, (String)billPk.toString(), (String)triggerMode);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e);
                }
            });
        }
    }

    private boolean isAssignToText(IDataEntityProperty assignmentProperty) {
        return assignmentProperty instanceof TextProp || assignmentProperty instanceof ComboProp;
    }
}

