/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.express.NoCodeExpBillCtx;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WfExpressionBillCtx
implements NoCodeExpBillCtx {
    String entityNumber;
    Object pkId;
    String expression;
    Map varValMap;
    DynamicObject rec;
    final Map<String, Object> customParam;

    public WfExpressionBillCtx(String entityNumber, Object pkId, String expression, Map varValMap, WfConsts.ExpressionCtxType ctxType) {
        this.entityNumber = entityNumber;
        this.pkId = pkId;
        this.expression = expression;
        this.varValMap = varValMap;
        this.customParam = new HashMap<String, Object>(16);
        this.customParam.put(WfConsts.ExpressionCtxType.class.getName(), ctxType.getCode());
        this.loadData();
    }

    private void loadData() {
        String selectProperties = NcEntityTypeUtil.getSelectPropertiesIncludePkId((String)this.entityNumber);
        String[] splitFields = selectProperties.split(",");
        HashSet selectSet = new HashSet(splitFields.length);
        Collections.addAll(selectSet, splitFields);
        this.rec = BusinessDataServiceHelper.loadSingle((Object)this.pkId, (String)this.entityNumber);
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public Object getPkId() {
        return this.pkId;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getVarValue(String key) {
        if (this.rec != null && this.rec.containsProperty(key)) {
            return this.rec.get(key);
        }
        if (this.varValMap != null && !this.varValMap.isEmpty() && this.varValMap.containsKey(key)) {
            return this.varValMap.get(key);
        }
        return key;
    }

    public Map<String, Object> getCustomParam() {
        return this.customParam;
    }
}

