/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.wf;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.design.NoCodeDesignerData;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDateField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDecimalField;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;
import kd.bos.nocode.ext.metadata.form.control.NoCodeDateFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeTextFieldAp;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.service.sys.SysFormMetaServiceImpl;
import kd.bos.nocode.utils.FormMetaUtil;

public class WfFormMetaService
extends SysFormMetaServiceImpl.FormMetaServiceSaveImpl {
    public String createForm(String appId, List<Map<String, String>> responseParams) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(16);
        parameters.put("bizappid", appId);
        parameters.put("name", CommonConstants.getNocodeWfTmpFormName());
        String id = FormMetaUtil.genIdUrlFriendly();
        parameters.put("id", id);
        parameters.put("modelType", "NoCodeModel");
        parameters.put("enabled", Boolean.FALSE);
        RestApiSaveItemData saveItemData = new RestApiSaveItemData();
        this.createModel(parameters, saveItemData);
        if (!saveItemData.isBillStatus()) {
            throw new RestApiException(SerializationUtils.toJsonString((Object)saveItemData));
        }
        String formId = saveItemData.getNumber();
        this.addFieldItem(formId, responseParams);
        return id;
    }

    private void addFieldItem(String formId, List<Map<String, String>> responseParams) {
        LinkedHashMap field2FieldAp = new LinkedHashMap(responseParams.size());
        for (Map<String, String> field : responseParams) {
            this.addField(field2FieldAp, field);
        }
        String errMsg = new NoCodeDesignerData().addFields2RootPrepend(formId, field2FieldAp);
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            throw new RestApiException(errMsg);
        }
    }

    private void addField(Map<Field<?>, FieldAp> field2FieldAp, Map<String, String> field) {
        NoCodeFieldAp fieldAp;
        NoCodeDecimalField fieldItem;
        String number = field.get("name");
        String name = field.get("fieldName");
        String type = field.get("fieldType");
        String id = Uuid16.create().toString();
        if (type.equalsIgnoreCase("text")) {
            NoCodeTextField textField = new NoCodeTextField();
            textField.setMaxLength(2000);
            fieldItem = textField;
            fieldAp = new NoCodeTextFieldAp();
        } else if (type.equalsIgnoreCase("number")) {
            fieldItem = new NoCodeDecimalField();
            fieldAp = new NoCodeFieldAp();
        } else if (type.equalsIgnoreCase("date")) {
            String formatType = field.getOrDefault("formatType", "0");
            NoCodeDateField noCodeDateField = new NoCodeDateField();
            noCodeDateField.setFormatType(formatType);
            fieldItem = noCodeDateField;
            fieldAp = new NoCodeDateFieldAp();
        } else {
            throw new RestApiException(ResManager.loadKDString((String)"\u65e0\u6548\u7684\u5b57\u6bb5\u7c7b\u578b\uff1a%s", (String)"WfFormMetaService_0", (String)"BOS_NOCODE", (Object[])new Object[]{type}));
        }
        fieldItem.setId(id);
        fieldItem.setKey(number);
        fieldItem.setName(new LocaleString(name));
        fieldAp.setId(id);
        fieldAp.setFieldId(id);
        fieldAp.setField((Field)fieldItem);
        fieldAp.setKey(number);
        fieldAp.setName(new LocaleString(name));
        field2FieldAp.put((Field<?>)fieldItem, (FieldAp)fieldAp);
    }
}

