/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.api.model;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.restapi.api.params.RestApiQueryParam;
import kd.bos.nocode.restapi.api.params.RestApiSaveParam;
import org.apache.commons.collections4.CollectionUtils;

public class ListFilterRequestBO {
    private String appId;
    private String formId;
    private String headField;
    private String groupField;
    private String env;
    private long userId;
    private String searchText;

    public ListFilterRequestBO() {
    }

    public ListFilterRequestBO(String appId, String formId, String headField, String env, long userId, String groupField) {
        this.appId = appId;
        this.formId = formId;
        this.headField = headField;
        this.env = env;
        this.userId = userId;
        this.groupField = groupField;
    }

    public ListFilterRequestBO(String appId, String formId, String headField, String env, long userId, String groupField, String searchText) {
        this.appId = appId;
        this.formId = formId;
        this.headField = headField;
        this.env = env;
        this.userId = userId;
        this.groupField = groupField;
        this.searchText = searchText;
    }

    public static ListFilterRequestBO build(RestApiQueryParam queryParam) {
        String appId = queryParam.getRequest().getHttpQueryString().get("appid");
        String formId = queryParam.getRequest().getHttpQueryString().get("formid");
        String env = queryParam.getRequest().getHttpQueryString().get("env");
        String headField = queryParam.getRequest().getHttpQueryString().get("head_field");
        String groupField = queryParam.getRequest().getHttpQueryString().get("group_field");
        String searchText = queryParam.getRequest().getHttpQueryString().get("search");
        ListFilterRequestBO.checkParam(appId, formId, env);
        return new ListFilterRequestBO(appId, formId, headField, env, RequestContext.get().getCurrUserId(), groupField, searchText);
    }

    public static ListFilterRequestBO build(RestApiSaveParam saveParam) {
        List<Map<String, Object>> dataList = saveParam.getDataList();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(dataList), (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, Object> map = dataList.get(0);
        String appId = (String)map.get("appid");
        String formId = (String)map.get("formid");
        String env = saveParam.getRequest().getHttpQueryString().get("env");
        String headField = saveParam.getRequest().getHttpQueryString().get("head_field");
        String groupField = saveParam.getRequest().getHttpQueryString().get("group_field");
        ListFilterRequestBO.checkParam(appId, formId, env);
        return new ListFilterRequestBO(appId, formId, headField, env, RequestContext.get().getCurrUserId(), groupField);
    }

    public static void checkParam(String appId, String formId, String env) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)formId), (Object)"formId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)env), (Object)"env\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getHeadField() {
        return this.headField;
    }

    public void setHeadField(String headField) {
        this.headField = headField;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String groupField) {
        this.groupField = groupField;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String toString() {
        return "ListFilterRequestBO{appId='" + this.appId + '\'' + ", formId='" + this.formId + '\'' + ", headField='" + this.headField + '\'' + ", groupField='" + this.groupField + '\'' + ", env='" + this.env + '\'' + ", userId=" + this.userId + ", searchText='" + this.searchText + '\'' + '}';
    }
}

