/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.api.result;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.nocode.restapi.api.result.RestApiSaveItemData;
import kd.bos.nocode.restapi.api.result.RestApiServiceResult;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RestApiSaveResult
extends RestApiServiceResult {
    private static final long serialVersionUID = 6764705449686964120L;
    private long successCount;
    private long failCount;
    private List<RestApiSaveItemData> result = new ArrayList<RestApiSaveItemData>();
    transient List<RestApiSaveItemData> inserts;
    transient List<RestApiSaveItemData> updates;
    private static final int INITIALCAPACITY_10 = 10;
    private Map<String, Object> extra = new HashMap<String, Object>(10);

    public RestApiSaveResult() {
    }

    public static RestApiSaveResult of(List<RestApiSaveItemData> insertIds, List<RestApiSaveItemData> updateIds) {
        return new RestApiSaveResult(insertIds, updateIds);
    }

    public static RestApiSaveResult of(List<RestApiSaveItemData> insertIds) {
        return new RestApiSaveResult(insertIds, null);
    }

    public RestApiSaveResult(List<RestApiSaveItemData> saveItemDataList) {
        this.result = saveItemDataList;
        this.failCount = this.result.stream().filter(r -> !r.isBillStatus()).count();
        this.successCount = (long)this.result.size() - this.failCount;
    }

    public RestApiSaveResult(List<RestApiSaveItemData> insertIds, List<RestApiSaveItemData> updateIds) {
        if (insertIds != null) {
            this.inserts = insertIds.stream().peek(r -> r.setType("Add")).collect(Collectors.toList());
            this.result.addAll(this.inserts);
        }
        if (updateIds != null) {
            this.updates = updateIds.stream().peek(r -> r.setType("Update")).collect(Collectors.toList());
            this.result.addAll(this.updates);
        }
        this.failCount = this.result.stream().filter(r -> !r.isBillStatus()).count();
        this.successCount = (long)this.result.size() - this.failCount;
    }

    public long getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(long successCount) {
        this.successCount = successCount;
    }

    public long getFailCount() {
        return this.failCount;
    }

    public void setFailCount(long failCount) {
        this.failCount = failCount;
    }

    public void setInsideInserts(List<RestApiSaveItemData> insertIds) {
        this.inserts = insertIds;
    }

    public void setInsideUpdates(List<RestApiSaveItemData> updateIds) {
        this.updates = updateIds;
    }

    public List<RestApiSaveItemData> getResult() {
        return this.result;
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, Object> extra) {
        this.extra = extra;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

